/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ip.basecomps.cache.test;

import com.sap.ip.basecomps.cache.Attributes;
import com.sap.ip.basecomps.cache.CacheAccess;
import com.sap.ip.basecomps.cache.CacheAdmin;
import com.sap.ip.basecomps.cache.CacheException;
import com.sap.ip.basecomps.cache.CacheLoader;
import com.sap.ip.basecomps.cache.EntryAttributes;
import com.sap.ip.basecomps.cache.EntryState;
import com.sap.ip.basecomps.cache.InvalidationEventHandler;
import com.sap.ip.basecomps.cache.PreemptionEventHandler;
import com.sap.ip.basecomps.cache.StateChangeEventHandler;
import com.sap.ip.basecomps.cache.StatisticEntry;
import com.sap.ip.basecomps.consistency.ConsistencyDomain;
import com.sap.ip.basecomps.test.CmdInt;
import com.sap.ip.basecomps.test.MainTestEnv;
import com.sap.ip.basecomps.util.Util;
import com.sap.ip.basecomps.util.WeakHashTable;
import com.sap.ip.basecomps.util.reg.Registration;
import com.sap.ip.basecomps.util.reg.RegistrationDestination;
import java.io.Serializable;
import java.lang.ref.Reference;
import java.lang.ref.SoftReference;
import java.net.InetAddress;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Properties;
import java.util.Random;
import java.util.Set;
import java.util.Vector;
import java.util.WeakHashMap;

public class TestEnv
extends CmdInt.Interpreter {
    static final CmdInt.Command[] c = new CmdInt.Command[]{new RegionCmd(), new DefineCmd(), new DestroyCmd(), new SwitchCmd(), new PutCmd(), new GetCmd(), new AttrCmd(), new GroupCmd(), new MembersCmd(), new ListCmd(), new InvalidateCmd(), new ReplaceCmd(), new InfoCmd(), new EventCmd(), new CloseCmd(), new RegistrationsCmd(), new UnregisterCmd(), new ObjectsCmd(), new UnRefCmd(), new CleanupCmd(), new LockCmd(), new UnlockCmd(), new SpeedCmd(), new GCCmd(), new MemoryCmd(), new SleepCmd(), new YieldCmd(), new LoadTestCmd(), new CleanupTestCmd(), new CmdInt.Interpreter.QuitCmd()};
    public static final TestEnv env = new TestEnv();
    public static final CacheRegistrations regs = new CacheRegistrations();
    CacheAccess access = null;
    static Handler handler;

    public TestEnv() {
        super("cache", "Cache Test System", c);
    }

    static Properties getProperties(String[] args, int start) {
        Properties props = new Properties();
        while (start < args.length) {
            String a = args[start];
            int i = a.indexOf(61);
            if (i <= 0) {
                CmdInt.SimpleCommand.Error("illegal assignment");
            }
            String n = a.substring(0, i);
            String v = a.substring(i + 1);
            props.setProperty(n, v);
            ++start;
        }
        return props;
    }

    static void printAttributes(Object name, Attributes attr) {
        long time = new Date().getTime();
        System.out.println("attributes of " + name);
        System.out.println("  lifetime   : " + attr.getLifeTime());
        System.out.println("  created    : " + attr.getCreateTime());
        if (attr.getLifeTime() > 0L) {
            System.out.println("    resttime : " + (attr.getLifeTime() + attr.getCreateTime() - time));
        }
        System.out.println("  idletime   : " + attr.getIdleTime());
        if (attr instanceof EntryAttributes) {
            EntryAttributes ea = (EntryAttributes)attr;
            System.out.println("  last-access: " + ea.getLastAccessTime());
            if (attr.getIdleTime() > 0L && ea.getState() != EntryState.NONE) {
                System.out.println("    resttime : " + (ea.getLastAccessTime() + attr.getIdleTime() - time));
            }
            System.out.println("  state      : " + ea.getState());
        }
        System.out.println("  reply      : " + attr.useReply());
        System.out.println("  unique     : " + attr.useUniqueMapping());
        System.out.println("  sync events: " + attr.syncEvents());
        if (attr.getMaxWeight() > 0L) {
            System.out.println("  maxweight: " + attr.getMaxWeight());
        }
        System.out.println("  weight     : " + attr.getWeight());
        System.out.println("  real-weight: " + attr.getRealWeight());
        System.out.println("  loader     : " + attr.getLoader());
        System.out.println("  ownerf     : " + attr.getOwnerFactory());
        System.out.println("  preempt    : " + attr.getPreemptionHandler());
        System.out.println("  keyhndlr   : " + attr.getKeyHandler());
        ConsistencyDomain dom = attr.getConsistencyDomain();
        System.out.println("  domain     : " + (dom == null ? null : dom.getName()));
    }

    static {
        System.out.println("adding cache test environment");
        MainTestEnv.addTestEnv(env);
        RegistrationDestination.registerRegistrationHandler(regs);
        handler = new Handler();
    }

    public static class InfoCmd
    extends CmdInt.Interpreter.SimpleCommand {
        public InfoCmd() {
            super("info", "[<name>]", "get region info");
        }

        public int Exec(CmdInt.Interpreter cmdint, String[] args) {
            String name;
            TestEnv te = (TestEnv)cmdint;
            CmdInt.SimpleCommand.CheckNumberOfArguments(args, 1, 2);
            if (args.length == 1) {
                if (te.access == null) {
                    CmdInt.SimpleCommand.Error("no region set");
                }
                name = te.access.getRegionName();
            } else {
                name = args[1];
            }
            try {
                StatisticEntry s = CacheAdmin.getStatistics(name);
                Attributes a = CacheAdmin.getAttributes(name);
                CacheAdmin.Counts c = CacheAdmin.getCounts(name);
                System.out.println("Admin information for region " + name);
                TestEnv.printAttributes(name, a);
                s.print();
                c.print();
                System.out.println("current cache accesses:");
                Collection accesses = CacheAdmin.getAccesses(name);
                Iterator i = accesses.iterator();
                while (i.hasNext()) {
                    CacheAccess acc = (CacheAccess)i.next();
                    s = acc.getStatistics();
                    s.print(acc.toString());
                }
            }
            catch (CacheException e) {
                CmdInt.SimpleCommand.Error(e.toString());
            }
            return 0;
        }
    }

    public static class EventCmd
    extends CmdInt.Interpreter.SimpleCommand {
        public EventCmd() {
            super("handler", "register|unregister", "regsiter/unregister event handler");
        }

        public int Exec(CmdInt.Interpreter cmdint, String[] args) {
            TestEnv te = (TestEnv)cmdint;
            CmdInt.SimpleCommand.CheckNumberOfArguments(args, 2);
            if (te.access == null) {
                CmdInt.SimpleCommand.Error("no region set");
            }
            try {
                if ("register".startsWith(args[1])) {
                    System.out.println("register test handler");
                    te.access.registerHandler(handler);
                } else if ("unregister".startsWith(args[1])) {
                    System.out.println("unregister test handler");
                    te.access.unregisterHandler(handler);
                } else {
                    CmdInt.SimpleCommand.Error("illegal opertation");
                }
            }
            catch (Exception e) {
                CmdInt.SimpleCommand.Error(e.toString());
            }
            return 0;
        }
    }

    static class Handler
    implements InvalidationEventHandler,
    PreemptionEventHandler,
    StateChangeEventHandler {
        Handler() {
        }

        public void handleInvalidation(String region, Object name, Object object) {
            System.out.println("*** invalidated: " + region + ", " + name + ", " + object);
        }

        public void handlePreemption(String region, Object name, Object object) {
            System.out.println("*** preempted: " + region + ", " + name + ", " + object);
        }

        public void handleStateChange(String region, Object name, Object object, EntryState sold, EntryState snew, StateChangeEventHandler.Reason reason) {
            System.out.println("*** state changed: " + region + ", " + name + ", " + object + ": " + sold + " -> " + snew + ": " + reason);
        }
    }

    public static class CloseCmd
    extends CmdInt.Interpreter.SimpleCommand {
        public CloseCmd() {
            super("close", "", "close currect cache access");
        }

        public int Exec(CmdInt.Interpreter cmdint, String[] args) {
            TestEnv te = (TestEnv)cmdint;
            CmdInt.SimpleCommand.CheckNumberOfArguments(args, 1);
            if (te.access == null) {
                CmdInt.SimpleCommand.Error("no region set");
            }
            try {
                te.access.close();
            }
            catch (Exception e) {
                CmdInt.SimpleCommand.Error(e.toString());
            }
            return 0;
        }
    }

    public static class PutCmd
    extends CmdInt.Interpreter.SimpleCommand {
        public PutCmd() {
            super("put", "<name> {<property>}", "put element");
        }

        public int Exec(CmdInt.Interpreter cmdint, String[] args) {
            TestEnv te = (TestEnv)cmdint;
            if (args.length < 2) {
                CmdInt.SimpleCommand.Error("arguments missing");
            }
            if (te.access == null) {
                CmdInt.SimpleCommand.Error("no region set");
            }
            Properties props = TestEnv.getProperties(args, 2);
            String group = props.getProperty("group");
            Attributes attr = null;
            if (((Hashtable)props).size() > (group == null ? 0 : 1)) {
                attr = new Attributes(props);
                TestEnv.printAttributes(args[1], attr);
            }
            try {
                if (group == null) {
                    te.access.put((Object)args[1], attr, (Object)new CacheObject("manual " + args[1] + "/" + te.access.getRegionName()));
                } else {
                    te.access.put(args[1], group, attr, new CacheObject("manual " + args[1] + "/" + te.access.getRegionName()));
                }
            }
            catch (CacheException e) {
                CmdInt.SimpleCommand.Error(e.toString());
            }
            return 0;
        }
    }

    public static class ReplaceCmd
    extends CmdInt.Interpreter.SimpleCommand {
        public ReplaceCmd() {
            super("replace", "<name>", "replace element");
        }

        public int Exec(CmdInt.Interpreter cmdint, String[] args) {
            TestEnv te = (TestEnv)cmdint;
            CmdInt.SimpleCommand.CheckNumberOfArguments(args, 2);
            if (te.access == null) {
                CmdInt.SimpleCommand.Error("no region set");
            }
            try {
                te.access.replace(args[1], new CacheObject("replaced " + args[1] + "/" + te.access.getRegionName()));
            }
            catch (CacheException e) {
                CmdInt.SimpleCommand.Error(e.toString());
            }
            return 0;
        }
    }

    public static class InvalidateCmd
    extends CmdInt.Interpreter.SimpleCommand {
        public InvalidateCmd() {
            super("invalidate", "[local|pattern] <name>", "invalidate element");
        }

        public int Exec(CmdInt.Interpreter cmdint, String[] args) {
            TestEnv te = (TestEnv)cmdint;
            int mode = 0;
            int start = 1;
            CmdInt.SimpleCommand.CheckNumberOfArguments(args, 2, 3);
            if (args.length == 3) {
                if ("local".startsWith(args[start])) {
                    mode = 1;
                } else if ("pattern".startsWith(args[start])) {
                    mode = 2;
                } else {
                    CmdInt.SimpleCommand.Error("illegal mode " + args[start]);
                }
                ++start;
            }
            if (te.access == null) {
                CmdInt.SimpleCommand.Error("no region set");
            }
            try {
                switch (mode) {
                    case 0: {
                        te.access.invalidate(args[start]);
                        break;
                    }
                    case 1: {
                        te.access.invalidateLocal(args[start]);
                        break;
                    }
                    case 2: {
                        te.access.invalidateLocalMatched(args[start]);
                    }
                }
            }
            catch (CacheException e) {
                CmdInt.SimpleCommand.Error(e.toString());
            }
            return 0;
        }
    }

    public static class ListCmd
    extends CmdInt.Interpreter.SimpleCommand {
        public ListCmd() {
            super("list", "groups|entries", "get element list");
        }

        private String group(CacheAccess.Element e) {
            if (e.getGroup() != null) {
                return " group " + e.getGroup().getId();
            }
            return "";
        }

        public int Exec(CmdInt.Interpreter cmdint, String[] args) {
            TestEnv te = (TestEnv)cmdint;
            CmdInt.SimpleCommand.CheckNumberOfArguments(args, 2, 3);
            if (te.access == null) {
                CmdInt.SimpleCommand.Error("no region set");
            }
            try {
                if ("groups".startsWith(args[1])) {
                    Iterator i = args.length == 3 ? te.access.getGroups(Util.getSwitch(args[2])).iterator() : te.access.getGroups().iterator();
                    while (i.hasNext()) {
                        CacheAccess.Group g = (CacheAccess.Group)i.next();
                        System.out.println("  " + g.getId() + this.group(g));
                    }
                } else if ("entries".startsWith(args[1])) {
                    Iterator i = te.access.getEntries().iterator();
                    while (i.hasNext()) {
                        CacheAccess.Entry e = (CacheAccess.Entry)i.next();
                        System.out.println("  " + e.getId() + ": " + e.getState() + this.group(e));
                    }
                } else if ("regions".startsWith(args[1])) {
                    Iterator i = args.length == 3 ? CacheAdmin.getRegions(args[2]).iterator() : CacheAdmin.getRegions().iterator();
                    while (i.hasNext()) {
                        String n = (String)i.next();
                        System.out.println("  " + n);
                    }
                } else {
                    CmdInt.SimpleCommand.Error("select groups or entries");
                }
            }
            catch (CacheException e) {
                CmdInt.SimpleCommand.Error(e.toString());
            }
            return 0;
        }
    }

    public static class MembersCmd
    extends CmdInt.Interpreter.SimpleCommand {
        public MembersCmd() {
            super("members", "<name>", "get group members");
        }

        public int Exec(CmdInt.Interpreter cmdint, String[] args) {
            TestEnv te = (TestEnv)cmdint;
            CmdInt.SimpleCommand.CheckNumberOfArguments(args, 2);
            if (te.access == null) {
                CmdInt.SimpleCommand.Error("no region set");
            }
            try {
                Set s = te.access.getGroupMembers(args[1]);
                Iterator i = s.iterator();
                while (i.hasNext()) {
                    System.out.println("  " + i.next());
                }
            }
            catch (CacheException e) {
                CmdInt.SimpleCommand.Error(e.toString());
            }
            return 0;
        }
    }

    public static class GroupCmd
    extends CmdInt.Interpreter.SimpleCommand {
        public GroupCmd() {
            super("group", "<name>", "get element group");
        }

        public int Exec(CmdInt.Interpreter cmdint, String[] args) {
            TestEnv te = (TestEnv)cmdint;
            CmdInt.SimpleCommand.CheckNumberOfArguments(args, 2);
            if (te.access == null) {
                CmdInt.SimpleCommand.Error("no region set");
            }
            try {
                String g = te.access.getGroup(args[1]);
                System.out.println(g == null ? "no group set for " + args[1] : "group of " + args[1] + " is " + g);
            }
            catch (CacheException e) {
                CmdInt.SimpleCommand.Error(e.toString());
            }
            return 0;
        }
    }

    public static class AttrCmd
    extends CmdInt.Interpreter.SimpleCommand {
        public AttrCmd() {
            super("attr", "<name>", "get element attributes");
        }

        public int Exec(CmdInt.Interpreter cmdint, String[] args) {
            TestEnv te = (TestEnv)cmdint;
            CmdInt.SimpleCommand.CheckNumberOfArguments(args, 2);
            if (te.access == null) {
                CmdInt.SimpleCommand.Error("no region set");
            }
            try {
                EntryAttributes a = te.access.getAttributes(args[1]);
                TestEnv.printAttributes(args[1], a);
            }
            catch (CacheException e) {
                CmdInt.SimpleCommand.Error(e.toString());
            }
            return 0;
        }
    }

    public static class GetCmd
    extends CmdInt.Interpreter.SimpleCommand {
        public GetCmd() {
            super("get", "<name>", "get element");
        }

        public int Exec(CmdInt.Interpreter cmdint, String[] args) {
            TestEnv te = (TestEnv)cmdint;
            CmdInt.SimpleCommand.CheckNumberOfArguments(args, 2);
            if (te.access == null) {
                CmdInt.SimpleCommand.Error("no region set");
            }
            try {
                Object o = te.access.get(args[1]);
                System.out.println(args[1] + " = " + o);
            }
            catch (CacheException e) {
                CmdInt.SimpleCommand.Error(e.toString());
            }
            return 0;
        }
    }

    public static class UnlockCmd
    extends CmdInt.Interpreter.SimpleCommand {
        public UnlockCmd() {
            super("unlock", "[<name>]", "unlock element(s)");
        }

        public int Exec(CmdInt.Interpreter cmdint, String[] args) {
            TestEnv te = (TestEnv)cmdint;
            CmdInt.SimpleCommand.CheckNumberOfArguments(args, 1, 2);
            if (te.access == null) {
                CmdInt.SimpleCommand.Error("no region set");
            }
            try {
                if (args.length == 2) {
                    te.access.releaseOwnership(args[1]);
                } else {
                    te.access.releaseOwnership();
                }
            }
            catch (CacheException e) {
                CmdInt.SimpleCommand.Error(e.toString());
            }
            return 0;
        }
    }

    public static class LockCmd
    extends CmdInt.Interpreter.SimpleCommand {
        public LockCmd() {
            super("lock", "<name>", "lock element");
        }

        public int Exec(CmdInt.Interpreter cmdint, String[] args) {
            TestEnv te = (TestEnv)cmdint;
            CmdInt.SimpleCommand.CheckNumberOfArguments(args, 2);
            if (te.access == null) {
                CmdInt.SimpleCommand.Error("no region set");
            }
            try {
                te.access.getOwnership(args[1], 0);
            }
            catch (CacheException e) {
                CmdInt.SimpleCommand.Error(e.toString());
            }
            return 0;
        }
    }

    public static class SwitchCmd
    extends CmdInt.Interpreter.SimpleCommand {
        public SwitchCmd() {
            super("switch", "[<region name>]", "switch region");
        }

        public int Exec(CmdInt.Interpreter cmdint, String[] args) {
            TestEnv te = (TestEnv)cmdint;
            CmdInt.SimpleCommand.CheckNumberOfArguments(args, 1, 2);
            if (args.length > 1) {
                if (te.access != null) {
                    te.access.close();
                    te.access = null;
                }
                try {
                    te.access = CacheAccess.getAccess(args[1]);
                }
                catch (CacheException e) {
                    CmdInt.SimpleCommand.Error(e.toString());
                }
            }
            System.out.println("region is " + te.access.getRegionName());
            return 0;
        }
    }

    public static class DestroyCmd
    extends CmdInt.Interpreter.SimpleCommand {
        public DestroyCmd() {
            super("destroy", "region|entry <name>", "destroy elements");
        }

        public int Exec(CmdInt.Interpreter cmdint, String[] args) {
            TestEnv te = (TestEnv)cmdint;
            if (args.length < 2) {
                CmdInt.SimpleCommand.Error("arguments missing");
            }
            String name = args.length > 2 ? args[2] : null;
            try {
                if ("region".startsWith(args[1])) {
                    if (name == null) {
                        if (te.access == null) {
                            CmdInt.SimpleCommand.Error("no region set");
                        }
                        name = te.access.getRegionName();
                    }
                    CacheAccess.destroyRegion(name);
                } else if ("entry".startsWith(args[1])) {
                    if (te.access == null) {
                        CmdInt.SimpleCommand.Error("no region set");
                    }
                    if (name == null) {
                        te.access.destroy();
                    } else {
                        System.out.println("size=" + args.length + ", name=" + name);
                        te.access.destroy(name);
                    }
                } else {
                    CmdInt.SimpleCommand.Error("illegal element " + args[1]);
                }
            }
            catch (CacheException e) {
                CmdInt.SimpleCommand.Error(e.toString());
            }
            return 0;
        }
    }

    public static class DefineCmd
    extends CmdInt.Interpreter.SimpleCommand {
        public DefineCmd() {
            super("define", "region|group|object <name> [<properties>]", "define elements");
        }

        public int Exec(CmdInt.Interpreter cmdint, String[] args) {
            TestEnv te = (TestEnv)cmdint;
            if (args.length < 3) {
                CmdInt.SimpleCommand.Error("arguments missing");
            }
            String name = args[2];
            try {
                if ("region".startsWith(args[1])) {
                    String l;
                    int start = args.length < 4 ? 3 : 4;
                    Properties props = TestEnv.getProperties(args, start);
                    if (start == 4) {
                        props.setProperty("consistency-domain", args[3]);
                    }
                    if ((l = props.getProperty("cache-loader.class")) != null && l.equals("MyLoader")) {
                        props.setProperty("cache-loader.class", "com.sap.ip.basecomps.cache.test.TestEnv$Loader");
                        props.setProperty("cache-loader.text", "MyLoader");
                    } else if (props.getProperty("cache-loader.loader.class") == null) {
                        props.setProperty("cache-loader.loader.class", "com.sap.ip.basecomps.cache.test.TestEnv$Loader");
                        props.setProperty("cache-loader.loader.text", "MyLoader");
                    }
                    Attributes attr = new Attributes(props);
                    CacheAccess.defineRegion(args[2], attr);
                } else if ("group".startsWith(args[1])) {
                    if (te.access == null) {
                        CmdInt.SimpleCommand.Error("no region set");
                    }
                    Properties props = TestEnv.getProperties(args, 3);
                    String group = props.getProperty("group");
                    Attributes attr = new Attributes(props);
                    if (group == null) {
                        te.access.defineGroup(args[2], attr);
                    } else {
                        te.access.defineGroup(args[2], group, attr);
                    }
                } else if ("object".startsWith(args[1])) {
                    if (te.access == null) {
                        CmdInt.SimpleCommand.Error("no region set");
                    }
                    Properties props = TestEnv.getProperties(args, 3);
                    String group = props.getProperty("group");
                    Attributes attr = new Attributes(props);
                    TestEnv.printAttributes("new " + args[2], attr);
                    if (group == null) {
                        te.access.defineObject(args[2], attr);
                    } else {
                        te.access.defineObject(args[2], group, attr);
                    }
                } else {
                    CmdInt.SimpleCommand.Error("illegal element " + args[1]);
                }
            }
            catch (CacheException e) {
                CmdInt.SimpleCommand.Error(e.toString());
            }
            return 0;
        }
    }

    public static class RegionCmd
    extends CmdInt.Interpreter.SimpleCommand {
        public RegionCmd() {
            super("region", "[<name> [<consistency domain> [<properties>]]]", "list/define region");
        }

        public int Exec(CmdInt.Interpreter cmdint, String[] args) {
            TestEnv te = (TestEnv)cmdint;
            if (args.length < 3) {
                CmdInt.SimpleCommand.CheckNumberOfArguments(args, 1, 3);
            }
            try {
                switch (args.length) {
                    case 1: {
                        CacheAccess a = te.access;
                        if (a == null) {
                            CmdInt.SimpleCommand.Error("no region set");
                        }
                        Attributes attr = a.getAttributes();
                        TestEnv.printAttributes(a.getRegionName(), attr);
                        break;
                    }
                    case 2: {
                        CacheAccess a = CacheAccess.getAccess(args[1]);
                        Attributes attr = a.getAttributes();
                        TestEnv.printAttributes(a.getRegionName(), attr);
                        a.close();
                        break;
                    }
                    default: {
                        Properties props = TestEnv.getProperties(args, 3);
                        props.setProperty("consistency-domain", args[2]);
                        String l = props.getProperty("cache-loader.class");
                        if (l != null && l.equals("MyLoader")) {
                            props.setProperty("cache-loader.class", "com.sap.ip.basecomps.cache.test.TestEnv$Loader");
                            props.setProperty("cache-loader.text", "MyLoader");
                        } else if (props.getProperty("cache-loader.loader.class") == null) {
                            props.setProperty("cache-loader.loader.class", "com.sap.ip.basecomps.cache.test.TestEnv$Loader");
                            props.setProperty("cache-loader.loader.text", "MyLoader");
                        }
                        Attributes attr = new Attributes(props);
                        TestEnv.printAttributes("creation of region " + args[1], attr);
                        CacheAccess.defineRegion(args[1], attr);
                        System.out.println("done");
                        break;
                    }
                }
            }
            catch (CacheException e) {
                CmdInt.SimpleCommand.Error(e.toString());
            }
            return 0;
        }
    }

    public static class LoadTestCmd
    extends CmdInt.Interpreter.SimpleCommand {
        public LoadTestCmd() {
            super("loadtest", "<#threads> <#objects> <#seconds>", "start load test");
        }

        public int Exec(CmdInt.Interpreter cmdint, String[] args) {
            CacheAccess[] acc;
            TestEnv te = (TestEnv)cmdint;
            if (args.length < 4) {
                CmdInt.SimpleCommand.ArgumentMissing();
            }
            if (args.length == 4) {
                if (te.access == null) {
                    CmdInt.SimpleCommand.Error("no region set");
                }
                acc = new CacheAccess[]{te.access};
            } else {
                acc = new CacheAccess[args.length - 4];
                int i = 4;
                while (i < args.length) {
                    try {
                        acc[i - 4] = CacheAccess.getAccess(args[i]);
                    }
                    catch (CacheException e) {
                        CmdInt.SimpleCommand.Error("no access for region " + args[i] + ": " + e);
                    }
                    ++i;
                }
            }
            try {
                int p = Integer.parseInt(args[1]);
                int o = Integer.parseInt(args[2]);
                long t = Integer.parseInt(args[3]) * 1000;
                System.out.println("*** starting load test (" + t / 1000L + " seconds)");
                Thread[] threads = new Thread[p];
                int i = 0;
                while (i < p) {
                    threads[i] = new LoadTestThread(acc[i % acc.length], i + 1, o, t);
                    threads[i].start();
                    ++i;
                }
                int i2 = 0;
                while (i2 < p) {
                    threads[i2].join();
                    ++i2;
                }
            }
            catch (Exception e) {
                CmdInt.SimpleCommand.Error("illegal number format");
            }
            return 0;
        }

        static class LoadTestThread
        extends Thread {
            long time;
            int objects;
            int id;
            CacheAccess acc;

            LoadTestThread(CacheAccess acc, int id, int objects, long time) {
                this.objects = objects;
                this.time = new Date().getTime() + time;
                this.id = id;
                this.acc = acc;
            }

            private void println(Object o) {
                System.out.println("### Thread " + this.id + "(" + this.acc.getRegionName() + "): " + o);
            }

            public void run() {
                this.println("starting load test: until " + this.time);
                int cnt = 0;
                Random r = new Random(new Date().getTime());
                while (true) {
                    if (++cnt % 1000 == 0) {
                        long t = new Date().getTime();
                        this.println("" + t + ": loop " + cnt);
                        if (t >= this.time) break;
                    }
                    if (r.nextInt(3) == 1) {
                        Thread.currentThread();
                        Thread.yield();
                    }
                    String key = "o" + r.nextInt(this.objects);
                    try {
                        Object o = this.acc.get(key);
                        if (o != null) continue;
                        this.println("  key " + key + " not found");
                    }
                    catch (Exception e) {
                        this.println("  " + e);
                        e.printStackTrace();
                        System.exit(1);
                    }
                }
                this.println("done");
            }
        }
    }

    public static class CleanupTestCmd
    extends CmdInt.Interpreter.SimpleCommand {
        public CleanupTestCmd() {
            super("cleanuptest", "<#threads> <#seconds>", "start cleanup threads");
        }

        public int Exec(CmdInt.Interpreter cmdint, String[] args) {
            TestEnv te = (TestEnv)cmdint;
            CmdInt.SimpleCommand.CheckNumberOfArguments(args, 3);
            if (te.access == null) {
                CmdInt.SimpleCommand.Error("no region set");
            }
            try {
                int p = Integer.parseInt(args[1]);
                long t = Integer.parseInt(args[2]) * 1000;
                System.out.println("*** starting cleanup threads (" + t / 1000L + " seconds)");
                Thread[] threads = new Thread[p];
                int i = 0;
                while (i < p) {
                    new CleanupThread(te, i + 1, t).start();
                    ++i;
                }
            }
            catch (Exception e) {
                CmdInt.SimpleCommand.Error("illegal number format");
            }
            return 0;
        }

        static class CleanupThread
        extends Thread {
            long time;
            int id;
            TestEnv te;

            CleanupThread(TestEnv te, int id, long time) {
                this.time = new Date().getTime() + time;
                this.id = id;
                this.te = te;
            }

            private void println(Object o) {
                System.out.println("### CThread " + this.id + ": " + o);
            }

            public void run() {
                this.println("starting cleanup thread: until " + this.time);
                int cnt = 0;
                Random r = new Random(new Date().getTime());
                while (true) {
                    if (++cnt % 10000 == 0) {
                        long t = new Date().getTime();
                        this.println("" + t + ": loop " + cnt);
                        if (t >= this.time) break;
                    }
                    if (r.nextInt(3) == 1) {
                        Thread.currentThread();
                        Thread.yield();
                    }
                    try {
                        CacheAdmin.cleanup();
                    }
                    catch (Exception e) {
                        this.println("  " + e);
                        e.printStackTrace();
                        System.exit(1);
                    }
                }
                this.println("done");
            }
        }
    }

    public static class YieldCmd
    extends CmdInt.Interpreter.SimpleCommand {
        public YieldCmd() {
            super("yield", "", "yield");
        }

        public int Exec(CmdInt.Interpreter cmdint, String[] args) {
            try {
                Thread.currentThread();
                Thread.yield();
            }
            catch (Exception e) {
                CmdInt.SimpleCommand.Error("illegal time format");
            }
            return 0;
        }
    }

    public static class SleepCmd
    extends CmdInt.Interpreter.SimpleCommand {
        public SleepCmd() {
            super("sleep", "<sec>", "sleep");
        }

        public int Exec(CmdInt.Interpreter cmdint, String[] args) {
            CmdInt.SimpleCommand.CheckNumberOfArguments(args, 2, "time missing");
            try {
                long t = Integer.parseInt(args[1]);
                System.out.println("*** sleeping " + t + " seconds");
                Thread.currentThread();
                Thread.sleep(t * 1000L);
            }
            catch (Exception e) {
                CmdInt.SimpleCommand.Error("illegal time format");
            }
            return 0;
        }
    }

    public static class MemoryCmd
    extends CmdInt.Interpreter.SimpleCommand {
        public MemoryCmd() {
            super("memory", "", "grep all memory");
        }

        public void add(Vector v, int blocksize) {
            if (v != null) {
                v.add(new char[blocksize]);
            }
        }

        public int Exec(CmdInt.Interpreter cmdint, String[] args) {
            int blocksize = 100000;
            int cnt = 0;
            SoftReference store = new SoftReference(new Vector());
            CmdInt.SimpleCommand.CheckNumberOfArguments(args, 1);
            while (((Reference)store).get() != null) {
                this.add((Vector)((Reference)store).get(), blocksize);
                ++cnt;
                System.gc();
            }
            System.out.println("" + cnt + " block allocated (" + cnt * blocksize + ")");
            return 0;
        }
    }

    public static class GCCmd
    extends CmdInt.Interpreter.SimpleCommand {
        public GCCmd() {
            super("gc", "", "garbage collection");
        }

        public int Exec(CmdInt.Interpreter cmdint, String[] args) {
            CmdInt.SimpleCommand.CheckNumberOfArguments(args, 1);
            System.gc();
            System.runFinalization();
            return 0;
        }
    }

    public static class CleanupCmd
    extends CmdInt.Interpreter.SimpleCommand {
        public CleanupCmd() {
            super("cleanup", "[<# steps>]", "house keeping for all regions");
        }

        public int Exec(CmdInt.Interpreter cmdint, String[] args) {
            CmdInt.SimpleCommand.CheckNumberOfArguments(args, 1, 2);
            if (args.length == 1) {
                CacheAdmin.cleanup();
            } else {
                try {
                    int n = Integer.parseInt(args[1]);
                    long time = new Date().getTime();
                    while (n-- > 0) {
                        CacheAdmin.cleanupStep(time);
                    }
                }
                catch (Exception e) {
                    CmdInt.SimpleCommand.Error("illegal number");
                }
            }
            return 0;
        }
    }

    public static class SpeedCmd
    extends CmdInt.Interpreter.SimpleCommand {
        public SpeedCmd() {
            super("speed", "[<flags>] [<key>]", "access time");
        }

        public int Exec(CmdInt.Interpreter cmdint, String[] args) {
            Object e;
            int n = 100000;
            CmdInt.SimpleCommand.CheckNumberOfArguments(args, 1, 2);
            long start = new Date().getTime();
            int i = 0;
            while (i < n) {
                ++i;
            }
            long end = new Date().getTime();
            double ss = ((double)end - (double)start) / (double)n;
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("elem1", new String("entry1"));
            map.put("elem2", new String("entry2"));
            map.put("elem3", new String("entry3"));
            start = new Date().getTime();
            i = 0;
            while (i < n) {
                e = map.get("elem2");
                ++i;
            }
            end = new Date().getTime();
            double ms = ((double)end - (double)start) / (double)n - ss;
            start = new Date().getTime();
            i = 0;
            while (i < n) {
                end = new Date().getTime();
                ++i;
            }
            end = new Date().getTime();
            double gs = ((double)end - (double)start) / (double)n - ss;
            if (args.length == 1) {
                System.out.println("time: " + ms);
            } else {
                String name = args[1];
                TestEnv te = (TestEnv)cmdint;
                if (te.access == null) {
                    CmdInt.SimpleCommand.Error("no region set");
                }
                try {
                    e = te.access.get(name);
                    System.out.println(name + " = " + e);
                    double cs1 = this.time(te, name, n) - ss;
                    CacheAdmin.setCleanupStepHandling(te.access.getRegionName(), false);
                    double cs2 = this.time(te, name, n) - ss;
                    CacheAdmin.setCleanupStepHandling(te.access.getRegionName(), true);
                    System.out.println("time for loop     : " + ss);
                    System.out.println("time with hashmap : " + ms);
                    System.out.println("time for get time : " + gs);
                    System.out.println("time with steps   : " + cs1 + ", factor " + cs1 / ms);
                    System.out.println("     without time : " + (cs1 - gs) + ", factor " + (cs1 - gs) / ms);
                    System.out.println("time without steps: " + cs2 + ", factor " + cs2 / ms);
                    System.out.println("factor            : " + cs1 / cs2);
                }
                catch (Exception ex) {
                    CmdInt.SimpleCommand.Error(ex.toString());
                }
            }
            return 0;
        }

        double time(TestEnv te, String name, int n) {
            try {
                long start = new Date().getTime();
                int i = 0;
                while (i < n) {
                    Object e = te.access.get(name);
                    ++i;
                }
                long end = new Date().getTime();
                return ((double)end - (double)start) / (double)n;
            }
            catch (Exception ex) {
                return 0.0;
            }
        }
    }

    public static class UnRefCmd
    extends CmdInt.Interpreter.SimpleCommand {
        public UnRefCmd() {
            super("unref", "[<name>]", "unref cache object");
        }

        public int Exec(CmdInt.Interpreter cmdint, String[] args) {
            CmdInt.SimpleCommand.CheckNumberOfArguments(args, 1, 2);
            if (args.length > 1) {
                if (CacheObject.objects.containsKey(args[1])) {
                    CacheObject.objects.remove(args[1]);
                } else {
                    CmdInt.SimpleCommand.Error(args[1] + " not registered");
                }
            } else {
                Iterator i = ((AbstractList)new ArrayList(CacheObject.objects.keySet())).iterator();
                while (i.hasNext()) {
                    String e = (String)i.next();
                    CacheObject.objects.remove(e);
                }
            }
            return 0;
        }
    }

    public static class ObjectsCmd
    extends CmdInt.Interpreter.SimpleCommand {
        public ObjectsCmd() {
            super("objects", "[off|on]", "list referenced cache objects");
        }

        public int Exec(CmdInt.Interpreter cmdint, String[] args) {
            CmdInt.SimpleCommand.CheckNumberOfArguments(args, 1, 2);
            if (args.length == 2) {
                CacheObject.store = args[1].equals("on");
                System.out.println("object store is " + CacheObject.store);
            } else {
                Iterator i = CacheObject.objects.keySet().iterator();
                System.out.println("Referenced Cache Objects");
                while (i.hasNext()) {
                    String n = (String)i.next();
                    System.out.println("  " + n);
                }
            }
            return 0;
        }
    }

    static class CacheObject
    implements Serializable {
        String name;
        Date date;
        static HashMap objects = new HashMap();
        static boolean store = true;

        CacheObject(String name) {
            this.name = name;
            this.date = new Date();
            if (store) {
                objects.put(name, this);
            }
        }

        public String getName() {
            return this.name;
        }

        public String toString() {
            String host;
            try {
                host = InetAddress.getLocalHost().getHostName();
            }
            catch (Exception e) {
                host = "localhost";
            }
            return "CacheObject: " + this.name + "(created on " + host + " " + this.date + ")";
        }

        public void finalize() {
            System.out.println("--- finalize " + this);
        }
    }

    public static class Loader
    extends CacheLoader {
        String text;

        public Loader(Properties props) {
            super(props);
            this.text = props.getProperty("text");
        }

        public Object load(Object handle, Object arg) {
            System.out.println("loading " + this.getRegion(handle) + ":" + this.getName(handle));
            String name = this.text + "(" + this.getRegion(handle) + ":" + this.getName(handle) + ")";
            return new CacheObject(name);
        }
    }

    public static class UnregisterCmd
    extends CmdInt.Interpreter.SimpleCommand {
        public UnregisterCmd() {
            super("unregister", "<name>", "unregister cache objects");
        }

        public int Exec(CmdInt.Interpreter cmdint, String[] args) {
            CmdInt.SimpleCommand.CheckNumberOfArguments(args, 2);
            if (regs.contains(args[1])) {
                regs.unregister(args[1]);
            } else {
                CmdInt.SimpleCommand.Error(args[1] + " not registered");
            }
            return 0;
        }
    }

    public static class RegistrationsCmd
    extends CmdInt.Interpreter.SimpleCommand {
        public RegistrationsCmd() {
            super("registrations", "[on|off]", "list cache object registrations");
        }

        public int Exec(CmdInt.Interpreter cmdint, String[] args) {
            CmdInt.SimpleCommand.CheckNumberOfArguments(args, 1, 2);
            if (args.length == 2) {
                if (args[1].equals("on")) {
                    RegistrationDestination.registerRegistrationHandler(regs);
                } else {
                    RegistrationDestination.unregisterRegistrationHandler(regs);
                }
            } else {
                Enumeration i = TestEnv.regs.registrations.keys();
                System.out.println("Registered Cache Objects");
                while (i.hasMoreElements()) {
                    String n = (String)i.nextElement();
                    System.out.println("  " + n);
                }
            }
            return 0;
        }
    }

    static class CacheRegistrations
    implements RegistrationDestination.IRegistrationHandler {
        WeakHashTable registrations = new WeakHashTable();
        WeakHashMap names = new WeakHashMap();

        CacheRegistrations() {
        }

        public void notifyRegistration(Registration r) {
            Object o = r.getObject();
            if (o instanceof CacheObject) {
                String name = ((CacheObject)o).getName();
                System.out.println("+++ register cache object " + name);
                this.registrations.put(name, r);
                this.names.put(r, name);
            }
        }

        public void notifyUnregistration(Registration r) {
            String name = (String)this.names.get(r);
            if (name != null) {
                System.out.println("+++ unregister cache object " + name);
                this.names.remove(r);
                this.registrations.remove(name);
            }
        }

        public boolean contains(String name) {
            return this.registrations.containsKey(name);
        }

        public void unregister(String name) {
            Registration r = (Registration)this.registrations.get(name);
            if (r != null) {
                r.unregister();
                this.registrations.remove(name);
                this.names.remove(r);
            }
        }
    }
}

