/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ip.basecomps.cache;

public class StatisticEntry {
    long hit_count;
    long load_count;
    long read_count;
    long write_count;

    StatisticEntry() {
    }

    synchronized void notifyHit() {
        ++this.hit_count;
        ++this.read_count;
    }

    synchronized void notifyMiss() {
        ++this.read_count;
    }

    synchronized void notifyLoad() {
        ++this.load_count;
    }

    synchronized void notifyWrite() {
        ++this.write_count;
    }

    public synchronized long getHitCount() {
        return this.hit_count;
    }

    public synchronized long getMissCount() {
        return this.read_count - this.hit_count;
    }

    public synchronized long getLoadCount() {
        return this.load_count;
    }

    public synchronized long getFailCount() {
        return this.getMissCount() - this.load_count;
    }

    public synchronized long getReadCount() {
        return this.read_count;
    }

    public synchronized long getWriteCount() {
        return this.write_count;
    }

    public synchronized void reset() {
        this.write_count = 0L;
        this.load_count = 0L;
        this.read_count = 0L;
        this.hit_count = 0L;
    }

    public void print() {
        this.print(null);
    }

    public synchronized void print(String txt) {
        System.out.println("*** statistic info" + (txt == null ? "" : " " + txt) + " ***");
        System.out.println("  read  : " + this.getReadCount());
        System.out.println("   hits : " + this.getHitCount());
        System.out.println("   miss : " + this.getMissCount());
        System.out.println("    load: " + this.getLoadCount());
        System.out.println("    fail: " + this.getFailCount());
        System.out.println("  write : " + this.getWriteCount());
    }
}

