/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ip.basecomps.cache;

import com.sap.ip.basecomps.cache.Attributes;
import com.sap.ip.basecomps.cache.CacheAccess;
import com.sap.ip.basecomps.cache.CacheAccessFactory;
import com.sap.ip.basecomps.cache.CacheAdmin;
import com.sap.ip.basecomps.cache.CacheException;
import com.sap.ip.basecomps.cache.CacheLoader;
import com.sap.ip.basecomps.cache.CacheNotAvailableException;
import com.sap.ip.basecomps.cache.DefaultPreemptionHandler;
import com.sap.ip.basecomps.cache.EntryAttributes;
import com.sap.ip.basecomps.cache.EntryState;
import com.sap.ip.basecomps.cache.EventHandler;
import com.sap.ip.basecomps.cache.HandlerRegistrations;
import com.sap.ip.basecomps.cache.InvalidGroupException;
import com.sap.ip.basecomps.cache.KeyHandler;
import com.sap.ip.basecomps.cache.NotARetrievableObjectException;
import com.sap.ip.basecomps.cache.ObjectExistsException;
import com.sap.ip.basecomps.cache.ObjectNotFoundException;
import com.sap.ip.basecomps.cache.OwnerFactory;
import com.sap.ip.basecomps.cache.OwnerInfo;
import com.sap.ip.basecomps.cache.PreemptionEventHandler;
import com.sap.ip.basecomps.cache.PreemptionHandler;
import com.sap.ip.basecomps.cache.RegionHandle;
import com.sap.ip.basecomps.cache.StateChangeEventHandler;
import com.sap.ip.basecomps.cache.StatisticEntry;
import com.sap.ip.basecomps.cache.ThreadOwnerFactory;
import com.sap.ip.basecomps.cache.TimeoutException;
import com.sap.ip.basecomps.consistency.ConsistencyDomain;
import com.sap.ip.basecomps.consistency.ConsistencyDomains;
import com.sap.ip.basecomps.debug.Debug;
import com.sap.ip.basecomps.util.reg.Registration;
import java.lang.ref.Reference;
import java.lang.ref.SoftReference;
import java.lang.ref.WeakReference;
import java.util.AbstractList;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.Vector;
import java.util.WeakHashMap;

class Region {
    private static Debug deb = Debug.getDebug("cache");
    volatile Attributes attr;
    private volatile String name;
    private volatile String path;
    private volatile String basename;
    private volatile Region parent;
    private HashMap subregions = new HashMap();
    private volatile long max;
    private volatile Counts counts = new Counts();
    private volatile PreemptionHandler.PreemptionCacheAccess access;
    private volatile boolean use_exceptions;
    private volatile boolean unique_mapping;
    private volatile boolean async_events;
    private volatile PreemptionHandler preempt;
    private WeakHashMap accessmap = new WeakHashMap();
    private volatile HashMap groups = new HashMap();
    private volatile HashMap entries = new HashMap();
    private volatile boolean dosteps = true;
    private volatile int stepgap = 10;
    private volatile int stepstate = 0;
    private volatile HandlerRegistrations handlers = new HandlerRegistrations();
    private Vector list = new Vector();
    private int frozen = 0;
    private int deleted = 0;
    volatile StatisticEntry statistic = new StatisticEntry();

    static long getMillis() {
        return System.currentTimeMillis();
    }

    Region(String name, String path, String basename, Region parent, Attributes attr) throws CacheNotAvailableException {
        this.name = name;
        this.path = path;
        this.basename = basename;
        this.parent = parent;
        this.attr = new Attributes(attr);
        this.attr.created = Region.getMillis();
        this.fillinDefaults();
        this._setup();
        this.access = new PreemptionHandler.PreemptionCacheAccess(this);
        this.preempt.setCacheAccess(this.access);
    }

    synchronized void addRegion(Region r) {
        this.subregions.put(r.getBaseName(), r);
    }

    synchronized void removeRegion(Region r) {
        this.subregions.remove(r.getBaseName());
    }

    public String getRegionName() {
        return this.name;
    }

    public String getBaseName() {
        return this.basename;
    }

    public String getPath() {
        return this.path;
    }

    public Region getParent() {
        return this.parent;
    }

    public Set getSubRegions() {
        return new HashSet(this.subregions.keySet());
    }

    public synchronized boolean hasSubRegions() {
        return this.subregions.size() != 0;
    }

    private void fillinDefaults() {
        if (this.attr.getOwnerFactory() == null) {
            this.attr.ownerfac = new ThreadOwnerFactory();
        }
        if (this.attr.getConsistencyDomain() == null) {
            this.attr.domain = ConsistencyDomains.queryDomain("<LOCAL>");
        }
        if (this.attr.getPreemptionHandler() == null) {
            this.attr.preempt = new DefaultPreemptionHandler();
        }
    }

    protected void finalize() throws Throwable {
        super.finalize();
        if (deb.active()) {
            deb.out("finalize region " + this.name);
        }
    }

    private void _setup() {
        this.max = this.attr.getMaxWeight();
        this.async_events = !this.attr.syncEvents();
        this.unique_mapping = this.attr.useUniqueMapping();
        this.use_exceptions = this.attr.useExceptions();
        this.preempt = new Preemption(this.attr.getPreemptionHandler());
    }

    synchronized void setCounts(CacheAdmin.Counts c) {
        this.counts.copyTo(c);
        c.entries = this.getSize();
        c.max = this.getMaxWeight();
        c.frozen = this.frozen;
        c.deleted = this.deleted;
    }

    void close() {
        Iterator i = this.getAccesses().iterator();
        while (i.hasNext()) {
            CacheAccess acc = (CacheAccess)i.next();
            acc.close();
        }
    }

    synchronized void open(CacheAccess acc) {
        this.accessmap.put(acc, null);
    }

    synchronized void close(CacheAccess acc) {
        this.accessmap.remove(acc);
    }

    public synchronized CacheAccess getAccess() {
        CacheAccessFactory f = this.attr.getAccessFactory();
        if (f != null) {
            return f.createCacheAccess(new RegionHandle(this));
        }
        return new CacheAccess(this);
    }

    synchronized Collection getAccesses() {
        return new HashSet(((AbstractMap)this.accessmap).keySet());
    }

    public synchronized int getNoOfOwnerInfos() {
        Iterator i = ((AbstractMap)this.accessmap).keySet().iterator();
        int sum = 0;
        while (i.hasNext()) {
            CacheAccess a = (CacheAccess)i.next();
            sum += a.getNoOfOwnerInfos();
        }
        return sum;
    }

    PreemptionHandler.PreemptionCacheAccess getPreemptionCacheAccess() {
        return this.access;
    }

    private void adjustKeptCount(int num, long weight) {
        this.counts.adjustKeptCount(num, weight);
    }

    private void adjustIdleCount(int num, long weight) {
        this.counts.adjustIdleCount(num, weight);
    }

    private void adjustPreemptedCount(int num, long weight) {
        this.counts.adjustPreemptedCount(num, weight);
    }

    private void adjustOutOfDateCount(int num, long weight) {
        this.counts.adjustOutOfDateCount(num, weight);
    }

    static long getWeight(Attributes attr) {
        return attr == null ? 1L : attr.getWeight();
    }

    private Group _queryGroup(String name) {
        return (Group)this.groups.get(name);
    }

    private synchronized Group queryGroup(String name) {
        Group g = (Group)this.groups.get(name);
        if (g != null && !g.requestUse()) {
            g = null;
        }
        return g;
    }

    private synchronized Element queryElement(Object name) {
        Element e = this._queryEntry(name);
        if (e == null && (e = (Group)this.groups.get(name)) != null && !e.requestUse()) {
            e = null;
        }
        return e;
    }

    private ConsistencyDomain getConsistencyDomain() {
        return this.attr.getConsistencyDomain();
    }

    private void _checkName(Object name) throws NotARetrievableObjectException {
        if (this.groups.get(name) != null) {
            throw new NotARetrievableObjectException(name.toString());
        }
    }

    private Group _checkNames(Object name, String group) throws InvalidGroupException, NotARetrievableObjectException {
        Group g = null;
        if (group != null && (g = this._queryGroup(group)) == null) {
            throw new InvalidGroupException(group);
        }
        this._checkName(name);
        return g;
    }

    public synchronized Attributes getAttributes() {
        this.attr.setWeight(this.getWeight());
        this.attr.setRealWeight(this.getRealWeight());
        this.attr.setUniqueMapping(this.unique_mapping);
        return this.attr;
    }

    public long getWeight() {
        return this.counts.getWeight();
    }

    public long getRealWeight() {
        return this.counts.getRealWeight();
    }

    public long getMaxWeight() {
        return this.max;
    }

    public synchronized int noofElems() {
        return this.list.size();
    }

    public synchronized int getSize() {
        return this.list.size() - this.deleted;
    }

    synchronized boolean setCleanupStepHandling(boolean dosteps) {
        boolean old = this.dosteps;
        this.dosteps = dosteps;
        return old;
    }

    private void globalCleanupStep() {
        if (this.dosteps) {
            this.globalCleanupStep(Region.getMillis());
        }
    }

    private void globalCleanupStep(long time) {
        if (this.dosteps) {
            try {
                if (this.stepstate-- <= 0) {
                    CacheAdmin.cleanupStep(time);
                    this.stepstate = this.stepgap;
                }
                Object var4_2 = null;
            }
            catch (Throwable throwable) {
                Object var4_3 = null;
                throw throwable;
            }
        }
    }

    public void registerHandler(EventHandler h) {
        this.handlers.registerHandler(h);
    }

    public void unregisterHandler(EventHandler h) {
        this.handlers.unregisterHandler(h);
    }

    private void handleStateChange(Object name, Object obj, EntryState sold, EntryState snew, StateChangeEventHandler.Reason reason) {
        this.handlers.handleStateChange(this.name, name, obj, sold, snew, reason);
    }

    private void handleInvalidation(Object name, Object obj) {
        this.handlers.handleInvalidation(this.name, name, obj);
    }

    private void handlePreemption(Object name, Object obj) {
        CacheLoader l;
        this.handlers.handlePreemption(this.name, name, obj);
        if (obj != null && (l = this.attr.getLoader()) != null && l instanceof PreemptionEventHandler) {
            ((PreemptionEventHandler)((Object)l)).handlePreemption(this.name, name, obj);
        }
    }

    private Entry _queryEntry(Object name) {
        Entry e = (Entry)this.entries.get(name);
        if (e != null && e.requestUse()) {
            return e;
        }
        return null;
    }

    private synchronized void addEntry(Object name, Entry e) {
        this.entries.put(name, e);
        this.list.add(e);
    }

    private synchronized void removeEntry(Entry e) {
        if (this.entries.get(e.getId()) == e) {
            this.entries.remove(e.getId());
        }
        if (this.frozen == 0) {
            this.list.remove(e);
        } else {
            int i = this.list.indexOf(e);
            if (i >= 0) {
                this.list.setElementAt(null, i);
                ++this.deleted;
            }
        }
    }

    synchronized void freeze() {
        ++this.frozen;
    }

    synchronized void unfreeze() {
        if (this.frozen > 0 && --this.frozen == 0 && this.deleted > 0) {
            int i = 0;
            while (i < this.list.size()) {
                if (this.list.elementAt(i) == null) {
                    this.list.removeElementAt(i);
                    continue;
                }
                ++i;
            }
            this.deleted = 0;
        }
    }

    private synchronized void removeGroup(Object name) {
        this.groups.remove(name);
    }

    private Entry _getEntry(Object name) {
        Entry e = this._queryEntry(name);
        if (e == null) {
            e = new Entry(name);
            e.requestUse();
        }
        return e;
    }

    PreemptionHandler.Entry queryPreemptionEntry(Object name) {
        Entry e;
        Region region = this;
        synchronized (region) {
            e = this._queryEntry(name);
        }
        if (e != null) {
            try {
                PreemptionHandler.Entry entry = e.getPreemptionEntry();
                Object var6_6 = null;
                e.releaseUse();
                return entry;
            }
            catch (Throwable throwable) {
                Object var6_7 = null;
                e.releaseUse();
                throw throwable;
            }
        }
        return null;
    }

    PreemptionHandler.Entry getEntryAt(int index) {
        Region region = this;
        synchronized (region) {
            Entry e = index >= 0 && index < this.list.size() ? (Entry)this.list.elementAt(index) : null;
            PreemptionHandler.Entry entry = e == null ? null : e.getPreemptionEntry();
            return entry;
        }
    }

    void cleanup() {
        Vector v;
        long time = Region.getMillis();
        Region region = this;
        synchronized (region) {
            v = (Vector)this.list.clone();
        }
        int size = v.size();
        int i = 0;
        while (i < size) {
            Entry e = (Entry)v.elementAt(i);
            if (e != null) {
                e.checkCleanup(time);
            }
            ++i;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public EntryState getState(CacheAccess acc, Object name) throws ObjectNotFoundException, NotARetrievableObjectException {
        try {
            Region region = this;
            // MONITORENTER : region
            this._checkName(name);
            Entry e = this._queryEntry(name);
            // MONITOREXIT : region
            if (e == null) {
                if (e.attr.useExceptions()) {
                    throw new ObjectNotFoundException(this.getRegionName(), name);
                }
                EntryState entryState = null;
                Object var9_7 = null;
                this.globalCleanupStep();
                return entryState;
            }
            try {
                EntryState entryState = e.getState();
                Object var7_10 = null;
                e.releaseUse();
                Object var9_8 = null;
                this.globalCleanupStep();
                return entryState;
            }
            catch (Throwable throwable) {
                Object var7_11 = null;
                e.releaseUse();
                throw throwable;
            }
        }
        catch (Throwable throwable) {
            Object var9_9 = null;
            this.globalCleanupStep();
            throw throwable;
        }
    }

    public Object get(CacheAccess acc, Object name) throws ObjectNotFoundException, NotARetrievableObjectException {
        return this.get(acc, name, null);
    }

    public Object get(CacheAccess acc, Object name, Object args) throws ObjectNotFoundException, NotARetrievableObjectException {
        try {
            Object object;
            Entry e;
            Region region = this;
            synchronized (region) {
                this._checkName(name);
                e = this._getEntry(name);
            }
            try {
                Object o = e.get(acc, args);
                if (o == null && e.attr.useExceptions()) {
                    throw new ObjectNotFoundException(this.getRegionName(), name);
                }
                object = o;
                Object var9_9 = null;
                e.releaseUse();
            }
            catch (Throwable throwable) {
                Object var9_10 = null;
                e.releaseUse();
                throw throwable;
            }
            Object var11_11 = null;
            this.globalCleanupStep();
            return object;
        }
        catch (Throwable throwable) {
            Object var11_12 = null;
            this.globalCleanupStep();
            throw throwable;
        }
    }

    public Object get(CacheAccess acc, Object name, String group, Object args) throws ObjectNotFoundException, InvalidGroupException, NotARetrievableObjectException {
        try {
            Object object;
            Entry e;
            Group g;
            Region region = this;
            synchronized (region) {
                g = this._checkNames(name, group);
                e = this._getEntry(name);
            }
            try {
                Object o = e.get(acc, g, args);
                if (o == null && e.attr.useExceptions()) {
                    throw new ObjectNotFoundException(this.getRegionName(), name);
                }
                object = o;
                Object var11_11 = null;
                e.releaseUse();
            }
            catch (Throwable throwable) {
                Object var11_12 = null;
                e.releaseUse();
                throw throwable;
            }
            Object var13_13 = null;
            this.globalCleanupStep();
            return object;
        }
        catch (Throwable throwable) {
            Object var13_14 = null;
            this.globalCleanupStep();
            throw throwable;
        }
    }

    public boolean isMapped(Object name) throws NotARetrievableObjectException {
        Entry e;
        Region region = this;
        synchronized (region) {
            this._checkName(name);
            e = this._queryEntry(name);
        }
        if (e != null) {
            try {
                boolean bl = e.isMapped();
                Object var6_6 = null;
                e.releaseUse();
                return bl;
            }
            catch (Throwable throwable) {
                Object var6_7 = null;
                e.releaseUse();
                throw throwable;
            }
        }
        return false;
    }

    public boolean containsGroup(Object name) {
        try {
            Region region = this;
            synchronized (region) {
                boolean bl = this.groups.get(name) != null;
                // MONITOREXIT @DISABLED, blocks:[0, 1, 2] lbl6 : MonitorExitStatement: MONITOREXIT : var3_2
                Object var7_4 = null;
                this.globalCleanupStep();
                return bl;
            }
        }
        catch (Throwable throwable) {
            Object var7_5 = null;
            this.globalCleanupStep();
            throw throwable;
        }
    }

    public EntryAttributes getAttributes(Object name) throws ObjectNotFoundException, InvalidGroupException, NotARetrievableObjectException {
        Element e = this.queryElement(name);
        if (deb.active()) {
            deb.out("getting attr for " + name + "(" + e + ")");
        }
        if (e != null) {
            try {
                EntryAttributes entryAttributes = e.getAttributes();
                Object var5_4 = null;
                e.releaseUse();
                return entryAttributes;
            }
            catch (Throwable throwable) {
                Object var5_5 = null;
                e.releaseUse();
                throw throwable;
            }
        }
        throw new ObjectNotFoundException(this.getRegionName(), name);
    }

    public void put(CacheAccess acc, Object name, String group, Attributes attr, Object obj) throws CacheException {
        Entry e;
        Group g;
        Region region = this;
        synchronized (region) {
            g = this._checkNames(name, group);
            e = this._getEntry(name);
        }
        try {
            e.put(acc, g, attr, obj);
            Object var11_10 = null;
            e.releaseUse();
        }
        catch (Throwable throwable) {
            Object var11_11 = null;
            e.releaseUse();
            throw throwable;
        }
    }

    public void defineObject(Object name, String group, Attributes attr) throws CacheException {
        Group g;
        Entry e = null;
        Region region = this;
        synchronized (region) {
            g = this._checkNames(name, group);
            e = this._queryEntry(name);
            if (e == null) {
                e = new Entry(name, attr, g);
                return;
            }
        }
        try {
            e.redefine(attr, g);
            Object var9_8 = null;
            e.releaseUse();
        }
        catch (Throwable throwable) {
            Object var9_9 = null;
            e.releaseUse();
            throw throwable;
        }
    }

    public void destroy(CacheAccess acc) throws CacheException {
        this.delete(acc, StateChangeEventHandler.Reason.DESTROYED);
    }

    public void delete(CacheAccess acc) throws CacheException {
        this.delete(acc, StateChangeEventHandler.Reason.DELETED);
    }

    public void delete(CacheAccess acc, StateChangeEventHandler.Reason reason) throws CacheException {
        Element e;
        Iterator<Object> i;
        ArrayList ent = new ArrayList();
        ArrayList grp = new ArrayList();
        Region region = this;
        synchronized (region) {
            i = this.entries.values().iterator();
            while (i.hasNext()) {
                ent.add(i.next());
            }
            i = this.groups.values().iterator();
            while (i.hasNext()) {
                grp.add(i.next());
            }
        }
        i = ((AbstractList)ent).iterator();
        while (i.hasNext()) {
            e = (Element)i.next();
            e.delete(reason);
            if (reason != StateChangeEventHandler.Reason.DESTROYED) continue;
            e.invalidate(acc);
        }
        i = ((AbstractList)grp).iterator();
        while (i.hasNext()) {
            e = (Element)i.next();
            e.delete(reason);
        }
    }

    public void destroy(CacheAccess acc, Object name) throws CacheException {
        this.delete(acc, name, StateChangeEventHandler.Reason.DESTROYED);
    }

    public void delete(CacheAccess acc, Object name) throws CacheException {
        this.delete(acc, name, StateChangeEventHandler.Reason.DELETED);
    }

    private void delete(CacheAccess acc, Object name, StateChangeEventHandler.Reason reason) throws CacheException {
        Element e;
        Region region = this;
        synchronized (region) {
            e = this.queryElement(name);
            if (e == null && reason == StateChangeEventHandler.Reason.DESTROYED) {
                e = this._getEntry(name);
            }
        }
        if (e != null) {
            e.releaseUse();
            e.delete(reason);
            if (acc != null && reason == StateChangeEventHandler.Reason.DESTROYED) {
                e.invalidate(acc);
            }
        }
    }

    public Object replace(CacheAccess acc, Object name, String group, Attributes attr, Object obj) throws CacheException {
        Entry e;
        Group g;
        Region region = this;
        synchronized (region) {
            g = this._checkNames(name, group);
            e = this._getEntry(name);
        }
        try {
            obj = e.replace(acc, g, attr, obj);
            Object var11_10 = null;
            e.releaseUse();
        }
        catch (Throwable throwable) {
            Object var11_11 = null;
            e.releaseUse();
            throw throwable;
        }
        return obj;
    }

    public String getGroup(CacheAccess acc, Object name) throws CacheException {
        Element e = this.queryElement(name);
        Group g = null;
        if (e != null) {
            try {
                g = e.getGroup();
                Object var6_5 = null;
                e.releaseUse();
            }
            catch (Throwable throwable) {
                Object var6_6 = null;
                e.releaseUse();
                throw throwable;
            }
        }
        return g == null ? null : g.getName();
    }

    public Set getGroupMembers(CacheAccess acc, Object name) throws CacheException {
        Group g;
        Region region = this;
        synchronized (region) {
            if (name == null) {
                Set set = null;
                return set;
            }
            g = (Group)this.groups.get(name);
            if (g == null) {
                throw new InvalidGroupException(name.toString());
            }
        }
        return g.getMemberIds();
    }

    public Set getGroupElements(CacheAccess acc, Object name) throws CacheException {
        Group g;
        Region region = this;
        synchronized (region) {
            if (name == null) {
                Set set = null;
                return set;
            }
            g = (Group)this.groups.get(name);
            if (g == null) {
                throw new InvalidGroupException(name.toString());
            }
        }
        return g.getMembers();
    }

    public Set getEntries(CacheAccess acc) {
        List list = this.getEntries();
        HashSet<CacheAccess.Entry> result = new HashSet<CacheAccess.Entry>();
        Iterator i = list.iterator();
        HashMap elems = new HashMap();
        while (i.hasNext()) {
            Entry e = (Entry)i.next();
            result.add(new CacheAccess.Entry(e, elems));
        }
        return result;
    }

    public Set getGroups(CacheAccess acc, boolean toplevel) {
        Group g;
        Iterator<Object> i;
        ArrayList<Group> list = new ArrayList<Group>();
        HashSet<CacheAccess.Group> result = new HashSet<CacheAccess.Group>();
        HashMap elems = new HashMap();
        Region region = this;
        synchronized (region) {
            i = this.groups.values().iterator();
            while (i.hasNext()) {
                g = (Group)i.next();
                if (toplevel && g.getGroup() != null) continue;
                list.add(g);
            }
        }
        i = ((AbstractList)list).iterator();
        while (i.hasNext()) {
            g = (Group)i.next();
            result.add(new CacheAccess.Group(g, elems));
        }
        return result;
    }

    public synchronized List getEntries() {
        ArrayList list = new ArrayList();
        Region region = this;
        synchronized (region) {
            Iterator i = this.entries.values().iterator();
            while (i.hasNext()) {
                list.add(i.next());
            }
        }
        return list;
    }

    public List getEntries(Object pattern) throws CacheException {
        KeyHandler h = this.attr.getKeyHandler();
        ArrayList<Element> list = new ArrayList<Element>();
        if (h != null) {
            Region region = this;
            synchronized (region) {
                Element e;
                Iterator i = this.entries.values().iterator();
                while (i.hasNext()) {
                    e = (Element)i.next();
                    if (!h.match(pattern, e.getId())) continue;
                    list.add(e);
                }
                i = this.groups.values().iterator();
                while (i.hasNext()) {
                    e = (Element)i.next();
                    if (!h.match(pattern, e.getId())) continue;
                    list.add(e);
                }
            }
        }
        return list;
    }

    public CacheAccess.EntryHandle queryEntry(Object name) {
        Element e = this.queryElement(name);
        if (e != null) {
            e.releaseUse();
        }
        return e;
    }

    public synchronized CacheAccess.EntryHandle getEntry(Object name) {
        Element e = this.queryElement(name);
        if (e != null) {
            e = this._getEntry(name);
        }
        if (e != null) {
            e.releaseUse();
        }
        return e;
    }

    public void invalidate(CacheAccess acc, CacheAccess.EntryHandle entry) throws CacheException {
        Element e = (Element)entry;
        Element c = this.queryElement(e.getId());
        if (c != null) {
            e = c;
        }
        try {
            e.invalidate(acc);
            Object var6_5 = null;
            if (c != null) {
                c.releaseUse();
            }
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            if (c != null) {
                c.releaseUse();
            }
            throw throwable;
        }
    }

    public void invalidateLocal(CacheAccess.EntryHandle entry) throws CacheException {
        Element e = (Element)entry;
        Element c = this.queryElement(e.getId());
        if (c != null) {
            try {
                if (e == c) {
                    c.invalidateLocal();
                }
                Object var5_4 = null;
                c.releaseUse();
            }
            catch (Throwable throwable) {
                Object var5_5 = null;
                c.releaseUse();
                throw throwable;
            }
        }
    }

    public void defineGroup(String name, String group, Attributes attr) throws CacheException {
        Group n = null;
        Group g = null;
        Region region = this;
        synchronized (region) {
            n = this._queryGroup(name);
            if (n != null) {
                throw new ObjectExistsException(name);
            }
            if (group != null && (g = this._queryGroup(group)) == null) {
                new InvalidGroupException(group);
            }
            n = new Group(name, attr, g);
            this.groups.put(name, n);
        }
    }

    public boolean getOwnership(CacheAccess acc, Object name, int timeout) throws CacheException {
        Entry e;
        OwnerInfo i;
        Region region = this;
        synchronized (region) {
            this._checkName(name);
            i = this.getOwnerInfo(acc);
            e = this._getEntry(name);
        }
        try {
            try {
                e.getLock().lock(i.group, (long)timeout);
            }
            catch (Exception io) {
                boolean bl = false;
                Object var10_10 = null;
                e.releaseUse();
                return bl;
            }
            Object var10_9 = null;
            e.releaseUse();
        }
        catch (Throwable throwable) {
            Object var10_11 = null;
            e.releaseUse();
            throw throwable;
        }
        return true;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void releaseOwnership(CacheAccess acc, Object name) throws CacheException {
        Entry e;
        OwnerInfo i;
        Region region = this;
        synchronized (region) {
            this._checkName(name);
            i = this.getOwnerInfo(acc);
            e = this._queryEntry(name);
        }
        if (e == null) return;
        try {
            try {
                e.getLock().unlock(i.group);
            }
            catch (Exception io) {
                throw new CacheException("release failed");
            }
            Object var8_6 = null;
        }
        catch (Throwable throwable) {
            Object var8_7 = null;
            e.handleEvents(null);
            e.releaseUse();
            throw throwable;
        }
        e.handleEvents(null);
        e.releaseUse();
    }

    public void releaseOwnership(CacheAccess acc) throws CacheException {
        this.releaseOwnership(this.getOwnerInfo(acc));
    }

    public void releaseOwnership(OwnerInfo i) throws CacheException {
        i.group.unlock();
    }

    public void waitForResponse(CacheAccess acc, long timeout) throws TimeoutException {
        OwnerInfo i = this.getOwnerInfo(acc);
        try {
            if (!i.waitForConfirmation(timeout)) {
                throw new TimeoutException();
            }
        }
        catch (Exception e) {
            // empty catch block
        }
    }

    public void cancelResponse(CacheAccess acc) {
        OwnerInfo i = this.getOwnerInfo(acc);
        i.cancelConfirmation();
    }

    synchronized OwnerInfo getOwnerInfo(CacheAccess acc) {
        Object o = this.attr.getOwnerFactory().getCurrentOwner(acc);
        return acc.getOwnerInfo();
    }

    void notifyHit() {
        this.statistic.notifyHit();
    }

    void notifyMiss() {
        this.statistic.notifyMiss();
    }

    void notifyLoad() {
        this.statistic.notifyLoad();
    }

    void notifyWrite() {
        this.statistic.notifyWrite();
    }

    StatisticEntry getStatistics() {
        return this.statistic;
    }

    class _GroupAttributes
    extends EntryAttributes {
        volatile Element elem;

        _GroupAttributes(Element e) {
            this.elem = e;
        }

        _GroupAttributes(Element e, Attributes attr) {
            this(e);
            this.join(attr);
        }

        protected Attributes getBase() {
            Attributes result = this.elem.getGroup() != null ? this.elem.getGroup().getAttributes() : Region.this.attr;
            return result;
        }

        public long getMaxWeight() {
            return 0L;
        }

        public ConsistencyDomain getConsistencyDomain() {
            return Region.this.getAttributes().getConsistencyDomain();
        }

        public void setConsistencyDomain(ConsistencyDomain d) {
        }

        public OwnerFactory getOwnerFactory() {
            return Region.this.getAttributes().getOwnerFactory();
        }

        public void setOwnerFactory(OwnerFactory f) {
        }

        public PreemptionHandler getPreemptionHandler() {
            return Region.this.getAttributes().getPreemptionHandler();
        }

        public void setPreemptionHandler(PreemptionHandler h) {
        }

        public KeyHandler getKeyHandler() {
            return Region.this.getAttributes().getKeyHandler();
        }

        public void setKeyHandler(KeyHandler h) {
        }
    }

    class Group
    implements Element {
        volatile String name;
        volatile _GroupAttributes attr;
        volatile HashSet entries = new HashSet();
        volatile Group group;

        Group(String name) {
            this.name = name;
        }

        Group(String name, Attributes a, Group g) {
            this.name = name;
            this.attr = new _GroupAttributes(this, a);
            this._setGroup(g);
        }

        public boolean requestUse() {
            return true;
        }

        public void releaseUse() {
        }

        public Object getId() {
            return this.name;
        }

        public String getName() {
            return this.name;
        }

        public EntryAttributes getAttributes() {
            return this.attr;
        }

        public Set getMemberIds() {
            HashSet<Object> set = new HashSet<Object>();
            Iterator i = this.iterator();
            while (i.hasNext()) {
                Element e = (Element)i.next();
                set.add(e.getId());
            }
            return set;
        }

        public Set getMembers() {
            HashSet<CacheAccess.Element> set = new HashSet<CacheAccess.Element>();
            Iterator i = this.iterator();
            HashMap elems = new HashMap();
            while (i.hasNext()) {
                Element e = (Element)i.next();
                if (e.isGroup()) {
                    set.add(new CacheAccess.Group((Group)e, elems));
                    continue;
                }
                set.add(new CacheAccess.Entry((Entry)e, elems));
            }
            return set;
        }

        public boolean isGroup() {
            return true;
        }

        public Attributes getAttributeAccess() {
            return this.getAttributes();
        }

        synchronized void add(Element e) {
            this.entries.add(e);
        }

        synchronized void remove(Element e) {
            this.entries.remove(e);
        }

        synchronized boolean isMember(Element e) {
            return this.entries.contains(e);
        }

        synchronized Iterator iterator() {
            return ((HashSet)this.entries.clone()).iterator();
        }

        void clear() {
            Iterator i = this.iterator();
            while (i.hasNext()) {
                Element e = (Element)i.next();
                e.delGroup();
            }
        }

        public void invalidate(CacheAccess acc) {
            Iterator i = this.iterator();
            while (i.hasNext()) {
                Element e = (Element)i.next();
                e.invalidate(acc);
            }
        }

        public void invalidateLocal() {
            Iterator i = this.iterator();
            while (i.hasNext()) {
                Element e = (Element)i.next();
                e.invalidateLocal();
            }
        }

        public void delete(StateChangeEventHandler.Reason reason) {
            this.clear();
            Region.this.removeGroup(this.name);
        }

        public Group getGroup() {
            return this.group;
        }

        public synchronized void setGroup(Group g) {
            if (this.group != null) {
                this.delGroup();
            }
            this._setGroup(g);
        }

        private void _setGroup(Group g) {
            this.group = g;
            if (g != null) {
                g.add(this);
            }
        }

        public synchronized void delGroup() {
            if (this.group != null) {
                this.group.remove(this);
            }
            this.group = null;
        }
    }

    class _EntryAttributes
    extends _GroupAttributes {
        _EntryAttributes(Element e, Attributes attr) {
            super(e);
            this.join(attr);
        }
    }

    class Entry
    extends ConsistencyDomain.LockableSupport
    implements Element {
        private List events = null;
        volatile State state;
        volatile ObjectHandle handle;
        volatile Object name;
        volatile _EntryAttributes attr;
        volatile PreemptionHandler.Entry pentry;
        volatile Group group;
        private volatile ConsistencyDomain.Lock lock;
        volatile long weight;
        volatile long last;
        volatile boolean implicit;
        volatile Mode mode;
        StatisticEntry statistic = new StatisticEntry();

        private void _addEvent(Event e) {
            if (this.events == null) {
                this.events = new ArrayList();
            }
            this.events.add(e);
        }

        private Iterator _getEvents() {
            if (this.events == null) {
                return null;
            }
            Iterator i = this.events.iterator();
            this.events = null;
            return i;
        }

        private void handleEvents(Iterator i) {
            boolean b;
            if (i != null) {
                while (i.hasNext()) {
                    ((Event)i.next()).handle();
                }
            }
            Entry entry = this;
            synchronized (entry) {
                b = this.implicit && this.state == State.NONE && this.startDelete();
            }
            if (b) {
                try {
                    this.delete(StateChangeEventHandler.Reason.CLEANUP);
                }
                catch (CacheException ce) {
                    // empty catch block
                }
            }
        }

        private void _addStateChangeEvent(Object o, EntryState sold, EntryState snew, StateChangeEventHandler.Reason reason) {
            if (!Region.this.handlers.isEmpty()) {
                if (Region.this.async_events) {
                    this._addEvent(new StateChangeEvent(o, sold, snew, reason));
                } else {
                    Region.this.handleStateChange(this.getName(), o, sold, snew, reason);
                }
            }
        }

        private void _addInvalidationEvent(Object o) {
            if (!Region.this.handlers.isEmpty()) {
                if (Region.this.async_events) {
                    this._addEvent(new InvalidationEvent(o));
                } else {
                    Region.this.handleInvalidation(this.getName(), o);
                }
            }
        }

        private void _addPreemptionEvent(Object o) {
            if (!Region.this.handlers.isEmpty()) {
                if (Region.this.async_events) {
                    this._addEvent(new PreemptionEvent(o));
                } else {
                    Region.this.handlePreemption(this.getName(), o);
                }
            }
        }

        Entry(Object name) {
            this(name, null, null);
        }

        Entry(Object name, Attributes attr, Group g) {
            this.name = name;
            this.weight = 0L;
            this.last = 0L;
            this.mode = new Mode();
            this.handle = new ObjectHandle();
            this.state = State.NONE;
            this.implicit = true;
            this._setAttributes(attr);
            this.lock = this.attr.getConsistencyDomain().createLock("cache-" + Region.this.name, this);
            this._setGroup(g);
            Region.this.addEntry(name, this);
            this.pentry = Region.this.preempt.createPreemptionEntry(name);
            this.pentry.setCacheEntry(this);
        }

        public boolean requestUse() {
            return this.mode.requestUse();
        }

        public void releaseUse() {
            this.mode.releaseUse();
            this.handleEvents(null);
        }

        boolean startDelete() {
            if (this.getLock().isLocallyLocked()) {
                return false;
            }
            return this.mode.startDelete();
        }

        boolean scheduleForDelete() {
            if (this.getLock().isLocallyLocked()) {
                return false;
            }
            return this.mode.scheduleForDelete();
        }

        public Object getId() {
            return this.name;
        }

        public boolean isGroup() {
            return false;
        }

        public Attributes getAttributeAccess() {
            return this.getAttributes();
        }

        PreemptionHandler.Entry getPreemptionEntry() {
            return this.pentry;
        }

        ConsistencyDomain.Lock getLock() {
            return this.lock;
        }

        Object getName() {
            return this.name;
        }

        Region getRegion() {
            return Region.this;
        }

        synchronized long getLastAccess() {
            return this.last;
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        long getCreateTime() {
            Iterator i = null;
            try {
                Entry entry = this;
                synchronized (entry) {
                    try {
                        if (!this._isMapped()) {
                            long l = 0L;
                            Object var8_4 = null;
                            i = this._getEvents();
                            // MONITOREXIT @DISABLED, blocks:[0, 2, 3, 6] lbl11 : MonitorExitStatement: MONITOREXIT : var2_2
                            Object var11_7 = null;
                            this.handleEvents(i);
                            return l;
                        }
                        long l = this.attr.getCreateTime();
                        Object var8_5 = null;
                        i = this._getEvents();
                        // MONITOREXIT @DISABLED, blocks:[0, 2, 3] lbl20 : MonitorExitStatement: MONITOREXIT : var2_2
                        Object var11_8 = null;
                        this.handleEvents(i);
                        return l;
                    }
                    catch (Throwable throwable) {
                        Object var8_6 = null;
                        i = this._getEvents();
                        throw throwable;
                    }
                }
            }
            catch (Throwable throwable) {
                Object var11_9 = null;
                this.handleEvents(i);
                throw throwable;
            }
        }

        synchronized long getWeight() {
            return this.weight;
        }

        private boolean _setWeight(long w) {
            this.attr.setWeight(w);
            if (this.weight != w) {
                this.state.adjust(this, w - this.weight);
                this.weight = w;
                return this._define();
            }
            return false;
        }

        void setWeight(long w) {
            Iterator i;
            boolean preempt;
            Entry entry = this;
            synchronized (entry) {
                preempt = this._setWeight(w);
                i = this._getEvents();
            }
            this.handleEvents(i);
            if (preempt) {
                Region.this.preempt.preempt(0L);
            }
        }

        private boolean _setAttributes(Attributes attr) {
            long w = attr != null ? attr.getWeight() : 1L;
            this.attr = new _EntryAttributes(this, attr);
            return this._setWeight(w);
        }

        void setAttributes(Attributes attr) {
            Iterator i;
            boolean preempt;
            Entry entry = this;
            synchronized (entry) {
                preempt = this._setAttributes(attr);
                i = this._getEvents();
            }
            this.handleEvents(i);
            if (preempt) {
                Region.this.preempt.preempt(0L);
            }
        }

        void setGroup(String name) throws CacheException {
            Group g;
            if (name == null) {
                g = null;
            } else {
                g = Region.this.queryGroup(name);
                if (g == null) {
                    throw new InvalidGroupException(name);
                }
            }
            Entry entry = this;
            synchronized (entry) {
                this.setGroup(g);
            }
            if (g != null) {
                g.releaseUse();
            }
        }

        void redefine(Attributes attr, Group g) throws ObjectExistsException {
            Iterator i = null;
            try {
                Entry entry = this;
                synchronized (entry) {
                    try {
                        if (this._isMapped()) {
                            throw new ObjectExistsException(this.name.toString());
                        }
                        this.implicit = false;
                        if (attr != null) {
                            this.setAttributes(attr);
                        }
                        if (g != null) {
                            this.setGroup(g);
                        }
                        Object var6_5 = null;
                        i = this._getEvents();
                    }
                    catch (Throwable throwable) {
                        Object var6_6 = null;
                        i = this._getEvents();
                        throw throwable;
                    }
                }
                Object var9_9 = null;
                this.handleEvents(i);
            }
            catch (Throwable throwable) {
                Object var9_10 = null;
                this.handleEvents(i);
                throw throwable;
            }
        }

        private void _switchTo(State s, StateChangeEventHandler.Reason reason) {
            Object o = null;
            if (this.state != s) {
                State sold = this.state;
                if (this.state != null) {
                    this.state.leave(this);
                    o = this.handle.getObject();
                    if (s != State.NONE) {
                        this.handle.validate();
                    }
                }
                if (this.state == null) {
                    s.enter(this);
                }
                if (sold != null && this.state != sold) {
                    this._addStateChangeEvent(o, sold.getState(), this.state.getState(), reason);
                    if (this.state == State.NONE) {
                        this._addInvalidationEvent(o);
                    }
                }
            }
        }

        synchronized void touch(long time) {
            this.pentry.touch(time);
            this.last = time;
        }

        void validate(long time) {
            Iterator i;
            Entry entry = this;
            synchronized (entry) {
                this._validate(time);
                i = this._getEvents();
            }
            this.handleEvents(i);
        }

        void _validate(long time) {
            long t;
            this.handle.validate();
            if (this.state != State.NONE && this.state != State.OUTOFDATE && (t = this.attr.getLifeTime()) > 0L && time >= this.attr.getCreateTime() + t) {
                if (deb.active()) {
                    deb.out(this.name + " is out of date");
                }
                this._switchTo(State.OUTOFDATE, StateChangeEventHandler.Reason.LIFETIME);
                return;
            }
            if (this.state == State.KEPT && (t = this.attr.getIdleTime()) > 0L && time >= this.getLastAccess() + t) {
                if (deb.active()) {
                    deb.out(this.name + " is idle");
                }
                this._switchTo(State.IDLE, StateChangeEventHandler.Reason.IDLETIME);
                return;
            }
        }

        void checkCleanup(long time) {
            Iterator i = null;
            Entry entry = this;
            synchronized (entry) {
                if (deb.active()) {
                    deb.out("cleanup step for " + this.name + ": " + this.implicit + "," + this.state);
                }
                this._validate(time);
                i = this._getEvents();
            }
            this.handleEvents(i);
        }

        boolean isOutOfDate(long time) {
            Iterator i = null;
            try {
                Entry entry = this;
                synchronized (entry) {
                    this._validate(time);
                    i = this._getEvents();
                    boolean bl = this.state == State.OUTOFDATE;
                    // MONITOREXIT @DISABLED, blocks:[0, 1, 2] lbl9 : MonitorExitStatement: MONITOREXIT : var4_3
                    Object var8_5 = null;
                    this.handleEvents(i);
                    return bl;
                }
            }
            catch (Throwable throwable) {
                Object var8_6 = null;
                this.handleEvents(i);
                throw throwable;
            }
        }

        boolean isIdle(long time) {
            Iterator i = null;
            try {
                Entry entry = this;
                synchronized (entry) {
                    this._validate(time);
                    i = this._getEvents();
                    boolean bl = this.state == State.IDLE;
                    // MONITOREXIT @DISABLED, blocks:[0, 1, 2] lbl9 : MonitorExitStatement: MONITOREXIT : var4_3
                    Object var8_5 = null;
                    this.handleEvents(i);
                    return bl;
                }
            }
            catch (Throwable throwable) {
                Object var8_6 = null;
                this.handleEvents(i);
                throw throwable;
            }
        }

        boolean isKept(long time) {
            Iterator i = null;
            try {
                Entry entry = this;
                synchronized (entry) {
                    this._validate(time);
                    i = this._getEvents();
                    boolean bl = this.state == State.KEPT;
                    // MONITOREXIT @DISABLED, blocks:[0, 1, 2] lbl9 : MonitorExitStatement: MONITOREXIT : var4_3
                    Object var8_5 = null;
                    this.handleEvents(i);
                    return bl;
                }
            }
            catch (Throwable throwable) {
                Object var8_6 = null;
                this.handleEvents(i);
                throw throwable;
            }
        }

        boolean isPreemptable() {
            return this.isPreemptable(Region.getMillis());
        }

        boolean isPreemptable(long time) {
            Iterator i = null;
            try {
                Entry entry = this;
                synchronized (entry) {
                    boolean bl;
                    try {
                        this._validate(time);
                        bl = this._isPreemptable();
                        Object var7_5 = null;
                        i = this._getEvents();
                        // MONITOREXIT @DISABLED, blocks:[0, 1, 2, 3] lbl12 : MonitorExitStatement: MONITOREXIT : var4_3
                    }
                    catch (Throwable throwable) {
                        Object var7_6 = null;
                        i = this._getEvents();
                        throw throwable;
                    }
                    Object var10_7 = null;
                    this.handleEvents(i);
                    return bl;
                }
            }
            catch (Throwable throwable) {
                Object var10_8 = null;
                this.handleEvents(i);
                throw throwable;
            }
        }

        boolean _isPreemptable() {
            return this.state == State.KEPT || this.state == State.IDLE;
        }

        synchronized boolean isKept() {
            return this.state == State.KEPT;
        }

        private boolean _isMapped() {
            return this.handle.mapped();
        }

        boolean isMapped() {
            Iterator i = null;
            try {
                Entry entry = this;
                synchronized (entry) {
                    boolean bl;
                    try {
                        bl = this._isMapped();
                        Object var5_4 = null;
                        i = this._getEvents();
                        // MONITOREXIT @DISABLED, blocks:[0, 1, 2, 3] lbl11 : MonitorExitStatement: MONITOREXIT : var2_2
                    }
                    catch (Throwable throwable) {
                        Object var5_5 = null;
                        i = this._getEvents();
                        throw throwable;
                    }
                    Object var8_6 = null;
                    this.handleEvents(i);
                    return bl;
                }
            }
            catch (Throwable throwable) {
                Object var8_7 = null;
                this.handleEvents(i);
                throw throwable;
            }
        }

        private boolean _define() {
            return this._define(Region.getMillis());
        }

        private boolean _define(long time) {
            if (this._isMapped()) {
                this.attr.created = time;
                this.touch(time);
                return true;
            }
            return false;
        }

        public EntryAttributes getAttributes() {
            long time = Region.getMillis();
            Iterator i = null;
            try {
                Entry entry = this;
                synchronized (entry) {
                    _EntryAttributes _EntryAttributes2;
                    try {
                        this._validate(time);
                        this.attr.setRealWeight(this._isMapped() ? this.weight : 0L);
                        this.attr.setLastAccessTime(this.last);
                        this.attr.setState(this.state.getState());
                        _EntryAttributes2 = this.attr;
                        Object var7_5 = null;
                        i = this._getEvents();
                        // MONITOREXIT @DISABLED, blocks:[0, 1, 2, 3] lbl16 : MonitorExitStatement: MONITOREXIT : var4_3
                    }
                    catch (Throwable throwable) {
                        Object var7_6 = null;
                        i = this._getEvents();
                        throw throwable;
                    }
                    Object var10_7 = null;
                    this.handleEvents(i);
                    return _EntryAttributes2;
                }
            }
            catch (Throwable throwable) {
                Object var10_8 = null;
                this.handleEvents(i);
                throw throwable;
            }
        }

        EntryState getState() {
            Iterator i = null;
            try {
                Entry entry = this;
                synchronized (entry) {
                    EntryState entryState;
                    try {
                        this._validate(Region.getMillis());
                        entryState = this.state.getState();
                        Object var5_4 = null;
                        i = this._getEvents();
                        // MONITOREXIT @DISABLED, blocks:[0, 1, 2, 3] lbl12 : MonitorExitStatement: MONITOREXIT : var2_2
                    }
                    catch (Throwable throwable) {
                        Object var5_5 = null;
                        i = this._getEvents();
                        throw throwable;
                    }
                    Object var8_6 = null;
                    this.handleEvents(i);
                    return entryState;
                }
            }
            catch (Throwable throwable) {
                Object var8_7 = null;
                this.handleEvents(i);
                throw throwable;
            }
        }

        Object get(CacheAccess acc) {
            return this.get(acc, null);
        }

        Object get(CacheAccess acc, Object args) {
            return this.get(acc, null, args);
        }

        Object get(CacheAccess acc, Group g, Object args) {
            Object obj = null;
            Iterator i = null;
            boolean preempt = false;
            try {
                Entry entry = this;
                synchronized (entry) {
                    try {
                        long time = Region.getMillis();
                        this._validate(time);
                        if (deb.active()) {
                            deb.out("state of " + this.name + ": " + this.state);
                        }
                        if ((obj = this.handle.getObject()) == null) {
                            this.notifyMiss(acc);
                            CacheLoader l = this.attr.getLoader();
                            if (l != null) {
                                obj = l.load(this, args);
                                this.handle.setObject(obj);
                                if (obj != null) {
                                    this.notifyLoad(acc);
                                    this._switchTo(State.KEPT, StateChangeEventHandler.Reason.LOADED);
                                    this._define(time);
                                    preempt = true;
                                }
                                if (g != null) {
                                    this.setGroup(g);
                                }
                            }
                        } else {
                            if (this.state != State.OUTOFDATE) {
                                if (!this._isPreemptable()) {
                                    preempt = true;
                                }
                                this.touch(time);
                                this._switchTo(State.KEPT, StateChangeEventHandler.Reason.RESURRECTED);
                            }
                            this.notifyHit(acc);
                        }
                        Object var12_10 = null;
                        i = this._getEvents();
                    }
                    catch (Throwable throwable) {
                        Object var12_11 = null;
                        i = this._getEvents();
                        throw throwable;
                    }
                }
                Object var15_14 = null;
                this.handleEvents(i);
            }
            catch (Throwable throwable) {
                Object var15_15 = null;
                this.handleEvents(i);
                throw throwable;
            }
            if (preempt) {
                Region.this.preempt.preempt(0L);
            }
            return obj;
        }

        synchronized Object getMapping() {
            return this.handle.getMapping();
        }

        private void _put(CacheAccess acc, Group g, Attributes attr, Object obj) {
            this.attr = new _EntryAttributes(this, attr);
            this.weight = this.attr.getWeight();
            this.handle.setObject(obj);
            this._switchTo(State.KEPT, StateChangeEventHandler.Reason.MAPPED);
            this.setGroup(g);
            this._define();
            this.notifyWrite(acc);
        }

        void put(CacheAccess acc, Group g, Attributes attr, Object obj) throws ObjectExistsException {
            Iterator i = null;
            try {
                Entry entry = this;
                synchronized (entry) {
                    try {
                        if (this._isMapped()) {
                            throw new ObjectExistsException(this.getName() == null ? "<null>" : this.getName().toString());
                        }
                        this._release(StateChangeEventHandler.Reason.MAPPED);
                        this._put(acc, g, attr, obj);
                        Object var8_7 = null;
                        i = this._getEvents();
                    }
                    catch (Throwable throwable) {
                        Object var8_8 = null;
                        i = this._getEvents();
                        throw throwable;
                    }
                }
                Object var11_11 = null;
                this.handleEvents(i);
            }
            catch (Throwable throwable) {
                Object var11_12 = null;
                this.handleEvents(i);
                throw throwable;
            }
            Region.this.preempt.preempt(0L);
        }

        Object replace(CacheAccess acc, Group g, Attributes attr, Object obj) {
            Iterator i = null;
            Object old = null;
            try {
                Entry entry = this;
                synchronized (entry) {
                    try {
                        old = this.handle.getObject();
                        this._release(StateChangeEventHandler.Reason.MAPPED);
                        this._put(acc, g, attr, obj);
                        Object var9_8 = null;
                        i = this._getEvents();
                    }
                    catch (Throwable throwable) {
                        Object var9_9 = null;
                        i = this._getEvents();
                        throw throwable;
                    }
                }
                Object var12_12 = null;
                this.handleEvents(i);
            }
            catch (Throwable throwable) {
                Object var12_13 = null;
                this.handleEvents(i);
                throw throwable;
            }
            Region.this.preempt.preempt(0L);
            this.propagate(acc, "invalidate");
            return old;
        }

        void release(StateChangeEventHandler.Reason reason) {
            Iterator i;
            Entry entry = this;
            synchronized (entry) {
                this._release(reason);
                i = this._getEvents();
            }
            this.handleEvents(i);
        }

        private void _release(StateChangeEventHandler.Reason reason) {
            if (this._isMapped() && deb.active()) {
                deb.out("releasing " + this.name);
            }
            this._switchTo(State.NONE, reason);
        }

        public void preempt() {
            Iterator i = null;
            try {
                Entry entry = this;
                synchronized (entry) {
                    try {
                        Object o = this.handle.getObject();
                        if (this.state != State.NONE) {
                            if (deb.active()) {
                                deb.out("preempt " + this.getId());
                            }
                            this._switchTo(State.PREEMPTED, StateChangeEventHandler.Reason.PREEMPTED);
                            this._addPreemptionEvent(o);
                        }
                        Object var5_4 = null;
                        i = this._getEvents();
                    }
                    catch (Throwable throwable) {
                        Object var5_5 = null;
                        i = this._getEvents();
                        throw throwable;
                    }
                }
                Object var8_8 = null;
                this.handleEvents(i);
            }
            catch (Throwable throwable) {
                Object var8_9 = null;
                this.handleEvents(i);
                throw throwable;
            }
        }

        public void invalidate(CacheAccess acc) {
            this.release(StateChangeEventHandler.Reason.INVALIDATED);
            this.propagate(acc, "invalidate");
        }

        public void invalidateLocal() {
            this.release(StateChangeEventHandler.Reason.INVALIDATED);
        }

        void propagate(CacheAccess acc, String msg) {
            OwnerInfo i = Region.this.getOwnerInfo(acc);
            i.addConfirmation(this.getLock().propagate(msg, this.attr.useReply()));
        }

        public void delete() throws CacheException {
            this.delete(StateChangeEventHandler.Reason.DELETED);
        }

        public void delete(StateChangeEventHandler.Reason reason) throws CacheException {
            if (this.getLock().isLocallyLocked()) {
                throw new CacheException("entry locked");
            }
            if (this.mode.scheduleForDelete()) {
                if (deb.active()) {
                    deb.out("*** destroy entry " + this.name + " " + reason);
                }
                Region.this.removeEntry(this);
                this.release(reason);
                this.delGroup();
                Region.this.preempt.deletePreemptionEntry(this.pentry);
            }
        }

        public Group getGroup() {
            return this.group;
        }

        public synchronized void setGroup(Group g) {
            if (this.group != null) {
                this.delGroup();
            }
            this._setGroup(g);
        }

        private void _setGroup(Group g) {
            this.group = g;
            if (g != null) {
                g.add(this);
            }
        }

        public synchronized void delGroup() {
            if (this.group != null) {
                this.group.remove(this);
            }
            this.group = null;
        }

        public void notify(String info) {
            this.release(StateChangeEventHandler.Reason.INVALIDATED);
            if (deb.active()) {
                deb.out("*** flushing " + Region.this.name + ":" + this.name);
            }
        }

        void notifyHit(CacheAccess acc) {
            this.statistic.notifyHit();
            acc.notifyHit();
        }

        void notifyMiss(CacheAccess acc) {
            this.statistic.notifyMiss();
            acc.notifyMiss();
        }

        void notifyLoad(CacheAccess acc) {
            this.statistic.notifyLoad();
            acc.notifyLoad();
        }

        void notifyWrite(CacheAccess acc) {
            this.statistic.notifyWrite();
            acc.notifyWrite();
        }

        class ObjectHandle
        extends Registration {
            volatile ObjectReference ref = null;

            ObjectHandle() {
                super(null);
            }

            public final synchronized void setObject(Object o) {
                this.dec();
                if (this.ref != null) {
                    this.ref.clear();
                    this.ref = null;
                }
                if (o != null) {
                    this.ref = new ObjectReference(o);
                    this.inc();
                }
            }

            protected final void handleUnregister() {
                try {
                    if (Entry.this.getLock().isLocallyLocked()) {
                        Entry.this.getLock().unlock();
                    }
                    Entry.this.delete(StateChangeEventHandler.Reason.CLEANUP);
                }
                catch (CacheException cacheException) {
                    // empty catch block
                }
            }

            public void setNone() {
                this.setObject(null);
            }

            public synchronized void setHard() {
                if (this.ref != null) {
                    this.ref.setHard();
                }
            }

            public synchronized void setSoft() {
                if (this.ref != null) {
                    this.ref.setSoft();
                }
            }

            public synchronized void setWeak() {
                if (this.ref != null) {
                    this.ref.setWeak();
                }
            }

            synchronized void validate() {
                if (this.ref != null && this.ref.invalidated()) {
                    if (deb.active()) {
                        deb.out(Entry.this.name + " has been vanished");
                    }
                    Entry.this._switchTo(State.NONE, StateChangeEventHandler.Reason.GARBAGE_COLLECTED);
                }
            }

            public synchronized Object getObject() {
                if (this.ref == null) {
                    return null;
                }
                Object o = this.ref.get();
                if (o == null) {
                    this.validate();
                }
                return o;
            }

            public synchronized Object getMapping() {
                if (this.ref == null) {
                    return null;
                }
                return this.ref.get();
            }

            public boolean mapped() {
                return this.getObject() != null;
            }
        }

        class PreemptionEvent
        implements Event {
            Object object;

            PreemptionEvent(Object o) {
                this.object = o;
            }

            public void handle() {
                Region.this.handlePreemption(Entry.this.getName(), this.object);
            }
        }

        class InvalidationEvent
        implements Event {
            Object object;

            InvalidationEvent(Object o) {
                this.object = o;
            }

            public void handle() {
                Region.this.handleInvalidation(Entry.this.getName(), this.object);
            }
        }

        class StateChangeEvent
        implements Event {
            Object object;
            EntryState old_state;
            EntryState new_state;
            StateChangeEventHandler.Reason reason;

            StateChangeEvent(Object o, EntryState sold, EntryState snew, StateChangeEventHandler.Reason reason) {
                this.object = o;
                this.old_state = sold;
                this.new_state = snew;
                this.reason = reason;
            }

            public void handle() {
                Region.this.handleStateChange(Entry.this.getName(), this.object, this.old_state, this.new_state, this.reason);
            }
        }

        class Mode {
            Thread scheduled = null;
            int busy = 0;

            Mode() {
            }

            synchronized boolean requestUse() {
                if (this.scheduled != null) {
                    if (this.scheduled.isAlive()) {
                        return false;
                    }
                    this.scheduled = null;
                }
                ++this.busy;
                return true;
            }

            synchronized void releaseUse() {
                if (this.busy > 0 && --this.busy == 0) {
                    this.notify();
                }
            }

            synchronized boolean startDelete() {
                if (this.busy > 0) {
                    return false;
                }
                if (this.scheduled != null && this.scheduled.isAlive()) {
                    return false;
                }
                this.scheduled = Thread.currentThread();
                return true;
            }

            synchronized boolean scheduleForDelete() {
                if (this.scheduled == Thread.currentThread()) {
                    return true;
                }
                if (this.scheduled != null && this.scheduled.isAlive()) {
                    return false;
                }
                this.scheduled = Thread.currentThread();
                while (this.busy > 0) {
                    try {
                        this.wait();
                    }
                    catch (InterruptedException ie) {
                        this.scheduled = null;
                        return false;
                    }
                }
                return true;
            }
        }
    }

    static interface Event {
        public void handle();
    }

    static interface Element
    extends CacheAccess.EntryHandle {
        public Object getId();

        public Group getGroup();

        public void setGroup(Group var1);

        public void delGroup();

        public void invalidate(CacheAccess var1);

        public void invalidateLocal();

        public void delete(StateChangeEventHandler.Reason var1) throws CacheException;

        public EntryAttributes getAttributes();

        public boolean requestUse();

        public void releaseUse();
    }

    static class StateOutOfDate
    implements State {
        StateOutOfDate() {
        }

        public void enter(Entry e) {
            if (e.getRegion().unique_mapping) {
                e.state = this;
                e.getRegion().adjustOutOfDateCount(1, e.weight);
                e.handle.setWeak();
            } else {
                State.NONE.enter(e);
            }
        }

        public void leave(Entry e) {
            e.state = null;
            e.getRegion().adjustOutOfDateCount(-1, -e.weight);
        }

        public void adjust(Entry e, long weight) {
            e.getRegion().adjustOutOfDateCount(0, weight);
        }

        public EntryState getState() {
            return EntryState.OUTOFDATE;
        }

        public String toString() {
            return "OUTOFDATE";
        }
    }

    static class StatePreempted
    implements State {
        StatePreempted() {
        }

        public void enter(Entry e) {
            e.state = this;
            e.getRegion().adjustPreemptedCount(1, e.weight);
            e.handle.setWeak();
        }

        public void leave(Entry e) {
            e.state = null;
            e.getRegion().adjustPreemptedCount(-1, -e.weight);
        }

        public void adjust(Entry e, long weight) {
            e.getRegion().adjustPreemptedCount(0, weight);
        }

        public EntryState getState() {
            return EntryState.PREEMPTED;
        }

        public String toString() {
            return "PREEMPTED";
        }
    }

    static class StateIdle
    implements State {
        StateIdle() {
        }

        public void enter(Entry e) {
            e.state = this;
            e.getRegion().adjustIdleCount(1, e.weight);
            e.handle.setSoft();
        }

        public void leave(Entry e) {
            e.state = null;
            e.getRegion().adjustIdleCount(-1, -e.weight);
        }

        public void adjust(Entry e, long weight) {
            e.getRegion().adjustIdleCount(0, weight);
        }

        public EntryState getState() {
            return EntryState.IDLE;
        }

        public String toString() {
            return "IDLE";
        }
    }

    static class StateKept
    implements State {
        StateKept() {
        }

        public void enter(Entry e) {
            e.state = this;
            e.getRegion().adjustKeptCount(1, e.weight);
            e.handle.setHard();
        }

        public void leave(Entry e) {
            e.state = null;
            e.getRegion().adjustKeptCount(-1, -e.weight);
        }

        public void adjust(Entry e, long weight) {
            e.getRegion().adjustKeptCount(0, weight);
        }

        public EntryState getState() {
            return EntryState.KEPT;
        }

        public String toString() {
            return "KEPT";
        }
    }

    static class StateNone
    implements State {
        StateNone() {
        }

        public void enter(Entry e) {
            e.state = this;
            e.handle.setObject(null);
        }

        public void leave(Entry e) {
            e.state = null;
        }

        public void adjust(Entry e, long weight) {
        }

        public EntryState getState() {
            return EntryState.NONE;
        }

        public String toString() {
            return "NONE";
        }
    }

    static interface State {
        public static final State NONE = new StateNone();
        public static final State KEPT = new StateKept();
        public static final State IDLE = new StateIdle();
        public static final State PREEMPTED = new StatePreempted();
        public static final State OUTOFDATE = new StateOutOfDate();

        public void enter(Entry var1);

        public void leave(Entry var1);

        public void adjust(Entry var1, long var2);

        public EntryState getState();
    }

    static class ObjectReference {
        private Object object;
        private Reference ref;
        private int state;
        public static final int NONE = 0;
        public static final int WEAK = 1;
        public static final int SOFT = 2;
        public static final int HARD = 3;

        public ObjectReference(Object o) {
            this.object = o;
            this.ref = null;
            this.state = 3;
        }

        public Object get() {
            if (this.ref != null) {
                return this.ref.get();
            }
            return this.object;
        }

        public int getState() {
            return this.state;
        }

        public boolean invalidated() {
            return this.state != 0 && this.object == null && this.ref.get() == null;
        }

        public boolean setHard() {
            if (this.state == 0) {
                return false;
            }
            if (this.state == 3) {
                return true;
            }
            this.object = this.get();
            if (this.object == null) {
                return false;
            }
            this.ref = null;
            this.state = 3;
            return true;
        }

        public boolean setWeak() {
            if (this.state == 0) {
                return false;
            }
            if (this.state == 1) {
                return !this.invalidated();
            }
            Object o = this.get();
            if (o == null) {
                return false;
            }
            this.ref = new WeakReference<Object>(o);
            this.object = null;
            this.state = 1;
            return true;
        }

        public boolean setSoft() {
            if (this.state == 0) {
                return false;
            }
            if (this.state == 2) {
                return !this.invalidated();
            }
            Object o = this.get();
            if (o == null) {
                return false;
            }
            this.ref = new SoftReference<Object>(o);
            this.object = null;
            this.state = 2;
            return true;
        }

        public void setNone() {
            this.object = null;
            if (this.ref != null) {
                this.ref.clear();
                this.ref = null;
            }
            this.state = 0;
        }

        public void clear() {
            this.setNone();
        }
    }

    private class Preemption
    implements PreemptionHandler {
        volatile PreemptionHandler preempt;

        Preemption(PreemptionHandler h) {
            this.preempt = h;
        }

        public void preempt(long additional) {
            long required;
            if (this.preempt == null) {
                return;
            }
            Region region = Region.this;
            synchronized (region) {
                required = Region.this.getWeight() + additional - Region.this.getMaxWeight();
            }
            if (required > 0L) {
                this._preempt(additional);
            }
        }

        public synchronized void setCacheAccess(PreemptionHandler.PreemptionCacheAccess access) {
            this.preempt.setCacheAccess(access);
        }

        public PreemptionHandler.Entry createPreemptionEntry(Object key) {
            return this.preempt.createPreemptionEntry(key);
        }

        public void deletePreemptionEntry(PreemptionHandler.Entry entry) {
            this.preempt.deletePreemptionEntry(entry);
        }

        private synchronized void _preempt(long additional) {
            PreemptionHandler hndlr = this.preempt;
            if (deb.active()) {
                deb.out("preemption for weight " + additional);
            }
            Region.this.freeze();
            hndlr.preempt(additional);
            Region.this.unfreeze();
        }
    }

    static class Counts {
        volatile long w_kept = 0L;
        volatile long w_idle = 0L;
        volatile long w_preempted = 0L;
        volatile long w_outofdate = 0L;
        volatile long c_kept = 0L;
        volatile long c_idle = 0L;
        volatile long c_preempted = 0L;
        volatile long c_outofdate = 0L;

        synchronized void copyTo(Counts c) {
            c.c_kept = this.c_kept;
            c.c_idle = this.c_idle;
            c.c_preempted = this.c_preempted;
            c.c_outofdate = this.c_outofdate;
            c.w_kept = this.w_kept;
            c.w_idle = this.w_idle;
            c.w_preempted = this.w_preempted;
            c.w_outofdate = this.w_outofdate;
        }

        synchronized void adjustKeptCount(int num, long weight) {
            this.w_kept += weight;
            this.c_kept += (long)num;
        }

        synchronized void adjustIdleCount(int num, long weight) {
            this.w_idle += weight;
            this.c_idle += (long)num;
        }

        synchronized void adjustPreemptedCount(int num, long weight) {
            this.w_preempted += weight;
            this.c_preempted += (long)num;
        }

        synchronized void adjustOutOfDateCount(int num, long weight) {
            this.w_outofdate += weight;
            this.c_outofdate += (long)num;
        }

        public synchronized long getWeight() {
            if (deb.active()) {
                deb.out("weight=" + (this.w_kept + this.w_idle) + ": kept=" + this.w_kept + ", idle=" + this.w_idle);
            }
            return this.w_kept + this.w_idle;
        }

        public synchronized long getRealWeight() {
            if (deb.active()) {
                deb.out("real weight=" + (this.w_kept + this.w_idle + this.w_preempted + this.w_outofdate) + ": kept=" + this.w_kept + ", idle=" + this.w_idle + ", pree=" + this.w_preempted + ", outd=" + this.w_outofdate);
            }
            return this.w_kept + this.w_idle + this.w_preempted + this.w_outofdate;
        }
    }
}

