/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ip.basecomps.cache;

import com.sap.ip.basecomps.cache.EntryState;
import com.sap.ip.basecomps.cache.Region;
import com.sap.ip.basecomps.cache.RegionHandle;
import com.sap.ip.basecomps.util.Util;
import java.util.Properties;

public interface PreemptionHandler {
    public void setCacheAccess(PreemptionCacheAccess var1);

    public Entry createPreemptionEntry(Object var1);

    public void deletePreemptionEntry(Entry var1);

    public void preempt(long var1);

    public static class util {
        private util() {
        }

        public static PreemptionHandler getHandler(Properties props) {
            return util.getHandler(props, null);
        }

        public static PreemptionHandler getHandler(Properties props, ClassLoader loader) {
            return (PreemptionHandler)Util.createObject(props, loader);
        }
    }

    public static class Entry {
        private Region.Entry entry;

        void setCacheEntry(Region.Entry e) {
            this.entry = e;
        }

        public long getWeight() {
            return this.entry.getWeight();
        }

        public Object getName() {
            return this.entry.getName();
        }

        public void validate(long time) {
            this.entry.validate(time);
        }

        public EntryState getState() {
            return this.entry.state.getState();
        }

        public boolean isPreemptable() {
            return this.entry.isPreemptable();
        }

        public long getLastAccess() {
            return this.entry.getLastAccess();
        }

        public boolean isOutOfDate(long time) {
            return this.entry.isOutOfDate(time);
        }

        public boolean isIdle(long time) {
            return this.entry.isIdle(time);
        }

        public long getCreateTime() {
            return this.entry.getCreateTime();
        }

        public void preempt() {
            this.entry.preempt();
        }

        public void touch(long time) {
        }

        public void checkCleanup(long time) {
            this.entry.checkCleanup(time);
        }
    }

    public static final class PreemptionCacheAccess
    extends RegionHandle {
        PreemptionCacheAccess(Region reg) {
            super(reg);
        }

        public Entry getEntry(Object key) {
            return this.getRegion().queryPreemptionEntry(key);
        }

        public long getSize() {
            return this.getRegion().getWeight();
        }

        public long getWeight() {
            return this.getRegion().getWeight();
        }

        public long getMaxSize() {
            return this.getRegion().getMaxWeight();
        }

        public long getMaxWeight() {
            return this.getRegion().getMaxWeight();
        }

        public String getRegionName() {
            return this.getRegion().getRegionName();
        }

        public int noofElems() {
            return this.getRegion().noofElems();
        }

        public Entry getEntryAt(int index) {
            return this.getRegion().getEntryAt(index);
        }

        public void cleanup() {
            this.getRegion().cleanup();
        }
    }
}

