/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ip.basecomps.cache;

import com.sap.ip.basecomps.cache.CacheAccess;
import com.sap.ip.basecomps.cache.InvalidHandleException;
import com.sap.ip.basecomps.consistency.ConsistencyDomain;

class OwnerInfo {
    ConsistencyDomain.Confirmations confirmations;
    ConsistencyDomain.LockGroup group;
    CacheAccess access;

    OwnerInfo(CacheAccess acc, Object owner) {
        this.access = acc;
        this.confirmations = new ConsistencyDomain.Confirmations();
        try {
            this.group = this.access.getRegion().attr.getConsistencyDomain().createLockGroup(owner.toString());
        }
        catch (InvalidHandleException e) {
            System.err.println("*** should never happen");
            e.printStackTrace(System.err);
        }
    }

    void addConfirmation(ConsistencyDomain.Confirmation c) {
        this.confirmations.add(c);
    }

    boolean waitForConfirmation(long timeout) throws ConsistencyDomain.Confirmation.AbortedException {
        return this.confirmations.waitForConfirmation(timeout);
    }

    boolean cancelConfirmation() {
        return this.confirmations.cancelConfirmation();
    }
}

