/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ip.basecomps.cache;

import com.sap.ip.basecomps.cache.PreemptionHandler;
import com.sap.ip.basecomps.cache.Region;
import com.sap.ip.basecomps.debug.Debug;
import java.util.ArrayList;
import java.util.ConcurrentModificationException;
import java.util.Iterator;

public class LRUPreemptionHandler
implements PreemptionHandler {
    private static Debug deb = Debug.getDebug("cache");
    PreemptionHandler.PreemptionCacheAccess access = null;
    DLL entries = new DLL();

    public void setCacheAccess(PreemptionHandler.PreemptionCacheAccess acc) {
        this.access = acc;
    }

    public PreemptionHandler.Entry createPreemptionEntry(Object key) {
        return new MyEntry();
    }

    public void deletePreemptionEntry(PreemptionHandler.Entry e) {
        DLL dLL = this.entries;
        synchronized (dLL) {
            ((MyEntry)e).remove();
            if (deb.active()) {
                deb.out("deleting preemption entry " + e.getName());
                StringBuffer sb = new StringBuffer();
                sb.append("access queue: ");
                Iterator i = this.entries.iterator();
                while (i.hasNext()) {
                    PreemptionHandler.Entry m = (PreemptionHandler.Entry)i.next();
                    sb.append(m.getName());
                    sb.append(" ");
                }
                deb.out(sb.toString());
            }
        }
    }

    public void preempt(long additional) {
        boolean done;
        ArrayList<MyEntry> found;
        long max = this.access.getMaxWeight();
        long required = this.access.getWeight() + additional - max;
        long time = Region.getMillis();
        if (max <= 0L || required <= 0L) {
            return;
        }
        if (required > max) {
            required = max;
        }
        do {
            MyEntry e;
            Iterator i;
            if (deb.active()) {
                deb.out("determining preemption set " + required);
            }
            done = false;
            do {
                found = new ArrayList<MyEntry>();
                try {
                    i = this.entries.iterator();
                    while (required > 0L && i.hasNext()) {
                        e = (MyEntry)i.next();
                        if (deb.active()) {
                            deb.out("  iter " + e);
                        }
                        e.validate(time);
                        if (!e.isPreemptable()) continue;
                        required -= e.getWeight();
                        found.add(e);
                    }
                    done = true;
                }
                catch (ConcurrentModificationException me) {
                    done = false;
                }
            } while (!done && found.isEmpty());
            if (deb.active()) {
                deb.out("found " + found.size() + " entries");
            }
            i = found.iterator();
            max = this.access.getMaxWeight();
            required = this.access.getWeight() + additional - max;
            if (required > max) {
                required = max;
            }
            if (deb.active()) {
                deb.out("preempting...");
            }
            while (required > 0L && i.hasNext()) {
                e = (MyEntry)i.next();
                if (deb.active()) {
                    deb.out("  trying " + e);
                }
                DLL dLL = this.entries;
                synchronized (dLL) {
                    if (!e.isLinked()) {
                        continue;
                    }
                }
                if (!e.isPreemptable()) continue;
                e.preempt();
                max = this.access.getMaxWeight();
                required = this.access.getWeight() + additional - max;
                if (required <= max) continue;
                required = max;
            }
            if (!deb.active()) continue;
            deb.out("preemption step done");
        } while ((!found.isEmpty() || !done) && required > 0L);
        if (deb.active()) {
            deb.out("preemption done");
        }
    }

    static void print(String txt, DLL root) {
        Iterator i = root.iterator();
        System.out.println(txt);
        while (i.hasNext()) {
            System.out.println("  " + i.next());
        }
    }

    public static void main(String[] args) {
        DLL root = new DLL();
        LRUPreemptionHandler.print("empty", root);
        DLLElement e1 = new DLLElement("e1");
        DLLElement e2 = new DLLElement("e2");
        DLLElement e3 = new DLLElement("e3");
        DLLElement e4 = new DLLElement("e4");
        root.inSucc(e1);
        LRUPreemptionHandler.print("e1", root);
        root.inSucc(e2);
        LRUPreemptionHandler.print("e2 e1", root);
        root.inSucc(e3);
        LRUPreemptionHandler.print("e3 e2 e1", root);
        root.inPred(e4);
        LRUPreemptionHandler.print("e3 e2 e1 e4", root);
        e1.remove();
        LRUPreemptionHandler.print("e3 e2 e4", root);
        e2.remove();
        e4.remove();
        LRUPreemptionHandler.print("e3", root);
        e3.remove();
        LRUPreemptionHandler.print("empty", root);
        root.inPred(e3);
        LRUPreemptionHandler.print("e3", root);
    }

    class MyEntry
    extends PreemptionHandler.Entry {
        DLLElement elem = new DLLElement(this);

        MyEntry() {
            DLL dLL = LRUPreemptionHandler.this.entries;
            synchronized (dLL) {
                LRUPreemptionHandler.this.entries.inSucc(this.elem);
            }
        }

        public void touch(long time) {
            DLL dLL = LRUPreemptionHandler.this.entries;
            synchronized (dLL) {
                this.elem.remove();
                LRUPreemptionHandler.this.entries.inPred(this.elem);
            }
        }

        void remove() {
            DLL dLL = LRUPreemptionHandler.this.entries;
            synchronized (dLL) {
                this.elem.remove();
            }
        }

        boolean isLinked() {
            return this.elem.isLinked();
        }
    }

    static class DLL
    extends DLLElement {
        public DLL() {
            super(null);
        }

        public boolean isEmpty() {
            return !this.isLinked();
        }

        public Iterator iterator() {
            return new DLLIterator();
        }

        private class DLLIterator
        implements Iterator {
            private DLLElement e;

            DLLIterator() {
                this.e = DLL.this;
            }

            public boolean hasNext() {
                DLL dLL = DLL.this;
                synchronized (dLL) {
                    if (!this.e.isLinked()) {
                        throw new ConcurrentModificationException();
                    }
                    boolean bl = this.e.succ() != null;
                    return bl;
                }
            }

            public Object next() {
                DLL dLL = DLL.this;
                synchronized (dLL) {
                    Object object;
                    try {
                        object = this.e.succ().getObject();
                        Object var4_3 = null;
                    }
                    catch (Throwable throwable) {
                        Object var4_4 = null;
                        this.e = this.e.succ;
                        throw throwable;
                    }
                    this.e = this.e.succ;
                    return object;
                }
            }

            public void remove() {
                throw new UnsupportedOperationException();
            }
        }
    }

    public static class DLLElement {
        private Object object;
        private DLLElement succ;
        private DLLElement prev;

        public DLLElement(Object o) {
            this.succ = this.prev = this;
            this.object = o;
        }

        public Object getObject() {
            return this.object;
        }

        public boolean isLinked() {
            return this.succ != this;
        }

        public void inSucc(DLLElement e) {
            if (!e.isLinked()) {
                e.succ = this.succ;
                e.prev = this;
                this.succ.prev = e;
                this.succ = e;
            }
        }

        public void inPred(DLLElement e) {
            this.prev.inSucc(e);
        }

        public void remove() {
            if (this.isLinked()) {
                this.succ.prev = this.prev;
                this.prev.succ = this.succ;
                this.succ = this.prev = this;
            }
        }

        public DLLElement succ() {
            if (this.succ instanceof DLL) {
                return null;
            }
            return this.succ;
        }

        public DLLElement prev() {
            if (this.prev instanceof DLL) {
                return null;
            }
            return this.prev;
        }
    }
}

