/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ip.basecomps.cache;

import com.sap.ip.basecomps.cache.EntryState;
import com.sap.ip.basecomps.cache.EventHandler;
import com.sap.ip.basecomps.cache.InvalidationEventHandler;
import com.sap.ip.basecomps.cache.PreemptionEventHandler;
import com.sap.ip.basecomps.cache.StateChangeEventHandler;
import com.sap.ip.basecomps.debug.Debug;
import com.sap.ip.basecomps.util.reg.SimpleRegistration;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;

class HandlerRegistrations {
    private static Debug deb = Debug.getDebug("cache");
    private HashMap handlers = new HashMap();
    private EventType statechange = new EventType(){

        boolean check(Object h) {
            return h instanceof StateChangeEventHandler;
        }

        void forward(Object h, String region, Object name, Object object, EntryState sold, EntryState snew, StateChangeEventHandler.Reason reason) {
            ((StateChangeEventHandler)h).handleStateChange(region, name, object, sold, snew, reason);
        }
    };
    private EventType invalidation = new EventType(){

        boolean check(Object h) {
            return h instanceof InvalidationEventHandler;
        }

        void forward(Object h, String region, Object name, Object object, EntryState sold, EntryState snew, StateChangeEventHandler.Reason reason) {
            ((InvalidationEventHandler)h).handleInvalidation(region, name, object);
        }
    };
    private EventType preemption = new EventType(){

        boolean check(Object h) {
            return h instanceof PreemptionEventHandler;
        }

        void forward(Object h, String region, Object name, Object object, EntryState sold, EntryState snew, StateChangeEventHandler.Reason reason) {
            ((PreemptionEventHandler)h).handlePreemption(region, name, object);
        }
    };

    HandlerRegistrations() {
    }

    public synchronized int size() {
        return this.handlers.size();
    }

    public synchronized boolean isEmpty() {
        return this.handlers.isEmpty();
    }

    public synchronized void clear() {
        ArrayList v = new ArrayList(this.handlers.keySet());
        Iterator i = v.iterator();
        while (i.hasNext()) {
            EventHandler h = (EventHandler)i.next();
            this.unregisterHandler(h);
        }
    }

    public synchronized void registerHandler(EventHandler h) {
        if (h != null && !this.handlers.containsKey(h)) {
            HandlerRegistration reg = new HandlerRegistration(h);
            this.handlers.put(h, reg);
            this.statechange.registerHandler(h);
            this.invalidation.registerHandler(h);
            this.preemption.registerHandler(h);
            reg.inc();
        }
    }

    private synchronized void unregisterHandler(HandlerRegistration reg, EventHandler h) {
        if (reg != null) {
            this.statechange.unregisterHandler(h);
            this.invalidation.unregisterHandler(h);
            this.preemption.unregisterHandler(h);
            this.handlers.remove(h);
            reg.dec();
        }
    }

    public void unregisterHandler(EventHandler h) {
        if (h != null) {
            this.unregisterHandler((HandlerRegistration)this.handlers.get(h), h);
        }
    }

    public synchronized void handleStateChange(String region, Object name, Object obj, EntryState sold, EntryState snew, StateChangeEventHandler.Reason reason) {
        this.statechange.raise(region, name, obj, sold, snew, reason);
    }

    public synchronized void handleInvalidation(String region, Object name, Object obj) {
        this.invalidation.raise(region, name, obj, null, null, null);
    }

    public synchronized void handlePreemption(String region, Object name, Object obj) {
        this.preemption.raise(region, name, obj, null, null, null);
    }

    protected void finalize() {
        this.clear();
    }

    static abstract class EventType {
        private HashSet handlers = new HashSet();

        EventType() {
        }

        void registerHandler(EventHandler h) {
            if (this.check(h)) {
                this.handlers.add(h);
            }
        }

        void unregisterHandler(EventHandler h) {
            this.handlers.remove(h);
        }

        void raise(String region, Object name, Object object, EntryState sold, EntryState snew, StateChangeEventHandler.Reason reason) {
            if (!this.handlers.isEmpty()) {
                Iterator i = this.handlers.iterator();
                while (i.hasNext()) {
                    try {
                        this.forward(i.next(), region, name, object, sold, snew, reason);
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                }
                if (object != null && this.check(object)) {
                    this.forward(object, region, name, object, sold, snew, reason);
                }
            }
        }

        abstract boolean check(Object var1);

        abstract void forward(Object var1, String var2, Object var3, Object var4, EntryState var5, EntryState var6, StateChangeEventHandler.Reason var7);
    }

    private final class HandlerRegistration
    extends SimpleRegistration {
        HandlerRegistration(EventHandler h) {
            super(h);
        }

        EventHandler getHandler() {
            return (EventHandler)this.getObject();
        }

        protected void handleUnregister() {
            HandlerRegistrations.this.unregisterHandler(this, this.getHandler());
        }

        protected void inc() {
            super.inc();
        }

        protected void dec() {
            super.dec();
        }
    }
}

