/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ip.basecomps.cache;

import com.sap.ip.basecomps.cache.PreemptionHandler;
import com.sap.ip.basecomps.cache.Region;

public class DefaultPreemptionHandler
implements PreemptionHandler {
    PreemptionHandler.PreemptionCacheAccess access = null;
    int next = 0;

    public void setCacheAccess(PreemptionHandler.PreemptionCacheAccess acc) {
        this.access = acc;
    }

    public PreemptionHandler.Entry createPreemptionEntry(Object key) {
        return new MyEntry();
    }

    public void deletePreemptionEntry(PreemptionHandler.Entry e) {
    }

    public void preempt(long additional) {
        boolean found = false;
        int size = this.access.noofElems();
        int loops = 0;
        MyEntry e = null;
        long max = this.access.getMaxWeight();
        long required = this.access.getWeight() + additional - max;
        long time = Region.getMillis();
        if (max <= 0L || size == 0) {
            return;
        }
        if (required <= 0L) {
            return;
        }
        if (required > max) {
            required = max;
        }
        if (this.next >= size) {
            this.next = 0;
        }
        int start = this.next;
        while (required > 0L && loops < 3) {
            e = (MyEntry)this.access.getEntryAt(this.next);
            if (e != null) {
                e.validate(time);
            }
            max = this.access.getMaxWeight();
            required = this.access.getWeight() + additional - max;
            if (required > max) {
                required = max;
            }
            if (required <= 0L) continue;
            if (e != null) {
                if (e.isPreemptable() && (e.isIdle(time) || !e.isTouched())) {
                    e.preempt();
                } else if (e.isTouched()) {
                    e.resetTouched();
                    found = true;
                }
            }
            ++this.next;
            if (this.next >= this.access.noofElems()) {
                if (this.next <= start) {
                    start = 0;
                }
                this.next = 0;
                ++loops;
            }
            if (this.next == start && !found) break;
        }
    }

    class MyEntry
    extends PreemptionHandler.Entry {
        boolean touched = false;

        MyEntry() {
        }

        public void touch(long time) {
            this.touched = true;
        }

        public boolean isTouched() {
            return this.touched;
        }

        public void resetTouched() {
            this.touched = false;
        }
    }
}

