/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ip.basecomps.cache;

import com.sap.ip.basecomps.cache.Attributes;
import com.sap.ip.basecomps.cache.CacheAccess;
import com.sap.ip.basecomps.cache.CacheException;
import com.sap.ip.basecomps.cache.EventHandler;
import com.sap.ip.basecomps.cache.ObjectExistsException;
import com.sap.ip.basecomps.cache.ObjectNotFoundException;
import com.sap.ip.basecomps.cache.PreemptionHandler;
import com.sap.ip.basecomps.cache.Region;
import com.sap.ip.basecomps.cache.RegionNotExistsException;
import com.sap.ip.basecomps.cache.StatisticEntry;
import com.sap.ip.basecomps.debug.Debug;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Properties;
import java.util.Vector;

public class CacheAdmin {
    private static Debug deb = Debug.getDebug("cache");
    private static HashMap regions = new HashMap();
    private static Vector accesses = new Vector();
    private static int size = 0;
    private static int access_id = 0;
    private static int entry_id = 0;

    static synchronized void setDefaultRegion(String name) throws RegionNotExistsException {
        Region r = CacheAdmin.getRegion(name);
        regions.put(null, r);
    }

    static synchronized Region queryRegion(String name) {
        return (Region)regions.get(name);
    }

    static synchronized Region getRegion(String name) throws RegionNotExistsException {
        Region r = (Region)regions.get(name);
        if (r == null) {
            throw new RegionNotExistsException(name);
        }
        return r;
    }

    public static synchronized void defineRegion(String name) throws CacheException {
        CacheAdmin.defineRegion(name, new Attributes());
    }

    public static synchronized void defineRegion(String name, Attributes attr) throws CacheException {
        String basename;
        String path = null;
        if (name.startsWith("/")) {
            name = name.substring(1);
        }
        if (regions.get(name) != null) {
            throw new ObjectExistsException(name);
        }
        int ix = name.lastIndexOf(47);
        if (ix >= 0) {
            basename = name.substring(ix + 1);
            if (ix > 0) {
                path = name.substring(0, ix);
            }
        } else {
            basename = name;
        }
        Region parent = null;
        if (path != null) {
            parent = CacheAdmin.getRegion(path);
        }
        Region r = new Region(name, path, basename, parent, attr);
        if (parent != null) {
            parent.addRegion(r);
        }
        regions.put(name, r);
        CacheAdmin.registerAccess(r.getPreemptionCacheAccess());
    }

    public static synchronized void destroyRegion(String name) throws CacheException {
        Region r = (Region)regions.get(name);
        if (r == null) {
            throw new ObjectNotFoundException(name);
        }
        if (r.hasSubRegions()) {
            throw new ObjectExistsException(name + " still has subregions");
        }
        regions.remove(name);
        Region parent = r.getParent();
        if (parent != null) {
            parent.removeRegion(r);
        }
        CacheAdmin.unregisterAccess(r.getPreemptionCacheAccess());
        r.close();
    }

    public static synchronized Collection getAllRegions() {
        return new HashSet(regions.keySet());
    }

    public static synchronized Collection getRegions() {
        HashSet<String> s = new HashSet<String>();
        Iterator i = regions.values().iterator();
        while (i.hasNext()) {
            Region r = (Region)i.next();
            if (r.getParent() != null) continue;
            s.add(r.getRegionName());
        }
        return s;
    }

    public static synchronized Collection getRegions(String name) throws CacheException {
        Region r = CacheAdmin.getRegion(name);
        return r.getSubRegions();
    }

    public static synchronized int getNoOfOwnerInfos() {
        int sum = 0;
        Iterator i = regions.values().iterator();
        while (i.hasNext()) {
            Region r = (Region)i.next();
            sum += r.getNoOfOwnerInfos();
        }
        return sum;
    }

    public static StatisticEntry getStatistics(String name) throws CacheException {
        Region r = CacheAdmin.getRegion(name);
        return r.getStatistics();
    }

    public static StatisticEntry getStatistics(CacheAccess access) throws CacheException {
        Region r = access.getRegion();
        return r.getStatistics();
    }

    public static Attributes getAttributes(String name) throws CacheException {
        Region r = CacheAdmin.getRegion(name);
        return r.getAttributes();
    }

    public static Attributes getAttributes(CacheAccess access) throws CacheException {
        Region r = access.getRegion();
        return r.getAttributes();
    }

    public static Collection getAccesses(String name) throws CacheException {
        Region r = CacheAdmin.getRegion(name);
        return r.getAccesses();
    }

    public static Collection getAccesses(CacheAccess access) throws CacheException {
        Region r = access.getRegion();
        return r.getAccesses();
    }

    public static Counts getCounts(String name) throws CacheException {
        Region r = CacheAdmin.getRegion(name);
        return new Counts(r);
    }

    public static void registerGlobalHandler(CacheAccess access, EventHandler h) throws RegionNotExistsException {
        Region r = CacheAdmin.getRegion(access.getRegionName());
        r.registerHandler(h);
    }

    public static void registerGlobalHandler(String name, EventHandler h) throws RegionNotExistsException {
        Region r = CacheAdmin.getRegion(name);
        r.registerHandler(h);
    }

    public static void unregisterGlobalHandler(CacheAccess access, EventHandler h) throws RegionNotExistsException {
        Region r = CacheAdmin.getRegion(access.getRegionName());
        r.unregisterHandler(h);
    }

    public static void unregisterGlobalHandler(String name, EventHandler h) throws RegionNotExistsException {
        Region r = CacheAdmin.getRegion(name);
        r.unregisterHandler(h);
    }

    static void registerAccess(PreemptionHandler.PreemptionCacheAccess access) {
        Vector vector = accesses;
        synchronized (vector) {
            if (!accesses.contains(access)) {
                accesses.add(access);
                ++size;
            }
        }
    }

    static void unregisterAccess(PreemptionHandler.PreemptionCacheAccess access) {
        Vector vector = accesses;
        synchronized (vector) {
            if (accesses.removeElement(access)) {
                --size;
            }
        }
    }

    public static void cleanupStep(long time) {
        try {
            PreemptionHandler.Entry entry;
            PreemptionHandler.PreemptionCacheAccess access;
            Vector vector = accesses;
            synchronized (vector) {
                if (access_id >= size) {
                    access_id = 0;
                }
                access = (PreemptionHandler.PreemptionCacheAccess)accesses.elementAt(access_id);
            }
            int noof = access.noofElems();
            if (entry_id >= noof) {
                ++access_id;
                entry_id = 0;
                entry = null;
            } else {
                entry = access.getEntryAt(entry_id++);
            }
            if (entry != null) {
                if (deb.active()) {
                    deb.out("cleanup step for " + access.getRegionName() + " " + entry_id);
                }
                entry.checkCleanup(time);
            }
        }
        catch (Exception e) {
            // empty catch block
        }
    }

    public static void cleanup() {
        PreemptionHandler.PreemptionCacheAccess access = null;
        boolean cont = true;
        int i = 0;
        long time = Region.getMillis();
        while (cont) {
            Vector vector = accesses;
            synchronized (vector) {
                if (i < size) {
                    access = (PreemptionHandler.PreemptionCacheAccess)accesses.elementAt(i);
                    ++i;
                } else {
                    cont = false;
                }
            }
            if (!cont || access == null) continue;
            access.cleanup();
        }
    }

    public static boolean setCleanupStepHandling(String name, boolean dosteps) throws CacheException {
        Region r = CacheAdmin.getRegion(name);
        return r.setCleanupStepHandling(dosteps);
    }

    public static boolean setCleanupStepHandling(CacheAccess access, boolean dosteps) throws CacheException {
        Region r = access.getRegion();
        return r.setCleanupStepHandling(dosteps);
    }

    static {
        Properties props = new Properties();
        props.setProperty("consistency-domain", "<NONE>");
        try {
            CacheAdmin.defineRegion("default", new Attributes(props));
            CacheAdmin.setDefaultRegion("default");
        }
        catch (Exception e) {
            System.err.println("creation of default cache region failed");
            e.printStackTrace(System.err);
        }
    }

    public static class Counts
    extends Region.Counts {
        volatile long entries;
        volatile long max;
        volatile long deleted;
        volatile long frozen;

        Counts(Region r) {
            r.setCounts(this);
        }

        public long getMaxWeight() {
            return this.max;
        }

        public long getKeptWeight() {
            return this.w_kept;
        }

        public long getIdleWeight() {
            return this.w_idle;
        }

        public long getPreemptedWeight() {
            return this.w_preempted;
        }

        public long getOutOfDateWeight() {
            return this.w_outofdate;
        }

        public long getKeptCount() {
            return this.c_kept;
        }

        public long getIdleCount() {
            return this.c_idle;
        }

        public long getPreemptedCount() {
            return this.c_preempted;
        }

        public long getOutOfDateCount() {
            return this.c_outofdate;
        }

        public long getNumOfEntries() {
            return this.entries;
        }

        public long getFrozen() {
            return this.frozen;
        }

        public long getDeleted() {
            return this.deleted;
        }

        public void print() {
            this.print(null);
        }

        public synchronized void print(String txt) {
            System.out.println("*** entry statistic info" + (txt == null ? "" : " " + txt) + " ***");
            System.out.println(" Weights:");
            System.out.println("  max      : " + this.getMaxWeight());
            System.out.println("  kept     : " + this.getKeptWeight());
            System.out.println("  idle     : " + this.getIdleWeight());
            System.out.println("  preempted: " + this.getPreemptedWeight());
            System.out.println("  outofdate: " + this.getOutOfDateWeight());
            System.out.println(" Counts:");
            System.out.println("  entries  : " + this.getNumOfEntries());
            System.out.println("  kept     : " + this.getKeptCount());
            System.out.println("  idle     : " + this.getIdleCount());
            System.out.println("  preempted: " + this.getPreemptedCount());
            System.out.println("  outofdate: " + this.getOutOfDateCount());
            System.out.println(" Internal Counts:");
            System.out.println("  frozen   : " + this.getFrozen());
            System.out.println("  deleted  : " + this.getDeleted());
        }
    }
}

