/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ip.basecomps.cache;

import com.sap.ip.basecomps.cache.Attributes;
import com.sap.ip.basecomps.cache.CacheAdmin;
import com.sap.ip.basecomps.cache.CacheException;
import com.sap.ip.basecomps.cache.EntryAttributes;
import com.sap.ip.basecomps.cache.EntryState;
import com.sap.ip.basecomps.cache.EventHandler;
import com.sap.ip.basecomps.cache.HandlerRegistrations;
import com.sap.ip.basecomps.cache.InvalidGroupException;
import com.sap.ip.basecomps.cache.InvalidHandleException;
import com.sap.ip.basecomps.cache.InvalidationEventHandler;
import com.sap.ip.basecomps.cache.NotARetrievableObjectException;
import com.sap.ip.basecomps.cache.ObjectNotFoundException;
import com.sap.ip.basecomps.cache.OwnerInfo;
import com.sap.ip.basecomps.cache.PreemptionEventHandler;
import com.sap.ip.basecomps.cache.Region;
import com.sap.ip.basecomps.cache.RegionHandle;
import com.sap.ip.basecomps.cache.StateChangeEventHandler;
import com.sap.ip.basecomps.cache.StatisticEntry;
import com.sap.ip.basecomps.debug.Debug;
import java.util.AbstractMap;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Set;
import java.util.WeakHashMap;

public class CacheAccess {
    private static Debug deb = Debug.getDebug("cache");
    private Region region;
    private String name;
    private Handler registered = null;
    private WeakHashMap owners = new WeakHashMap();
    StatisticEntry statistic = new StatisticEntry();

    public static void defineRegion(String name) throws CacheException {
        CacheAdmin.defineRegion(name);
    }

    public static void defineRegion(String name, Attributes attr) throws CacheException {
        CacheAdmin.defineRegion(name, attr);
    }

    public static void destroyRegion(String name) throws CacheException {
        CacheAdmin.destroyRegion(name);
    }

    public void defineSubRegion(String name) throws CacheException {
        CacheAdmin.defineRegion(this.getRegionName() + "/" + name);
    }

    public void defineSubRegion(String name, Attributes attr) throws CacheException {
        CacheAdmin.defineRegion(this.getRegionName() + "/" + name, attr);
    }

    public static final CacheAccess getAccess() throws CacheException {
        return CacheAdmin.getRegion(null).getAccess();
    }

    public static final CacheAccess getAccess(String name) throws CacheException {
        return CacheAdmin.getRegion(name).getAccess();
    }

    public final CacheAccess getSubAccess(String name) throws CacheException {
        return CacheAdmin.getRegion(this.getRegionName() + "/" + name).getAccess();
    }

    public final Collection getRegions() throws CacheException {
        this.check();
        return this.region.getSubRegions();
    }

    private void check() throws InvalidHandleException {
        if (this.region == null) {
            throw new InvalidHandleException(this.getRegionName());
        }
    }

    protected CacheAccess(RegionHandle r) {
        this(r.getRegion());
    }

    CacheAccess(Region r) {
        this.region = r;
        this.name = r.getRegionName();
        this.region.open(this);
    }

    public final String getRegionName() {
        return this.name;
    }

    protected void _close() {
    }

    public final synchronized void close() {
        if (this.region != null) {
            this._close();
            this.releaseOwnerships();
            if (this.registered != null) {
                this.region.unregisterHandler(this.registered);
                this.registered.clear();
                this.registered = null;
            }
            this.region.close(this);
            this.region = null;
        }
    }

    protected void _finalize() {
    }

    public final void finalize() throws Throwable {
        super.finalize();
        deb.out("finalize cache access for region " + this.getRegionName());
        this.close();
        this._finalize();
    }

    public final synchronized void registerHandler(EventHandler h) throws InvalidHandleException {
        this.check();
        if (this.registered == null) {
            this.registered = new Handler();
            this.region.registerHandler(this.registered);
        }
        this.registered.registerHandler(h);
    }

    public final synchronized void unregisterHandler(EventHandler h) throws InvalidHandleException {
        this.check();
        if (this.registered != null) {
            this.registered.unregisterHandler(h);
            if (this.registered.isEmpty()) {
                this.region.unregisterHandler(this.registered);
                this.registered.clear();
                this.registered = null;
            }
        }
    }

    public final void registerGlobalHandler(EventHandler h) throws InvalidHandleException {
        this.check();
        this.region.registerHandler(h);
    }

    public final void unregisterGlobalHandler(EventHandler h) throws InvalidHandleException {
        this.check();
        this.region.unregisterHandler(h);
    }

    final Region getRegion() throws InvalidHandleException {
        this.check();
        return this.region;
    }

    protected EntryState _getState(Object name) throws ObjectNotFoundException, InvalidHandleException, NotARetrievableObjectException {
        return this.region.getState(this, name);
    }

    public final EntryState getState(Object name) throws ObjectNotFoundException, InvalidHandleException, NotARetrievableObjectException {
        this.check();
        return this._getState(name);
    }

    public final boolean containsKey(Object name) throws ObjectNotFoundException, InvalidHandleException, NotARetrievableObjectException {
        this.check();
        return this.region.isMapped(name);
    }

    protected Object _get(Object name, String group, Object args) throws ObjectNotFoundException, InvalidHandleException, InvalidGroupException, NotARetrievableObjectException {
        return this.region.get(this, name, group, args);
    }

    public final Object get(Object name) throws ObjectNotFoundException, InvalidHandleException, NotARetrievableObjectException {
        this.check();
        try {
            return this._get(name, null, null);
        }
        catch (InvalidGroupException ig) {
            return null;
        }
    }

    public final Object get(Object name, Object args) throws ObjectNotFoundException, InvalidHandleException, NotARetrievableObjectException {
        this.check();
        try {
            return this._get(name, null, args);
        }
        catch (InvalidGroupException ig) {
            return null;
        }
    }

    public final Object get(Object name, String group, Object args) throws ObjectNotFoundException, InvalidHandleException, InvalidGroupException, NotARetrievableObjectException {
        this.check();
        return this._get(name, group, args);
    }

    protected void _put(Object name, String group, Attributes attr, Object obj) throws CacheException {
        this.region.put(this, name, group, attr, obj);
    }

    public final void put(Object name, Object obj) throws CacheException {
        this.put(name, null, null, obj);
    }

    public final void put(Object name, String group, Object obj) throws CacheException {
        this.put(name, group, null, obj);
    }

    public final void put(Object name, Attributes attr, Object obj) throws CacheException {
        this.put(name, null, attr, obj);
    }

    public final void put(Object name, String group, Attributes attr, Object obj) throws CacheException {
        this.check();
        this._put(name, group, attr, obj);
    }

    protected Object _replace(Object name, String group, Attributes attr, Object obj) throws CacheException {
        return this.region.replace(this, name, group, attr, obj);
    }

    public final Object replace(Object name, Object obj) throws CacheException {
        this.check();
        return this._replace(name, null, null, obj);
    }

    public final Object replace(Object name, String group, Object obj) throws CacheException {
        this.check();
        return this._replace(name, group, null, obj);
    }

    public final Object replace(Object name, String group, Attributes attr, Object obj) throws CacheException {
        this.check();
        return this._replace(name, group, attr, obj);
    }

    public Set getEntries() throws CacheException {
        this.check();
        return this.region.getEntries(this);
    }

    public Set getGroups() throws CacheException {
        this.check();
        return this.region.getGroups(this, false);
    }

    public Set getGroups(boolean toplevel) throws CacheException {
        this.check();
        return this.region.getGroups(this, toplevel);
    }

    protected void _invalidate(EntryHandle h) throws CacheException {
        this.region.invalidate(this, h);
    }

    public final void invalidate() throws CacheException {
        this.check();
        Iterator i = this.region.getEntries().iterator();
        while (i.hasNext()) {
            this._invalidate((EntryHandle)i.next());
        }
    }

    public final void invalidate(Object name) throws CacheException {
        this.check();
        EntryHandle h = this.region.getEntry(name);
        if (h != null) {
            this._invalidate(h);
        }
    }

    protected final void _invalidateLocal(EntryHandle h) throws CacheException {
        this.region.invalidateLocal(h);
    }

    public final void invalidateLocal(Object name) throws CacheException {
        this.check();
        EntryHandle h = this.region.queryEntry(name);
        if (h != null) {
            this._invalidateLocal(h);
        }
    }

    public final void invalidateLocalMatched(Object pattern) throws CacheException {
        this.check();
        Iterator i = this.region.getEntries(pattern).iterator();
        while (i.hasNext()) {
            this._invalidateLocal((EntryHandle)i.next());
        }
    }

    public final void waitForResponse(long timeout) throws CacheException {
        this.check();
        this.region.waitForResponse(this, timeout);
    }

    public final void cancelResponse() throws CacheException {
        this.check();
        this.region.cancelResponse(this);
    }

    public final void defineGroup(String name) throws CacheException {
        this.defineGroup(name, (String)null);
    }

    public final void defineGroup(String name, String group) throws CacheException {
        this.defineGroup(name, group, null);
    }

    public final void defineGroup(String name, Attributes attr) throws CacheException {
        this.defineGroup(name, null, attr);
    }

    public final void defineGroup(String name, String group, Attributes attr) throws CacheException {
        this.check();
        this.region.defineGroup(name, group, attr);
    }

    public final boolean containsGroup(String name) throws CacheException {
        this.check();
        return this.region.containsGroup(name);
    }

    protected void _defineObject(Object name, String group, Attributes attr) throws CacheException {
        this.region.defineObject(name, group, attr);
    }

    public final void defineObject(Object name, Attributes attr) throws CacheException {
        this.defineObject(name, null, attr);
    }

    public final void defineObject(Object name, String group, Attributes attr) throws CacheException {
        this.check();
        this.region.defineObject(name, group, attr);
    }

    public final void delete() throws CacheException {
        this.check();
        this.region.delete(this);
    }

    public final void delete(Object name) throws CacheException {
        this.check();
        this.region.delete(this, name);
    }

    public final void destroy() throws CacheException {
        this.check();
        this.region.destroy(this);
    }

    protected void _destroy(Object name) throws CacheException {
        this.region.destroy(this, name);
    }

    public final void destroy(Object name) throws CacheException {
        this.check();
        this._destroy(name);
    }

    public final boolean getOwnership(Object name, int timeout) throws CacheException {
        this.check();
        return this.region.getOwnership(this, name, timeout);
    }

    public final void releaseOwnership(Object name) throws CacheException {
        this.check();
        this.region.releaseOwnership(this, name);
    }

    public final void releaseOwnership() throws CacheException {
        this.check();
        this.region.releaseOwnership(this);
    }

    public final Attributes getAttributes() throws CacheException {
        this.check();
        return new Attributes(this.region.getAttributes());
    }

    public final EntryAttributes getAttributes(Object name) throws CacheException {
        this.check();
        return new EntryAttributes(this.region.getAttributes(name));
    }

    public final String getGroup(Object name) throws CacheException {
        this.check();
        return this.region.getGroup(this, name);
    }

    public final Set getGroupMembers(Object name) throws CacheException {
        this.check();
        return this.region.getGroupMembers(this, name);
    }

    public final Set getGroupElements(Object name) throws CacheException {
        this.check();
        return this.region.getGroupElements(this, name);
    }

    public final synchronized int getNoOfOwnerInfos() {
        return this.owners.size();
    }

    final synchronized OwnerInfo getOwnerInfo() {
        Object o = this.region.attr.getOwnerFactory().getCurrentOwner(this);
        OwnerInfo i = (OwnerInfo)this.owners.get(o);
        if (i == null) {
            i = new OwnerInfo(this, o);
            this.owners.put(o, i);
        }
        return i;
    }

    final synchronized void releaseOwnerships() {
        Iterator o = ((AbstractMap)this.owners).values().iterator();
        while (o.hasNext()) {
            try {
                this.region.releaseOwnership((OwnerInfo)o.next());
            }
            catch (CacheException cacheException) {
                // empty catch block
            }
            o.remove();
        }
    }

    final void notifyHit() {
        this.statistic.notifyHit();
        this.region.notifyHit();
    }

    final void notifyMiss() {
        this.statistic.notifyMiss();
        this.region.notifyMiss();
    }

    final void notifyLoad() {
        this.statistic.notifyLoad();
        this.region.notifyLoad();
    }

    final void notifyWrite() {
        this.statistic.notifyWrite();
        this.region.notifyWrite();
    }

    public final StatisticEntry getStatistics() {
        return this.statistic;
    }

    public final StatisticEntry getRegionStatistics() {
        return this.region.getStatistics();
    }

    protected static interface EntryHandle {
        public Object getId();

        public Attributes getAttributeAccess();

        public boolean isGroup();
    }

    public static class Group
    extends Element {
        Group(Region.Group g, HashMap elems) {
            super(g, elems);
        }

        public boolean isGroup() {
            return true;
        }
    }

    public static class Entry
    extends Element {
        private EntryState state;
        private Object value;

        Entry(Region.Entry e, HashMap elems) {
            super(e, elems);
            this.value = e.getMapping();
            this.state = e.getState();
        }

        public Object getValue() {
            return this.value;
        }

        public EntryState getState() {
            return this.state;
        }
    }

    public static class Element {
        private Object name;
        private Attributes attr;
        private Group group;

        Element(Region.Element e, HashMap elems) {
            this.name = e.getId();
            this.attr = e.getAttributes();
            Region.Group g = e.getGroup();
            elems.put(e, this);
            if (g != null) {
                this.group = (Group)elems.get(g);
                if (this.group == null) {
                    this.group = new Group(g, elems);
                }
            } else {
                this.group = null;
            }
        }

        public Object getId() {
            return this.name;
        }

        public Attributes getAttributes() {
            return this.attr;
        }

        public Group getGroup() {
            return this.group;
        }

        public boolean isGroup() {
            return false;
        }
    }

    private class Handler
    implements InvalidationEventHandler,
    PreemptionEventHandler,
    StateChangeEventHandler {
        private HandlerRegistrations handlers = new HandlerRegistrations();

        public void clear() {
            this.handlers.clear();
        }

        public boolean isEmpty() {
            return this.handlers.isEmpty();
        }

        public void registerHandler(EventHandler h) {
            this.handlers.registerHandler(h);
        }

        public void unregisterHandler(EventHandler h) {
            this.handlers.unregisterHandler(h);
        }

        public void handleInvalidation(String region, Object name, Object obj) {
            this.handlers.handleInvalidation(region, name, obj);
        }

        public void handlePreemption(String region, Object name, Object obj) {
            this.handlers.handlePreemption(region, name, obj);
        }

        public void handleStateChange(String region, Object name, Object obj, EntryState sold, EntryState snew, StateChangeEventHandler.Reason reason) {
            this.handlers.handleStateChange(region, name, obj, sold, snew, reason);
        }
    }
}

