/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ip.basecomps.cache;

import com.sap.ip.basecomps.cache.CacheAccessFactory;
import com.sap.ip.basecomps.cache.CacheLoader;
import com.sap.ip.basecomps.cache.KeyHandler;
import com.sap.ip.basecomps.cache.OwnerFactory;
import com.sap.ip.basecomps.cache.PreemptionHandler;
import com.sap.ip.basecomps.consistency.ConsistencyDomain;
import com.sap.ip.basecomps.consistency.ConsistencyDomains;
import com.sap.ip.basecomps.util.Util;
import java.util.Hashtable;
import java.util.Properties;

public class Attributes {
    Object user_attributes;
    KeyHandler keyhandler;
    CacheLoader loader;
    ConsistencyDomain domain;
    CacheAccessFactory accessfac;
    OwnerFactory ownerfac;
    PreemptionHandler preempt;
    long weight;
    boolean weight_set;
    long real_weight;
    boolean real_weight_set;
    long lifetime;
    boolean lifetime_set;
    long idletime;
    boolean idletime_set;
    boolean reply;
    boolean reply_set;
    boolean no_null;
    boolean no_null_set;
    boolean unique_mapping;
    boolean unique_mapping_set;
    boolean sync_events;
    boolean sync_events_set;
    long maxweight;
    boolean maxweight_set;
    long created;

    public Attributes() {
        this((Properties)null);
    }

    public Attributes(Properties props) {
        if (props != null) {
            this.user_attributes = null;
            Properties a = Util.getProperties(props, "key-handler");
            this.keyhandler = KeyHandler.util.getHandler(a);
            a = Util.getProperties(props, "preemption-handler");
            this.preempt = PreemptionHandler.util.getHandler(a);
            a = Util.getProperties(props, "cache-loader");
            this.loader = CacheLoader.getLoader(a);
            a = Util.getProperties(props, "access-factory");
            this.accessfac = CacheAccessFactory.util.getFactory(a);
            a = Util.getProperties(props, "owner-factory");
            this.ownerfac = OwnerFactory.util.getOwnerFactory(a);
            String name = props.getProperty("consistency-domain");
            if (name == null) {
                a = Util.getProperties(props, "consistency-domain");
                if (((Hashtable)a).size() == 0) {
                    a = null;
                } else {
                    name = a.getProperty("name");
                }
            }
            this.domain = name != null ? (a == null ? ConsistencyDomains.queryDomain(name) : ConsistencyDomains.createDomain(name, a)) : null;
            name = props.getProperty("weight");
            this.weight = 1L;
            this.weight_set = false;
            if (name != null) {
                try {
                    this.weight = Integer.parseInt(name);
                    this.weight_set = true;
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
            name = props.getProperty("maxweight");
            this.maxweight = 0L;
            this.maxweight_set = false;
            if (name != null) {
                try {
                    this.maxweight = Integer.parseInt(name);
                    this.maxweight_set = true;
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
            name = props.getProperty("lifetime");
            this.lifetime = 0L;
            this.lifetime_set = false;
            if (name != null) {
                try {
                    this.lifetime = Integer.parseInt(name);
                    this.lifetime_set = true;
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
            name = props.getProperty("idletime");
            this.idletime = 0L;
            this.idletime_set = false;
            if (name != null) {
                try {
                    this.idletime = Integer.parseInt(name);
                    this.idletime_set = true;
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
            name = props.getProperty("reply");
            this.reply = false;
            this.reply_set = false;
            if (name != null) {
                this.reply = Util.getSwitch(name);
                this.reply_set = true;
            }
            name = props.getProperty("no-null");
            this.no_null = false;
            this.no_null_set = false;
            if (name != null) {
                this.no_null = Util.getSwitch(name);
                this.no_null_set = true;
            }
            name = props.getProperty("unique-mapping");
            this.unique_mapping = false;
            this.unique_mapping_set = false;
            if (name != null) {
                this.unique_mapping = Util.getSwitch(name);
                this.unique_mapping_set = true;
            }
            name = props.getProperty("sync-events");
            this.sync_events = false;
            this.sync_events_set = false;
            if (name != null) {
                this.sync_events = Util.getSwitch(name);
                this.sync_events_set = true;
            }
        } else {
            this.init();
        }
    }

    private void init() {
        this.user_attributes = null;
        this.keyhandler = null;
        this.loader = null;
        this.domain = null;
        this.accessfac = null;
        this.ownerfac = null;
        this.preempt = null;
        this.weight = 1L;
        this.weight_set = false;
        this.real_weight = 1L;
        this.real_weight_set = false;
        this.lifetime = 0L;
        this.lifetime_set = false;
        this.idletime = 0L;
        this.idletime_set = false;
        this.reply = false;
        this.reply_set = false;
        this.maxweight = 0L;
        this.maxweight_set = false;
        this.no_null = false;
        this.no_null_set = false;
        this.unique_mapping = false;
        this.unique_mapping_set = false;
        this.sync_events = false;
        this.sync_events_set = false;
        this.created = 0L;
    }

    public Attributes(Attributes attr) {
        if (attr != null) {
            this.user_attributes = attr.getUserAttributes();
            this.keyhandler = attr.getKeyHandler();
            this.loader = attr.getLoader();
            this.accessfac = attr.getAccessFactory();
            this.ownerfac = attr.getOwnerFactory();
            this.domain = attr.getConsistencyDomain();
            this.preempt = attr.getPreemptionHandler();
            this.weight = attr.getWeight();
            this.weight_set = true;
            this.real_weight = attr.getRealWeight();
            this.real_weight_set = true;
            this.lifetime = attr.getLifeTime();
            this.lifetime_set = true;
            this.idletime = attr.getIdleTime();
            this.idletime_set = true;
            this.reply = attr.useReply();
            this.reply_set = true;
            this.maxweight = attr.getMaxWeight();
            this.maxweight_set = true;
            this.no_null = attr.useExceptions();
            this.no_null_set = true;
            this.unique_mapping = attr.useUniqueMapping();
            this.unique_mapping_set = true;
            this.sync_events = attr.syncEvents();
            this.sync_events_set = true;
            this.created = attr.getCreateTime();
        } else {
            this.init();
        }
    }

    protected Attributes getBase() {
        return null;
    }

    void join(Attributes attr) {
        if (attr != null) {
            if (attr.user_attributes != null) {
                this.user_attributes = attr.getUserAttributes();
            }
            if (attr.keyhandler != null) {
                this.keyhandler = attr.getKeyHandler();
            }
            if (attr.loader != null) {
                this.loader = attr.getLoader();
            }
            if (attr.accessfac != null) {
                this.accessfac = attr.getAccessFactory();
            }
            if (attr.ownerfac != null) {
                this.ownerfac = attr.getOwnerFactory();
            }
            if (attr.domain != null) {
                this.domain = attr.getConsistencyDomain();
            }
            if (attr.preempt != null) {
                this.preempt = attr.getPreemptionHandler();
            }
            if (attr.weight_set) {
                this.weight = attr.weight;
                this.weight_set = true;
            }
            if (attr.real_weight_set) {
                this.real_weight = attr.real_weight;
                this.real_weight_set = true;
            }
            if (attr.lifetime_set) {
                this.lifetime = attr.lifetime;
                this.lifetime_set = true;
            }
            if (attr.idletime_set) {
                this.idletime = attr.idletime;
                this.idletime_set = true;
            }
            if (attr.reply_set) {
                this.reply = attr.reply;
                this.reply_set = true;
            }
            if (attr.maxweight_set) {
                this.maxweight = attr.maxweight;
                this.maxweight_set = true;
            }
            if (attr.no_null_set) {
                this.no_null = attr.no_null;
                this.no_null_set = true;
            }
            if (attr.unique_mapping_set) {
                this.unique_mapping = attr.unique_mapping;
                this.unique_mapping_set = true;
            }
            if (attr.sync_events_set) {
                this.sync_events = attr.sync_events;
                this.sync_events_set = true;
            }
            if (attr.getCreateTime() > 0L) {
                this.created = attr.getCreateTime();
            }
        }
    }

    public long getCreateTime() {
        return this.created;
    }

    public Object getUserAttributes() {
        if (this.user_attributes != null) {
            return this.user_attributes;
        }
        Attributes base = this.getBase();
        if (base != null) {
            return base.getUserAttributes();
        }
        return null;
    }

    public void setUserAttributes(Object attr) {
        this.user_attributes = attr;
    }

    public KeyHandler getKeyHandler() {
        if (this.keyhandler != null) {
            return this.keyhandler;
        }
        Attributes base = this.getBase();
        if (base != null) {
            return base.getKeyHandler();
        }
        return null;
    }

    public void setKeyHandler(KeyHandler keyhandler) {
        this.keyhandler = keyhandler;
    }

    public CacheLoader getLoader() {
        if (this.loader != null) {
            return this.loader;
        }
        Attributes base = this.getBase();
        if (base != null) {
            return base.getLoader();
        }
        return null;
    }

    public void setLoader(CacheLoader loader) {
        this.loader = loader;
    }

    public CacheAccessFactory getAccessFactory() {
        if (this.accessfac != null) {
            return this.accessfac;
        }
        Attributes base = this.getBase();
        if (base != null) {
            return base.getAccessFactory();
        }
        return null;
    }

    public void setAccessFactory(CacheAccessFactory accessfac) {
        this.accessfac = accessfac;
    }

    public OwnerFactory getOwnerFactory() {
        if (this.ownerfac != null) {
            return this.ownerfac;
        }
        Attributes base = this.getBase();
        if (base != null) {
            return base.getOwnerFactory();
        }
        return null;
    }

    public void setOwnerFactory(OwnerFactory ownerfac) {
        this.ownerfac = ownerfac;
    }

    public ConsistencyDomain getConsistencyDomain() {
        if (this.domain != null) {
            return this.domain;
        }
        Attributes base = this.getBase();
        if (base != null) {
            return base.getConsistencyDomain();
        }
        return null;
    }

    public void setConsistencyDomain(ConsistencyDomain domain) {
        this.domain = domain;
    }

    public PreemptionHandler getPreemptionHandler() {
        if (this.preempt != null) {
            return this.preempt;
        }
        Attributes base = this.getBase();
        if (base != null) {
            return base.getPreemptionHandler();
        }
        return null;
    }

    public void setPreemptionHandler(PreemptionHandler preempt) {
        this.preempt = preempt;
    }

    public long getWeight() {
        if (this.weight_set) {
            return this.weight;
        }
        Attributes base = this.getBase();
        if (base != null) {
            return base.getWeight();
        }
        return 1L;
    }

    public void setWeight(long weight) {
        this.weight = weight;
        this.weight_set = true;
    }

    public long getRealWeight() {
        if (this.real_weight_set) {
            return this.real_weight;
        }
        Attributes base = this.getBase();
        if (base != null) {
            return base.getRealWeight();
        }
        return 1L;
    }

    public void setRealWeight(long weight) {
        this.real_weight = weight;
        this.real_weight_set = true;
    }

    public long getMaxWeight() {
        if (this.maxweight_set) {
            return this.maxweight;
        }
        Attributes base = this.getBase();
        if (base != null) {
            return base.getMaxWeight();
        }
        return 0L;
    }

    public void setMaxWeight(long weight) {
        this.maxweight = weight;
        this.maxweight_set = true;
    }

    public long getLifeTime() {
        if (this.lifetime_set) {
            return this.lifetime;
        }
        Attributes base = this.getBase();
        if (base != null) {
            return base.getLifeTime();
        }
        return 0L;
    }

    public void setLifeTime(long lifetime) {
        this.lifetime = lifetime;
        this.lifetime_set = true;
    }

    public long getIdleTime() {
        if (this.idletime_set) {
            return this.idletime;
        }
        Attributes base = this.getBase();
        if (base != null) {
            return base.getIdleTime();
        }
        return 0L;
    }

    public void setIdleTime(long idletime) {
        this.idletime = idletime;
        this.idletime_set = true;
    }

    public boolean useReply() {
        if (this.reply_set) {
            return this.reply;
        }
        Attributes base = this.getBase();
        if (base != null) {
            return base.useReply();
        }
        return false;
    }

    public void setReply(boolean reply) {
        this.reply = reply;
        this.reply_set = true;
    }

    public boolean useExceptions() {
        if (this.no_null_set) {
            return this.no_null;
        }
        Attributes base = this.getBase();
        if (base != null) {
            return base.useExceptions();
        }
        return false;
    }

    public void setExceptions(boolean no_null) {
        this.no_null = no_null;
        this.no_null_set = true;
    }

    public boolean useUniqueMapping() {
        if (this.unique_mapping_set) {
            return this.unique_mapping;
        }
        Attributes base = this.getBase();
        if (base != null) {
            return base.useUniqueMapping();
        }
        return false;
    }

    public void setUniqueMapping(boolean unique_mapping) {
        this.unique_mapping = unique_mapping;
        this.unique_mapping_set = true;
    }

    public boolean syncEvents() {
        if (this.sync_events_set) {
            return this.sync_events;
        }
        Attributes base = this.getBase();
        if (base != null) {
            return base.syncEvents();
        }
        return false;
    }

    public void setSyncEvents(boolean sync_events) {
        this.sync_events = sync_events;
        this.sync_events_set = true;
    }
}

