/*
 * Decompiled with CFR 0.152.
 */
package iaik.utils;

import iaik.utils.NumberTheory;
import java.math.BigInteger;
import java.util.Random;

public final class CryptoUtils {
    public static void zeroBlock(int[] nArray, int n, int n2) {
        int n3 = n;
        while (n3 < n + n2) {
            nArray[n3] = 0;
            ++n3;
        }
    }

    public static void zeroBlock(int[] nArray) {
        CryptoUtils.zeroBlock(nArray, 0, nArray.length);
    }

    public static void zeroBlock(byte[] byArray, int n, int n2) {
        int n3 = n;
        while (n3 < n + n2) {
            byArray[n3] = 0;
            ++n3;
        }
    }

    public static void zeroBlock(byte[] byArray) {
        CryptoUtils.zeroBlock(byArray, 0, byArray.length);
    }

    public static void xorBlock(byte[] byArray, byte[] byArray2, byte[] byArray3) {
        CryptoUtils.xorBlock(byArray, 0, byArray2, 0, byArray3, 0, byArray.length);
    }

    public static void xorBlock(byte[] byArray, int n, byte[] byArray2, int n2, byte[] byArray3, int n3, int n4) {
        int n5 = 0;
        while (n5 < n4) {
            byArray3[n3 + n5] = (byte)(byArray[n + n5] ^ byArray2[n2 + n5]);
            ++n5;
        }
    }

    public static void squashBytesToShortsLE(byte[] byArray, int n, int[] nArray, int n2, int n3) {
        int n4 = 0;
        while (n4 < n3) {
            int n5 = n + (n4 << 1) + 1;
            nArray[n2 + n4] = (byArray[n5--] & 0xFF) << 8 | byArray[n5] & 0xFF;
            ++n4;
        }
    }

    public static void squashBytesToShortsBE(byte[] byArray, int n, int[] nArray, int n2, int n3) {
        int n4 = 0;
        while (n4 < n3) {
            int n5 = n + (n4 << 1);
            nArray[n2 + n4] = (byArray[n5++] & 0xFF) << 8 | byArray[n5] & 0xFF;
            ++n4;
        }
    }

    public static void squashBytesToIntsPadZero(byte[] byArray, int n, int[] nArray, int n2, int n3) {
        int n4 = n3 >> 2;
        int n5 = n3 & 3;
        if (n4 != 0) {
            CryptoUtils.squashBytesToInts(byArray, n, nArray, n2, n4);
        }
        if (n5 != 0) {
            n += n3 - n5;
            n2 += n4;
            switch (n5) {
                case 3: {
                    nArray[n2] = (byArray[n++] & 0xFF) << 24 | (byArray[n++] & 0xFF) << 16 | (byArray[n++] & 0xFF) << 8;
                    return;
                }
                case 2: {
                    nArray[n2] = (byArray[n++] & 0xFF) << 24 | (byArray[n++] & 0xFF) << 16;
                    return;
                }
                case 1: {
                    nArray[n2] = (byArray[n++] & 0xFF) << 24;
                    return;
                }
            }
        }
    }

    public static int squashBytesToIntsLEPadZero(byte[] byArray, int n, int[] nArray, int n2, int n3) {
        int n4 = n3 >> 2;
        int n5 = n3 & 3;
        if (n4 != 0) {
            CryptoUtils.squashBytesToIntsLE(byArray, n, nArray, n2, n4);
        }
        if (n5 != 0) {
            n += n3 - n5;
            n2 += n4;
            switch (n5) {
                case 3: {
                    nArray[n2] = byArray[n++] & 0xFF | (byArray[n++] & 0xFF) << 8 | (byArray[n++] & 0xFF) << 16;
                    break;
                }
                case 2: {
                    nArray[n2] = byArray[n++] & 0xFF | (byArray[n++] & 0xFF) << 8;
                    break;
                }
                case 1: {
                    nArray[n2] = byArray[n++] & 0xFF;
                    break;
                }
            }
            return n4 + 1;
        }
        return n4;
    }

    public static void squashBytesToIntsLE(byte[] byArray, int n, int[] nArray, int n2, int n3) {
        int n4 = 0;
        while (n4 < n3) {
            int n5 = n + (n4 << 2);
            nArray[n2 + n4] = byArray[n5++] & 0xFF | (byArray[n5++] & 0xFF) << 8 | (byArray[n5++] & 0xFF) << 16 | byArray[n5] << 24;
            ++n4;
        }
    }

    public static void squashBytesToInts(byte[] byArray, int n, int[] nArray, int n2, int n3) {
        int n4 = 0;
        while (n4 < n3) {
            int n5 = n + (n4 << 2);
            nArray[n2 + n4] = (byArray[n5++] & 0xFF) << 24 | (byArray[n5++] & 0xFF) << 16 | (byArray[n5++] & 0xFF) << 8 | byArray[n5] & 0xFF;
            ++n4;
        }
    }

    public static void spreadShortsToBytesLE(int[] nArray, int n, byte[] byArray, int n2, int n3) {
        int n4 = 0;
        while (n4 < n3) {
            byArray[n2 + (n4 << 1) + 1] = (byte)(nArray[n + n4] >>> 8);
            byArray[n2 + (n4 << 1)] = (byte)nArray[n + n4];
            ++n4;
        }
    }

    public static void spreadShortsToBytesBE(int[] nArray, int n, byte[] byArray, int n2, int n3) {
        int n4 = 0;
        while (n4 < n3) {
            byArray[n2 + (n4 << 1)] = (byte)(nArray[n + n4] >>> 8);
            byArray[n2 + (n4 << 1) + 1] = (byte)nArray[n + n4];
            ++n4;
        }
    }

    public static void spreadIntsToBytesLE(int[] nArray, int n, byte[] byArray, int n2, int n3) {
        int n4 = 0;
        while (n4 < n3) {
            int n5 = n2 + (n4 << 2);
            int n6 = n + n4;
            byArray[n5++] = (byte)nArray[n6];
            byArray[n5++] = (byte)(nArray[n6] >>> 8);
            byArray[n5++] = (byte)(nArray[n6] >>> 16);
            byArray[n5] = (byte)(nArray[n6] >>> 24);
            ++n4;
        }
    }

    public static void spreadIntsToBytes(int[] nArray, int n, byte[] byArray, int n2, int n3) {
        int n4 = 0;
        while (n4 < n3) {
            int n5 = n2 + (n4 << 2);
            int n6 = n + n4;
            byArray[n5++] = (byte)(nArray[n6] >>> 24);
            byArray[n5++] = (byte)(nArray[n6] >>> 16);
            byArray[n5++] = (byte)(nArray[n6] >>> 8);
            byArray[n5] = (byte)nArray[n6];
            ++n4;
        }
    }

    public static void reverseArray(byte[] byArray, int n, int n2) {
        if (byArray != null && byArray.length > 0) {
            int n3 = n;
            while (n3 < n + n2 / 2) {
                byte by = byArray[n3];
                int n4 = 2 * n + n2 - n3 - 1;
                byArray[n3] = byArray[n4];
                byArray[n4] = by;
                ++n3;
            }
        }
    }

    public static byte[] resizeArray(byte[] byArray, int n) {
        if (n < 0) {
            throw new NegativeArraySizeException("Invalid length: " + n);
        }
        byte[] byArray2 = new byte[n];
        System.arraycopy(byArray, 0, byArray2, 0, Math.min(n, byArray.length));
        return byArray2;
    }

    public static void randomBlock(byte[] byArray, int n, int n2) {
        int n3 = n;
        while (n3 < n + n2) {
            byArray[n3] = (byte)(Math.random() * 256.0);
            ++n3;
        }
    }

    public static void randomBlock(byte[] byArray) {
        CryptoUtils.randomBlock(byArray, 0, byArray.length);
    }

    public static byte[] increment(byte[] byArray) {
        int n = byArray.length - 1;
        while (n >= 0) {
            int n2 = n--;
            byArray[n2] = (byte)(byArray[n2] + 1);
            if (byArray[n2] == 0) continue;
        }
        return byArray;
    }

    public static BigInteger getStrongPrime(int n, Random random) {
        return NumberTheory.getStrongPrime(n, random);
    }

    public static int gcd(int n, int n2) {
        return NumberTheory.gcd(n, n2);
    }

    public static void fillBlock(byte[] byArray, int n, byte by, int n2) {
        int n3 = n;
        while (n3 < n + n2) {
            byArray[n3] = by;
            ++n3;
        }
    }

    public static void fillBlock(byte[] byArray, byte by) {
        CryptoUtils.fillBlock(byArray, 0, by, byArray.length);
    }

    public static int[] extGcd(int n, int n2) {
        return NumberTheory.extGcd(n, n2);
    }

    public static boolean equalsBlock(byte[] byArray, byte[] byArray2) {
        if (byArray.length != byArray2.length) {
            return false;
        }
        return CryptoUtils.equalsBlock(byArray, 0, byArray2, 0, byArray.length);
    }

    public static boolean equalsBlock(byte[] byArray, int n, byte[] byArray2, int n2, int n3) {
        int n4 = 0;
        while (n4 < n3) {
            if (byArray[n + n4] != byArray2[n2 + n4]) {
                return false;
            }
            ++n4;
        }
        return true;
    }

    public static void copyBlock(long[] lArray, long[] lArray2) {
        int n = lArray.length;
        int n2 = 0;
        while (n2 < n) {
            lArray2[n2] = lArray[n2];
            ++n2;
        }
    }

    public static void copyBlock(long[] lArray, int n, long[] lArray2, int n2, int n3) {
        int n4 = 0;
        while (n4 < n3) {
            lArray2[n2 + n4] = lArray[n + n4];
            ++n4;
        }
    }

    public static void copyBlock(int[] nArray, int[] nArray2) {
        int n = nArray.length;
        int n2 = 0;
        while (n2 < n) {
            nArray2[n2] = nArray[n2];
            ++n2;
        }
    }

    public static void copyBlock(int[] nArray, int n, int[] nArray2, int n2, int n3) {
        int n4 = 0;
        while (n4 < n3) {
            nArray2[n2 + n4] = nArray[n + n4];
            ++n4;
        }
    }

    public static void copyBlock(byte[] byArray, byte[] byArray2) {
        int n = byArray.length;
        int n2 = 0;
        while (n2 < n) {
            byArray2[n2] = byArray[n2];
            ++n2;
        }
    }

    public static void copyBlock(byte[] byArray, int n, byte[] byArray2, int n2, int n3) {
        int n4 = 0;
        while (n4 < n3) {
            byArray2[n2 + n4] = byArray[n + n4];
            ++n4;
        }
    }

    public static int compareBlock(byte[] byArray, byte[] byArray2) {
        int n = byArray.length < byArray2.length ? byArray.length : byArray2.length;
        int n2 = CryptoUtils.compareBlock(byArray, 0, byArray2, 0, n);
        if (n2 != -1) {
            return n2;
        }
        if (byArray.length != byArray2.length) {
            return n;
        }
        return -1;
    }

    public static int compareBlock(byte[] byArray, int n, byte[] byArray2, int n2, int n3) {
        int n4 = 0;
        while (n4 < n3) {
            if (byArray[n + n4] != byArray2[n2 + n4]) {
                return n4;
            }
            ++n4;
        }
        return -1;
    }

    private CryptoUtils() {
    }
}

