/*
 * Decompiled with CFR 0.152.
 */
package iaik.pkcs.pkcs12;

import iaik.asn1.ASN1Object;
import iaik.asn1.CON_SPEC;
import iaik.asn1.CodingException;
import iaik.asn1.OCTET_STRING;
import iaik.asn1.ObjectID;
import iaik.asn1.SEQUENCE;
import iaik.pkcs.pkcs12.SafeBag;
import iaik.x509.X509Certificate;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;

public class CertificateBag
extends SafeBag {
    ASN1Object b = ObjectID.x509Certificate;
    X509Certificate a;

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("Certificate type: " + this.a.getType() + "\n");
        stringBuffer.append(super.toString());
        return stringBuffer.toString();
    }

    public ASN1Object toASN1Object() throws CodingException {
        SEQUENCE sEQUENCE = new SEQUENCE();
        sEQUENCE.addComponent(this.b);
        try {
            OCTET_STRING oCTET_STRING = new OCTET_STRING(this.a.getEncoded());
            sEQUENCE.addComponent(new CON_SPEC(0, oCTET_STRING));
        }
        catch (CertificateEncodingException certificateEncodingException) {
            throw new CodingException("Error encoding certificate!");
        }
        return sEQUENCE;
    }

    public static X509Certificate[] getCertificates(CertificateBag[] certificateBagArray) {
        X509Certificate[] x509CertificateArray = new X509Certificate[certificateBagArray.length];
        int n = 0;
        while (n < certificateBagArray.length) {
            x509CertificateArray[n] = certificateBagArray[n].getCertificate();
            ++n;
        }
        return x509CertificateArray;
    }

    public X509Certificate getCertificate() {
        return this.a;
    }

    public void decode(ASN1Object aSN1Object) throws CodingException {
        this.b = aSN1Object.getComponentAt(0);
        ASN1Object aSN1Object2 = (ASN1Object)aSN1Object.getComponentAt(1).getValue();
        try {
            this.a = new X509Certificate((byte[])aSN1Object2.getValue());
            return;
        }
        catch (CertificateException certificateException) {
            throw new CodingException("Error decoding certifcate!");
        }
    }

    public CertificateBag(X509Certificate x509Certificate, String string, byte[] byArray) {
        super(string, byArray);
        this.a = x509Certificate;
        ((SafeBag)this).b = ObjectID.pkcs12_certBag;
    }

    public CertificateBag(X509Certificate x509Certificate) {
        this.a = x509Certificate;
        ((SafeBag)this).b = ObjectID.pkcs12_certBag;
    }

    protected CertificateBag() {
        ((SafeBag)this).b = ObjectID.pkcs12_certBag;
    }
}

