/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sql.trace;

import com.sap.sql.trace.Constants;
import com.sap.tc.logging.Location;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;

public class SQLTraceParser
extends Constants {
    private static final Location TRACE = Location.getLocation((String)"com.sap.sql.trace.SQLTraceParser");
    protected static final Map elements = new HashMap();
    protected static final Map elementsIgnore;

    public static Map parseFromString(String inRecord) {
        ArrayList<String> tokens = new ArrayList<String>();
        HashMap res = new HashMap();
        StringTokenizer st = new StringTokenizer(inRecord, "<>");
        while (st.hasMoreTokens()) {
            String line = st.nextToken();
            if ("".equals(line = line.trim())) continue;
            tokens.add(line);
        }
        SQLTraceParser.populateTraceRecord(tokens, res);
        return res;
    }

    public static Map getElements() {
        return elements;
    }

    public static Map getElementsToIgnore() {
        return elementsIgnore;
    }

    protected static void populateTraceRecord(List tokens, Map res) {
        String contents = null;
        int i = 0;
        while (i < tokens.size()) {
            block1: {
                String tag;
                block4: {
                    String tok1;
                    block2: {
                        block5: {
                            String tok2;
                            block3: {
                                tok1 = (String)tokens.get(i);
                                if (elementsIgnore.containsKey(tok1) || tok1.startsWith("/") && elementsIgnore.containsKey(tok1.substring(1))) break block1;
                                if (!elements.containsKey(tok1)) break block2;
                                tok2 = (String)tokens.get(i + 1);
                                if (!tok2.equals("/" + tok1)) break block3;
                                tag = tok1;
                                contents = " ";
                                ++i;
                                break block4;
                            }
                            tok2 = (String)tokens.get(i + 2);
                            if (!tok2.equals("/" + tok1)) break block5;
                            tag = tok1;
                            contents = (String)tokens.get(i + 1);
                            i += 2;
                            break block4;
                        }
                        TRACE.infoT("No end tag found for token " + tok1);
                        break block1;
                    }
                    TRACE.infoT("Unknown token " + tok1);
                    break block1;
                }
                SQLTraceParser.doPopulate(res, tag, contents);
            }
            ++i;
        }
    }

    protected static void doPopulate(Map res, String tag, String value) {
        int tagNr = (Integer)elements.get(tag);
        switch (tagNr) {
            case 7: {
                SQLTraceParser.appendToElement(res, tag, value);
                break;
            }
            case 11: {
                SQLTraceParser.appendToElement(res, tag, value);
                break;
            }
            case 37: {
                SQLTraceParser.appendToElement(res, tag, value);
                break;
            }
            case 8: {
                SQLTraceParser.appendToElement(res, tag, value);
                break;
            }
            default: {
                res.put(tag, value);
            }
        }
    }

    protected static void appendToElement(Map res, String tagName, String value) {
        List tmp = res.containsKey(tagName) ? (List)res.get(tagName) : new ArrayList();
        tmp.add(value);
        res.put(tagName, tmp);
    }

    static {
        elements.put("starttime", new Integer(0));
        elements.put("duration", new Integer(1));
        elements.put("dbid", new Integer(2));
        elements.put("location", new Integer(3));
        elements.put("msg-clear", new Integer(4));
        elements.put("result", new Integer(5));
        elements.put("param", new Integer(7));
        elements.put("in", new Integer(8));
        elements.put("line", new Integer(14));
        elements.put("generation_time", new Integer(13));
        elements.put("program", new Integer(12));
        elements.put("table", new Integer(11));
        elements.put("thread", new Integer(19));
        elements.put("rsid", new Integer(20));
        elements.put("pstmtid", new Integer(21));
        elements.put("errcode", new Integer(15));
        elements.put("sqlstate", new Integer(22));
        elements.put("id", new Integer(34));
        elements.put("vars_per_batch", new Integer(9));
        elements.put("dstmtid", new Integer(23));
        elements.put("pooledstmtid", new Integer(24));
        elements.put("physstmtid", new Integer(25));
        elements.put("dconnid", new Integer(26));
        elements.put("pooledconnid", new Integer(27));
        elements.put("logpooledconnid", new Integer(28));
        elements.put("physconnid", new Integer(29));
        elements.put("batchcalls", new Integer(30));
        elements.put("user", new Integer(31));
        elements.put("session", new Integer(32));
        elements.put("transaction", new Integer(33));
        elements.put("dsrtransaction", new Integer(35));
        elements.put("stmt", new Integer(37));
        elements.put("application", new Integer(39));
        elements.put("stacktrace", new Integer(40));
        elementsIgnore = new HashMap();
        elementsIgnore.put("log", new Integer(17));
        elementsIgnore.put("add_info", new Integer(18));
        elementsIgnore.put("record", new Integer(16));
        elementsIgnore.put("bindparams", new Integer(6));
        elementsIgnore.put("tables", new Integer(10));
        elementsIgnore.put("stmts", new Integer(38));
        elementsIgnore.put("inparams", new Integer(36));
    }
}

