/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sql.trace;

import com.sap.sql.trace.Format;
import com.sap.sql.trace.SQLParameters;
import com.sap.sql.trace.Utils;

public class BindParams
extends SQLParameters
implements Format {
    private int numberOfVarsPerAddBatch = 0;

    public void setBatch(int numberOfVarsPerAddBatch) {
        this.numberOfVarsPerAddBatch = numberOfVarsPerAddBatch;
    }

    public void clearParameters() {
        this.numberOfVarsPerAddBatch = 0;
        super.clearParameters();
    }

    public String toXML() {
        int startIndex = 1;
        String indent = "      ";
        int length = this.maxIndex - startIndex + 1;
        if (0 >= length) {
            return "";
        }
        StringBuffer sb = new StringBuffer();
        if (this.numberOfVarsPerAddBatch > 0 && this.numberOfVarsPerAddBatch < this.maxIndex) {
            indent = indent + "  ";
            sb.append("    <");
            sb.append("vars_per_batch");
            sb.append(">");
            sb.append(this.numberOfVarsPerAddBatch);
            sb.append("</");
            sb.append("vars_per_batch");
            sb.append(">");
            sb.append(Utils.EOL);
        }
        sb.append("    <");
        sb.append("bindparams");
        sb.append(">");
        sb.append(Utils.EOL);
        int i = 1;
        while (i <= this.maxIndex) {
            sb.append(indent);
            sb.append("<");
            sb.append("param");
            sb.append(">");
            if (this.params[i] == null) {
                sb.append("null");
            } else {
                sb.append(Utils.escape(this.params[i].toString()));
            }
            sb.append("</");
            sb.append("param");
            sb.append(">");
            sb.append(Utils.EOL);
            ++i;
        }
        sb.append("    </");
        sb.append("bindparams");
        sb.append(">");
        sb.append(Utils.EOL);
        return sb.toString();
    }
}

