/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sql.jdbc.stmtpool;

class DoubleLinkedList {
    private DoubleLinkable head = null;
    private DoubleLinkable tail = null;
    private int elemCnt = 0;

    public DoubleLinkedList() {
    }

    public DoubleLinkedList(DoubleLinkable[] links) {
        int i = 0;
        while (i < links.length) {
            this.addLast(links[i]);
            ++i;
        }
        this.elemCnt = links.length;
    }

    public boolean isEmpty() {
        return this.head == null;
    }

    public DoubleLinkable getFirst() {
        return this.head;
    }

    public DoubleLinkable getLast() {
        return this.tail;
    }

    public void addBefore(DoubleLinkable newLink, DoubleLinkable link) {
        DoubleLinkable previous = link.getPrevious();
        link.setPrevious(newLink);
        newLink.setNext(link);
        newLink.setPrevious(previous);
        if (previous != null) {
            previous.setNext(newLink);
        } else {
            this.head = newLink;
        }
        newLink.setMyList(this);
        ++this.elemCnt;
    }

    public void addAfter(DoubleLinkable newLink, DoubleLinkable link) {
        DoubleLinkable next = link.getNext();
        link.setNext(newLink);
        newLink.setNext(next);
        newLink.setPrevious(link);
        if (next != null) {
            next.setPrevious(newLink);
        } else {
            this.tail = newLink;
        }
        newLink.setMyList(this);
        ++this.elemCnt;
    }

    public void addFirst(DoubleLinkable link) {
        link.setPrevious(null);
        link.setNext(this.head);
        if (this.head != null) {
            this.head.setPrevious(link);
        }
        this.head = link;
        if (this.tail == null) {
            this.tail = link;
        }
        link.setMyList(this);
        ++this.elemCnt;
    }

    public void addLast(DoubleLinkable link) {
        link.setNext(null);
        link.setPrevious(this.tail);
        if (this.tail != null) {
            this.tail.setNext(link);
        }
        this.tail = link;
        if (this.head == null) {
            this.head = link;
        }
        link.setMyList(this);
        ++this.elemCnt;
    }

    public void remove(DoubleLinkable link) {
        if (this != link.getMyList()) {
            return;
        }
        DoubleLinkable previous = link.getPrevious();
        DoubleLinkable next = link.getNext();
        if (previous == null) {
            this.head = next;
        } else {
            previous.setNext(next);
        }
        if (next == null) {
            this.tail = previous;
        } else {
            next.setPrevious(previous);
        }
        link.setMyList(null);
        link.setPrevious(null);
        link.setNext(null);
        --this.elemCnt;
    }

    public int size() {
        return this.elemCnt;
    }

    public static interface DoubleLinkable {
        public void setNext(DoubleLinkable var1);

        public DoubleLinkable getNext();

        public void setPrevious(DoubleLinkable var1);

        public DoubleLinkable getPrevious();

        public void setMyList(DoubleLinkedList var1);

        public DoubleLinkedList getMyList();
    }
}

