/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sql.jdbc.direct;

import com.sap.sql.jdbc.ContextFactory;
import com.sap.sql.jdbc.XAResourceWrapper;
import com.sap.sql.jdbc.stmtpool.StatementPool;
import javax.transaction.xa.XAException;
import javax.transaction.xa.XAResource;
import javax.transaction.xa.Xid;

public class DirectXAResource
implements XAResource,
XAResourceWrapper {
    private XAResource wrappedXAResource;
    private ContextFactory factory;
    private StatementPool statementPool;

    DirectXAResource(XAResource xaResource, ContextFactory factory) {
        this.wrappedXAResource = xaResource;
        this.factory = factory;
        this.statementPool = factory.getConnectionContext().getStatementPool();
    }

    public void start(Xid xid, int flags) throws XAException {
        this.wrappedXAResource.start(xid, flags);
    }

    public void end(Xid xid, int flags) throws XAException {
        this.wrappedXAResource.end(xid, flags);
    }

    public int prepare(Xid xid) throws XAException {
        return this.wrappedXAResource.prepare(xid);
    }

    public void commit(Xid xid, boolean onePhase) throws XAException {
        if (this.statementPool != null) {
            this.statementPool.clear();
        }
        this.wrappedXAResource.commit(xid, onePhase);
    }

    public void rollback(Xid xid) throws XAException {
        if (this.statementPool != null) {
            this.statementPool.clear();
        }
        this.wrappedXAResource.rollback(xid);
    }

    public void forget(Xid xid) throws XAException {
        this.wrappedXAResource.forget(xid);
    }

    public Xid[] recover(int flag) throws XAException {
        return this.wrappedXAResource.recover(flag);
    }

    public boolean isSameRM(XAResource xares) throws XAException {
        XAResource xar = xares;
        while (xar instanceof XAResourceWrapper) {
            xar = ((XAResourceWrapper)((Object)xar)).getWrappedXAResource();
        }
        return this.wrappedXAResource.isSameRM(xar);
    }

    public boolean setTransactionTimeout(int seconds) throws XAException {
        return this.wrappedXAResource.setTransactionTimeout(seconds);
    }

    public int getTransactionTimeout() throws XAException {
        return this.wrappedXAResource.getTransactionTimeout();
    }

    public XAResource getWrappedXAResource() {
        return this.wrappedXAResource;
    }
}

