/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sql.jdbc.direct;

import com.sap.sql.jdbc.ConnectionContext;
import com.sap.sql.jdbc.ExtendedStatement;
import com.sap.sql.jdbc.direct.DirectConnection;
import com.sap.sql.jdbc.direct.DirectResultSet;
import com.sap.sql.log.Syslog;
import com.sap.sql.services.core.CoreServices;
import com.sap.sql.trace.Id;
import com.sap.sql.trace.SQLTracable;
import com.sap.sql.trace.SQLTrace;
import com.sap.sql.trace.SQLTracer;
import com.sap.sql.trace.TraceContext;
import com.sap.tc.logging.Location;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;

public class DirectStatement
implements ExtendedStatement,
SQLTracable {
    private static final Location TRACE = Location.getLocation((Class)(class$com$sap$sql$jdbc$direct$DirectStatement == null ? (class$com$sap$sql$jdbc$direct$DirectStatement = DirectStatement.class$("com.sap.sql.jdbc.direct.DirectStatement")) : class$com$sap$sql$jdbc$direct$DirectStatement));
    protected DirectConnection dConn;
    protected Statement stmt;
    protected SQLTracer trc;
    protected String sql;
    protected boolean isClosed = false;
    ResultSet resultSet = null;
    private int nrBatch = 0;
    static /* synthetic */ Class class$com$sap$sql$jdbc$direct$DirectStatement;

    DirectStatement(DirectConnection dConn, Statement stmt) {
        this.stmt = stmt;
        this.dConn = dConn;
    }

    public ResultSet executeQuery(String sql) throws SQLException {
        return this.executeQuery(sql, null);
    }

    public ResultSet executeQuery(String sql, TraceContext traceContext) throws SQLException {
        if (TRACE.bePath()) {
            TRACE.entering("executeQuery()");
        }
        try {
            this.validate();
            this.sql = sql;
            try {
                this.closeResultSet();
                if (SQLTrace.isOn()) {
                    SQLTracer sqlTrace = this.getSQLTracer();
                    sqlTrace.startTimer();
                    this.resultSet = new DirectResultSet(this.dConn, this, this.stmt.executeQuery(sql));
                    sqlTrace.stopTimer();
                    sqlTrace.setId(this.resultSet, "rsid");
                    sqlTrace.trace("executeQuery()", sql);
                } else {
                    this.resultSet = new DirectResultSet(this.dConn, this, this.stmt.executeQuery(sql));
                }
            }
            catch (SQLException e) {
                throw this.processSQLException(e, true, "executeQuery()", sql);
            }
            Object var5_5 = null;
        }
        catch (Throwable throwable) {
            Object var5_6 = null;
            if (TRACE.bePath()) {
                TRACE.exiting((Object)this.resultSet);
            }
            throw throwable;
        }
        if (TRACE.bePath()) {
            TRACE.exiting((Object)this.resultSet);
        }
        return this.resultSet;
    }

    public int executeUpdate(String sql) throws SQLException {
        return this.executeUpdate(sql, (TraceContext)null);
    }

    public int executeUpdate(String sql, TraceContext traceContext) throws SQLException {
        int rowCnt = 0;
        if (TRACE.bePath()) {
            TRACE.entering("executeUpdate(" + sql + ")");
        }
        this.sql = sql;
        try {
            this.validate();
            try {
                this.closeResultSet();
                if (SQLTrace.isOn()) {
                    SQLTracer sqlTrace = this.getSQLTracer();
                    sqlTrace.startTimer();
                    rowCnt = this.stmt.executeUpdate(sql);
                    sqlTrace.stopTimer();
                    sqlTrace.trace("executeUpdate()", sql, "" + rowCnt);
                } else {
                    rowCnt = this.stmt.executeUpdate(sql);
                }
            }
            catch (SQLException e) {
                throw this.processSQLException(e, true, "executeUpdate()", sql);
            }
            Object var6_6 = null;
        }
        catch (Throwable throwable) {
            Object var6_7 = null;
            if (TRACE.bePath()) {
                TRACE.exiting((Object)new Integer(rowCnt));
            }
            throw throwable;
        }
        if (TRACE.bePath()) {
            TRACE.exiting((Object)new Integer(rowCnt));
        }
        return rowCnt;
    }

    public void close() throws SQLException {
        this.close(true);
    }

    public int getMaxFieldSize() throws SQLException {
        this.validate();
        try {
            return this.stmt.getMaxFieldSize();
        }
        catch (SQLException e) {
            throw this.processSQLException(e);
        }
    }

    public void setMaxFieldSize(int max) throws SQLException {
        if (TRACE.bePath()) {
            TRACE.entering("setMaxFieldSize(" + max + ")");
        }
        try {
            this.validate();
            try {
                this.stmt.setMaxFieldSize(max);
            }
            catch (SQLException e) {
                throw this.processSQLException(e);
            }
            Object var4_3 = null;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            if (TRACE.bePath()) {
                TRACE.exiting();
            }
            throw throwable;
        }
        if (TRACE.bePath()) {
            TRACE.exiting();
        }
    }

    public int getMaxRows() throws SQLException {
        this.validate();
        try {
            return this.stmt.getMaxRows();
        }
        catch (SQLException e) {
            throw this.processSQLException(e);
        }
    }

    public void setMaxRows(int max) throws SQLException {
        if (TRACE.bePath()) {
            TRACE.entering("setMaxRows(" + max + ")");
        }
        try {
            this.validate();
            try {
                this.stmt.setMaxRows(max);
            }
            catch (SQLException e) {
                throw this.processSQLException(e);
            }
            Object var4_3 = null;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            if (TRACE.bePath()) {
                TRACE.exiting();
            }
            throw throwable;
        }
        if (TRACE.bePath()) {
            TRACE.exiting();
        }
    }

    public void setEscapeProcessing(boolean enable) throws SQLException {
        if (TRACE.bePath()) {
            TRACE.entering("setEscapeProcessing(" + enable + ")");
        }
        try {
            this.validate();
            try {
                this.stmt.setEscapeProcessing(enable);
            }
            catch (SQLException e) {
                throw this.processSQLException(e);
            }
            Object var4_3 = null;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            if (TRACE.bePath()) {
                TRACE.exiting();
            }
            throw throwable;
        }
        if (TRACE.bePath()) {
            TRACE.exiting();
        }
    }

    public int getQueryTimeout() throws SQLException {
        this.validate();
        try {
            return this.stmt.getQueryTimeout();
        }
        catch (SQLException e) {
            throw this.processSQLException(e);
        }
    }

    public void setQueryTimeout(int seconds) throws SQLException {
        if (TRACE.bePath()) {
            TRACE.entering("setQueryTimeout(" + seconds + ")");
        }
        try {
            this.validate();
            try {
                this.stmt.setQueryTimeout(seconds);
            }
            catch (SQLException e) {
                throw this.processSQLException(e);
            }
            Object var4_3 = null;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            if (TRACE.bePath()) {
                TRACE.exiting();
            }
            throw throwable;
        }
        if (TRACE.bePath()) {
            TRACE.exiting();
        }
    }

    public void cancel() throws SQLException {
        if (TRACE.bePath()) {
            TRACE.entering("cancel()");
        }
        try {
            this.validate();
            try {
                this.stmt.cancel();
            }
            catch (SQLException e) {
                throw this.processSQLException(e);
            }
            Object var3_2 = null;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            if (TRACE.bePath()) {
                TRACE.exiting();
            }
            throw throwable;
        }
        if (TRACE.bePath()) {
            TRACE.exiting();
        }
    }

    public SQLWarning getWarnings() throws SQLException {
        if (this.isClosed) {
            return null;
        }
        try {
            return this.stmt.getWarnings();
        }
        catch (SQLException e) {
            throw this.processSQLException(e);
        }
    }

    public void clearWarnings() throws SQLException {
        if (this.isClosed) {
            return;
        }
        try {
            this.stmt.clearWarnings();
        }
        catch (SQLException e) {
            throw this.processSQLException(e);
        }
    }

    public void setCursorName(String name) throws SQLException {
        if (TRACE.bePath()) {
            TRACE.entering("setCursorName(" + name + ")");
        }
        try {
            this.validate();
            try {
                this.stmt.setCursorName(name);
            }
            catch (SQLException e) {
                throw this.processSQLException(e);
            }
            Object var4_3 = null;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            if (TRACE.bePath()) {
                TRACE.exiting();
            }
            throw throwable;
        }
        if (TRACE.bePath()) {
            TRACE.exiting();
        }
    }

    public boolean execute(String sql, TraceContext traceContext) throws SQLException {
        return this.execute(sql);
    }

    public boolean execute(String sql) throws SQLException {
        boolean success = false;
        if (TRACE.bePath()) {
            TRACE.entering("execute(" + sql + ")");
        }
        try {
            this.validate();
            this.sql = sql;
            try {
                this.closeResultSet();
                if (SQLTrace.isOn()) {
                    SQLTracer sqlTrace = this.getSQLTracer();
                    sqlTrace.startTimer();
                    success = this.stmt.execute(sql);
                    sqlTrace.stopTimer();
                    sqlTrace.trace("execute()", sql, "" + success);
                } else {
                    success = this.stmt.execute(sql);
                }
            }
            catch (SQLException e) {
                throw this.processSQLException(e, true, "execute()", sql);
            }
            Object var5_5 = null;
        }
        catch (Throwable throwable) {
            Object var5_6 = null;
            if (TRACE.bePath()) {
                TRACE.exiting((Object)new Boolean(success));
            }
            throw throwable;
        }
        if (TRACE.bePath()) {
            TRACE.exiting((Object)new Boolean(success));
        }
        return success;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public ResultSet getResultSet() throws SQLException {
        block10: {
            ResultSet resultSet;
            block9: {
                if (TRACE.bePath()) {
                    TRACE.entering("getResultSet()");
                }
                try {
                    this.validate();
                    if (this.resultSet != null) {
                        resultSet = this.resultSet;
                        Object var4_5 = null;
                        break block9;
                    }
                    try {
                        if (SQLTrace.isOn()) {
                            SQLTracer sqlTrace = this.getSQLTracer();
                            sqlTrace.startTimer();
                            ResultSet nrs = this.stmt.getResultSet();
                            sqlTrace.stopTimer();
                            if (nrs != null) {
                                this.resultSet = new DirectResultSet(this.dConn, this, nrs);
                                sqlTrace.setId(this.resultSet, "rsid");
                            }
                            sqlTrace.trace("getResultSet()", this.sql);
                            break block10;
                        }
                        ResultSet nrs = this.stmt.getResultSet();
                        if (nrs != null) {
                            this.resultSet = new DirectResultSet(this.dConn, this, nrs);
                        }
                        break block10;
                    }
                    catch (SQLException e) {
                        throw this.processSQLException(e, true, "getResultSet()", this.sql);
                    }
                }
                catch (Throwable throwable) {
                    Object var4_7 = null;
                    if (!TRACE.bePath()) throw throwable;
                    TRACE.exiting((Object)this.resultSet);
                    throw throwable;
                }
            }
            if (!TRACE.bePath()) return resultSet;
            TRACE.exiting((Object)this.resultSet);
            return resultSet;
        }
        Object var4_6 = null;
        if (!TRACE.bePath()) return this.resultSet;
        TRACE.exiting((Object)this.resultSet);
        return this.resultSet;
    }

    public int getUpdateCount() throws SQLException {
        this.validate();
        try {
            return this.stmt.getUpdateCount();
        }
        catch (SQLException e) {
            throw this.processSQLException(e);
        }
    }

    public boolean getMoreResults() throws SQLException {
        this.validate();
        try {
            this.closeResultSet();
            return this.stmt.getMoreResults();
        }
        catch (SQLException e) {
            throw this.processSQLException(e);
        }
    }

    public void setFetchDirection(int direction) throws SQLException {
        if (TRACE.bePath()) {
            TRACE.entering("setFetchDirection()");
        }
        try {
            this.validate();
            try {
                this.stmt.setFetchDirection(direction);
            }
            catch (SQLException e) {
                throw this.processSQLException(e);
            }
            Object var4_3 = null;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            if (TRACE.bePath()) {
                TRACE.exiting();
            }
            throw throwable;
        }
        if (TRACE.bePath()) {
            TRACE.exiting();
        }
    }

    public int getFetchDirection() throws SQLException {
        this.validate();
        try {
            return this.stmt.getFetchDirection();
        }
        catch (SQLException e) {
            throw this.processSQLException(e);
        }
    }

    public void setFetchSize(int rows) throws SQLException {
        if (TRACE.bePath()) {
            TRACE.entering("setFetchSize(" + rows + ")");
        }
        try {
            this.validate();
            try {
                this.stmt.setFetchSize(rows);
            }
            catch (SQLException e) {
                throw this.processSQLException(e);
            }
            Object var4_3 = null;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            if (TRACE.bePath()) {
                TRACE.exiting();
            }
            throw throwable;
        }
        if (TRACE.bePath()) {
            TRACE.exiting();
        }
    }

    public int getFetchSize() throws SQLException {
        this.validate();
        try {
            return this.stmt.getFetchSize();
        }
        catch (SQLException e) {
            throw this.processSQLException(e);
        }
    }

    public int getResultSetConcurrency() throws SQLException {
        this.validate();
        try {
            return this.stmt.getResultSetConcurrency();
        }
        catch (SQLException e) {
            throw this.processSQLException(e);
        }
    }

    public int getResultSetType() throws SQLException {
        this.validate();
        try {
            return this.stmt.getResultSetType();
        }
        catch (SQLException e) {
            throw this.processSQLException(e);
        }
    }

    public void addBatch(String sql) throws SQLException {
        if (TRACE.bePath()) {
            TRACE.entering("addBatch(" + sql + ")");
        }
        try {
            this.validate();
            this.sql = sql;
            ++this.nrBatch;
            try {
                if (SQLTrace.isOn()) {
                    SQLTracer sqlTrace = this.getSQLTracer();
                    sqlTrace.startTimer();
                    this.stmt.addBatch(sql);
                    sqlTrace.stopTimer();
                    sqlTrace.addAttribute("batchcalls", "" + this.nrBatch);
                    sqlTrace.trace("addBatch()", sql);
                } else {
                    this.stmt.addBatch(sql);
                }
            }
            catch (SQLException e) {
                throw this.processSQLException(e, true, "addBatch()", sql);
            }
            Object var4_4 = null;
        }
        catch (Throwable throwable) {
            Object var4_5 = null;
            if (TRACE.bePath()) {
                TRACE.exiting();
            }
            throw throwable;
        }
        if (TRACE.bePath()) {
            TRACE.exiting();
        }
    }

    public void clearBatch() throws SQLException {
        if (TRACE.bePath()) {
            TRACE.entering("clearBatch()");
        }
        try {
            this.validate();
            this.nrBatch = 0;
            try {
                if (SQLTrace.isOn()) {
                    SQLTracer sqlTrace = this.getSQLTracer();
                    sqlTrace.startTimer();
                    this.stmt.clearBatch();
                    sqlTrace.stopTimer();
                    sqlTrace.trace("clearBatch()");
                } else {
                    this.stmt.clearBatch();
                }
            }
            catch (SQLException e) {
                throw this.processSQLException(e, true, "clearBatch()", null);
            }
            Object var3_3 = null;
        }
        catch (Throwable throwable) {
            Object var3_4 = null;
            if (TRACE.bePath()) {
                TRACE.exiting();
            }
            throw throwable;
        }
        if (TRACE.bePath()) {
            TRACE.exiting();
        }
    }

    public int[] executeBatch() throws SQLException {
        int[] updateCounts = null;
        if (TRACE.bePath()) {
            TRACE.entering("executeBatch()");
        }
        try {
            this.validate();
            try {
                this.closeResultSet();
                if (SQLTrace.isOn()) {
                    SQLTracer sqlTrace = this.getSQLTracer();
                    sqlTrace.startTimer();
                    updateCounts = this.stmt.executeBatch();
                    sqlTrace.stopTimer();
                    StringBuffer sb = new StringBuffer();
                    int index = 0;
                    while (index < updateCounts.length) {
                        sb.append("" + updateCounts[index] + " ");
                        ++index;
                    }
                    sqlTrace.addAttribute("batchcalls", "" + this.nrBatch);
                    sqlTrace.trace("executeBatch()", "executeBatch()", sb.toString());
                } else {
                    updateCounts = this.stmt.executeBatch();
                }
            }
            catch (SQLException e) {
                throw this.processSQLException(e, true, "executeBatch()", null);
            }
            Object var6_6 = null;
            this.nrBatch = 0;
        }
        catch (Throwable throwable) {
            Object var6_7 = null;
            this.nrBatch = 0;
            if (TRACE.bePath()) {
                TRACE.exiting((Object)updateCounts);
            }
            throw throwable;
        }
        if (TRACE.bePath()) {
            TRACE.exiting((Object)updateCounts);
        }
        return updateCounts;
    }

    public Connection getConnection() throws SQLException {
        this.validate();
        throw Syslog.createUnsupportedMethodError(this, "getConnection()");
    }

    public void prepareResultSet(Object[] resultSetColumns) throws SQLException {
    }

    public String getDbIdForTrace() {
        return this.dConn.getDbIdForTrace();
    }

    public Id[] getIds() {
        return new Id[]{new Id(this, "dstmtid"), new Id(this.stmt, "physstmtid")};
    }

    public String getSQL() {
        return this.sql;
    }

    protected void validate() throws SQLException {
        if (this.isClosed) {
            throw Syslog.createAndLogOpenSQLException(this, "com.sap.sql_0005", new Object[]{this});
        }
    }

    protected void invalidate() {
        this.dConn = null;
        this.stmt = null;
        this.sql = null;
        this.trc = null;
    }

    protected SQLException processSQLException(SQLException e, boolean trace, String methodName, String sql) {
        if (trace && SQLTrace.isOn()) {
            SQLTracer sqlTrace = this.getSQLTracer();
            if (sql == null) {
                sql = methodName;
            }
            sqlTrace.traceException(e, methodName, sql);
        }
        ConnectionContext ctx = this.dConn.getConnectionContext();
        SQLException ex = e;
        if (!CoreServices.isDuplicateKeyException(ctx, e)) {
            ex = Syslog.logSQLException(this, e, ctx.getConnectionID(), sql);
        }
        this.dConn.analyzeSQLException(e);
        return ex;
    }

    protected SQLException processSQLException(SQLException e) {
        return this.processSQLException(e, false, null, null);
    }

    protected SQLException processSQLException(SQLException e, boolean trace, String sql) {
        return this.processSQLException(e, trace, null, sql);
    }

    protected SQLTracer getSQLTracer() {
        if (this.trc == null) {
            this.trc = new SQLTracer(this);
            return this.trc;
        }
        return this.trc;
    }

    protected void closeResultSet() {
        if (this.resultSet != null) {
            try {
                this.resultSet.close();
            }
            catch (SQLException ex) {
                this.processSQLException(ex, false, "close()");
            }
            this.resultSet = null;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    void close(boolean notify) throws SQLException {
        block14: {
            block13: {
                if (TRACE.bePath()) {
                    TRACE.entering("close()");
                }
                try {
                    try {
                        if (this.isClosed) {
                            Object var4_2 = null;
                            if (!this.isClosed && this.dConn.getConnectionContext().getState() == 0) {
                                this.invalidate();
                            }
                            this.isClosed = true;
                            break block13;
                        }
                        if (notify) {
                            this.dConn.statementClosed(this);
                        }
                        this.closeResultSet();
                        if (SQLTrace.isOn()) {
                            SQLTracer sqlTrace = this.getSQLTracer();
                            sqlTrace.startTimer();
                            this.stmt.close();
                            sqlTrace.stopTimer();
                            sqlTrace.trace("close()");
                            break block14;
                        } else {
                            this.stmt.close();
                        }
                        break block14;
                    }
                    catch (SQLException e) {
                        throw this.processSQLException(e, true, "close()", null);
                    }
                }
                catch (Throwable throwable) {
                    Object var4_4 = null;
                    if (!this.isClosed && this.dConn.getConnectionContext().getState() == 0) {
                        this.invalidate();
                    }
                    this.isClosed = true;
                    if (!TRACE.bePath()) throw throwable;
                    TRACE.exiting();
                    throw throwable;
                }
            }
            if (!TRACE.bePath()) return;
            TRACE.exiting();
            return;
        }
        Object var4_3 = null;
        if (!this.isClosed && this.dConn.getConnectionContext().getState() == 0) {
            this.invalidate();
        }
        this.isClosed = true;
        if (!TRACE.bePath()) return;
        TRACE.exiting();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

