/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sql.jdbc.direct;

import com.sap.exception.BaseRuntimeException;
import com.sap.sql.jdbc.ConnectionContext;
import com.sap.sql.jdbc.ContextFactory;
import com.sap.sql.jdbc.ExtendedPooledConnection;
import com.sap.sql.jdbc.direct.DirectConnection;
import com.sap.sql.jdbc.direct.DirectConnectionFactory;
import com.sap.sql.jdbc.direct.PhysicalConnection;
import com.sap.sql.jdbc.stmtpool.StatementPool;
import com.sap.sql.log.OpenSQLException;
import com.sap.sql.log.Syslog;
import com.sap.sql.trace.Id;
import com.sap.sql.trace.SQLTracable;
import com.sap.sql.trace.SQLTrace;
import com.sap.sql.trace.SQLTracer;
import com.sap.tc.logging.Location;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Collection;
import javax.sql.ConnectionEvent;
import javax.sql.ConnectionEventListener;
import javax.sql.PooledConnection;

public class DirectPooledConnection
implements ExtendedPooledConnection,
ConnectionEventListener,
PhysicalConnection,
SQLTracable {
    private static final Location TRACE = Location.getLocation((Class)(class$com$sap$sql$jdbc$direct$DirectPooledConnection == null ? (class$com$sap$sql$jdbc$direct$DirectPooledConnection = DirectPooledConnection.class$("com.sap.sql.jdbc.direct.DirectPooledConnection")) : class$com$sap$sql$jdbc$direct$DirectPooledConnection));
    private final ConnectionEvent closeEvent = new ConnectionEvent(this);
    private ContextFactory factory = null;
    private ConnectionContext connContext;
    private PooledConnection nativePooledConn = null;
    private Connection nativeConn = null;
    private DirectConnection logicalConn = null;
    private ArrayList listeners = new ArrayList(2);
    private StatementPool stmtPool = null;
    private SQLTracer trc = null;
    private int defaultTransactionIsolation = 0;
    private boolean isClosed = false;
    private boolean listenerNotifying = false;
    static /* synthetic */ Class class$com$sap$sql$jdbc$direct$DirectPooledConnection;

    DirectPooledConnection(ContextFactory factory) throws SQLException {
        this(null, factory);
    }

    DirectPooledConnection(PooledConnection pooledConnection, ContextFactory factory) throws SQLException {
        this.nativePooledConn = pooledConnection;
        this.factory = factory;
        this.connContext = factory.getConnectionContext();
        this.nativeConn = this.connContext.getWrappedConnection();
        this.stmtPool = this.connContext.getStatementPool();
        this.defaultTransactionIsolation = this.connContext.getTransactionIsolation();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void close() throws SQLException {
        block20: {
            block17: {
                block18: {
                    if (TRACE.bePath()) {
                        TRACE.entering("close()");
                    }
                    try {
                        if (this.isClosed) {
                            Object var4_1 = null;
                            if (this.isClosed || this.connContext.getState() != 0) break block17;
                            break block18;
                        }
                        if (this.logicalConn != null) {
                            try {
                                this.logicalConn.close();
                            }
                            catch (SQLException ex) {
                                // empty catch block
                            }
                        }
                        SQLException exception = null;
                        try {
                            if (SQLTrace.isOn()) {
                                SQLTracer sqlTrace = this.getSQLTracer();
                                sqlTrace.startTimer();
                                this.nativeConn.close();
                                sqlTrace.stopTimer();
                                sqlTrace.trace("close()");
                            } else {
                                this.nativeConn.close();
                            }
                        }
                        catch (SQLException ex) {
                            exception = Syslog.logSQLException(this, ex, this.connContext.getConnectionID());
                        }
                        if (this.nativePooledConn != null) {
                            try {
                                this.nativePooledConn.close();
                            }
                            catch (SQLException ex) {
                                exception = Syslog.logSQLException(this, ex, this.connContext.getConnectionID());
                            }
                        }
                        if (exception != null) {
                            throw exception;
                        }
                        break block20;
                    }
                    catch (Throwable throwable) {
                        Object var4_3 = null;
                        if (!this.isClosed && this.connContext.getState() == 0) {
                            DirectConnectionFactory.unregisterConnection(this);
                            ContextFactory.closeConnectionContext(this.connContext);
                            this.connContext = null;
                            this.factory = null;
                            this.listeners = null;
                            this.logicalConn = null;
                            this.nativeConn = null;
                            this.nativePooledConn = null;
                            this.stmtPool = null;
                            this.trc = null;
                        }
                        this.isClosed = true;
                        if (!TRACE.bePath()) throw throwable;
                        TRACE.exiting();
                        throw throwable;
                    }
                }
                DirectConnectionFactory.unregisterConnection(this);
                ContextFactory.closeConnectionContext(this.connContext);
                this.connContext = null;
                this.factory = null;
                this.listeners = null;
                this.logicalConn = null;
                this.nativeConn = null;
                this.nativePooledConn = null;
                this.stmtPool = null;
                this.trc = null;
            }
            this.isClosed = true;
            if (!TRACE.bePath()) return;
            TRACE.exiting();
            return;
        }
        Object var4_2 = null;
        if (!this.isClosed && this.connContext.getState() == 0) {
            DirectConnectionFactory.unregisterConnection(this);
            ContextFactory.closeConnectionContext(this.connContext);
            this.connContext = null;
            this.factory = null;
            this.listeners = null;
            this.logicalConn = null;
            this.nativeConn = null;
            this.nativePooledConn = null;
            this.stmtPool = null;
            this.trc = null;
        }
        this.isClosed = true;
        if (!TRACE.bePath()) return;
        TRACE.exiting();
    }

    public Connection getConnection() throws SQLException {
        if (TRACE.bePath()) {
            TRACE.entering("getConnection()");
        }
        try {
            this.validate();
            if (this.logicalConn != null) {
                try {
                    this.logicalConn.close();
                }
                catch (SQLException e) {
                    // empty catch block
                }
            }
            if (SQLTrace.isOn()) {
                SQLTracer sqlTrace = this.getSQLTracer();
                sqlTrace.startTimer();
                this.logicalConn = (DirectConnection)DirectConnectionFactory.createDirectConnectionHandle(this, this.factory);
                sqlTrace.stopTimer();
                sqlTrace.trace("getConnection()", new Id(this.logicalConn, "logpooledconnid"));
            } else {
                this.logicalConn = (DirectConnection)DirectConnectionFactory.createDirectConnectionHandle(this, this.factory);
            }
            this.logicalConn.setTransactionIsolation(this.defaultTransactionIsolation);
            Object var3_3 = null;
        }
        catch (Throwable throwable) {
            Object var3_4 = null;
            if (TRACE.bePath()) {
                TRACE.exiting();
            }
            throw throwable;
        }
        if (TRACE.bePath()) {
            TRACE.exiting();
        }
        return this.logicalConn;
    }

    public void addConnectionEventListener(ConnectionEventListener listener) {
        if (TRACE.bePath()) {
            TRACE.entering("addConnectionEventListener(ConnectionEventListener)", new Object[]{listener});
        }
        try {
            this.validateRTE();
            this.listeners.add(listener);
            Object var3_2 = null;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            if (TRACE.bePath()) {
                TRACE.exiting();
            }
            throw throwable;
        }
        if (TRACE.bePath()) {
            TRACE.exiting();
        }
    }

    public void removeConnectionEventListener(ConnectionEventListener listener) {
        if (TRACE.bePath()) {
            TRACE.entering("removeConnectionEventListener(ConnectionEventListener)", new Object[]{listener});
        }
        try {
            this.validateRTE();
            ((AbstractCollection)this.listeners).remove(listener);
            Object var3_2 = null;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            if (TRACE.bePath()) {
                TRACE.exiting();
            }
            throw throwable;
        }
        if (TRACE.bePath()) {
            TRACE.exiting();
        }
    }

    public void connectionHandleClosed() {
        if (TRACE.bePath()) {
            TRACE.entering("connectionHandleClosed()");
        }
        try {
            this.validateRTE();
            if (this.logicalConn != null) {
                this.logicalConn.closeStatements();
            }
            if (this.stmtPool != null) {
                this.stmtPool.connectionClosed();
            }
            Object var2_1 = null;
        }
        catch (Throwable throwable) {
            Object var2_2 = null;
            if (TRACE.bePath()) {
                TRACE.exiting();
            }
            throw throwable;
        }
        if (TRACE.bePath()) {
            TRACE.exiting();
        }
    }

    public void connectionClosed(ConnectionEvent event) {
        this.validateRTE();
    }

    public void connectionErrorOccurred(ConnectionEvent event) {
        this.validateRTE();
        this.connectionErrorOccurred(event.getSQLException());
    }

    public String getDbIdForTrace() {
        ConnectionContext conCtxt = this.factory.getConnectionContext();
        return conCtxt.getConnectionName() + "?" + conCtxt.getUserName();
    }

    public Id[] getIds() {
        return new Id[]{new Id(this, "pooledconnid"), new Id(this.nativeConn, "physconnid")};
    }

    public ConnectionContext getConnectionContext() {
        return this.factory.getConnectionContext();
    }

    public Collection getOpenStatements() {
        return this.logicalConn != null ? this.logicalConn.getOpenStatements() : new ArrayList(0);
    }

    void connectionClosed() {
        if (TRACE.bePath()) {
            TRACE.entering("connectionClosed()");
        }
        try {
            this.validateRTE();
            int i = 0;
            while (i < this.listeners.size()) {
                ((ConnectionEventListener)this.listeners.get(i)).connectionClosed(this.closeEvent);
                ++i;
            }
            if (this.stmtPool != null) {
                this.stmtPool.connectionClosed();
            }
            if (SQLTrace.isOn()) {
                SQLTracer sqlTrace = this.getSQLTracer();
                sqlTrace.startTimer();
                sqlTrace.stopTimer();
                sqlTrace.trace("connectionClosed()", new Id(this.logicalConn, "logpooledconnid"));
            }
            Object var4_3 = null;
            this.logicalConn = null;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            this.logicalConn = null;
            if (TRACE.bePath()) {
                TRACE.exiting();
            }
            throw throwable;
        }
        if (TRACE.bePath()) {
            TRACE.exiting();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    void connectionErrorOccurred(SQLException ex) {
        block9: {
            block8: {
                if (TRACE.bePath()) {
                    TRACE.entering("connectionErrorOccured(SQLException)", new Object[]{ex});
                }
                try {
                    this.validateRTE();
                    if (this.listenerNotifying) {
                        Object var4_2 = null;
                        this.listenerNotifying = false;
                        break block8;
                    }
                    if (this.logicalConn != null) {
                        this.logicalConn.getConnectionContext().setState(1);
                    } else {
                        this.connContext.setState(1);
                    }
                    this.listenerNotifying = true;
                    int i = 0;
                    while (true) {
                        if (i >= this.listeners.size()) {
                            break block9;
                        }
                        ((ConnectionEventListener)this.listeners.get(i)).connectionErrorOccurred(new ConnectionEvent(this, ex));
                        ++i;
                    }
                }
                catch (Throwable throwable) {
                    Object var4_4 = null;
                    this.listenerNotifying = false;
                    if (!TRACE.bePath()) throw throwable;
                    TRACE.exiting();
                    throw throwable;
                }
            }
            if (!TRACE.bePath()) return;
            TRACE.exiting();
            return;
        }
        Object var4_3 = null;
        this.listenerNotifying = false;
        if (!TRACE.bePath()) return;
        TRACE.exiting();
    }

    Connection getNativeConnection() {
        return this.nativeConn;
    }

    DirectConnection getDirectConnection() {
        return this.logicalConn;
    }

    StatementPool getStatementPool() {
        return this.stmtPool;
    }

    private SQLTracer getSQLTracer() {
        if (this.trc == null) {
            this.trc = new SQLTracer(this);
        }
        return this.trc;
    }

    private void validate() throws SQLException {
        if (this.isClosed) {
            throw Syslog.createAndLogOpenSQLException(this, "com.sap.sql_0004", new Object[]{this});
        }
    }

    private void validateRTE() {
        if (this.isClosed) {
            OpenSQLException ex = Syslog.createAndLogOpenSQLException(this, "com.sap.sql_0004", new Object[]{this});
            throw new BaseRuntimeException((Throwable)ex);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

