/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sql.jdbc.direct;

import com.sap.sql.jdbc.NativeConnectionFactory;
import com.sap.sql.jdbc.direct.DirectConnectionFactory;
import java.io.PrintWriter;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.Properties;
import javax.sql.ConnectionPoolDataSource;
import javax.sql.DataSource;
import javax.sql.PooledConnection;

public class DirectDataSource
implements DataSource,
ConnectionPoolDataSource {
    private String classname;
    private String url;
    private String user;
    private String password;
    private Properties info;

    public DirectDataSource(String url, String user, String password) {
        this(null, url, user, password);
    }

    public DirectDataSource(String classname, String url, String user, String password) {
        this.classname = classname;
        this.url = url;
        this.user = user;
        this.password = password;
        this.info = new Properties();
        this.info.setProperty("user", user);
        this.info.setProperty("password", password);
    }

    public Connection getConnection() throws SQLException {
        return this.getConnection(this.user, this.password);
    }

    public Connection getConnection(String user, String password) throws SQLException {
        Connection nativeConnection = NativeConnectionFactory.createNativeConnection(this.url, this.info);
        return DirectConnectionFactory.createDirectConnection(nativeConnection, null);
    }

    public PooledConnection getPooledConnection() throws SQLException {
        return this.getPooledConnection(this.user, this.password);
    }

    public PooledConnection getPooledConnection(String user, String password) throws SQLException {
        Connection nativeConnection = NativeConnectionFactory.createNativeConnection(this.url, this.info);
        return DirectConnectionFactory.createDirectPooledConnection(nativeConnection, null);
    }

    public int getLoginTimeout() throws SQLException {
        return DriverManager.getLoginTimeout();
    }

    public PrintWriter getLogWriter() throws SQLException {
        return DriverManager.getLogWriter();
    }

    public void setLoginTimeout(int seconds) throws SQLException {
        DriverManager.setLoginTimeout(seconds);
    }

    public void setLogWriter(PrintWriter out) throws SQLException {
        DriverManager.setLogWriter(out);
    }
}

