/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sql.jdbc;

import com.sap.sql.jdbc.ConfigurationManager;
import com.sap.sql.jdbc.ConnectionContext;
import com.sap.sql.jdbc.DataSourceContext;
import com.sap.sql.jdbc.basic.BasicDbPortingServices;
import com.sap.sql.jdbc.basic.SQLExceptionAnalyzer;
import com.sap.sql.jdbc.stmtpool.StatementPool;
import com.sap.sql.log.Syslog;
import com.sap.sql.trace.SQLTrace;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Vector;

public class ContextFactory {
    protected static final String SEPARATOR = "?";
    private static final String defaultFile = "com/sap/sql/jdbc/jdbi.properties";
    private static final String localFile = "jdbilocal.properties";
    private static Properties defaultProperties = null;
    private static List dataSourceNames = new Vector();
    private static Properties generalProperties = null;
    private static Map schemaProperties = new Hashtable();
    private static Map dataSourceProperties = new Hashtable();
    private static ConfigurationManager confManager = null;
    protected ConnectionContextImpl context;
    protected ConnectionContextImpl cloneContext;
    static /* synthetic */ Class class$com$sap$sql$jdbc$ContextFactory;

    public ConnectionContext createConnectionContext(DataSourceContext dataSourceContext) {
        this.context = this.cloneContext = new ConnectionContextImpl(dataSourceContext);
        return this.cloneContext;
    }

    public ConnectionContext createConnectionContextClone() {
        this.context = new ConnectionContextImpl(this.cloneContext);
        return this.context;
    }

    public ConnectionContext getConnectionContext() {
        return this.context;
    }

    public static void closeConnectionContext(ConnectionContext context) {
        ConnectionContextImpl ctx = (ConnectionContextImpl)context;
        ctx.connection = null;
        ctx.wrappedConnection = null;
        ctx.connectionID = null;
        ctx.userName = null;
        ctx.statementPool = null;
        ctx.dbPortingServices = null;
        ctx.sqlExceptionAnalyzer = null;
        ctx.properties = null;
        ctx.parent = null;
        ctx.dataSourceContext = null;
    }

    public static DataSourceContext createDataSourceContext(String dataSourceName, String serverName, String databaseName, String userName, int vendorID, String vendorName, int sqlType) {
        return new DataSourceContextImpl(dataSourceName, serverName, databaseName, userName, vendorID, vendorName, sqlType);
    }

    public void setConnection(Connection connection) {
        this.context.connection = connection;
    }

    public void setWrappedConnection(Connection wrappedConnection) {
        this.context.wrappedConnection = wrappedConnection;
    }

    public void setConnectionID(String connectionID) {
        this.context.connectionID = connectionID;
    }

    public void setUserName(String userName) {
        this.context.userName = userName;
    }

    public void setStatementPool(StatementPool statementPool) {
        this.context.statementPool = statementPool;
    }

    public void setDbPortingServices(BasicDbPortingServices dbPortingServices) {
        this.context.dbPortingServices = dbPortingServices;
    }

    public void setSQLExceptionAnalyzer(SQLExceptionAnalyzer sqlExceptionAnalyzer) {
        this.context.sqlExceptionAnalyzer = sqlExceptionAnalyzer;
    }

    public void setProperties(Properties properties) {
        this.context.properties = properties;
    }

    public void setAutoCommit(boolean autoCommit) {
        this.context.autoCommit = autoCommit;
    }

    public void setTransactionIsolation(int level) {
        this.context.transactionIsolation = level;
    }

    public static void setConfigurationManager(ConfigurationManager manager) {
        confManager = manager;
    }

    public static void addDataSource(String dataSourceName) {
        dataSourceNames.add(dataSourceName);
    }

    public static synchronized void setGeneralProperties(Properties properties) throws SQLException {
        generalProperties = (Properties)((Hashtable)ContextFactory.getDefaultProperties()).clone();
        if (properties != null) {
            ((Hashtable)generalProperties).putAll(properties);
            SQLTrace.setDefaultsFromProperties(generalProperties);
        }
    }

    public static synchronized Properties setSchemaProperties(String schemaName, Properties properties) throws SQLException {
        Properties props = generalProperties != null ? generalProperties : ContextFactory.getDefaultProperties();
        Properties newProps = (Properties)((Hashtable)props).clone();
        if (properties != null) {
            ((Hashtable)newProps).putAll(properties);
            schemaProperties.put(schemaName, newProps);
        }
        return newProps;
    }

    public static synchronized Properties setDataSourceProperties(String schemaName, String dataSourceName, Properties properties) throws SQLException {
        Properties props = (Properties)schemaProperties.get(schemaName);
        if (props == null) {
            props = generalProperties != null ? generalProperties : ContextFactory.getDefaultProperties();
        }
        Properties newProps = (Properties)((Hashtable)props).clone();
        if (properties != null) {
            ((Hashtable)newProps).putAll(properties);
            dataSourceProperties.put(schemaName + "@@@" + dataSourceName, newProps);
        }
        return newProps;
    }

    public static Properties mergeProperties(Properties properties) throws SQLException {
        Properties props = (Properties)((Hashtable)ContextFactory.getDefaultProperties()).clone();
        if (properties != null) {
            ((Hashtable)props).putAll(properties);
        }
        return props;
    }

    public static Properties mergeProperties(String schemaName, String dataSourceName, Properties properties) throws SQLException {
        Properties props;
        if (confManager == null || !ContextFactory.isRegisteredDataSource(dataSourceName)) {
            props = ContextFactory.getDefaultProperties();
        } else {
            props = (Properties)dataSourceProperties.get(schemaName + "@@@" + dataSourceName);
            if (props == null) {
                Properties p;
                props = (Properties)schemaProperties.get(schemaName);
                if (props == null) {
                    p = confManager.syncSchema(schemaName);
                    props = ContextFactory.setSchemaProperties(schemaName, p);
                }
                p = confManager.syncDataSource(schemaName, dataSourceName);
                props = ContextFactory.setDataSourceProperties(schemaName, dataSourceName, p);
            }
        }
        Properties clone = (Properties)((Hashtable)props).clone();
        if (properties != null) {
            ((Hashtable)clone).putAll(properties);
        }
        return clone;
    }

    private static boolean isRegisteredDataSource(String dataSourceName) {
        return dataSourceName != null && (dataSourceName.equalsIgnoreCase("SYSTEM") || dataSourceNames.contains(dataSourceName));
    }

    private static Properties getDefaultProperties() throws SQLException {
        if (defaultProperties == null) {
            ContextFactory.setDefaultProperties();
        }
        return defaultProperties;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static void setDefaultProperties() throws SQLException {
        defaultProperties = new Properties();
        InputStream in = (class$com$sap$sql$jdbc$ContextFactory == null ? (class$com$sap$sql$jdbc$ContextFactory = ContextFactory.class$("com.sap.sql.jdbc.ContextFactory")) : class$com$sap$sql$jdbc$ContextFactory).getClassLoader().getResourceAsStream(defaultFile);
        if (in == null) {
            throw Syslog.createAndLogOpenSQLException(class$com$sap$sql$jdbc$ContextFactory == null ? (class$com$sap$sql$jdbc$ContextFactory = ContextFactory.class$("com.sap.sql.jdbc.ContextFactory")) : class$com$sap$sql$jdbc$ContextFactory, "com.sap.sql_0009", new Object[]{defaultFile});
        }
        try {
            try {
                defaultProperties.load(in);
            }
            catch (IOException ex) {
                throw Syslog.createAndLogOpenSQLException(class$com$sap$sql$jdbc$ContextFactory == null ? (class$com$sap$sql$jdbc$ContextFactory = ContextFactory.class$("com.sap.sql.jdbc.ContextFactory")) : class$com$sap$sql$jdbc$ContextFactory, "com.sap.sql_0010", new Object[]{defaultFile}, (Throwable)ex);
            }
            Object var3_1 = null;
        }
        catch (Throwable throwable) {
            Object var3_2 = null;
            try {
                in.close();
                throw throwable;
            }
            catch (IOException ex) {
                throw Syslog.createAndLogOpenSQLException(class$com$sap$sql$jdbc$ContextFactory == null ? (class$com$sap$sql$jdbc$ContextFactory = ContextFactory.class$("com.sap.sql.jdbc.ContextFactory")) : class$com$sap$sql$jdbc$ContextFactory, "com.sap.sql_0010", new Object[]{defaultFile}, (Throwable)ex);
            }
        }
        try {}
        catch (IOException ex) {
            throw Syslog.createAndLogOpenSQLException(class$com$sap$sql$jdbc$ContextFactory == null ? (class$com$sap$sql$jdbc$ContextFactory = ContextFactory.class$("com.sap.sql.jdbc.ContextFactory")) : class$com$sap$sql$jdbc$ContextFactory, "com.sap.sql_0010", new Object[]{defaultFile}, (Throwable)ex);
        }
        in.close();
        ContextFactory.mergeLocalProperties();
        Iterator iter = ((Hashtable)defaultProperties).entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry entry = iter.next();
            entry.setValue(((String)entry.getValue()).trim());
        }
        return;
    }

    /*
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static void mergeLocalProperties() {
        InputStream in;
        block9: {
            in = null;
            in = (class$com$sap$sql$jdbc$ContextFactory == null ? (class$com$sap$sql$jdbc$ContextFactory = ContextFactory.class$("com.sap.sql.jdbc.ContextFactory")) : class$com$sap$sql$jdbc$ContextFactory).getClassLoader().getResourceAsStream(localFile);
            if (in == null) {
                in = new FileInputStream(localFile);
            }
            if (in == null) break block9;
            Properties props = new Properties();
            props.load(in);
            ((Hashtable)defaultProperties).putAll(props);
        }
        Object var3_3 = null;
        if (in == null) return;
        try {
            in.close();
            return;
        }
        catch (IOException ex2) {}
        return;
        {
            catch (IOException ex) {
                Object var3_4 = null;
                if (in == null) return;
                try {
                    in.close();
                    return;
                }
                catch (IOException ex2) {}
                return;
            }
        }
        catch (Throwable throwable) {
            Object var3_5 = null;
            if (in == null) throw throwable;
            try {
                in.close();
                throw throwable;
            }
            catch (IOException ex2) {
                // empty catch block
            }
            throw throwable;
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private static class DataSourceContextImpl
    implements DataSourceContext {
        private String dataSourceName;
        private String serverName;
        private String databaseName;
        private String userName;
        private int vendorID;
        private String vendorName;
        private int sqlType;

        protected DataSourceContextImpl(String dataSourceName, String serverName, String databaseName, String userName, int vendorID, String vendorName, int sqlType) {
            this.dataSourceName = dataSourceName;
            this.serverName = serverName;
            this.databaseName = databaseName;
            this.userName = userName;
            this.vendorID = vendorID;
            this.vendorName = vendorName;
            this.sqlType = sqlType;
        }

        public String getDataSourceName() {
            return this.dataSourceName;
        }

        public String getServerName() {
            return this.serverName;
        }

        public String getDatabaseName() {
            return this.databaseName;
        }

        public String getUserName() {
            return this.userName;
        }

        public int getVendorID() {
            return this.vendorID;
        }

        public String getVendorName() {
            return this.vendorName;
        }

        public int getSqlType() {
            return this.sqlType;
        }
    }

    protected static class ConnectionContextImpl
    implements ConnectionContext {
        private ConnectionContextImpl parent;
        private Connection connection;
        private Connection wrappedConnection;
        private boolean commonSQL;
        private String connectionID;
        private String userName;
        private StatementPool statementPool;
        private BasicDbPortingServices dbPortingServices;
        private SQLExceptionAnalyzer sqlExceptionAnalyzer;
        private Properties properties;
        private boolean autoCommit;
        private int transactionIsolation;
        private int state;
        private DataSourceContext dataSourceContext;

        protected ConnectionContextImpl(DataSourceContext dataSourceContext) {
            this.parent = null;
            this.commonSQL = false;
            this.state = 0;
            this.dataSourceContext = dataSourceContext;
        }

        protected ConnectionContextImpl(ConnectionContextImpl parent) {
            this.parent = parent;
            this.connection = parent.connection;
            this.wrappedConnection = parent.wrappedConnection;
            this.commonSQL = parent.commonSQL;
            this.connectionID = parent.connectionID;
            this.userName = parent.userName;
            this.statementPool = parent.statementPool;
            this.dbPortingServices = parent.dbPortingServices;
            this.sqlExceptionAnalyzer = parent.sqlExceptionAnalyzer;
            this.properties = parent.properties;
            this.autoCommit = parent.autoCommit;
            this.transactionIsolation = parent.transactionIsolation;
            this.state = parent.state;
            this.dataSourceContext = parent.dataSourceContext;
        }

        public Connection getConnection() {
            return this.connection;
        }

        public Connection getWrappedConnection() {
            return this.wrappedConnection;
        }

        public boolean isCommonSQL() {
            return this.commonSQL;
        }

        public String getConnectionID() {
            return this.connectionID;
        }

        public String getConnectionName() {
            return this.dataSourceContext.getDataSourceName();
        }

        public String getUserName() {
            return this.userName;
        }

        public int getVendorID() {
            return this.dataSourceContext.getVendorID();
        }

        public StatementPool getStatementPool() {
            return this.statementPool;
        }

        public BasicDbPortingServices getDbPortingServices() {
            return this.dbPortingServices;
        }

        public SQLExceptionAnalyzer getSQLExceptionAnalyzer() {
            return this.sqlExceptionAnalyzer;
        }

        public Properties getProperties() {
            return this.properties;
        }

        public boolean getAutoCommit() {
            return this.autoCommit;
        }

        public void setAutoCommit(boolean autoCommit) {
            this.autoCommit = autoCommit;
            if (this.parent != null) {
                this.parent.setAutoCommit(autoCommit);
            }
        }

        public int getTransactionIsolation() {
            return this.transactionIsolation;
        }

        public void setTransactionIsolation(int level) {
            this.transactionIsolation = level;
            if (this.parent != null) {
                this.parent.setTransactionIsolation(level);
            }
        }

        public int getState() {
            return this.state;
        }

        public void setState(int state) {
            this.state = state;
            if (this.parent != null) {
                this.parent.setState(state);
            }
        }

        public DataSourceContext getDataSourceContext() {
            return this.dataSourceContext;
        }

        protected void setCommonSQL(boolean commonSQL) {
            this.commonSQL = commonSQL;
            ((DataSourceContextImpl)this.dataSourceContext).sqlType = 1;
        }
    }
}

