/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sql.connect;

import com.sap.exception.standard.SAPIllegalArgumentException;
import java.util.Properties;

public class OpenSQLProperties {
    private static final String CONNECTION_NAME = "jndiName";
    private static final String VM_ID = "clusterId";
    private Properties connProps;
    private Properties newProps = null;

    OpenSQLProperties(Properties properties) {
        this.connProps = properties;
    }

    public boolean getTableBuffer() {
        return new Boolean(this.getProperty("com.sap.sql.tablebuffer.manager.active"));
    }

    public void setTableBuffer(boolean tableBuffer) {
        this.setProperty("com.sap.sql.tablebuffer.manager.active", new Boolean(tableBuffer).toString());
    }

    public boolean getSyncWriter() {
        return new Boolean(this.getProperty("com.sap.sql.sync.writer.active"));
    }

    public void setSyncWriter(boolean syncWriter) {
        this.setProperty("com.sap.sql.sync.writer.active", new Boolean(syncWriter).toString());
    }

    public boolean getSyncReader() {
        return new Boolean(this.getProperty("com.sap.sql.sync.reader.active"));
    }

    public void setSyncReader(boolean syncReader) {
        this.setProperty("com.sap.sql.sync.reader.active", new Boolean(syncReader).toString());
    }

    public boolean getSystemDataSource() {
        return new Boolean(this.getProperty("systemDataSource"));
    }

    public void setSystemDataSource(boolean systemDataSource) {
        this.setProperty("systemDataSource", new Boolean(systemDataSource).toString());
    }

    public String getConnectionName() {
        return this.getProperty(CONNECTION_NAME);
    }

    public void setConnectionName(String connectionName) {
        this.setProperty(CONNECTION_NAME, connectionName);
    }

    public String getVmId() {
        return this.getProperty(VM_ID);
    }

    public void setVmId(String vmId) {
        this.setProperty(VM_ID, vmId);
    }

    public String getProperty(String key) {
        if (key == null) {
            throw new SAPIllegalArgumentException("com.sap.exception.standard_0001", new Object[]{"key"});
        }
        return this.newProps != null ? this.newProps.getProperty(key, this.connProps.getProperty(key)) : this.connProps.getProperty(key);
    }

    public void setProperty(String key, String value) {
        if (key == null) {
            throw new SAPIllegalArgumentException("com.sap.exception.standard_0001", new Object[]{"key"});
        }
        if (value == null) {
            throw new SAPIllegalArgumentException("com.sap.exception.standard_0001", new Object[]{"value"});
        }
        if (this.newProps == null) {
            this.newProps = new Properties();
        }
        this.newProps.setProperty(key, value);
    }

    Properties getChangedProperties() {
        return this.newProps;
    }
}

