/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sql.connect;

import com.sap.exception.standard.SAPIllegalArgumentException;
import com.sap.security.core.server.secstorefs.SecStoreFSException;
import com.sap.sql.connect.CommonFactory;
import com.sap.sql.connect.CommonFactoryCore;
import com.sap.sql.connect.OpenSQLConnectInfo;
import com.sap.sql.connect.OpenSQLDataSource;
import com.sap.sql.connect.OpenSQLProperties;
import com.sap.sql.jdbc.ContextFactory;
import com.sap.sql.jdbc.NativeConnectionFactory;
import com.sap.sql.jdbc.VMContext;
import com.sap.sql.jdbc.direct.DirectConnectionFactory;
import com.sap.sql.log.Syslog;
import java.io.PrintWriter;
import java.lang.reflect.Method;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import javax.sql.ConnectionPoolDataSource;
import javax.sql.DataSource;
import javax.sql.PooledConnection;
import javax.sql.XAConnection;
import javax.sql.XADataSource;

public class OpenSQLDataSourceImpl
extends OpenSQLDataSource {
    private static final String FMT_SCHEMA = "jdbc://";
    private static final char FMT_DELIM_FIRST = '?';
    private static final char FMT_DELIM_PAIRS = '&';
    private static final char FMT_DELIM_KEY = '=';
    private static final char FMT_ESCAPE = '\\';
    private static final Class[] PARAM_STRING = new Class[]{class$java$lang$String == null ? (class$java$lang$String = OpenSQLDataSourceImpl.class$("java.lang.String")) : class$java$lang$String};
    private static final Class[] PARAM_INT = new Class[]{Integer.TYPE};
    private static final Class[] PARAM_SHORT = new Class[]{Short.TYPE};
    private static final Class[] PARAM_BOOLEAN = new Class[]{Boolean.TYPE};
    private static final Class[][] PARAM_LIST = new Class[][]{PARAM_STRING, PARAM_INT, PARAM_SHORT, PARAM_BOOLEAN};
    private static final String DB_NAME = "DatabaseName";
    private int dsType = -1;
    private String dsClassName;
    private Properties dsProps = new Properties();
    private String dsPropsString;
    private String dsName;
    private Object dataSource;
    private int connType = 1;
    private OpenSQLProperties openSqlProps = new OpenSQLProperties(ContextFactory.mergeProperties(null));
    private String driverClassName = null;
    private String driverUrl = null;
    private String driverUser = null;
    private String driverPassword = null;
    private static CommonFactory commonFactory = null;
    private static final String commonFactoryLibImpl = "com.sap.sql.connect.CommonFactoryLib";
    static /* synthetic */ Class class$java$lang$String;

    public OpenSQLDataSourceImpl() throws SQLException {
        if (commonFactory == null) {
            if (VMContext.isJ2EEServerActive()) {
                OpenSQLDataSourceImpl.setCommonFactory(CommonFactoryCore.getInstance());
            } else {
                try {
                    CommonFactory factory = (CommonFactory)Class.forName(commonFactoryLibImpl).getMethod("getInstance", null).invoke(null, null);
                    OpenSQLDataSourceImpl.setCommonFactory(factory);
                }
                catch (Exception ex) {
                    throw Syslog.createAndLogOpenSQLException(this, "com.sap.sql_0007", new Object[]{commonFactoryLibImpl}, (Throwable)ex);
                }
            }
        }
    }

    public static void setCommonFactory(CommonFactory factory) {
        commonFactory = factory;
    }

    public void setDataSourceProperties(String className, Properties properties) throws SQLException {
        if (className == null) {
            throw new SAPIllegalArgumentException("com.sap.exception.standard_0001", new Object[]{"className"});
        }
        if (properties == null) {
            throw new SAPIllegalArgumentException("com.sap.exception.standard_0001", new Object[]{"properties"});
        }
        this.dsClassName = className;
        this.dsProps = properties;
        this.convert2string(className, properties);
        this.createDataSource();
    }

    public void setDriverProperties(String driver, String url, String user, String password) throws SQLException {
        if (driver == null) {
            throw new SAPIllegalArgumentException("com.sap.exception.standard_0001", new Object[]{"driver"});
        }
        if (url == null) {
            throw new SAPIllegalArgumentException("com.sap.exception.standard_0001", new Object[]{"url"});
        }
        if (user == null) {
            throw new SAPIllegalArgumentException("com.sap.exception.standard_0001", new Object[]{"user"});
        }
        if (password == null) {
            throw new SAPIllegalArgumentException("com.sap.exception.standard_0001", new Object[]{"password"});
        }
        this.driverClassName = driver;
        this.driverUrl = url;
        this.driverUser = user;
        this.driverPassword = password;
        this.dsType = 4;
        this.dsProps = this.getDriverProperties(this.driverClassName, url, user, password);
        this.convert2string(this.driverClassName, url, user, password);
    }

    public String getDataSourceName() {
        return this.dsName;
    }

    public void setDataSourceName(String name) throws SQLException {
        this.setDataSourceName(name, null);
    }

    public void setDataSourceName(String name, String keyPhrase) throws SQLException {
        if (name == null) {
            throw new SAPIllegalArgumentException("com.sap.exception.standard_0001", new Object[]{"name"});
        }
        this.dsName = name;
        try {
            String info = OpenSQLConnectInfo.lookup(this.dsName, keyPhrase);
            this.setDataSourceProperties(info);
        }
        catch (SecStoreFSException ex) {
            throw Syslog.createAndLogOpenSQLException(this, "com.sap.sql.connect_1221", new Object[]{ex.getMessage()}, (Throwable)ex);
        }
    }

    public int getDataSourceType() {
        return this.dsType;
    }

    public int getConnectionType() {
        return this.connType;
    }

    public void setConnectionType(int type) {
        this.connType = type;
    }

    public OpenSQLProperties getOpenSQLProperties() {
        return this.openSqlProps;
    }

    String getDataSourceClassName() {
        return this.dsType == 4 ? this.driverClassName : this.dsClassName;
    }

    Properties getDataSourceProperties() {
        return this.dsProps;
    }

    protected void setDataSourceProperties(String properties) throws SQLException {
        this.dsPropsString = properties;
        this.convert2properties(properties);
        if (this.dsType == 0) {
            this.createDataSource();
        }
    }

    String getDataSourcePropertiesString() {
        return this.dsPropsString;
    }

    public Connection getConnection() throws SQLException {
        return this.createConnection(null, null);
    }

    public Connection getConnection(String username, String password) throws SQLException {
        return this.createConnection(username, password);
    }

    public PooledConnection getPooledConnection() throws SQLException {
        return this.createPooledConnection(null, null);
    }

    public PooledConnection getPooledConnection(String username, String password) throws SQLException {
        return this.createPooledConnection(username, password);
    }

    public XAConnection getXAConnection() throws SQLException {
        return this.createXAConnection(null, null);
    }

    public XAConnection getXAConnection(String username, String password) throws SQLException {
        return this.createXAConnection(username, password);
    }

    public int getLoginTimeout() throws SQLException {
        switch (this.dsType) {
            case 1: {
                return ((DataSource)this.dataSource).getLoginTimeout();
            }
            case 2: {
                return ((ConnectionPoolDataSource)this.dataSource).getLoginTimeout();
            }
            case 3: {
                return ((XADataSource)this.dataSource).getLoginTimeout();
            }
            case 4: {
                return DriverManager.getLoginTimeout();
            }
        }
        throw Syslog.createAndLogOpenSQLException(this, "com.sap.sql.connect_1222", new Object[]{new Integer(this.dsType)});
    }

    public void setLoginTimeout(int seconds) throws SQLException {
        switch (this.dsType) {
            case 1: {
                ((DataSource)this.dataSource).setLoginTimeout(seconds);
                break;
            }
            case 2: {
                ((ConnectionPoolDataSource)this.dataSource).setLoginTimeout(seconds);
                break;
            }
            case 3: {
                ((XADataSource)this.dataSource).setLoginTimeout(seconds);
                break;
            }
            case 4: {
                DriverManager.setLoginTimeout(seconds);
                break;
            }
            default: {
                throw Syslog.createAndLogOpenSQLException(this, "com.sap.sql.connect_1222", new Object[]{new Integer(this.dsType)});
            }
        }
    }

    public PrintWriter getLogWriter() throws SQLException {
        switch (this.dsType) {
            case 1: {
                return ((DataSource)this.dataSource).getLogWriter();
            }
            case 2: {
                return ((ConnectionPoolDataSource)this.dataSource).getLogWriter();
            }
            case 3: {
                return ((XADataSource)this.dataSource).getLogWriter();
            }
            case 4: {
                return DriverManager.getLogWriter();
            }
        }
        throw Syslog.createAndLogOpenSQLException(this, "com.sap.sql.connect_1222", new Object[]{new Integer(this.dsType)});
    }

    public void setLogWriter(PrintWriter out) throws SQLException {
        switch (this.dsType) {
            case 1: {
                ((DataSource)this.dataSource).setLogWriter(out);
                break;
            }
            case 2: {
                ((ConnectionPoolDataSource)this.dataSource).setLogWriter(out);
                break;
            }
            case 3: {
                ((XADataSource)this.dataSource).setLogWriter(out);
                break;
            }
            case 4: {
                DriverManager.setLogWriter(out);
                break;
            }
            default: {
                throw Syslog.createAndLogOpenSQLException(this, "com.sap.sql.connect_1222", new Object[]{new Integer(this.dsType)});
            }
        }
    }

    private Properties getConnProperties() throws SQLException {
        return this.openSqlProps.getChangedProperties();
    }

    private Properties getDriverProperties(String driver, String url, String user, String password) {
        Properties props = new Properties();
        props.setProperty("ClassName", driver);
        props.setProperty("Url", url);
        props.setProperty("User", user);
        props.setProperty("Password", password);
        return props;
    }

    private void createDataSource() throws SQLException {
        Object factory;
        Class<?> clazz;
        try {
            clazz = Class.forName(this.dsClassName);
            factory = clazz.newInstance();
        }
        catch (ClassNotFoundException notFound) {
            throw Syslog.createAndLogOpenSQLException(this, "com.sap.sql_0006", new Object[]{this.dsClassName}, (Throwable)notFound);
        }
        catch (Exception ex) {
            throw Syslog.createAndLogOpenSQLException(this, "com.sap.sql_0007", new Object[]{this.dsClassName}, (Throwable)ex);
        }
        Enumeration enumeration = ((Hashtable)this.dsProps).keys();
        while (enumeration.hasMoreElements()) {
            String key = (String)enumeration.nextElement();
            String value = this.dsProps.getProperty(key);
            if (value == null || value.length() == 0) {
                throw Syslog.createAndLogOpenSQLException(this, "com.sap.sql_0014", new Object[]{"(set)" + key, value != null ? value : "null"});
            }
            Method method = null;
            int type = 0;
            while (type < PARAM_LIST.length) {
                try {
                    method = clazz.getMethod("set" + key, PARAM_LIST[type]);
                    break;
                }
                catch (Exception ex) {
                    ++type;
                }
            }
            if (method == null) {
                throw Syslog.createAndLogOpenSQLException(this, "com.sap.sql.connect_1223", new Object[]{"set" + key, this.dsClassName});
            }
            try {
                switch (type) {
                    case 0: {
                        method.invoke(factory, value);
                        break;
                    }
                    case 1: {
                        method.invoke(factory, new Integer(value));
                        break;
                    }
                    case 2: {
                        method.invoke(factory, new Short(value));
                        break;
                    }
                    case 3: {
                        method.invoke(factory, new Boolean(value));
                    }
                }
            }
            catch (Exception ex) {
                throw Syslog.createAndLogOpenSQLException(this, "com.sap.sql_0018", new Object[]{method.getName(), this.dsClassName}, (Throwable)ex);
            }
        }
        this.dataSource = factory;
        if (this.dataSource instanceof XADataSource) {
            this.dsType = 3;
        } else if (this.dataSource instanceof ConnectionPoolDataSource) {
            this.dsType = 2;
        } else if (this.dataSource instanceof DataSource) {
            this.dsType = 1;
        }
    }

    private Connection createConnection(String username, String password) throws SQLException {
        Connection conn;
        switch (this.dsType) {
            case 1: {
                if (username != null && password != null) {
                    conn = ((DataSource)this.dataSource).getConnection(username, password);
                    break;
                }
                conn = ((DataSource)this.dataSource).getConnection();
                break;
            }
            case 4: {
                if (username != null && password != null) {
                    conn = NativeConnectionFactory.createNativeConnection(this.driverClassName, this.driverUrl, username, password);
                    break;
                }
                conn = NativeConnectionFactory.createNativeConnection(this.driverClassName, this.driverUrl, this.driverUser, this.driverPassword);
                break;
            }
            default: {
                throw Syslog.createAndLogOpenSQLException(this, "com.sap.sql.connect_1224", new Object[]{"getConnection", new Integer(this.dsType)});
            }
        }
        switch (this.connType) {
            case 1: {
                return commonFactory.createCommonConnection(conn, this.getConnProperties());
            }
            case 2: {
                return DirectConnectionFactory.createDirectConnection(conn, this.getConnProperties());
            }
        }
        return conn;
    }

    private PooledConnection createPooledConnection(String username, String password) throws SQLException {
        switch (this.dsType) {
            case 2: {
                PooledConnection poolConn = username != null && password != null ? ((ConnectionPoolDataSource)this.dataSource).getPooledConnection(username, password) : ((ConnectionPoolDataSource)this.dataSource).getPooledConnection();
                switch (this.connType) {
                    case 1: {
                        return commonFactory.createCommonPooledConnection(poolConn, this.getConnProperties());
                    }
                    case 2: {
                        return DirectConnectionFactory.createDirectPooledConnection(poolConn, this.getConnProperties());
                    }
                }
                return poolConn;
            }
            case 1: {
                Connection conn = username != null && password != null ? ((DataSource)this.dataSource).getConnection(username, password) : ((DataSource)this.dataSource).getConnection();
                switch (this.connType) {
                    case 1: {
                        return commonFactory.createCommonPooledConnection(conn, this.getConnProperties());
                    }
                    case 2: {
                        return DirectConnectionFactory.createDirectPooledConnection(conn, this.getConnProperties());
                    }
                }
                throw Syslog.createAndLogOpenSQLException(this, "com.sap.sql.connect_1224", new Object[]{"getPooledConnection", new Integer(this.dsType)});
            }
            case 4: {
                Connection conn = username != null && password != null ? NativeConnectionFactory.createNativeConnection(this.driverClassName, this.driverUrl, username, password) : NativeConnectionFactory.createNativeConnection(this.driverClassName, this.driverUrl, this.driverUser, this.driverPassword);
                switch (this.connType) {
                    case 1: {
                        return commonFactory.createCommonPooledConnection(conn, this.getConnProperties());
                    }
                    case 2: {
                        return DirectConnectionFactory.createDirectPooledConnection(conn, this.getConnProperties());
                    }
                }
                throw Syslog.createAndLogOpenSQLException(this, "com.sap.sql.connect_1224", new Object[]{"getPooledConnection", new Integer(this.dsType)});
            }
        }
        throw Syslog.createAndLogOpenSQLException(this, "com.sap.sql.connect_1224", new Object[]{"getPooledConnection", new Integer(this.dsType)});
    }

    private XAConnection createXAConnection(String username, String password) throws SQLException {
        if (this.dsType != 3) {
            throw Syslog.createAndLogOpenSQLException(this, "com.sap.sql.connect_1224", new Object[]{"getXAConnection", new Integer(this.dsType)});
        }
        XAConnection conn = username != null && password != null ? ((XADataSource)this.dataSource).getXAConnection(username, password) : ((XADataSource)this.dataSource).getXAConnection();
        switch (this.connType) {
            case 1: {
                return commonFactory.createCommonXAConnection(conn, this.getConnProperties());
            }
            case 2: {
                return DirectConnectionFactory.createDirectXAConnection(conn, this.getConnProperties());
            }
        }
        return conn;
    }

    private void convert2properties(String properties) throws SQLException {
        if (properties == null || !properties.startsWith(FMT_SCHEMA)) {
            throw Syslog.createAndLogOpenSQLException(this, "com.sap.sql.connect_1225", new Object[]{"leading jdbc://expected"});
        }
        int stop = properties.length();
        int parsePos = FMT_SCHEMA.length();
        int parseState = 0;
        String keyToken = null;
        StringBuffer tokBuffer = new StringBuffer();
        do {
            char expectedDelim;
            char ch;
            block18: {
                tokBuffer.setLength(0);
                do {
                    if ((ch = properties.charAt(parsePos)) == '\\') {
                        if (++parsePos >= stop) {
                            throw Syslog.createAndLogOpenSQLException(this, "com.sap.sql.connect_1225", new Object[]{"trailing ESCAPE"});
                        }
                        ch = properties.charAt(parsePos);
                    } else if (ch == '?' || ch == '&' || ch == '=') break block18;
                    tokBuffer.append(ch);
                } while (++parsePos < stop);
                throw Syslog.createAndLogOpenSQLException(this, "com.sap.sql.connect_1225", new Object[]{"missing terminating delimiter"});
            }
            if (parseState != 2 && tokBuffer.length() == 0) {
                throw Syslog.createAndLogOpenSQLException(this, "com.sap.sql.connect_1225", new Object[]{"empty token, expecting " + (parseState == 0 ? "datasource type" : "property key")});
            }
            String token = tokBuffer.toString();
            if (parseState == 0) {
                expectedDelim = '?';
                if (token.equals("Driver")) {
                    this.dsType = 4;
                    this.dsClassName = null;
                } else {
                    this.dsType = 0;
                    this.dsClassName = token;
                    this.driverClassName = null;
                    this.driverUrl = null;
                    this.driverUser = null;
                    this.driverPassword = null;
                }
                ((Hashtable)this.dsProps).clear();
                parseState = 1;
            } else if (parseState == 1) {
                expectedDelim = '=';
                parseState = 2;
                keyToken = token;
            } else {
                expectedDelim = '&';
                parseState = 1;
                this.dsProps.setProperty(keyToken, token);
                keyToken = null;
            }
            if (ch == expectedDelim) continue;
            throw Syslog.createAndLogOpenSQLException(this, "com.sap.sql.connect_1225", new Object[]{"expected delimiter '" + expectedDelim + "', got '" + ch + "'"});
        } while (++parsePos < stop);
        if (this.dsType == 4) {
            this.driverClassName = this.dsProps.getProperty("ClassName");
            this.driverUrl = this.dsProps.getProperty("Url");
            this.driverUser = this.dsProps.getProperty("User");
            this.driverPassword = this.dsProps.getProperty("Password");
            if (this.driverClassName == null) {
                throw Syslog.createAndLogOpenSQLException(this, "com.sap.sql_0013", new Object[]{"ClassName"});
            }
            if (this.driverUrl == null) {
                throw Syslog.createAndLogOpenSQLException(this, "com.sap.sql_0013", new Object[]{"Url"});
            }
            if (this.driverUser == null) {
                throw Syslog.createAndLogOpenSQLException(this, "com.sap.sql_0013", new Object[]{"User"});
            }
            if (this.driverPassword == null) {
                throw Syslog.createAndLogOpenSQLException(this, "com.sap.sql_0013", new Object[]{"Password"});
            }
        }
    }

    private static StringBuffer encodeAppending(StringBuffer buffer, String text) {
        int textLength = text.length();
        buffer.ensureCapacity(buffer.capacity() + textLength);
        int i = 0;
        while (i < textLength) {
            char ch = text.charAt(i);
            if (ch == '\\' || ch == '?' || ch == '&' || ch == '=') {
                buffer.append('\\');
            }
            buffer.append(ch);
            ++i;
        }
        return buffer;
    }

    private void convert2string(String className, Properties properties) {
        StringBuffer buffer = new StringBuffer();
        buffer.append(FMT_SCHEMA);
        OpenSQLDataSourceImpl.encodeAppending(buffer, className).append('?');
        Enumeration enumeration = ((Hashtable)properties).keys();
        while (enumeration.hasMoreElements()) {
            String key = (String)enumeration.nextElement();
            OpenSQLDataSourceImpl.encodeAppending(buffer, key).append('=');
            OpenSQLDataSourceImpl.encodeAppending(buffer, properties.getProperty(key)).append('&');
        }
        this.dsPropsString = buffer.toString();
    }

    private void convert2string(String className, String url, String user, String password) {
        StringBuffer buffer = new StringBuffer();
        buffer.append(FMT_SCHEMA).append("Driver").append('?').append("ClassName").append('=');
        OpenSQLDataSourceImpl.encodeAppending(buffer, className).append('&').append("Url").append('=');
        OpenSQLDataSourceImpl.encodeAppending(buffer, url).append('&').append("User").append('=');
        OpenSQLDataSourceImpl.encodeAppending(buffer, user).append('&').append("Password").append('=');
        OpenSQLDataSourceImpl.encodeAppending(buffer, password).append('&');
        this.dsPropsString = buffer.toString();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

