/*
 * Decompiled with CFR 0.152.
 */
package com.sap.s2x.validation;

import com.sap.s2x.S2XTypes;
import com.sap.s2x.core.types.LangType;
import com.sap.s2x.core.types.RestypeValue;
import com.sap.s2x.validation.CodepageValidator;
import com.sap.s2x.validation.SchemaValidator;
import com.sap.s2x.validation.ValidationException;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.ResourceBundle;
import javax.xml.parsers.ParserConfigurationException;
import org.xml.sax.SAXException;

public class Validator {
    static ResourceBundle res = ResourceBundle.getBundle("com.sap.s2x.validation.ValidatorRes");
    private static Validator instance = null;
    private static SchemaValidator schemaValidator;
    private static CodepageValidator codepageValidator;
    S2XTypes s2xTypes;
    private boolean _useCodePageCheck;
    private boolean _codepageValidatorExists = false;

    private Validator(boolean pUseCodepageValidation) throws IOException, ParserConfigurationException, SAXException, ValidationException, ExceptionInInitializerError {
        this._useCodePageCheck = pUseCodepageValidation;
        schemaValidator = SchemaValidator.getInstance();
        if (pUseCodepageValidation) {
            this._codepageValidatorExists = true;
            codepageValidator = CodepageValidator.getInstance();
        }
        this.s2xTypes = S2XTypes.getInstance();
    }

    public static synchronized Validator getInstance(boolean pUseCodepageValidation) throws IOException, ParserConfigurationException, SAXException, ValidationException, ExceptionInInitializerError {
        if (instance == null) {
            instance = new Validator(pUseCodepageValidation);
        }
        return instance;
    }

    public boolean getUseCodePageCheck() {
        return this._useCodePageCheck;
    }

    public void setUseCodePageCheck(boolean pUseCodepageCheck) throws IOException, ValidationException, SAXException, ParserConfigurationException {
        this._useCodePageCheck = pUseCodepageCheck;
        if (!this._codepageValidatorExists && pUseCodepageCheck) {
            codepageValidator = CodepageValidator.getInstance();
        }
    }

    public String checkAgainstSchema(String constraintName, String data) {
        return schemaValidator.checkValidity(constraintName, data);
    }

    public String checkTextLength(String text, RestypeValue restype, int maxwidth, int maxLength) {
        StringBuffer errorMsg = new StringBuffer();
        if (maxLength > 255) {
            MessageFormat mf = new MessageFormat(res.getString("ymsg_MaxLengthTooLong"));
            Object[] obj = new Object[]{new Integer(maxLength), new Integer(255)};
            return mf.format(obj);
        }
        if (maxwidth > 0) {
            Object[] obj;
            MessageFormat mf;
            if (restype != null && restype.getSAPInternalValue().startsWith("X") && maxwidth > 255) {
                mf = new MessageFormat(res.getString("ymsg_XTextTooLong"));
                obj = new Object[]{new Integer(maxwidth), "maxwidth", new Integer(255)};
                if (errorMsg.length() > 0) {
                    errorMsg.append("\n");
                }
                errorMsg.append(mf.format(obj));
            }
            if (this.getTextLength(text) > maxwidth) {
                mf = new MessageFormat(res.getString("ymsg_TextLongerThanMaxwidth"));
                obj = new Object[]{text, new Integer(this.getTextLength(text)), new Integer(maxwidth)};
                if (errorMsg.length() > 0) {
                    errorMsg.append("\n");
                }
                errorMsg.append(mf.format(obj));
            }
        } else if (restype != null && restype.getSAPInternalValue().startsWith("X")) {
            if (this.getTextLength(text) > maxLength) {
                MessageFormat mf = new MessageFormat(res.getString("ymsg_XTextLongerThanDefault"));
                Object[] obj = new Object[]{text, new Integer(this.getTextLength(text)), new Integer(maxLength)};
                if (errorMsg.length() > 0) {
                    errorMsg.append("\n");
                }
                errorMsg.append(mf.format(obj));
            }
        } else if (this.getTextLength(text) > 16384) {
            MessageFormat mf = new MessageFormat(res.getString("ymsg_YTextLongerThanDefault"));
            Object[] obj = new Object[]{new Integer(this.getTextLength(text)), new Integer(16384)};
            if (errorMsg.length() > 0) {
                errorMsg.append("\n");
            }
            errorMsg.append(mf.format(obj));
        }
        return errorMsg.toString();
    }

    public String checkTextLength(String text, RestypeValue restype, int maxwidth) {
        StringBuffer errorMsg = new StringBuffer();
        if (maxwidth > 0) {
            Object[] obj;
            MessageFormat mf;
            if (restype != null && restype.getSAPInternalValue().startsWith("X") && maxwidth > 255) {
                mf = new MessageFormat(res.getString("ymsg_XTextTooLong"));
                obj = new Object[]{new Integer(maxwidth), "maxwidth", new Integer(255)};
                if (errorMsg.length() > 0) {
                    errorMsg.append("\n");
                }
                errorMsg.append(mf.format(obj));
            }
            if (this.getTextLength(text) > maxwidth) {
                mf = new MessageFormat(res.getString("ymsg_TextLongerThanMaxwidth"));
                obj = new Object[]{text, new Integer(this.getTextLength(text)), new Integer(maxwidth)};
                if (errorMsg.length() > 0) {
                    errorMsg.append("\n");
                }
                errorMsg.append(mf.format(obj));
            }
        } else if (restype != null && restype.getSAPInternalValue().startsWith("X")) {
            if (this.getTextLength(text) > 255) {
                MessageFormat mf = new MessageFormat(res.getString("ymsg_XTextLongerThanDefault"));
                Object[] obj = new Object[]{text, new Integer(this.getTextLength(text)), new Integer(255)};
                if (errorMsg.length() > 0) {
                    errorMsg.append("\n");
                }
                errorMsg.append(mf.format(obj));
            }
        } else if (this.getTextLength(text) > 16384) {
            MessageFormat mf = new MessageFormat(res.getString("ymsg_YTextLongerThanDefault"));
            Object[] obj = new Object[]{new Integer(this.getTextLength(text)), new Integer(16384)};
            if (errorMsg.length() > 0) {
                errorMsg.append("\n");
            }
            errorMsg.append(mf.format(obj));
        }
        return errorMsg.toString();
    }

    public String checkTextLength(String text, String restype, int maxwidth, int maxLength) {
        StringBuffer errorMsg = new StringBuffer();
        String error = this.checkAgainstSchema("restype", restype);
        if (!error.equals("")) {
            return error;
        }
        RestypeValue restypeValue = this.s2xTypes.getRestype(restype, "XLIFF");
        if (maxLength > 255) {
            MessageFormat mf = new MessageFormat(res.getString("ymsg_MaxLengthTooLong"));
            Object[] obj = new Object[]{new Integer(maxLength), new Integer(255)};
            return mf.format(obj);
        }
        if (maxwidth > 0) {
            Object[] obj;
            MessageFormat mf;
            if (restypeValue != null && restypeValue.getXLIFFValue().startsWith("X") && maxwidth > 255) {
                mf = new MessageFormat(res.getString("ymsg_XTextTooLong"));
                obj = new Object[]{new Integer(maxwidth), "maxwidth", new Integer(255)};
                if (errorMsg.length() > 0) {
                    errorMsg.append("\n");
                }
                errorMsg.append(mf.format(obj));
            }
            if (this.getTextLength(text) > maxwidth) {
                mf = new MessageFormat(res.getString("ymsg_TextLongerThanMaxwidth"));
                obj = new Object[]{text, new Integer(this.getTextLength(text)), new Integer(maxwidth)};
                if (errorMsg.length() > 0) {
                    errorMsg.append("\n");
                }
                errorMsg.append(mf.format(obj));
            }
        } else if (restypeValue != null && restypeValue.getSAPInternalValue().startsWith("X")) {
            if (this.getTextLength(text) > maxLength) {
                MessageFormat mf = new MessageFormat(res.getString("ymsg_XTextLongerThanDefault"));
                Object[] obj = new Object[]{text, new Integer(this.getTextLength(text)), new Integer(maxLength)};
                if (errorMsg.length() > 0) {
                    errorMsg.append("\n");
                }
                errorMsg.append(mf.format(obj));
            }
        } else if (this.getTextLength(text) > 16384) {
            MessageFormat mf = new MessageFormat(res.getString("ymsg_YTextLongerThanDefault"));
            Object[] obj = new Object[]{new Integer(this.getTextLength(text)), new Integer(16384)};
            if (errorMsg.length() > 0) {
                errorMsg.append("\n");
            }
            errorMsg.append(mf.format(obj));
        }
        return errorMsg.toString();
    }

    public String checkTextLength(String text, String restype, int maxwidth) {
        StringBuffer errorMsg = new StringBuffer();
        String error = this.checkAgainstSchema("restype", restype);
        if (!error.equals("")) {
            return error;
        }
        RestypeValue restypeValue = this.s2xTypes.getRestype(restype, "XLIFF");
        if (maxwidth > 0) {
            Object[] obj;
            MessageFormat mf;
            if (restypeValue != null && restypeValue.getSAPInternalValue().startsWith("X") && maxwidth > 255) {
                mf = new MessageFormat(res.getString("ymsg_XTextTooLong"));
                obj = new Object[]{new Integer(maxwidth), "maxwidth", new Integer(255)};
                if (errorMsg.length() > 0) {
                    errorMsg.append("\n");
                }
                errorMsg.append(mf.format(obj));
            }
            if (this.getTextLength(text) > maxwidth) {
                mf = new MessageFormat(res.getString("ymsg_TextLongerThanMaxwidth"));
                obj = new Object[]{text, new Integer(this.getTextLength(text)), new Integer(maxwidth)};
                if (errorMsg.length() > 0) {
                    errorMsg.append("\n");
                }
                errorMsg.append(mf.format(obj));
            }
        } else if (restypeValue != null && restypeValue.getSAPInternalValue().startsWith("X")) {
            if (this.getTextLength(text) > 255) {
                MessageFormat mf = new MessageFormat(res.getString("ymsg_XTextLongerThanDefault"));
                Object[] obj = new Object[]{text, new Integer(this.getTextLength(text)), new Integer(255)};
                if (errorMsg.length() > 0) {
                    errorMsg.append("\n");
                }
                errorMsg.append(mf.format(obj));
            }
        } else if (this.getTextLength(text) > 16384) {
            MessageFormat mf = new MessageFormat(res.getString("ymsg_YTextLongerThanDefault"));
            Object[] obj = new Object[]{new Integer(this.getTextLength(text)), new Integer(16384)};
            if (errorMsg.length() > 0) {
                errorMsg.append("\n");
            }
            errorMsg.append(mf.format(obj));
        }
        return errorMsg.toString();
    }

    public String checkAgainstCodepage(String str, String language) {
        if (!this._useCodePageCheck) {
            return new String("");
        }
        LangType languType = this.s2xTypes.getLangtype(language, "XLIFF");
        return this.checkAgainstCodepage(str, languType);
    }

    public String checkAgainstCodepage(String str, LangType language) {
        if (!this._useCodePageCheck) {
            return new String("");
        }
        String error = this.checkAgainstSchema("source-language", language.getXLIFFValue());
        if (error.length() == 0 && (error = codepageValidator.isValidC(str, language.getSAPInternalValue())).length() > 0) {
            MessageFormat mf = new MessageFormat(res.getString("ymsg_Codepage"));
            Object[] obj = new Object[2];
            obj[0] = language.getXLIFFValue().substring(0, 2);
            if (obj[0].equals("zh")) {
                obj[0] = language.getXLIFFValue();
            }
            obj[1] = error;
            error = mf.format(obj);
        }
        return error;
    }

    private int getTextLength(String pText) {
        int length;
        int j = length = pText.length();
        int i = 0;
        while (i < j) {
            char c = pText.charAt(i);
            switch (c) {
                case '\\': {
                    ++length;
                    break;
                }
                case '\t': {
                    ++length;
                    break;
                }
                case '\n': {
                    ++length;
                    break;
                }
                case '\r': {
                    ++length;
                    break;
                }
                case '\f': {
                    ++length;
                }
            }
            ++i;
        }
        return length;
    }
}

