/*
 * Decompiled with CFR 0.152.
 */
package com.sap.s2x.tools;

import com.sap.s2x.DuplicatePhaseException;
import com.sap.s2x.S2XDocument;
import com.sap.s2x.TextNotFoundException;
import com.sap.s2x.etc.TranslationUnit;
import com.sap.s2x.validation.ValidationException;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Vector;
import javax.xml.parsers.ParserConfigurationException;
import org.xml.sax.SAXException;

public class S2XMerger {
    public S2XDocument mergeMSXWithS2X(File msxFile, File s2xFile) throws IOException, ParserConfigurationException, SAXException, TextNotFoundException, ValidationException {
        return this.mergeMSXWithS2X(new FileInputStream(msxFile), new FileInputStream(s2xFile));
    }

    public S2XDocument mergeMSXWithS2X(InputStream msxFile, InputStream s2xFile) throws IOException, ParserConfigurationException, SAXException, TextNotFoundException, ValidationException {
        S2XDocument msx = new S2XDocument(msxFile, 1);
        S2XDocument s2x = new S2XDocument(s2xFile);
        msx.setDatatype(s2x.getDatatype());
        msx.setTool(s2x.getTool());
        String[] str = s2x.getExternalFile();
        if (str[1] != null && !str[1].equals("")) {
            msx.setExternalFile(str[0], str[1], str[2]);
        }
        str = s2x.getInternalFile();
        msx.setInternalFile(str[0], str[1], str[2]);
        Vector phases = s2x.getPhases();
        int i = 0;
        while (i < phases.size()) {
            String[] notes;
            str = (String[])phases.get(i);
            if (str.length > 3) {
                notes = new String[str.length - 3];
                int j = 0;
                while (j < str.length - 3) {
                    notes[j] = str[j + 2];
                    ++j;
                }
            } else {
                notes = new String[]{};
            }
            try {
                msx.addPhase(str[0], str[1], str[2], notes);
            }
            catch (DuplicatePhaseException dpe) {
                // empty catch block
            }
            ++i;
        }
        Vector texts = msx.getTexts();
        int size = texts.size();
        i = 0;
        while (i < size) {
            TranslationUnit tu = (TranslationUnit)texts.get(i);
            msx.setResname(tu.getID(), tu.getRestype(), s2x.getText(tu.getID(), tu.getRestype()).getResname());
            ++i;
        }
        return msx;
    }
}

