/*
 * Decompiled with CFR 0.152.
 */
package com.sap.s2x.core;

import com.sap.s2x.core.GiltDirectivesType;
import com.sap.s2x.core.MarshalException;
import com.sap.s2x.validation.ValidationException;
import com.sap.s2x.validation.Validator;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.ResourceBundle;
import javax.xml.parsers.ParserConfigurationException;
import org.xml.sax.SAXException;

public class GiltDirectives
extends GiltDirectivesType
implements Serializable {
    static ResourceBundle res = ResourceBundle.getBundle("com.sap.s2x.core.GiltDirectivesRes");
    private ArrayList errors = new ArrayList();
    private boolean valid;

    public GiltDirectives() {
        this.setMaxLength(new Integer(255).toString());
    }

    public ArrayList getErrorMessages() {
        return this.errors;
    }

    public boolean isValid() throws IOException, ParserConfigurationException, SAXException, ValidationException {
        this.validate();
        return this.valid;
    }

    public boolean isValidRSX() throws IOException, ParserConfigurationException, SAXException, ValidationException {
        this.validateRSX();
        return this.valid;
    }

    public boolean isValidISX() throws IOException, ParserConfigurationException, SAXException, ValidationException {
        this.validateISX();
        return this.valid;
    }

    public void marshal(OutputStream out) throws IOException, MarshalException {
        String xml = "<giltDirectives>";
        xml = xml + System.getProperty("line.separator");
        xml = xml + "<develContact>";
        xml = xml + this.getDevelContact();
        xml = xml + "</develContact>";
        xml = xml + System.getProperty("line.separator");
        xml = xml + "<domain>";
        xml = xml + this.getDomain().getXLIFFValue();
        xml = xml + "</domain>";
        xml = xml + System.getProperty("line.separator");
        xml = xml + "<collection>";
        xml = xml + this.getCollection();
        xml = xml + "</collection>";
        xml = xml + System.getProperty("line.separator");
        xml = xml + "<originalLocale xml:lang=\"";
        xml = xml + this.getOriginalLocale().getLang().getXLIFFValue();
        xml = xml + "\"/>";
        xml = xml + System.getProperty("line.separator");
        xml = xml + "<maxLength>";
        xml = xml + this.getMaxLength();
        xml = xml + "</maxLength>";
        xml = xml + System.getProperty("line.separator");
        xml = xml + "</giltDirectives>";
        xml = xml + System.getProperty("line.separator");
        try {
            out.write(xml.getBytes("UTF-8"));
        }
        catch (UnsupportedEncodingException uee) {
            throw new MarshalException(MarshalException.ERROR_UTF8);
        }
    }

    public void marshalMSX(OutputStream out) throws IOException, MarshalException {
        String xml = "<giltDirectives>";
        xml = xml + System.getProperty("line.separator");
        xml = xml + "<develContact>";
        xml = xml + this.getDevelContact();
        xml = xml + "</develContact>";
        xml = xml + System.getProperty("line.separator");
        xml = xml + "<domain>";
        xml = xml + this.getDomain().getSAPInternalValue();
        xml = xml + "</domain>";
        xml = xml + System.getProperty("line.separator");
        xml = xml + "<collection>";
        xml = xml + this.getCollection();
        xml = xml + "</collection>";
        xml = xml + System.getProperty("line.separator");
        xml = xml + "<originalLocale xml:lang=\"";
        xml = xml + this.getOriginalLocale().getLang().getSAPInternalValue();
        xml = xml + "\"/>";
        xml = xml + System.getProperty("line.separator");
        xml = xml + "<maxLength>";
        xml = xml + this.getMaxLength();
        xml = xml + "</maxLength>";
        xml = xml + System.getProperty("line.separator");
        xml = xml + "</giltDirectives>";
        xml = xml + System.getProperty("line.separator");
        try {
            out.write(xml.getBytes("UTF-8"));
        }
        catch (UnsupportedEncodingException uee) {
            throw new MarshalException(MarshalException.ERROR_UTF8);
        }
    }

    public void marshalRSX(OutputStream out) throws IOException, MarshalException {
        String xml = "<giltDirectives>";
        xml = xml + System.getProperty("line.separator");
        xml = xml + "<develContact>";
        xml = xml + this.getDevelContact();
        xml = xml + "</develContact>";
        xml = xml + "<domain>";
        xml = xml + this.getDomain().getXLIFFValue();
        xml = xml + "</domain>";
        xml = xml + System.getProperty("line.separator");
        xml = xml + "<originalLocale xml:lang=\"";
        xml = xml + this.getOriginalLocale().getLang().getXLIFFValue();
        xml = xml + "\"/>";
        xml = xml + System.getProperty("line.separator");
        xml = xml + "<maxLength>";
        xml = xml + this.getMaxLength();
        xml = xml + "</maxLength>";
        xml = xml + System.getProperty("line.separator");
        xml = xml + "</giltDirectives>";
        xml = xml + System.getProperty("line.separator");
        try {
            out.write(xml.getBytes("UTF-8"));
        }
        catch (UnsupportedEncodingException uee) {
            throw new MarshalException(MarshalException.ERROR_UTF8);
        }
    }

    public void validate() throws IOException, ParserConfigurationException, SAXException, ValidationException {
        String str = new String();
        this.valid = true;
        this.errors.clear();
        Validator v = Validator.getInstance(false);
        str = v.checkAgainstSchema("develContact", this.getDevelContact());
        if (str.length() > 0) {
            this.errors.add(res.getString("ymsg_wrongEmail1") + " " + str);
            str = new String();
            this.valid = false;
        }
        if ((str = v.checkAgainstSchema("domain", this.getDomain().getXLIFFValue())).length() > 0) {
            this.errors.add(res.getString("ymsg_wrongDomain") + " " + str);
            str = new String();
            this.valid = false;
        }
        if ((str = v.checkAgainstSchema("collection", this.getCollection())).length() > 0) {
            this.errors.add(res.getString("ymsg_wrongCollection") + " " + str);
            str = new String();
            this.valid = false;
        }
        if ((str = v.checkAgainstSchema("maxLength", this.getMaxLength())).length() > 0) {
            this.errors.add(res.getString("ymsg_wrongMaxlength1") + " " + str);
            str = new String();
            this.valid = false;
        }
        if ((str = v.checkAgainstSchema("xml:lang", this.getOriginalLocale().getLang().getXLIFFValue())).length() > 0) {
            this.errors.add(res.getString("ymsg_wrongOrigLang1") + " " + str);
            this.valid = false;
        }
    }

    public void validateRSX() throws IOException, ParserConfigurationException, SAXException, ValidationException {
        String str = new String();
        this.valid = true;
        this.errors.clear();
        Validator v = Validator.getInstance(false);
        str = v.checkAgainstSchema("develContact", this.getDevelContact());
        if (str.length() > 0) {
            this.errors.add(res.getString("ymsg_wrongEmail2") + " " + str);
            str = new String();
            this.valid = false;
        }
        if ((str = v.checkAgainstSchema("maxLength", this.getMaxLength())).length() > 0) {
            this.errors.add(res.getString("ymsg_wrongMaxlength2") + " " + str);
            str = new String();
            this.valid = false;
        }
        if ((str = v.checkAgainstSchema("xml:lang", this.getOriginalLocale().getLang().getXLIFFValue())).length() > 0) {
            this.errors.add(res.getString("ymsg_wrongOrigLang") + " " + str);
            this.valid = false;
        }
    }

    public void validateISX() throws IOException, ParserConfigurationException, SAXException, ValidationException {
        String str = new String();
        this.valid = true;
        this.errors.clear();
        Validator v = Validator.getInstance(false);
        str = v.checkAgainstSchema("develContact", this.getDevelContact());
        if (str.length() > 0) {
            this.errors.add(res.getString("ymsg_wrongEmail2") + " " + str);
            str = new String();
            this.valid = false;
        }
        if ((str = v.checkAgainstSchema("maxLength", this.getMaxLength())).length() > 0) {
            this.errors.add(res.getString("ymsg_wrongMaxlength2") + " " + str);
            str = new String();
            this.valid = false;
        }
        if (this.getDomain() != null && this.getDomain().getXLIFFValue() != null && !this.getDomain().getXLIFFValue().equals("") && (str = v.checkAgainstSchema("domain", this.getDomain().getXLIFFValue())).length() > 0) {
            this.errors.add(res.getString("ymsg_wrongDomain") + " " + str);
            str = new String();
            this.valid = false;
        }
        if ((str = v.checkAgainstSchema("xml:lang", this.getOriginalLocale().getLang().getXLIFFValue())).length() > 0) {
            this.errors.add(res.getString("ymsg_wrongOrigLang") + " " + str);
            this.valid = false;
        }
    }
}

