/*
 * Decompiled with CFR 0.152.
 */
package com.sap.s2x.core;

import com.sap.s2x.S2XTypes;
import com.sap.s2x.core.Body;
import com.sap.s2x.core.Header;
import com.sap.s2x.core.types.DatatypeValue;
import com.sap.s2x.core.types.LangType;
import java.io.Serializable;

public abstract class FileType
implements Serializable {
    private String _original;
    private LangType _sourceLanguage;
    private DatatypeValue _datatype;
    private String _tool;
    private String _productname;
    private Header _header = new Header();
    private Body _body = new Body();

    public FileType() {
        this._original = new String();
        this._tool = new String();
        this._productname = new String();
        this._datatype = new DatatypeValue();
        LangType type = S2XTypes.getInstance().getLangtype("en", "XLIFF");
        this._sourceLanguage = new LangType(type.getXLIFFValue(), type.getSAPInternalValue(), type.getDescription(), type.getDocumentation());
    }

    public Body getBody() {
        return this._body;
    }

    public DatatypeValue getDatatype() {
        return this._datatype;
    }

    public Header getHeader() {
        return this._header;
    }

    public String getOriginal() {
        return this._original;
    }

    public LangType getSourceLanguage() {
        return this._sourceLanguage;
    }

    public String getTool() {
        return this._tool;
    }

    public String getProductname() {
        return this._productname;
    }

    public void setBody(Body body) {
        this._body = body;
    }

    public void setDatatype(DatatypeValue datatype) {
        this._datatype = datatype;
    }

    public void setHeader(Header header) {
        this._header = header;
    }

    public void setOriginal(String original) {
        this._original = original;
    }

    public void setSourceLanguage(LangType sourceLanguage) {
        this._sourceLanguage = sourceLanguage;
    }

    public void setTool(String tool) {
        this._tool = tool;
    }

    public void setProductname(String productname) {
        this._productname = productname;
    }
}

