/*
 * Decompiled with CFR 0.152.
 */
package com.sap.s2x;

import com.sap.s2x.DuplicateIDException;
import com.sap.s2x.DuplicatePhaseException;
import com.sap.s2x.DuplicateResnameException;
import com.sap.s2x.S2XErrorHandler;
import com.sap.s2x.S2XTypes;
import com.sap.s2x.TextNotFoundException;
import com.sap.s2x.core.Group;
import com.sap.s2x.core.MarshalException;
import com.sap.s2x.core.OriginalLocaleType;
import com.sap.s2x.core.Phase;
import com.sap.s2x.core.PhaseTypeItem;
import com.sap.s2x.core.TransUnit;
import com.sap.s2x.core.Xliff;
import com.sap.s2x.core.types.DatatypeValue;
import com.sap.s2x.core.types.DomainType;
import com.sap.s2x.core.types.LangType;
import com.sap.s2x.core.types.RestypeValue;
import com.sap.s2x.core.types.S2XTypeInterface;
import com.sap.s2x.etc.TranslationUnit;
import com.sap.s2x.tools.EscapeHandler;
import com.sap.s2x.tools.GUIDVersionException;
import com.sap.s2x.tools.S2XGUID;
import com.sap.s2x.validation.SourceValidator;
import com.sap.s2x.validation.ValidationException;
import com.sap.s2x.validation.Validator;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.ResourceBundle;
import java.util.Vector;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class S2XDocument {
    static ResourceBundle res = ResourceBundle.getBundle("com.sap.s2x.S2XDocumentRes");
    public static final boolean CODEPAGE_VALIDATION_ON = true;
    public static final boolean CODEPAGE_VALIDATION_OFF = false;
    public static final int S2X_FLAVOUR = 0;
    public static final int MSX_FLAVOUR = 1;
    public static final int RSX_FLAVOUR = 2;
    public static final int ISX_FLAVOUR = 3;
    private Xliff xliff;
    private SourceValidator sourcevalidator;
    private Validator validator;
    private boolean codepageValidation;
    S2XTypes s2xTypes;
    private ArrayList errorMessages = new ArrayList();
    private ArrayList errorMessagesLoadRSX = new ArrayList();
    private String fileName;

    public S2XDocument() throws IOException, ParserConfigurationException, SAXException, ValidationException {
        this(true);
    }

    public S2XDocument(boolean pUseCodepageChecker) throws IOException, ParserConfigurationException, SAXException, ValidationException {
        this.validator = Validator.getInstance(pUseCodepageChecker);
        this.sourcevalidator = new SourceValidator();
        this.codepageValidation = pUseCodepageChecker;
        this.xliff = new Xliff();
        this.s2xTypes = S2XTypes.getInstance();
        this.fileName = new String();
    }

    public S2XDocument(File f) throws IOException, ParserConfigurationException, SAXException, ValidationException {
        this(f, true);
    }

    public S2XDocument(File f, boolean pUseCodepageChecker) throws IOException, ParserConfigurationException, SAXException, ValidationException {
        this.fileName = f.getAbsolutePath();
        this.codepageValidation = pUseCodepageChecker;
        this.sourcevalidator = new SourceValidator();
        this.validator = Validator.getInstance(pUseCodepageChecker);
        this.xliff = new Xliff();
        this.s2xTypes = S2XTypes.getInstance();
        this.load(f);
    }

    public S2XDocument(File f, int flavour) throws IOException, ParserConfigurationException, SAXException, ValidationException {
        this(f, flavour, true);
    }

    public S2XDocument(File f, int flavour, boolean pUseCodepageChecker) throws IOException, ParserConfigurationException, SAXException, ValidationException {
        this.fileName = f.getAbsolutePath();
        this.codepageValidation = pUseCodepageChecker;
        this.sourcevalidator = new SourceValidator();
        this.validator = Validator.getInstance(pUseCodepageChecker);
        this.xliff = new Xliff();
        this.s2xTypes = S2XTypes.getInstance();
        if (flavour == 1) {
            this.loadMSX(f);
        } else if (flavour == 0) {
            this.load(f);
        } else if (flavour == 2) {
            this.loadRSX(f);
        } else if (flavour == 3) {
            this.loadISX(f);
        }
    }

    public S2XDocument(String uri) throws IOException, ParserConfigurationException, SAXException, ValidationException {
        this(uri, true);
    }

    public S2XDocument(String uri, boolean pUseCodepageChecker) throws IOException, ParserConfigurationException, SAXException, ValidationException {
        this.fileName = new String();
        this.codepageValidation = pUseCodepageChecker;
        this.sourcevalidator = new SourceValidator();
        this.validator = Validator.getInstance(pUseCodepageChecker);
        this.xliff = new Xliff();
        this.s2xTypes = S2XTypes.getInstance();
        this.load(uri);
    }

    public S2XDocument(InputSource in) throws IOException, ParserConfigurationException, SAXException, ValidationException {
        this(in, true);
    }

    public S2XDocument(InputSource in, boolean pUseCodepageChecker) throws IOException, ParserConfigurationException, SAXException, ValidationException {
        this.fileName = new String();
        this.codepageValidation = pUseCodepageChecker;
        this.sourcevalidator = new SourceValidator();
        this.validator = Validator.getInstance(pUseCodepageChecker);
        this.xliff = new Xliff();
        this.load(in);
    }

    public S2XDocument(InputStream is) throws IOException, ParserConfigurationException, SAXException, ValidationException {
        this(is, true);
    }

    public S2XDocument(InputStream is, boolean pUseCodepageChecker) throws IOException, ParserConfigurationException, SAXException, ValidationException {
        this.fileName = new String();
        this.codepageValidation = pUseCodepageChecker;
        this.sourcevalidator = new SourceValidator();
        this.validator = Validator.getInstance(pUseCodepageChecker);
        this.xliff = new Xliff();
        this.s2xTypes = S2XTypes.getInstance();
        this.load(is);
    }

    public S2XDocument(InputStream is, int flavour) throws IOException, ParserConfigurationException, SAXException, ValidationException {
        this(is, flavour, true);
    }

    public S2XDocument(InputStream is, int flavour, boolean pUseCodepageChecker) throws IOException, ParserConfigurationException, SAXException, ValidationException {
        this.fileName = new String();
        this.codepageValidation = pUseCodepageChecker;
        this.sourcevalidator = new SourceValidator();
        this.validator = Validator.getInstance(pUseCodepageChecker);
        this.xliff = new Xliff();
        this.s2xTypes = S2XTypes.getInstance();
        if (flavour == 1) {
            this.loadMSX(is);
        } else if (flavour == 0) {
            this.load(is);
        } else if (flavour == 2) {
            this.loadRSX(is);
        } else if (flavour == 3) {
            this.loadISX(is);
        }
    }

    public S2XDocument(InputStream is, String systemId) throws IOException, ParserConfigurationException, SAXException, ValidationException {
        this(is, systemId, true);
    }

    public S2XDocument(InputStream is, String systemId, boolean pUseCodepageChecker) throws IOException, ParserConfigurationException, SAXException, ValidationException {
        this.fileName = new String();
        this.codepageValidation = pUseCodepageChecker;
        this.sourcevalidator = new SourceValidator();
        this.validator = Validator.getInstance(pUseCodepageChecker);
        this.xliff = new Xliff();
        this.s2xTypes = S2XTypes.getInstance();
        this.load(is, systemId);
    }

    private void addText(String text, String id, String resname, String restype, String maxwidth, boolean xliffRestype) throws DuplicateResnameException, ValidationException {
        String err;
        Object[] obj;
        MessageFormat mf;
        RestypeValue restypeValue;
        StringBuffer errorMsg = new StringBuffer();
        Group group = null;
        boolean validRestype = true;
        if ((text = text.trim()).equals("")) {
            throw new ValidationException(res.getString("ymsg_EmptyText"));
        }
        if (xliffRestype) {
            restypeValue = this.s2xTypes.getRestype(restype, "XLIFF");
            if (restypeValue == null) {
                mf = new MessageFormat(res.getString("ymsg_XLIFFTexttype"));
                obj = new Object[]{restype};
                errorMsg.append(mf.format(obj));
                validRestype = false;
            }
        } else {
            restypeValue = this.s2xTypes.getRestype(restype, "SAP");
            if (restypeValue == null) {
                mf = new MessageFormat(res.getString("ymsg_SAPinternalTyp"));
                obj = new Object[]{restype};
                errorMsg.append(mf.format(obj));
                validRestype = false;
            }
        }
        errorMsg.append(this.validator.checkAgainstSchema("id", id));
        String error = this.validator.checkAgainstSchema("maxwidth", new Integer(maxwidth).toString());
        if (!error.equals("")) {
            if (errorMsg.length() > 0) {
                errorMsg.append("\n");
            }
            errorMsg.append(error);
        }
        if (errorMsg.length() > 0) {
            throw new ValidationException(errorMsg.toString());
        }
        group = this.getGroup(restypeValue.getXLIFFValue());
        if (group != null) {
            int i = 0;
            while (i < group.getTransUnitCount()) {
                if (group.getTransUnit(i).getResname().equals(resname)) {
                    mf = new MessageFormat(res.getString("ymsg_DuplicateKey"));
                    obj = new Object[]{resname};
                    throw new DuplicateResnameException(mf.format(obj));
                }
                ++i;
            }
        }
        if (this.isCodepageValidationON() && !(err = this.validator.checkAgainstCodepage(text, S2XTypes.getInstance().getLangtype(this.getSourceLanguage(), "XLIFF"))).equals("")) {
            throw new ValidationException(err);
        }
        errorMsg.append(this.validator.checkTextLength(text, restypeValue, (int)new Integer(maxwidth), (int)new Integer(this.getMaxLength())));
        if (errorMsg.length() > 0 || !validRestype) {
            throw new ValidationException(errorMsg.toString());
        }
        if (group == null) {
            group = new Group();
            group.setRestype(restypeValue);
            this.xliff.getFile().getBody().addGroup(group);
        }
        TransUnit transunit = new TransUnit();
        transunit.setId(id);
        transunit.setMaxwidth(new Integer(maxwidth));
        transunit.setResname(resname);
        transunit.setSource(text);
        group.addTransUnit(transunit);
    }

    private void addText(String text, String id, String resname, String restype, String maxwidth, boolean xliffRestype, Boolean translate) throws DuplicateResnameException, ValidationException {
        String err;
        Object[] obj;
        MessageFormat mf;
        RestypeValue restypeValue;
        StringBuffer errorMsg = new StringBuffer();
        Group group = null;
        boolean validRestype = true;
        String translate_s = translate != false ? "yes" : "no";
        if ((text = text.trim()).equals("")) {
            throw new ValidationException(res.getString("ymsg_EmptyText"));
        }
        if (xliffRestype) {
            restypeValue = this.s2xTypes.getRestype(restype, "XLIFF");
            if (restypeValue == null) {
                mf = new MessageFormat(res.getString("ymsg_XLIFFTexttype"));
                obj = new Object[]{restype};
                errorMsg.append(mf.format(obj));
                validRestype = false;
            }
        } else {
            restypeValue = this.s2xTypes.getRestype(restype, "SAP");
            if (restypeValue == null) {
                mf = new MessageFormat(res.getString("ymsg_SAPinternalTyp"));
                obj = new Object[]{restype};
                errorMsg.append(mf.format(obj));
                validRestype = false;
            }
        }
        errorMsg.append(this.validator.checkAgainstSchema("id", id));
        String error = this.validator.checkAgainstSchema("maxwidth", new Integer(maxwidth).toString());
        if (!error.equals("")) {
            if (errorMsg.length() > 0) {
                errorMsg.append("\n");
            }
            errorMsg.append(error);
        }
        if (errorMsg.length() > 0) {
            throw new ValidationException(errorMsg.toString());
        }
        group = this.getGroup(restypeValue.getXLIFFValue());
        if (group != null) {
            int i = 0;
            while (i < group.getTransUnitCount()) {
                if (group.getTransUnit(i).getResname().equals(resname)) {
                    mf = new MessageFormat(res.getString("ymsg_DuplicateKey"));
                    obj = new Object[]{resname};
                    throw new DuplicateResnameException(mf.format(obj));
                }
                ++i;
            }
        }
        if (this.isCodepageValidationON() && !translate_s.equals("no") && !(err = this.validator.checkAgainstCodepage(text, S2XTypes.getInstance().getLangtype(this.getSourceLanguage(), "XLIFF"))).equals("")) {
            throw new ValidationException(err);
        }
        errorMsg.append(this.validator.checkTextLength(text, restypeValue, (int)new Integer(maxwidth), (int)new Integer(this.getMaxLength())));
        if (errorMsg.length() > 0 || !validRestype) {
            throw new ValidationException(errorMsg.toString());
        }
        if (group == null) {
            group = new Group();
            group.setRestype(restypeValue);
            this.xliff.getFile().getBody().addGroup(group);
        }
        TransUnit transunit = new TransUnit();
        transunit.setId(id);
        transunit.setMaxwidth(new Integer(maxwidth));
        transunit.setResname(resname);
        transunit.setSource(text);
        transunit.setTranslate(translate_s);
        group.addTransUnit(transunit);
    }

    public void addText(String text, String id, String resname, String xliffRestype, String maxwidth) throws DuplicateIDException, ValidationException {
        String err;
        StringBuffer errorMsg = new StringBuffer();
        Group group = null;
        RestypeValue restype = null;
        boolean validRestype = true;
        if (text == null || (text = text.trim()).equals("")) {
            throw new ValidationException(res.getString("ymsg_EmptyText"));
        }
        if (resname == null) {
            resname = new String(id);
        } else if (resname.equals("")) {
            resname = id;
        }
        errorMsg.append(this.validator.checkAgainstSchema("restype", xliffRestype));
        if (errorMsg.length() > 0) {
            validRestype = false;
        } else {
            restype = this.s2xTypes.getRestype(xliffRestype, "XLIFF");
        }
        String error = this.validator.checkAgainstSchema("id", id);
        if (!error.equals("")) {
            if (errorMsg.length() > 0) {
                errorMsg.append("\n");
            }
            errorMsg.append(error);
        }
        error = "";
        error = this.validator.checkAgainstSchema("maxwidth", new Integer(maxwidth).toString());
        if (!error.equals("")) {
            if (errorMsg.length() > 0) {
                errorMsg.append("\n");
            }
            errorMsg.append(error);
        }
        if (errorMsg.length() > 0) {
            throw new ValidationException(errorMsg.toString());
        }
        try {
            if (this.getText(id) != null) {
                MessageFormat mf = new MessageFormat(res.getString("ymsg_DuplicateID3"));
                Object[] obj = new Object[]{id, text};
                throw new DuplicateIDException(mf.format(obj));
            }
        }
        catch (TextNotFoundException tnfe) {
            // empty catch block
        }
        if (this.isCodepageValidationON() && !(err = this.validator.checkAgainstCodepage(text, S2XTypes.getInstance().getLangtype(this.getSourceLanguage(), "XLIFF"))).equals("")) {
            throw new ValidationException(err);
        }
        errorMsg.append(this.validator.checkTextLength(text, restype, (int)new Integer(maxwidth), (int)new Integer(this.getMaxLength())));
        if (errorMsg.length() > 0 || !validRestype) {
            throw new ValidationException(errorMsg.toString());
        }
        group = this.getGroup(restype.getXLIFFValue());
        if (group == null) {
            group = new Group();
            group.setRestype(restype);
            this.xliff.getFile().getBody().addGroup(group);
        }
        TransUnit transunit = new TransUnit();
        transunit.setId(id);
        transunit.setMaxwidth(new Integer(maxwidth));
        transunit.setResname(resname);
        transunit.setSource(text);
        group.addTransUnit(transunit);
    }

    public void addText(String text, String id, String resname, String xliffRestype, String maxwidth, Boolean translate) throws DuplicateIDException, ValidationException {
        String err;
        StringBuffer errorMsg = new StringBuffer();
        Group group = null;
        RestypeValue restype = null;
        boolean validRestype = true;
        String translate_s = translate != false ? "yes" : "no";
        if (text == null || (text = text.trim()).equals("")) {
            throw new ValidationException(res.getString("ymsg_EmptyText"));
        }
        if (resname == null) {
            resname = new String(id);
        } else if (resname.equals("")) {
            resname = id;
        }
        errorMsg.append(this.validator.checkAgainstSchema("restype", xliffRestype));
        if (errorMsg.length() > 0) {
            validRestype = false;
        } else {
            restype = this.s2xTypes.getRestype(xliffRestype, "XLIFF");
        }
        String error = this.validator.checkAgainstSchema("id", id);
        if (!error.equals("")) {
            if (errorMsg.length() > 0) {
                errorMsg.append("\n");
            }
            errorMsg.append(error);
        }
        error = "";
        error = this.validator.checkAgainstSchema("maxwidth", new Integer(maxwidth).toString());
        if (!error.equals("")) {
            if (errorMsg.length() > 0) {
                errorMsg.append("\n");
            }
            errorMsg.append(error);
        }
        if (errorMsg.length() > 0) {
            throw new ValidationException(errorMsg.toString());
        }
        try {
            if (this.getText(id) != null) {
                MessageFormat mf = new MessageFormat(res.getString("ymsg_DuplicateID3"));
                Object[] obj = new Object[]{id, text};
                throw new DuplicateIDException(mf.format(obj));
            }
        }
        catch (TextNotFoundException tnfe) {
            // empty catch block
        }
        if (this.isCodepageValidationON() && !translate_s.equals("no") && !(err = this.validator.checkAgainstCodepage(text, S2XTypes.getInstance().getLangtype(this.getSourceLanguage(), "XLIFF"))).equals("")) {
            throw new ValidationException(err);
        }
        errorMsg.append(this.validator.checkTextLength(text, restype, (int)new Integer(maxwidth), (int)new Integer(this.getMaxLength())));
        if (errorMsg.length() > 0 || !validRestype) {
            throw new ValidationException(errorMsg.toString());
        }
        group = this.getGroup(restype.getXLIFFValue());
        if (group == null) {
            group = new Group();
            group.setRestype(restype);
            this.xliff.getFile().getBody().addGroup(group);
        }
        TransUnit transunit = new TransUnit();
        transunit.setId(id);
        transunit.setMaxwidth(new Integer(maxwidth));
        transunit.setResname(resname);
        transunit.setSource(text);
        transunit.setTranslate(translate_s);
        group.addTransUnit(transunit);
    }

    public String addText(String text, String resname, String xliffRestype, String maxwidth) throws DuplicateResnameException, ValidationException {
        String err;
        StringBuffer errorMsg = new StringBuffer();
        String id = new String();
        Group group = null;
        RestypeValue restype = null;
        boolean validRestype = true;
        if (resname == null || resname.equals("")) {
            return this.addText(text, xliffRestype, maxwidth);
        }
        if (text == null || (text = text.trim()).equals("")) {
            throw new ValidationException(res.getString("ymsg_EmptyText"));
        }
        errorMsg.append(this.validator.checkAgainstSchema("restype", xliffRestype));
        if (errorMsg.length() > 0) {
            validRestype = false;
        } else {
            restype = this.s2xTypes.getRestype(xliffRestype, "XLIFF");
        }
        String error = this.validator.checkAgainstSchema("maxwidth", new Integer(maxwidth).toString());
        if (!error.equals("")) {
            if (errorMsg.length() > 0) {
                errorMsg.append("\n");
            }
            errorMsg.append(error);
        }
        if (errorMsg.length() > 0) {
            throw new ValidationException(errorMsg.toString());
        }
        if (restype != null && (group = this.getGroup(restype.getXLIFFValue())) != null) {
            int i = 0;
            while (i < group.getTransUnitCount()) {
                if (group.getTransUnit(i).getResname().equals(resname)) {
                    MessageFormat mf = new MessageFormat(res.getString("ymsg_DuplicateKey"));
                    Object[] obj = new Object[]{resname};
                    throw new DuplicateResnameException(mf.format(obj));
                }
                ++i;
            }
        }
        if (this.isCodepageValidationON() && !(err = this.validator.checkAgainstCodepage(text, S2XTypes.getInstance().getLangtype(this.getSourceLanguage(), "XLIFF"))).equals("")) {
            throw new ValidationException(err);
        }
        errorMsg.append(this.validator.checkTextLength(text, restype, (int)new Integer(maxwidth), (int)new Integer(this.getMaxLength())));
        if (errorMsg.length() > 0 || !validRestype) {
            throw new ValidationException(errorMsg.toString());
        }
        if (group == null) {
            group = new Group();
            group.setRestype(restype);
            this.xliff.getFile().getBody().addGroup(group);
        }
        if (!id.equals(resname)) {
            try {
                id = S2XGUID.getGUID();
            }
            catch (GUIDVersionException gve) {
                throw new ValidationException(res.getString("ymsg_GUID"));
            }
        }
        TransUnit transunit = new TransUnit();
        transunit.setId(id);
        transunit.setMaxwidth(new Integer(maxwidth));
        transunit.setResname(resname);
        transunit.setSource(text);
        group.addTransUnit(transunit);
        return id;
    }

    public String addText(String text, String resname, String xliffRestype, String maxwidth, Boolean translate) throws DuplicateResnameException, ValidationException {
        String err;
        StringBuffer errorMsg = new StringBuffer();
        String id = new String();
        Group group = null;
        RestypeValue restype = null;
        boolean validRestype = true;
        String translate_s = translate != false ? "yes" : "no";
        if (resname == null || resname.equals("")) {
            return this.addText(text, xliffRestype, maxwidth);
        }
        if (text == null || (text = text.trim()).equals("")) {
            throw new ValidationException(res.getString("ymsg_EmptyText"));
        }
        errorMsg.append(this.validator.checkAgainstSchema("restype", xliffRestype));
        if (errorMsg.length() > 0) {
            validRestype = false;
        } else {
            restype = this.s2xTypes.getRestype(xliffRestype, "XLIFF");
        }
        String error = this.validator.checkAgainstSchema("maxwidth", new Integer(maxwidth).toString());
        if (!error.equals("")) {
            if (errorMsg.length() > 0) {
                errorMsg.append("\n");
            }
            errorMsg.append(error);
        }
        if (errorMsg.length() > 0) {
            throw new ValidationException(errorMsg.toString());
        }
        if (restype != null && (group = this.getGroup(restype.getXLIFFValue())) != null) {
            int i = 0;
            while (i < group.getTransUnitCount()) {
                if (group.getTransUnit(i).getResname().equals(resname)) {
                    MessageFormat mf = new MessageFormat(res.getString("ymsg_DuplicateKey"));
                    Object[] obj = new Object[]{resname};
                    throw new DuplicateResnameException(mf.format(obj));
                }
                ++i;
            }
        }
        if (this.isCodepageValidationON() && !translate_s.equals("no") && !(err = this.validator.checkAgainstCodepage(text, S2XTypes.getInstance().getLangtype(this.getSourceLanguage(), "XLIFF"))).equals("")) {
            throw new ValidationException(err);
        }
        errorMsg.append(this.validator.checkTextLength(text, restype, (int)new Integer(maxwidth), (int)new Integer(this.getMaxLength())));
        if (errorMsg.length() > 0 || !validRestype) {
            throw new ValidationException(errorMsg.toString());
        }
        if (group == null) {
            group = new Group();
            group.setRestype(restype);
            this.xliff.getFile().getBody().addGroup(group);
        }
        if (!id.equals(resname)) {
            try {
                id = S2XGUID.getGUID();
            }
            catch (GUIDVersionException gve) {
                throw new ValidationException(res.getString("ymsg_GUID"));
            }
        }
        TransUnit transunit = new TransUnit();
        transunit.setId(id);
        transunit.setMaxwidth(new Integer(maxwidth));
        transunit.setResname(resname);
        transunit.setSource(text);
        transunit.setTranslate(translate_s);
        group.addTransUnit(transunit);
        return id;
    }

    public String addText(String text, String xliffRestype, String maxwidth) throws ValidationException {
        String err;
        StringBuffer errorMsg = new StringBuffer();
        String id = new String();
        Group group = null;
        RestypeValue restype = null;
        boolean validRestype = true;
        if (text == null || (text = text.trim()).equals("")) {
            throw new ValidationException(res.getString("ymsg_EmptyText"));
        }
        errorMsg.append(this.validator.checkAgainstSchema("restype", xliffRestype));
        if (errorMsg.length() > 0) {
            validRestype = false;
        } else {
            restype = this.s2xTypes.getRestype(xliffRestype, "XLIFF");
        }
        String error = this.validator.checkAgainstSchema("maxwidth", new Integer(maxwidth).toString());
        if (!error.equals("")) {
            if (errorMsg.length() > 0) {
                errorMsg.append("\n");
            }
            errorMsg.append(error);
        }
        if (errorMsg.length() > 0) {
            throw new ValidationException(errorMsg.toString());
        }
        if (this.isCodepageValidationON() && !(err = this.validator.checkAgainstCodepage(text, S2XTypes.getInstance().getLangtype(this.getSourceLanguage(), "XLIFF"))).equals("")) {
            throw new ValidationException(err);
        }
        if (restype != null) {
            errorMsg.append(this.validator.checkTextLength(text, restype, (int)new Integer(maxwidth), (int)new Integer(this.getMaxLength())));
        }
        if (errorMsg.length() > 0 || !validRestype) {
            throw new ValidationException(errorMsg.toString());
        }
        group = this.getGroup(restype.getXLIFFValue());
        if (group == null) {
            group = new Group();
            group.setRestype(restype);
            this.xliff.getFile().getBody().addGroup(group);
        }
        try {
            id = S2XGUID.getGUID();
        }
        catch (GUIDVersionException gve) {
            throw new ValidationException(res.getString("ymsg_GUID"));
        }
        TransUnit transunit = new TransUnit();
        transunit.setId(id);
        transunit.setResname(id);
        transunit.setMaxwidth(new Integer(maxwidth));
        transunit.setSource(text);
        group.addTransUnit(transunit);
        return id;
    }

    public String addText(String text, String xliffRestype, String maxwidth, Boolean translate) throws ValidationException {
        String err;
        StringBuffer errorMsg = new StringBuffer();
        String id = new String();
        Group group = null;
        RestypeValue restype = null;
        boolean validRestype = true;
        String translate_s = translate != false ? "yes" : "no";
        if (text == null || (text = text.trim()).equals("")) {
            throw new ValidationException(res.getString("ymsg_EmptyText"));
        }
        errorMsg.append(this.validator.checkAgainstSchema("restype", xliffRestype));
        if (errorMsg.length() > 0) {
            validRestype = false;
        } else {
            restype = this.s2xTypes.getRestype(xliffRestype, "XLIFF");
        }
        String error = this.validator.checkAgainstSchema("maxwidth", new Integer(maxwidth).toString());
        if (!error.equals("")) {
            if (errorMsg.length() > 0) {
                errorMsg.append("\n");
            }
            errorMsg.append(error);
        }
        if (errorMsg.length() > 0) {
            throw new ValidationException(errorMsg.toString());
        }
        if (this.isCodepageValidationON() && !translate_s.equals("no") && !(err = this.validator.checkAgainstCodepage(text, S2XTypes.getInstance().getLangtype(this.getSourceLanguage(), "XLIFF"))).equals("")) {
            throw new ValidationException(err);
        }
        if (restype != null) {
            errorMsg.append(this.validator.checkTextLength(text, restype, (int)new Integer(maxwidth), (int)new Integer(this.getMaxLength())));
        }
        if (errorMsg.length() > 0 || !validRestype) {
            throw new ValidationException(errorMsg.toString());
        }
        group = this.getGroup(restype.getXLIFFValue());
        if (group == null) {
            group = new Group();
            group.setRestype(restype);
            this.xliff.getFile().getBody().addGroup(group);
        }
        try {
            id = S2XGUID.getGUID();
        }
        catch (GUIDVersionException gve) {
            throw new ValidationException(res.getString("ymsg_GUID"));
        }
        TransUnit transunit = new TransUnit();
        transunit.setId(id);
        transunit.setResname(id);
        transunit.setMaxwidth(new Integer(maxwidth));
        transunit.setSource(text);
        transunit.setTranslate(translate_s);
        group.addTransUnit(transunit);
        return id;
    }

    public void addPhase(String phasename, String processname, String tool, String[] notes) throws DuplicatePhaseException, ValidationException {
        StringBuffer buffer = new StringBuffer();
        Object[] obj = new Object[2];
        MessageFormat mf = new MessageFormat(res.getString("ymsg_EmptyAttribute"));
        obj[0] = "phase";
        if (phasename == null || phasename.equals("")) {
            obj[1] = "phase-name";
            buffer.append(mf.format(obj));
        }
        if (processname == null || processname.equals("")) {
            if (buffer.length() > 0) {
                buffer.append("\n");
            }
            obj[1] = "process-name";
            buffer.append(mf.format(obj));
        }
        if (tool == null || tool.equals("")) {
            if (buffer.length() > 0) {
                buffer.append("\n");
            }
            obj[1] = "tool";
            buffer.append(mf.format(obj));
        }
        if (buffer.length() != 0) {
            throw new ValidationException(buffer.toString());
        }
        int i = 0;
        while (i < this.xliff.getFile().getHeader().getPhaseGroup().getPhaseCount()) {
            if (this.xliff.getFile().getHeader().getPhaseGroup().getPhase(i).getPhaseName().equals(phasename)) {
                mf = new MessageFormat(res.getString("ymsg_DuplicatePhase"));
                obj = new Object[]{"phase", phasename, "phase-name"};
                throw new DuplicatePhaseException(mf.format(obj));
            }
            ++i;
        }
        Phase phase = new Phase();
        phase.setPhaseName(phasename);
        phase.setProcessName(processname);
        phase.setTool(tool);
        PhaseTypeItem item = phase.getPhaseTypeItem(0);
        int i2 = 0;
        while (i2 < notes.length) {
            if (!notes[i2].equals("")) {
                item.addNote(notes[i2]);
            }
            ++i2;
        }
        this.xliff.getFile().getHeader().getPhaseGroup().addPhase(phase);
    }

    public void changeResname(String id, String newResname, String restype, String oldResname) throws TextNotFoundException, ValidationException {
        StringBuffer errorMsg = new StringBuffer();
        errorMsg.append(this.validator.checkAgainstSchema("restype", restype));
        errorMsg.append(this.validator.checkAgainstSchema("id", id));
        if (errorMsg.length() > 0) {
            throw new ValidationException(errorMsg.toString());
        }
        TransUnit transUnit = this.getTransUnit(restype, id);
        if (transUnit == null) {
            MessageFormat mf = new MessageFormat(res.getString("ymsg_TextDoesNotExist"));
            Object[] obj = new Object[]{id, restype};
            throw new TextNotFoundException(mf.format(obj));
        }
        if (!oldResname.equals("") && !transUnit.getResname().equals(oldResname)) {
            MessageFormat mf = new MessageFormat(res.getString("ymsg_TextResnameNotExists"));
            Object[] obj = new Object[]{id, oldResname};
            throw new TextNotFoundException(mf.format(obj));
        }
        transUnit.setResname(newResname);
    }

    public void changeTranslate(String id, String restype) throws Exception, ValidationException {
        StringBuffer errorMsg = new StringBuffer();
        errorMsg.append(this.validator.checkAgainstSchema("restype", restype));
        errorMsg.append(this.validator.checkAgainstSchema("id", id));
        if (errorMsg.length() > 0) {
            throw new ValidationException(errorMsg.toString());
        }
        TransUnit transUnit = this.getTransUnit(restype, id);
        if (transUnit == null) {
            MessageFormat mf = new MessageFormat(res.getString("ymsg_TextDoesNotExist"));
            Object[] obj = new Object[]{id, restype};
            throw new TextNotFoundException(mf.format(obj));
        }
        if (transUnit.getTranslate().toLowerCase().equals("yes")) {
            transUnit.setTranslate("no");
        } else if (transUnit.getTranslate().toLowerCase().equals("no")) {
            transUnit.setTranslate("yes");
        } else {
            MessageFormat mf = new MessageFormat(res.getString("ymsg_TranslateNotChanged"));
            Object[] obj = new Object[]{id, transUnit.getTranslate().toLowerCase()};
            throw new Exception(mf.format(obj));
        }
    }

    public void changeRestype(String id, String oldXLIFFRestype, String newXLIFFRestype) throws TextNotFoundException, ValidationException {
        StringBuffer errorMsg = new StringBuffer();
        errorMsg.append(this.validator.checkAgainstSchema("restype", oldXLIFFRestype));
        errorMsg.append(this.validator.checkAgainstSchema("restype", newXLIFFRestype));
        errorMsg.append(this.validator.checkAgainstSchema("id", id));
        if (errorMsg.length() > 0) {
            throw new ValidationException(errorMsg.toString());
        }
        TransUnit transUnit = this.getTransUnit(oldXLIFFRestype, id);
        if (transUnit == null) {
            MessageFormat mf = new MessageFormat(res.getString("ymsg_TextDoesNotExist"));
            Object[] obj = new Object[]{id, oldXLIFFRestype};
            throw new TextNotFoundException(mf.format(obj));
        }
        Group group = this.getGroup(oldXLIFFRestype);
        group.removeTransUnit(transUnit);
        group = this.getGroup(newXLIFFRestype);
        if (group == null) {
            group = new Group();
            RestypeValue restype = this.s2xTypes.getRestype(newXLIFFRestype, "XLIFF");
            group.setRestype(restype);
            this.xliff.getFile().getBody().addGroup(group);
        }
        group.addTransUnit(transUnit);
    }

    public String getDatatype() {
        return this.xliff.getFile().getDatatype().getXLIFFValue();
    }

    private Group getGroup(String restype) {
        Group group = null;
        int i = 0;
        while (i < this.xliff.getFile().getBody().getGroupCount()) {
            if (this.xliff.getFile().getBody().getGroup(i).getRestype().getXLIFFValue().equals(restype)) {
                group = this.xliff.getFile().getBody().getGroup(i);
                break;
            }
            ++i;
        }
        return group;
    }

    public String getOriginal() {
        return this.xliff.getFile().getOriginal();
    }

    public String getSourceLanguage() {
        return this.xliff.getFile().getSourceLanguage().getXLIFFValue();
    }

    public String getProductname() {
        return this.xliff.getFile().getProductname();
    }

    public TranslationUnit getText(String id, String restype) throws TextNotFoundException, ValidationException {
        TransUnit transUnit;
        TranslationUnit tu = null;
        String validationError = this.validator.checkAgainstSchema("restype", restype);
        if (validationError.length() > 0) {
            throw new ValidationException(validationError);
        }
        Group group = this.getGroup(restype);
        if (group != null) {
            transUnit = this.getTransUnit(group, id);
            if (transUnit == null) {
                MessageFormat mf = new MessageFormat(res.getString("ymsg_TextDoesNotExist"));
                Object[] obj = new Object[]{id, restype};
                throw new TextNotFoundException(mf.format(obj));
            }
        } else {
            MessageFormat mf = new MessageFormat(res.getString("ymsg_NoTextsForRestype"));
            Object[] obj = new Object[]{restype};
            throw new TextNotFoundException(mf.format(obj));
        }
        tu = new TranslationUnit();
        tu.setSource(transUnit.getSource());
        tu.setID(transUnit.getId());
        tu.setResname(transUnit.getResname());
        tu.setTranslate(transUnit.getTranslate());
        tu.setMaxwidth(new Integer(transUnit.getMaxwidth()).toString());
        tu.setRestype(group.getRestype().getXLIFFValue());
        return tu;
    }

    public TranslationUnit getText(String id) throws TextNotFoundException, ValidationException {
        TranslationUnit tu = null;
        int i = 0;
        while (i < this.xliff.getFile().getBody().getGroupCount()) {
            Group group = this.xliff.getFile().getBody().getGroup(i);
            TransUnit transUnit = this.getTransUnit(group, id);
            if (transUnit != null) {
                tu = new TranslationUnit();
                tu.setSource(transUnit.getSource());
                tu.setID(transUnit.getId());
                tu.setResname(transUnit.getResname());
                tu.setTranslate(transUnit.getTranslate());
                tu.setMaxwidth(new Integer(transUnit.getMaxwidth()).toString());
                tu.setRestype(group.getRestype().getXLIFFValue());
                break;
            }
            ++i;
        }
        if (tu == null) {
            MessageFormat mf = new MessageFormat(res.getString("ymsg_TextIDDoesNotExist"));
            Object[] obj = new Object[]{id};
            throw new TextNotFoundException(mf.format(obj));
        }
        return tu;
    }

    public Vector getTexts() {
        Vector<TranslationUnit> texts = new Vector<TranslationUnit>();
        int i = 0;
        while (i < this.xliff.getFile().getBody().getGroupCount()) {
            Group group = this.xliff.getFile().getBody().getGroup(i);
            int j = 0;
            while (j < group.getTransUnitCount()) {
                TransUnit transUnit = group.getTransUnit(j);
                TranslationUnit tu = new TranslationUnit();
                tu.setSource(transUnit.getSource());
                tu.setID(transUnit.getId());
                tu.setResname(transUnit.getResname());
                tu.setTranslate(transUnit.getTranslate());
                tu.setMaxwidth(new Integer(transUnit.getMaxwidth()).toString());
                tu.setRestype(group.getRestype().getXLIFFValue());
                texts.add(tu);
                ++j;
            }
            ++i;
        }
        return texts;
    }

    public void set_Translate_allTexts(Boolean translate) {
        String translate_s = translate != false ? "yes" : "no";
        int i = 0;
        while (i < this.xliff.getFile().getBody().getGroupCount()) {
            Group group = this.xliff.getFile().getBody().getGroup(i);
            int j = 0;
            while (j < group.getTransUnitCount()) {
                group.getTransUnit(j).setTranslate(translate_s);
                ++j;
            }
            ++i;
        }
    }

    private TransUnit getTransUnit(Group group, String id) {
        TransUnit transUnit = null;
        int i = 0;
        while (i < group.getTransUnitCount()) {
            if (group.getTransUnit(i).getId().equals(id)) {
                transUnit = group.getTransUnit(i);
                break;
            }
            ++i;
        }
        return transUnit;
    }

    private TransUnit getTransUnit(String restype, String id) {
        TransUnit transUnit = null;
        Group group = this.getGroup(restype);
        if (group != null) {
            int i = 0;
            while (i < group.getTransUnitCount()) {
                if (group.getTransUnit(i).getId().equals(id)) {
                    transUnit = group.getTransUnit(i);
                    break;
                }
                ++i;
            }
        }
        return transUnit;
    }

    public String getTool() {
        return this.xliff.getFile().getTool();
    }

    public String getVersion() {
        return this.xliff.getVersion();
    }

    public String getDevelContact() {
        return this.xliff.getFile().getHeader().getS2x().getGiltDirectives().getDevelContact();
    }

    public DomainType getDomain() {
        return this.xliff.getFile().getHeader().getS2x().getGiltDirectives().getDomain();
    }

    public String getCollection() {
        return this.xliff.getFile().getHeader().getS2x().getGiltDirectives().getCollection();
    }

    public ArrayList getErrorMessages() {
        this.errorMessages.addAll(this.xliff.getErrorMessages());
        return this.errorMessages;
    }

    public ArrayList getErrorMessagesLoadRSX() {
        return this.errorMessagesLoadRSX;
    }

    public String[] getExternalFile() {
        String[] externalFile = new String[]{this.xliff.getFile().getHeader().getSkl().getExternalFile().getCrc(), this.xliff.getFile().getHeader().getSkl().getExternalFile().getHref(), this.xliff.getFile().getHeader().getSkl().getExternalFile().getUid()};
        return externalFile;
    }

    public String[] getInternalFile() {
        String[] internalFile = new String[]{this.xliff.getFile().getHeader().getSkl().getInternalFile().getCrc(), this.xliff.getFile().getHeader().getSkl().getInternalFile().getForm(), this.xliff.getFile().getHeader().getSkl().getInternalFile().getContent()};
        return internalFile;
    }

    public String getMaxLength() {
        return this.xliff.getFile().getHeader().getS2x().getGiltDirectives().getMaxLength();
    }

    public String getOriginalLocale() {
        return this.xliff.getFile().getHeader().getS2x().getGiltDirectives().getOriginalLocale().getLang().getXLIFFValue();
    }

    public String[] getPhase(String phaseName) {
        String[] phase = null;
        int i = 0;
        while (i < this.xliff.getFile().getHeader().getPhaseGroup().getPhaseCount()) {
            if (this.xliff.getFile().getHeader().getPhaseGroup().getPhase(i).getPhaseName().equals(phaseName)) {
                phase = new String[this.xliff.getFile().getHeader().getPhaseGroup().getPhase(i).getPhaseTypeItem(0).getNoteCount() + 3];
                phase[0] = this.xliff.getFile().getHeader().getPhaseGroup().getPhase(i).getPhaseName();
                phase[1] = this.xliff.getFile().getHeader().getPhaseGroup().getPhase(i).getProcessName();
                phase[2] = this.xliff.getFile().getHeader().getPhaseGroup().getPhase(i).getTool();
                int j = 0;
                while (j < this.xliff.getFile().getHeader().getPhaseGroup().getPhase(i).getPhaseTypeItem(0).getNoteCount()) {
                    phase[j + 3] = this.xliff.getFile().getHeader().getPhaseGroup().getPhase(i).getPhaseTypeItem(0).getNote(j);
                    ++j;
                }
                break;
            }
            ++i;
        }
        return phase;
    }

    public Vector getPhases() {
        Vector<String[]> phases = new Vector<String[]>();
        int i = 0;
        while (i < this.xliff.getFile().getHeader().getPhaseGroup().getPhaseCount()) {
            String[] phase = new String[this.xliff.getFile().getHeader().getPhaseGroup().getPhase(i).getPhaseTypeItem(0).getNoteCount() + 3];
            phase[0] = this.xliff.getFile().getHeader().getPhaseGroup().getPhase(i).getPhaseName();
            phase[1] = this.xliff.getFile().getHeader().getPhaseGroup().getPhase(i).getProcessName();
            phase[2] = this.xliff.getFile().getHeader().getPhaseGroup().getPhase(i).getTool();
            int j = 0;
            while (j < this.xliff.getFile().getHeader().getPhaseGroup().getPhase(i).getPhaseTypeItem(0).getNoteCount()) {
                phase[j + 3] = this.xliff.getFile().getHeader().getPhaseGroup().getPhase(i).getPhaseTypeItem(0).getNote(j);
                ++j;
            }
            phases.add(phase);
            ++i;
        }
        return phases;
    }

    public String getDc() {
        return this.xliff.getFile().getHeader().getS2x().getDtr().getDc();
    }

    public String getRel() {
        return this.xliff.getFile().getHeader().getS2x().getDtr().getRel();
    }

    public S2XTypes getS2XTypes() {
        return S2XTypes.getInstance();
    }

    public String getSc() {
        return this.xliff.getFile().getHeader().getS2x().getDtr().getSc();
    }

    public void removePhase(String phaseName) {
        int i = 0;
        while (i < this.xliff.getFile().getHeader().getPhaseGroup().getPhaseCount()) {
            Phase phase = this.xliff.getFile().getHeader().getPhaseGroup().getPhase(i);
            if (phase.getPhaseName().equals(phaseName)) {
                this.xliff.getFile().getHeader().getPhaseGroup().removePhase(phase);
                break;
            }
            ++i;
        }
    }

    public void removeText(String id, String restype) throws TextNotFoundException {
        TransUnit transUnit;
        Group group = this.getGroup(restype);
        if (group != null) {
            transUnit = this.getTransUnit(group, id);
            if (transUnit == null) {
                MessageFormat mf = new MessageFormat(res.getString("ymsg_TextDoesNotExist"));
                Object[] obj = new Object[]{id, restype};
                throw new TextNotFoundException(mf.format(obj));
            }
        } else {
            MessageFormat mf = new MessageFormat(res.getString("ymsg_NoTextsForRestype"));
            Object[] obj = new Object[]{restype};
            throw new TextNotFoundException(mf.format(obj));
        }
        group.removeTransUnit(transUnit);
    }

    public boolean isCodepageValidationON() {
        return this.codepageValidation;
    }

    public SourceValidator getSourceTextValidator() {
        return this.sourcevalidator;
    }

    public boolean isValid() throws IOException, ParserConfigurationException, SAXException, ValidationException {
        this.errorMessages.clear();
        return this.xliff.isValid();
    }

    public boolean isValidRSX() throws IOException, ParserConfigurationException, SAXException, ValidationException {
        this.errorMessages.clear();
        return this.xliff.isValidRSX();
    }

    public boolean isValidISX() throws IOException, ParserConfigurationException, SAXException, ValidationException {
        this.errorMessages.clear();
        return this.xliff.isValidISX();
    }

    public void modifyMaxwidth(String id, String xliffRestype, String newMaxwidth) throws TextNotFoundException, ValidationException {
        StringBuffer errorMsg = new StringBuffer();
        RestypeValue restype = null;
        errorMsg.append(this.validator.checkAgainstSchema("restype", xliffRestype));
        if (errorMsg.length() == 0) {
            restype = this.s2xTypes.getRestype(xliffRestype, "XLIFF");
        }
        errorMsg.append(this.validator.checkAgainstSchema("maxwidth", newMaxwidth));
        if (errorMsg.length() > 0) {
            throw new ValidationException(errorMsg.toString());
        }
        TransUnit transUnit = this.getTransUnit(xliffRestype, id);
        if (restype != null) {
            errorMsg.append(this.validator.checkTextLength(transUnit.getSource(), restype, (int)new Integer(newMaxwidth), (int)new Integer(this.getMaxLength())));
        }
        if (errorMsg.length() > 0) {
            throw new ValidationException(errorMsg.toString());
        }
        transUnit.setMaxwidth(new Integer(newMaxwidth));
    }

    public void modifyText(String newText, String id, String xliffRestype) throws TextNotFoundException, ValidationException {
        String err;
        TransUnit transUnit;
        StringBuffer errorMsg = new StringBuffer();
        RestypeValue restype = null;
        errorMsg.append(this.validator.checkAgainstSchema("restype", xliffRestype));
        if (errorMsg.length() == 0) {
            restype = this.s2xTypes.getRestype(xliffRestype, "XLIFF");
        }
        if ((transUnit = this.getTransUnit(xliffRestype, id)) == null) {
            MessageFormat mf = new MessageFormat(res.getString("ymsg_TextDoesNotExist"));
            Object[] obj = new Object[]{id, restype};
            throw new TextNotFoundException(mf.format(obj));
        }
        if (restype != null) {
            errorMsg.append(this.validator.checkTextLength(newText, restype, (int)new Integer(transUnit.getMaxwidth()), (int)new Integer(this.getMaxLength())));
        }
        if (errorMsg.length() > 0) {
            throw new ValidationException(errorMsg.toString());
        }
        if (this.isCodepageValidationON() && !(err = this.validator.checkAgainstCodepage(newText, S2XTypes.getInstance().getLangtype(this.getSourceLanguage(), "XLIFF"))).equals("")) {
            throw new ValidationException(err);
        }
        transUnit.setSource(newText);
    }

    private void load(String uri) throws IOException, ParserConfigurationException, SAXException, ValidationException {
        if (uri == null) {
            throw new IllegalArgumentException(res.getString("ymsg_URINull"));
        }
        InputSource in = new InputSource(uri);
        this.load(in);
    }

    private void load(File f) throws IOException, ParserConfigurationException, SAXException, ValidationException {
        if (f == null) {
            MessageFormat mf = new MessageFormat(res.getString("ymsg_FileNull"));
            Object[] obj = new Object[]{"java.io.File", "null"};
            throw new IllegalArgumentException(mf.format(obj));
        }
        String uri = "file:" + f.getAbsolutePath();
        if (File.separatorChar == '\\') {
            uri = uri.replace('\\', '/');
        }
        InputSource in = new InputSource(uri);
        this.load(in);
    }

    private void load(InputStream is) throws IOException, ParserConfigurationException, SAXException, ValidationException {
        if (is == null) {
            MessageFormat mf = new MessageFormat(res.getString("ymsg_InputStreamNull"));
            Object[] obj = new Object[]{"java.io.InputStream", "null"};
            throw new IllegalArgumentException(mf.format(obj));
        }
        InputSource in = new InputSource(is);
        this.load(in);
    }

    private void load(InputStream is, String systemId) throws IOException, ParserConfigurationException, SAXException, ValidationException {
        if (is == null) {
            MessageFormat mf = new MessageFormat(res.getString("ymsg_InputStreamNull"));
            Object[] obj = new Object[]{"java.io.InputStream", "null"};
            throw new IllegalArgumentException(mf.format(obj));
        }
        InputSource in = new InputSource(is);
        in.setSystemId(systemId);
        this.load(in);
    }

    private void load(InputSource in) throws IOException, ParserConfigurationException, SAXException, ValidationException {
        int j;
        int i;
        String crc;
        Object[] obj2;
        MessageFormat mf2;
        Element header;
        EscapeHandler esc = new EscapeHandler();
        this.errorMessages.clear();
        this.errorMessagesLoadRSX.clear();
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(this.getClass().getClassLoader());
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setExpandEntityReferences(true);
        factory.setValidating(true);
        DocumentBuilder builder = factory.newDocumentBuilder();
        builder.setErrorHandler(new S2XErrorHandler(this));
        Thread.currentThread().setContextClassLoader(cl);
        Document document = builder.parse(in);
        Element root = document.getDocumentElement();
        if (root == null || !root.getNodeName().equals("xliff")) {
            MessageFormat mf2 = new MessageFormat(res.getString("ymsg_ElementNotExists"));
            Object[] obj2 = new Object[]{"xliff"};
            throw new ValidationException(mf2.format(obj2));
        }
        if (root.getAttribute("version") != null) {
            this.xliff.setVersion(root.getAttribute("version"));
        }
        if ((header = (Element)root.getElementsByTagName("header").item(0)) == null) {
            MessageFormat mf2 = new MessageFormat(res.getString("ymsg_FatalError"));
            Object[] obj2 = new Object[]{"header"};
            throw new ValidationException(mf2.format(obj2));
        }
        Element current = (Element)root.getElementsByTagName("file").item(0);
        if (current != null) {
            if (current.getAttribute("datatype") != null) {
                DatatypeValue datatype = this.s2xTypes.getDatatype(current.getAttribute("datatype"), "XLIFF");
                if (datatype != null) {
                    this.xliff.getFile().setDatatype(datatype);
                } else {
                    this.xliff.getFile().getDatatype().setXLIFFValue(current.getAttribute("datatype"));
                }
            } else {
                this.xliff.getFile().getDatatype().setXLIFFValue("");
                mf2 = new MessageFormat(res.getString("ymsg_AttributeNoValue"));
                obj2 = new Object[]{"datatype"};
                this.errorMessagesLoadRSX.add(mf2.format(obj2));
            }
            if (current.getAttribute("original") != null) {
                this.xliff.getFile().setOriginal(current.getAttribute("original"));
            } else {
                this.xliff.getFile().setOriginal("");
                mf2 = new MessageFormat(res.getString("ymsg_AttributeNoValue"));
                obj2 = new Object[]{"original"};
                this.errorMessagesLoadRSX.add(mf2.format(obj2));
            }
            if (current.getAttribute("product-name") != null) {
                this.xliff.getFile().setProductname(current.getAttribute("product-name"));
            } else {
                this.xliff.getFile().setOriginal("");
                mf2 = new MessageFormat(res.getString("ymsg_AttributeNoValue"));
                obj2 = new Object[]{"product-name"};
                this.errorMessagesLoadRSX.add(mf2.format(obj2));
            }
            if (current.getAttribute("source-language") != null) {
                LangType langType = this.s2xTypes.getLangtype(current.getAttribute("source-language"), "XLIFF");
                if (langType != null) {
                    this.xliff.getFile().setSourceLanguage(langType);
                } else {
                    this.xliff.getFile().getSourceLanguage().setXLIFFValue(current.getAttribute("source-language"));
                    mf2 = new MessageFormat(res.getString("ymsg_wrongSourceLangu"));
                    obj2 = new Object[]{current.getAttribute("source-language")};
                    this.errorMessagesLoadRSX.add(mf2.format(obj2));
                }
            } else {
                this.xliff.getFile().getSourceLanguage().setXLIFFValue("");
                mf2 = new MessageFormat(res.getString("ymsg_AttributeNoValue3"));
                obj2 = new Object[]{"source-language"};
                this.errorMessagesLoadRSX.add(mf2.format(obj2));
            }
            if (current.getAttribute("tool") != null) {
                this.setTool(current.getAttribute("tool"));
            }
        } else {
            MessageFormat mf2 = new MessageFormat(res.getString("ymsg_FatalError"));
            Object[] obj2 = new Object[]{"file"};
            throw new ValidationException(mf2.format(obj2));
        }
        current = (Element)header.getElementsByTagName("external-file").item(0);
        if (current != null) {
            crc = new String("");
            String href = new String("");
            String uid = new String("");
            if (current.getAttribute("crc") != null) {
                crc = current.getAttribute("crc");
            }
            if (current.getAttribute("href") != null) {
                href = current.getAttribute("href");
            }
            if (current.getAttribute("uid") != null) {
                uid = current.getAttribute("uid");
            }
            this.xliff.getFile().getHeader().getSkl().getExternalFile().setCrc(crc);
            this.xliff.getFile().getHeader().getSkl().getExternalFile().setHref(href);
            this.xliff.getFile().getHeader().getSkl().getExternalFile().setUid(uid);
        }
        if ((current = (Element)header.getElementsByTagName("internal-file").item(0)) != null) {
            crc = new String("");
            String content = new String("");
            String form = new String("");
            if (current.getAttribute("crc") != null) {
                crc = current.getAttribute("crc");
            }
            if (current.getFirstChild() != null && current.getFirstChild().getNodeValue() != null) {
                content = current.getFirstChild().getNodeValue();
            }
            if (current.getAttribute("form") != null) {
                form = current.getAttribute("form");
            }
            this.setInternalFile(crc, form, content);
        }
        if ((current = (Element)header.getElementsByTagName("phase-group").item(0)) != null) {
            NodeList phases = current.getElementsByTagName("phase");
            i = 0;
            while (i < phases.getLength()) {
                String phaseName = new String("");
                String processName = new String("");
                String tool = new String("");
                String[] notesContent = new String[]{};
                current = (Element)phases.item(i);
                if (current.getAttribute("phase-name") != null) {
                    phaseName = current.getAttribute("phase-name");
                }
                if (current.getAttribute("process-name") != null) {
                    processName = current.getAttribute("process-name");
                }
                if (current.getAttribute("tool") != null) {
                    tool = current.getAttribute("tool");
                }
                if (current.hasChildNodes()) {
                    PhaseTypeItem phaseTypeItem = new PhaseTypeItem();
                    NodeList notes = current.getElementsByTagName("note");
                    notesContent = new String[notes.getLength()];
                    j = 0;
                    while (j < notes.getLength()) {
                        if (notes.item(j).getFirstChild() != null && notes.item(j).getFirstChild().getNodeValue() != null) {
                            notesContent[j] = notes.item(j).getFirstChild().getNodeValue();
                        }
                        ++j;
                    }
                }
                if (phaseName != null && !phaseName.equals("")) {
                    Phase phase = new Phase();
                    phase.setPhaseName(phaseName);
                    phase.setProcessName(processName);
                    phase.setTool(tool);
                    if (notesContent.length > 0) {
                        phase.getPhaseTypeItem(0).setNote(notesContent);
                    }
                    this.xliff.getFile().getHeader().getPhaseGroup().addPhase(phase);
                }
                ++i;
            }
        }
        if ((current = (Element)header.getElementsByTagName("s2x").item(0)) == null) {
            mf2 = new MessageFormat(res.getString("ymsg_ElementAutoCorrect"));
            obj2 = new Object[]{"s2x"};
            this.errorMessagesLoadRSX.add(mf2.format(obj2));
        }
        if ((current = (Element)header.getElementsByTagName("dtr").item(0)) == null) {
            mf2 = new MessageFormat(res.getString("ymsg_ElementAutoCorrect"));
            obj2 = new Object[]{"dtr"};
            this.errorMessagesLoadRSX.add(mf2.format(obj2));
        }
        if ((current = (Element)header.getElementsByTagName("dc").item(0)) != null && current.getFirstChild() != null) {
            if (current.getFirstChild().getNodeValue() != null && !current.getFirstChild().getNodeValue().equals("")) {
                this.xliff.getFile().getHeader().getS2x().getDtr().setDc(current.getFirstChild().getNodeValue());
            } else {
                this.xliff.getFile().getHeader().getS2x().getDtr().setDc("");
                mf2 = new MessageFormat(res.getString("ymsg_ElementNoValue"));
                obj2 = new Object[]{"dc"};
                this.errorMessagesLoadRSX.add(mf2.format(obj2));
            }
        } else {
            this.xliff.getFile().getHeader().getS2x().getDtr().setDc("");
            mf2 = new MessageFormat(res.getString("ymsg_ElementNotExists2"));
            obj2 = new Object[]{"dc"};
            this.errorMessagesLoadRSX.add(mf2.format(obj2));
        }
        current = (Element)header.getElementsByTagName("rel").item(0);
        if (current != null && current.getFirstChild() != null) {
            if (current.getFirstChild().getNodeValue() != null && !current.getFirstChild().getNodeValue().equals("")) {
                this.xliff.getFile().getHeader().getS2x().getDtr().setRel(current.getFirstChild().getNodeValue());
            } else {
                this.xliff.getFile().getHeader().getS2x().getDtr().setRel("");
                mf2 = new MessageFormat(res.getString("ymsg_ElementNoValue"));
                obj2 = new Object[]{"rel"};
                this.errorMessagesLoadRSX.add(mf2.format(obj2));
            }
        } else {
            this.xliff.getFile().getHeader().getS2x().getDtr().setRel("");
            mf2 = new MessageFormat(res.getString("ymsg_ElementNotExists3"));
            obj2 = new Object[]{"rel"};
            this.errorMessagesLoadRSX.add(mf2.format(obj2));
        }
        current = (Element)header.getElementsByTagName("sc").item(0);
        if (current != null && current.getFirstChild() != null && current.getFirstChild().getNodeValue() != null) {
            this.setSc(current.getFirstChild().getNodeValue());
        }
        if ((current = (Element)header.getElementsByTagName("giltDirectives").item(0)) == null) {
            mf2 = new MessageFormat(res.getString("ymsg_ElementAutoCorrect"));
            obj2 = new Object[]{"giltDirectives"};
            this.errorMessagesLoadRSX.add(mf2.format(obj2));
        }
        if ((current = (Element)header.getElementsByTagName("develContact").item(0)) != null && current.getFirstChild() != null) {
            if (current.getFirstChild().getNodeValue() != null) {
                this.xliff.getFile().getHeader().getS2x().getGiltDirectives().setDevelContact(current.getFirstChild().getNodeValue());
            } else {
                this.xliff.getFile().getHeader().getS2x().getGiltDirectives().setDevelContact("");
                mf2 = new MessageFormat(res.getString("ymsg_ElementNoValue"));
                obj2 = new Object[]{"develContact"};
                this.errorMessagesLoadRSX.add(mf2.format(obj2));
            }
        } else {
            this.xliff.getFile().getHeader().getS2x().getGiltDirectives().setDevelContact("");
            mf2 = new MessageFormat(res.getString("ymsg_ElementNotExists"));
            obj2 = new Object[]{"develContact"};
            this.errorMessagesLoadRSX.add(mf2.format(obj2));
        }
        current = (Element)header.getElementsByTagName("domain").item(0);
        if (current != null && current.getFirstChild() != null) {
            if (current.getFirstChild().getNodeValue() != null && !current.getFirstChild().getNodeValue().equals("")) {
                this.xliff.getFile().getHeader().getS2x().getGiltDirectives().getDomain().setXLIFFValue(current.getFirstChild().getNodeValue());
            } else {
                this.xliff.getFile().getHeader().getS2x().getGiltDirectives().getDomain().setXLIFFValue("");
                mf2 = new MessageFormat(res.getString("ymsg_ElementNoValue1"));
                obj2 = new Object[]{"domain"};
                this.errorMessagesLoadRSX.add(mf2.format(obj2));
            }
        } else {
            this.xliff.getFile().getHeader().getS2x().getGiltDirectives().getDomain().setXLIFFValue("");
            mf2 = new MessageFormat(res.getString("ymsg_ElementNotExists4"));
            obj2 = new Object[]{"domain"};
            this.errorMessagesLoadRSX.add(mf2.format(obj2));
        }
        current = (Element)header.getElementsByTagName("collection").item(0);
        if (current != null && current.getFirstChild() != null && current.getFirstChild().getNodeValue() != null) {
            this.xliff.getFile().getHeader().getS2x().getGiltDirectives().setCollection(current.getFirstChild().getNodeValue());
        } else {
            mf2 = new MessageFormat(res.getString("ymsg_ElementNotExists4"));
            obj2 = new Object[]{"collection"};
            this.errorMessagesLoadRSX.add(mf2.format(obj2));
        }
        current = (Element)header.getElementsByTagName("originalLocale").item(0);
        if (current != null) {
            if (current.getAttribute("xml:lang") != null) {
                LangType lang = this.s2xTypes.getLangtype(current.getAttribute("xml:lang"), "XLIFF");
                if (lang != null) {
                    this.xliff.getFile().getHeader().getS2x().getGiltDirectives().getOriginalLocale().setLang(lang);
                } else {
                    this.xliff.getFile().getHeader().getS2x().getGiltDirectives().getOriginalLocale().getLang().setXLIFFValue(current.getAttribute("xml:lang"));
                }
            } else {
                this.xliff.getFile().getHeader().getS2x().getGiltDirectives().getOriginalLocale().getLang().setXLIFFValue("");
                mf2 = new MessageFormat(res.getString("ymsg_AttributeNoValue1"));
                obj2 = new Object[]{"xml:lang"};
                obj2[1] = "originalLocale";
                this.errorMessagesLoadRSX.add(mf2.format(obj2));
            }
        } else {
            this.xliff.getFile().getHeader().getS2x().getGiltDirectives().getOriginalLocale().getLang().setXLIFFValue("");
            mf2 = new MessageFormat(res.getString("ymsg_AttributeNotExits"));
            obj2 = new Object[]{"xml:lang", "originalLocale"};
            this.errorMessagesLoadRSX.add(mf2.format(obj2));
        }
        current = (Element)header.getElementsByTagName("maxLength").item(0);
        if (current != null && current.getFirstChild() != null && current.getFirstChild().getNodeValue() != null) {
            this.xliff.getFile().getHeader().getS2x().getGiltDirectives().setMaxLength(current.getFirstChild().getNodeValue());
        } else {
            mf2 = new MessageFormat(res.getString("ymsg_SetMLToDefault"));
            obj2 = new Object[]{"maxLength", new Integer(255)};
            this.errorMessagesLoadRSX.add(mf2.format(obj2));
        }
        Element body = (Element)root.getElementsByTagName("body").item(0);
        if (body == null) {
            mf2 = new MessageFormat(res.getString("ymsg_ElementNotExists"));
            obj2 = new Object[]{"body"};
            this.errorMessagesLoadRSX.add(mf2.format(obj2));
        } else {
            NodeList groups = body.getElementsByTagName("group");
            if (body.getChildNodes().getLength() > groups.getLength() * 2 + 1) {
                this.errorMessagesLoadRSX.add(res.getString("ymsg_missingGroup"));
            }
            i = 0;
            while (i < groups.getLength()) {
                current = (Element)groups.item(i);
                if (current.getAttribute("restype") != null && !current.getAttribute("restype").equals("")) {
                    String restype = current.getAttribute("restype");
                    RestypeValue restypeValue = this.s2xTypes.getRestype(restype, "XLIFF");
                    if (restypeValue != null) {
                        Group group = null;
                        group = this.getGroup(restypeValue.getXLIFFValue());
                        if (group == null) {
                            group = new Group();
                            group.setRestype(restypeValue);
                            this.xliff.getFile().getBody().addGroup(group);
                        }
                        NodeList transunits = current.getElementsByTagName("trans-unit");
                        int len = transunits.getLength();
                        j = 0;
                        while (j < len) {
                            current = (Element)transunits.item(j);
                            if (current != null) {
                                TransUnit tu = new TransUnit();
                                String id = current.getAttribute("id") != null ? current.getAttribute("id") : "";
                                tu.setId(id);
                                String maxwidth = current.getAttribute("maxwidth") != null && !current.getAttribute("maxwidth").equals("") ? current.getAttribute("maxwidth") : "0";
                                tu.setMaxwidth(new Integer(maxwidth));
                                String resname = current.getAttribute("resname") != null ? current.getAttribute("resname") : id;
                                tu.setResname(resname);
                                String translate = current.getAttribute("translate") != null ? current.getAttribute("translate") : "yes";
                                tu.setTranslate(translate);
                                current = (Element)current.getElementsByTagName("source").item(0);
                                String source = current != null && current.getFirstChild() != null && current.getFirstChild().getNodeValue() != null ? esc.unescape(current.getFirstChild().getNodeValue()) : "";
                                tu.setSource(source);
                                TranslationUnit tunit = null;
                                try {
                                    tunit = this.getText(id);
                                }
                                catch (TextNotFoundException tnfe) {
                                    // empty catch block
                                }
                                if (tunit == null) {
                                    group.addTransUnit(tu);
                                } else {
                                    if (resname.equals(id)) {
                                        mf2 = new MessageFormat(res.getString("ymsg_DuplicateID1"));
                                        obj2 = new Object[]{id, source};
                                    } else {
                                        mf2 = new MessageFormat(res.getString("ymsg_DuplicateID2"));
                                        obj2 = new Object[]{id, source, resname};
                                    }
                                    this.errorMessagesLoadRSX.add(mf2.format(obj2));
                                }
                            }
                            ++j;
                        }
                    } else {
                        mf2 = new MessageFormat(res.getString("ymsg_wrongRestype"));
                        obj2 = new Object[]{restype};
                        this.errorMessagesLoadRSX.add(mf2.format(obj2));
                    }
                } else {
                    this.errorMessagesLoadRSX.add(res.getString("ymsg_noRestype"));
                }
                ++i;
            }
        }
    }

    private void loadMSX(String uri) throws IOException, ParserConfigurationException, SAXException, ValidationException {
        if (uri == null) {
            throw new IllegalArgumentException(res.getString("ymsg_URINull"));
        }
        InputSource in = new InputSource(uri);
        this.loadMSX(in);
    }

    private void loadMSX(File f) throws IOException, ParserConfigurationException, SAXException, ValidationException {
        if (f == null) {
            MessageFormat mf = new MessageFormat(res.getString("ymsg_FileNull"));
            Object[] obj = new Object[]{"java.io.File", "null"};
            throw new IllegalArgumentException(mf.format(obj));
        }
        String uri = "file:" + f.getAbsolutePath();
        if (File.separatorChar == '\\') {
            uri = uri.replace('\\', '/');
        }
        InputSource in = new InputSource(uri);
        this.loadMSX(in);
    }

    private void loadMSX(InputStream is) throws IOException, ParserConfigurationException, SAXException, ValidationException {
        if (is == null) {
            MessageFormat mf = new MessageFormat(res.getString("ymsg_InputStreamNull"));
            Object[] obj = new Object[]{"java.io.InputStream", "null"};
            throw new IllegalArgumentException(mf.format(obj));
        }
        InputSource in = new InputSource(is);
        this.loadMSX(in);
    }

    private void loadMSX(InputStream is, String systemId) throws IOException, ParserConfigurationException, SAXException, ValidationException {
        if (is == null) {
            MessageFormat mf = new MessageFormat(res.getString("ymsg_InputStreamNull"));
            Object[] obj = new Object[]{"java.io.InputStream", "null"};
            throw new IllegalArgumentException(mf.format(obj));
        }
        InputSource in = new InputSource(is);
        in.setSystemId(systemId);
        this.loadMSX(in);
    }

    private void loadMSX(InputSource in) throws IOException, ParserConfigurationException, SAXException, ValidationException {
        int j;
        int i;
        String crc;
        StringBuffer errorMsg = new StringBuffer();
        EscapeHandler esc = new EscapeHandler();
        this.setCodepageValidation(false);
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(this.getClass().getClassLoader());
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setExpandEntityReferences(true);
        factory.setValidating(true);
        DocumentBuilder builder = factory.newDocumentBuilder();
        builder.setErrorHandler(new S2XErrorHandler(this));
        Thread.currentThread().setContextClassLoader(cl);
        Document document = builder.parse(in);
        Element root = document.getDocumentElement();
        this.xliff.setVersion(root.getAttribute("version"));
        Element header = (Element)root.getElementsByTagName("header").item(0);
        Element current = (Element)root.getElementsByTagName("file").item(0);
        if (current != null && current.getFirstChild().getNodeValue() != null) {
            try {
                this.setOriginal(current.getAttribute("original"));
            }
            catch (ValidationException ve) {
                errorMsg.append(ve.getMessage());
            }
            try {
                this.setProductname(current.getAttribute("product-name"));
            }
            catch (Exception ve) {
                errorMsg.append(ve.getMessage());
            }
            try {
                this.setSourceLanguage(this.s2xTypes.getLangtype(current.getAttribute("source-language"), "SAP").getXLIFFValue());
            }
            catch (ValidationException ve) {
                errorMsg.append(ve.getMessage());
            }
        } else {
            errorMsg.append("File can't be null!");
        }
        current = (Element)header.getElementsByTagName("external-file").item(0);
        if (current != null) {
            crc = new String("");
            String href = new String("");
            String uid = new String("");
            if (current.getAttribute("crc") != null) {
                crc = current.getAttribute("crc");
            }
            if (current.getAttribute("href") != null) {
                href = current.getAttribute("href");
            }
            if (current.getAttribute("uid") != null) {
                uid = current.getAttribute("uid");
            }
            try {
                this.setExternalFile(crc, href, uid);
            }
            catch (ValidationException ve) {
                errorMsg.append(ve.getMessage());
            }
        }
        if ((current = (Element)header.getElementsByTagName("internal-file").item(0)) != null) {
            crc = new String("");
            String content = new String("");
            String form = new String("");
            if (current.getAttribute("crc") != null) {
                crc = current.getAttribute("crc");
            }
            if (current.getFirstChild().getNodeValue() != null) {
                content = current.getFirstChild().getNodeValue();
            }
            if (current.getAttribute("form") != null) {
                form = current.getAttribute("form");
            }
            this.setInternalFile(crc, form, content);
        }
        if ((current = (Element)header.getElementsByTagName("phase-group").item(0)) != null) {
            NodeList phases = current.getElementsByTagName("phase");
            i = 0;
            while (i < phases.getLength()) {
                String phaseName = new String("");
                String processName = new String("");
                String tool = new String("");
                String[] notesContent = new String[]{};
                current = (Element)phases.item(i);
                if (current.getAttribute("phase-name") != null) {
                    phaseName = current.getAttribute("phase-name");
                }
                if (current.getAttribute("process-name") != null) {
                    processName = current.getAttribute("process-name");
                }
                if (current.getAttribute("tool") != null) {
                    tool = current.getAttribute("tool");
                }
                if (current.hasChildNodes()) {
                    PhaseTypeItem phaseTypeItem = new PhaseTypeItem();
                    NodeList notes = current.getElementsByTagName("note");
                    notesContent = new String[notes.getLength()];
                    j = 0;
                    while (j < notes.getLength()) {
                        if (notes.item(j).getFirstChild().getNodeValue() != null) {
                            notesContent[j] = notes.item(j).getFirstChild().getNodeValue();
                        }
                        ++j;
                    }
                }
                try {
                    this.addPhase(phaseName, processName, tool, notesContent);
                }
                catch (Exception ve) {
                    errorMsg.append(ve.getMessage());
                }
                ++i;
            }
        }
        if ((current = (Element)header.getElementsByTagName("dc").item(0)) != null && current.getFirstChild() != null && current.getFirstChild().getNodeValue() != null) {
            try {
                this.setDc(current.getFirstChild().getNodeValue());
            }
            catch (Exception ve) {
                errorMsg.append(ve.getMessage());
            }
        }
        if ((current = (Element)header.getElementsByTagName("rel").item(0)) != null && current.getFirstChild().getNodeValue() != null) {
            try {
                this.setRel(current.getFirstChild().getNodeValue());
            }
            catch (ValidationException ve) {
                errorMsg.append(ve.getMessage());
            }
        }
        if ((current = (Element)header.getElementsByTagName("sc").item(0)) != null && current.getFirstChild() != null && current.getFirstChild().getNodeValue() != null) {
            this.setSc(current.getFirstChild().getNodeValue());
        } else {
            errorMsg.append("sc can't be null!");
        }
        current = (Element)header.getElementsByTagName("develContact").item(0);
        if (current != null && current.getFirstChild().getNodeValue() != null) {
            try {
                this.setDevelContact(current.getFirstChild().getNodeValue());
            }
            catch (ValidationException ve) {
                errorMsg.append(ve.getMessage());
            }
        } else {
            errorMsg.append("developer Contact can't be null!");
        }
        current = (Element)header.getElementsByTagName("domain").item(0);
        if (current != null && current.getFirstChild().getNodeValue() != null) {
            String domain = this.s2xTypes.getDomaintype(current.getFirstChild().getNodeValue(), "SAP").getXLIFFValue();
            try {
                this.setDomain(domain);
            }
            catch (ValidationException ve) {
                errorMsg.append(ve.getMessage());
            }
        } else {
            errorMsg.append("Domain can't be null.");
        }
        current = (Element)header.getElementsByTagName("collection").item(0);
        if (current != null && current.getFirstChild().getNodeValue() != null) {
            try {
                this.setCollection(current.getFirstChild().getNodeValue());
            }
            catch (ValidationException ve) {
                errorMsg.append(ve.getMessage());
            }
        } else {
            errorMsg.append("Collection can't be null.");
        }
        current = (Element)header.getElementsByTagName("originalLocale").item(0);
        if (current != null && current.getAttribute("xml:lang") != null) {
            try {
                this.setOriginalLocale(this.s2xTypes.getLangtype(current.getAttribute("xml:lang"), "SAP").getXLIFFValue());
            }
            catch (ValidationException ve) {
                errorMsg.append(ve.getMessage());
            }
        } else {
            errorMsg.append("originalLocale can't be null.");
        }
        current = (Element)header.getElementsByTagName("maxLength").item(0);
        if (current != null && current.getFirstChild().getNodeValue() != null) {
            try {
                this.setMaxLength(current.getFirstChild().getNodeValue());
            }
            catch (ValidationException ve) {
                errorMsg.append(ve.getMessage());
            }
        }
        Element body = (Element)root.getElementsByTagName("body").item(0);
        NodeList groups = body.getElementsByTagName("group");
        i = 0;
        while (i < groups.getLength()) {
            current = (Element)groups.item(i);
            String sapRestype = current.getAttribute("restype");
            NodeList transunits = current.getElementsByTagName("trans-unit");
            int len = transunits.getLength();
            j = 0;
            while (j < len) {
                current = (Element)transunits.item(j);
                String id = current.getAttribute("id") != null ? current.getAttribute("id") : "";
                String maxwidth = current.getAttribute("maxwidth") != null && !current.getAttribute("maxwidth").equals("") ? current.getAttribute("maxwidth") : "0";
                String resname = id;
                Boolean translate = current.getAttribute("translate").toLowerCase().equals("no") ? new Boolean(false) : new Boolean(true);
                current = (Element)current.getElementsByTagName("source").item(0);
                String source = current.getFirstChild().getNodeValue() != null ? esc.unescape(current.getFirstChild().getNodeValue()) : "";
                try {
                    if (current.getAttribute("translate") != null) {
                        this.addText(source, id, resname, sapRestype, maxwidth, false, translate);
                    } else {
                        this.addText(source, id, resname, sapRestype, maxwidth, false);
                    }
                }
                catch (Exception ve) {
                    errorMsg.append(ve.getMessage());
                }
                ++j;
            }
            ++i;
        }
        if (errorMsg.length() > 0) {
            throw new ValidationException(errorMsg.toString());
        }
    }

    private void loadRSX(String uri) throws IOException, ParserConfigurationException, SAXException, ValidationException {
        if (uri == null) {
            throw new IllegalArgumentException(res.getString("ymsg_URINull"));
        }
        InputSource in = new InputSource(uri);
        this.loadRSX(in);
    }

    private void loadRSX(File f) throws IOException, ParserConfigurationException, SAXException, ValidationException {
        if (f == null) {
            MessageFormat mf = new MessageFormat(res.getString("ymsg_FileNull"));
            Object[] obj = new Object[]{"java.io.File", "null"};
            throw new IllegalArgumentException(mf.format(obj));
        }
        this.fileName = f.getAbsolutePath();
        String uri = "file:" + f.getAbsolutePath();
        if (File.separatorChar == '\\') {
            uri = uri.replace('\\', '/');
        }
        InputSource in = new InputSource(uri);
        this.loadRSX(in);
    }

    private void loadRSX(InputStream is) throws IOException, ParserConfigurationException, SAXException, ValidationException {
        if (is == null) {
            MessageFormat mf = new MessageFormat(res.getString("ymsg_InputStreamNull"));
            Object[] obj = new Object[]{"java.io.InputStream", "null"};
            throw new IllegalArgumentException(mf.format(obj));
        }
        InputSource in = new InputSource(is);
        this.loadRSX(in);
    }

    private void loadRSX(InputStream is, String systemId) throws IOException, ParserConfigurationException, SAXException, ValidationException {
        if (is == null) {
            MessageFormat mf = new MessageFormat(res.getString("ymsg_InputStreamNull"));
            Object[] obj = new Object[]{"java.io.InputStream", "null"};
            throw new IllegalArgumentException(mf.format(obj));
        }
        InputSource in = new InputSource(is);
        in.setSystemId(systemId);
        this.loadRSX(in);
    }

    private void loadRSX(InputSource in) throws IOException, ParserConfigurationException, SAXException, ValidationException {
        int j;
        int i;
        String crc;
        Object[] obj2;
        MessageFormat mf2;
        Element header;
        EscapeHandler esc = new EscapeHandler();
        this.errorMessages.clear();
        this.errorMessagesLoadRSX.clear();
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(this.getClass().getClassLoader());
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setExpandEntityReferences(true);
        factory.setValidating(true);
        DocumentBuilder builder = factory.newDocumentBuilder();
        builder.setErrorHandler(new S2XErrorHandler(this));
        Thread.currentThread().setContextClassLoader(cl);
        Document document = builder.parse(in);
        Element root = document.getDocumentElement();
        if (root == null || !root.getNodeName().equals("xliff")) {
            MessageFormat mf2 = new MessageFormat(res.getString("ymsg_ElementNotExists"));
            Object[] obj2 = new Object[]{"xliff"};
            throw new ValidationException(mf2.format(obj2));
        }
        if (root.getAttribute("version") != null) {
            this.xliff.setVersion(root.getAttribute("version"));
        }
        if ((header = (Element)root.getElementsByTagName("header").item(0)) == null) {
            MessageFormat mf2 = new MessageFormat(res.getString("ymsg_FatalError"));
            Object[] obj2 = new Object[]{"header"};
            throw new ValidationException(mf2.format(obj2));
        }
        Element current = (Element)root.getElementsByTagName("file").item(0);
        if (current != null) {
            if (current.getAttribute("datatype") != null) {
                DatatypeValue datatype = this.s2xTypes.getDatatype(current.getAttribute("datatype"), "XLIFF");
                if (datatype != null) {
                    this.xliff.getFile().setDatatype(datatype);
                } else {
                    this.xliff.getFile().getDatatype().setXLIFFValue(current.getAttribute("datatype"));
                }
            } else {
                this.xliff.getFile().getDatatype().setXLIFFValue("");
                mf2 = new MessageFormat(res.getString("ymsg_AttributeNoValue"));
                obj2 = new Object[]{"datatype"};
                this.errorMessagesLoadRSX.add(mf2.format(obj2));
            }
            if (current.getAttribute("product-name") != null) {
                this.xliff.getFile().setProductname(current.getAttribute("product-name"));
            } else {
                this.xliff.getFile().setOriginal("");
                mf2 = new MessageFormat(res.getString("ymsg_AttributeNoValue"));
                obj2 = new Object[]{"product-name"};
                this.errorMessagesLoadRSX.add(mf2.format(obj2));
            }
            if (current.getAttribute("source-language") != null) {
                LangType langType = this.s2xTypes.getLangtype(current.getAttribute("source-language"), "XLIFF");
                if (langType != null) {
                    this.xliff.getFile().setSourceLanguage(langType);
                } else {
                    this.xliff.getFile().getSourceLanguage().setXLIFFValue(current.getAttribute("source-language"));
                    mf2 = new MessageFormat(res.getString("ymsg_wrongSourceLangu"));
                    obj2 = new Object[]{current.getAttribute("source-language")};
                    this.errorMessagesLoadRSX.add(mf2.format(obj2));
                }
            } else {
                this.xliff.getFile().getSourceLanguage().setXLIFFValue("");
                mf2 = new MessageFormat(res.getString("ymsg_AttributeNoValue3"));
                obj2 = new Object[]{"source-language"};
                this.errorMessagesLoadRSX.add(mf2.format(obj2));
            }
            if (current.getAttribute("tool") != null) {
                this.setTool(current.getAttribute("tool"));
            }
        } else {
            MessageFormat mf2 = new MessageFormat(res.getString("ymsg_FatalError"));
            Object[] obj2 = new Object[]{"file"};
            throw new ValidationException(mf2.format(obj2));
        }
        current = (Element)header.getElementsByTagName("external-file").item(0);
        if (current != null) {
            crc = new String("");
            String href = new String("");
            String uid = new String("");
            if (current.getAttribute("crc") != null) {
                crc = current.getAttribute("crc");
            }
            if (current.getAttribute("href") != null) {
                href = current.getAttribute("href");
            }
            if (current.getAttribute("uid") != null) {
                uid = current.getAttribute("uid");
            }
            this.xliff.getFile().getHeader().getSkl().getExternalFile().setCrc(crc);
            this.xliff.getFile().getHeader().getSkl().getExternalFile().setHref(href);
            this.xliff.getFile().getHeader().getSkl().getExternalFile().setUid(uid);
        }
        if ((current = (Element)header.getElementsByTagName("internal-file").item(0)) != null) {
            crc = new String("");
            String content = new String("");
            String form = new String("");
            if (current.getAttribute("crc") != null) {
                crc = current.getAttribute("crc");
            }
            if (current.getFirstChild() != null && current.getFirstChild().getNodeValue() != null) {
                content = current.getFirstChild().getNodeValue();
            }
            if (current.getAttribute("form") != null) {
                form = current.getAttribute("form");
            }
            this.setInternalFile(crc, form, content);
        }
        if ((current = (Element)header.getElementsByTagName("phase-group").item(0)) != null) {
            NodeList phases = current.getElementsByTagName("phase");
            i = 0;
            while (i < phases.getLength()) {
                String phaseName = new String("");
                String processName = new String("");
                String tool = new String("");
                String[] notesContent = new String[]{};
                current = (Element)phases.item(i);
                if (current.getAttribute("phase-name") != null) {
                    phaseName = current.getAttribute("phase-name");
                }
                if (current.getAttribute("process-name") != null) {
                    processName = current.getAttribute("process-name");
                }
                if (current.getAttribute("tool") != null) {
                    tool = current.getAttribute("tool");
                }
                if (current.hasChildNodes()) {
                    PhaseTypeItem phaseTypeItem = new PhaseTypeItem();
                    NodeList notes = current.getElementsByTagName("note");
                    notesContent = new String[notes.getLength()];
                    j = 0;
                    while (j < notes.getLength()) {
                        if (notes.item(j).getFirstChild() != null && notes.item(j).getFirstChild().getNodeValue() != null) {
                            notesContent[j] = notes.item(j).getFirstChild().getNodeValue();
                        }
                        ++j;
                    }
                }
                if (phaseName != null && !phaseName.equals("")) {
                    Phase phase = new Phase();
                    phase.setPhaseName(phaseName);
                    phase.setProcessName(processName);
                    phase.setTool(tool);
                    if (notesContent.length > 0) {
                        phase.getPhaseTypeItem(0).setNote(notesContent);
                    }
                    this.xliff.getFile().getHeader().getPhaseGroup().addPhase(phase);
                }
                ++i;
            }
        }
        if ((current = (Element)header.getElementsByTagName("s2x").item(0)) == null) {
            mf2 = new MessageFormat(res.getString("ymsg_ElementAutoCorrect"));
            obj2 = new Object[]{"s2x"};
            this.errorMessagesLoadRSX.add(mf2.format(obj2));
        }
        if ((current = (Element)header.getElementsByTagName("giltDirectives").item(0)) == null) {
            mf2 = new MessageFormat(res.getString("ymsg_ElementAutoCorrect"));
            obj2 = new Object[]{"giltDirectives"};
            this.errorMessagesLoadRSX.add(mf2.format(obj2));
        }
        if ((current = (Element)header.getElementsByTagName("develContact").item(0)) != null && current.getFirstChild() != null) {
            if (current.getFirstChild().getNodeValue() != null) {
                this.xliff.getFile().getHeader().getS2x().getGiltDirectives().setDevelContact(current.getFirstChild().getNodeValue());
            } else {
                this.xliff.getFile().getHeader().getS2x().getGiltDirectives().setDevelContact("");
                mf2 = new MessageFormat(res.getString("ymsg_ElementNoValue"));
                obj2 = new Object[]{"develContact"};
                this.errorMessagesLoadRSX.add(mf2.format(obj2));
            }
        } else {
            mf2 = new MessageFormat(res.getString("ymsg_ElementNotExists"));
            obj2 = new Object[]{"develContact"};
            this.errorMessagesLoadRSX.add(mf2.format(obj2));
        }
        current = (Element)header.getElementsByTagName("domain").item(0);
        if (current != null && current.getFirstChild() != null) {
            if (current.getFirstChild().getNodeValue() != null && !current.getFirstChild().getNodeValue().equals("")) {
                this.xliff.getFile().getHeader().getS2x().getGiltDirectives().getDomain().setXLIFFValue(current.getFirstChild().getNodeValue());
            } else {
                this.xliff.getFile().getHeader().getS2x().getGiltDirectives().getDomain().setXLIFFValue("");
            }
        }
        if ((current = (Element)header.getElementsByTagName("originalLocale").item(0)) != null) {
            if (current.getAttribute("xml:lang") != null) {
                LangType lang = this.s2xTypes.getLangtype(current.getAttribute("xml:lang"), "XLIFF");
                if (lang != null) {
                    this.xliff.getFile().getHeader().getS2x().getGiltDirectives().getOriginalLocale().setLang(lang);
                } else {
                    this.xliff.getFile().getHeader().getS2x().getGiltDirectives().getOriginalLocale().getLang().setXLIFFValue(current.getAttribute("xml:lang"));
                }
            } else {
                this.xliff.getFile().getHeader().getS2x().getGiltDirectives().getOriginalLocale().getLang().setXLIFFValue("");
                mf2 = new MessageFormat(res.getString("ymsg_AttributeNoValue1"));
                obj2 = new Object[]{"xml:lang"};
                obj2[1] = "originalLocale";
                this.errorMessagesLoadRSX.add(mf2.format(obj2));
            }
        } else {
            mf2 = new MessageFormat(res.getString("ymsg_AttributeNotExits"));
            obj2 = new Object[]{"xml:lang", "originalLocale"};
            this.errorMessagesLoadRSX.add(mf2.format(obj2));
        }
        current = (Element)header.getElementsByTagName("maxLength").item(0);
        if (current != null && current.getFirstChild().getNodeValue() != null) {
            this.xliff.getFile().getHeader().getS2x().getGiltDirectives().setMaxLength(current.getFirstChild().getNodeValue());
        } else {
            mf2 = new MessageFormat(res.getString("ymsg_SetMLToDefault"));
            obj2 = new Object[]{"maxLength", new Integer(255)};
            this.errorMessagesLoadRSX.add(mf2.format(obj2));
        }
        Element body = (Element)root.getElementsByTagName("body").item(0);
        if (body == null) {
            mf2 = new MessageFormat(res.getString("ymsg_ElementNotExists"));
            obj2 = new Object[]{"body"};
            this.errorMessagesLoadRSX.add(mf2.format(obj2));
        } else {
            NodeList groups = body.getElementsByTagName("group");
            if (body.getChildNodes().getLength() > groups.getLength() * 2 + 1) {
                this.errorMessagesLoadRSX.add(res.getString("ymsg_missingGroup"));
            }
            i = 0;
            while (i < groups.getLength()) {
                current = (Element)groups.item(i);
                if (current.getAttribute("restype") != null && !current.getAttribute("restype").equals("")) {
                    String restype = current.getAttribute("restype");
                    RestypeValue restypeValue = this.s2xTypes.getRestype(restype, "XLIFF");
                    if (restypeValue != null) {
                        Group group = null;
                        group = this.getGroup(restypeValue.getXLIFFValue());
                        if (group == null) {
                            group = new Group();
                            group.setRestype(restypeValue);
                            this.xliff.getFile().getBody().addGroup(group);
                        }
                        NodeList transunits = current.getElementsByTagName("trans-unit");
                        int len = transunits.getLength();
                        j = 0;
                        while (j < len) {
                            current = (Element)transunits.item(j);
                            if (current != null) {
                                TransUnit tu = new TransUnit();
                                String id = current.getAttribute("id") != null ? current.getAttribute("id") : "";
                                tu.setId(id);
                                String maxwidth = current.getAttribute("maxwidth") != null && !current.getAttribute("maxwidth").equals("") ? current.getAttribute("maxwidth") : "0";
                                tu.setMaxwidth(new Integer(maxwidth));
                                String translate = current.getAttribute("translate") != null && !current.getAttribute("maxwidth").equals("") ? current.getAttribute("translate") : "yes";
                                tu.setTranslate(translate);
                                String resname = current.getAttribute("resname") != null ? current.getAttribute("resname") : id;
                                tu.setResname(resname);
                                current = (Element)current.getElementsByTagName("source").item(0);
                                String source = current != null && current.getFirstChild() != null && current.getFirstChild().getNodeValue() != null ? esc.unescape(current.getFirstChild().getNodeValue()) : "";
                                tu.setSource(source);
                                TranslationUnit tunit = null;
                                try {
                                    tunit = this.getText(id);
                                }
                                catch (TextNotFoundException tnfe) {
                                    // empty catch block
                                }
                                if (tunit == null) {
                                    group.addTransUnit(tu);
                                } else {
                                    if (resname.equals(id)) {
                                        mf2 = new MessageFormat(res.getString("ymsg_DuplicateID1"));
                                        obj2 = new Object[]{id, source};
                                    } else {
                                        mf2 = new MessageFormat(res.getString("ymsg_DuplicateID2"));
                                        obj2 = new Object[]{id, source, resname};
                                    }
                                    this.errorMessagesLoadRSX.add(mf2.format(obj2));
                                }
                            }
                            ++j;
                        }
                    } else {
                        mf2 = new MessageFormat(res.getString("ymsg_wrongRestype"));
                        obj2 = new Object[]{restype};
                        this.errorMessagesLoadRSX.add(mf2.format(obj2));
                    }
                } else {
                    this.errorMessagesLoadRSX.add(res.getString("ymsg_noRestype"));
                }
                ++i;
            }
        }
    }

    private void loadISX(String uri) throws IOException, ParserConfigurationException, SAXException, ValidationException {
        if (uri == null) {
            throw new IllegalArgumentException(res.getString("ymsg_URINull"));
        }
        InputSource in = new InputSource(uri);
        this.loadISX(in);
    }

    private void loadISX(File f) throws IOException, ParserConfigurationException, SAXException, ValidationException {
        if (f == null) {
            MessageFormat mf = new MessageFormat(res.getString("ymsg_FileNull"));
            Object[] obj = new Object[]{"java.io.File", "null"};
            throw new IllegalArgumentException(mf.format(obj));
        }
        this.fileName = f.getAbsolutePath();
        String uri = "file:" + f.getAbsolutePath();
        if (File.separatorChar == '\\') {
            uri = uri.replace('\\', '/');
        }
        InputSource in = new InputSource(uri);
        this.loadISX(in);
    }

    private void loadISX(InputStream is) throws IOException, ParserConfigurationException, SAXException, ValidationException {
        if (is == null) {
            MessageFormat mf = new MessageFormat(res.getString("ymsg_InputStreamNull"));
            Object[] obj = new Object[]{"java.io.InputStream", "null"};
            throw new IllegalArgumentException(mf.format(obj));
        }
        InputSource in = new InputSource(is);
        this.loadISX(in);
    }

    private void loadISX(InputStream is, String systemId) throws IOException, ParserConfigurationException, SAXException, ValidationException {
        if (is == null) {
            MessageFormat mf = new MessageFormat(res.getString("ymsg_InputStreamNull"));
            Object[] obj = new Object[]{"java.io.InputStream", "null"};
            throw new IllegalArgumentException(mf.format(obj));
        }
        InputSource in = new InputSource(is);
        in.setSystemId(systemId);
        this.loadISX(in);
    }

    private void loadISX(InputSource in) throws IOException, ParserConfigurationException, SAXException, ValidationException {
        int j;
        int i;
        String crc;
        Object[] obj2;
        MessageFormat mf2;
        Element header;
        EscapeHandler esc = new EscapeHandler();
        this.errorMessages.clear();
        this.errorMessagesLoadRSX.clear();
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(this.getClass().getClassLoader());
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setExpandEntityReferences(true);
        factory.setValidating(true);
        DocumentBuilder builder = factory.newDocumentBuilder();
        builder.setErrorHandler(new S2XErrorHandler(this));
        Thread.currentThread().setContextClassLoader(cl);
        Document document = builder.parse(in);
        Element root = document.getDocumentElement();
        if (root == null || !root.getNodeName().equals("xliff")) {
            MessageFormat mf2 = new MessageFormat(res.getString("ymsg_ElementNotExists"));
            Object[] obj2 = new Object[]{"xliff"};
            throw new ValidationException(mf2.format(obj2));
        }
        if (root.getAttribute("version") != null) {
            this.xliff.setVersion(root.getAttribute("version"));
        }
        if ((header = (Element)root.getElementsByTagName("header").item(0)) == null) {
            MessageFormat mf2 = new MessageFormat(res.getString("ymsg_FatalError"));
            Object[] obj2 = new Object[]{"header"};
            throw new ValidationException(mf2.format(obj2));
        }
        Element current = (Element)root.getElementsByTagName("file").item(0);
        if (current != null) {
            if (current.getAttribute("datatype") != null) {
                DatatypeValue datatype = this.s2xTypes.getDatatype(current.getAttribute("datatype"), "XLIFF");
                if (datatype != null) {
                    this.xliff.getFile().setDatatype(datatype);
                } else {
                    this.xliff.getFile().getDatatype().setXLIFFValue(current.getAttribute("datatype"));
                }
            } else {
                this.xliff.getFile().getDatatype().setXLIFFValue("");
                mf2 = new MessageFormat(res.getString("ymsg_AttributeNoValue"));
                obj2 = new Object[]{"datatype"};
                this.errorMessagesLoadRSX.add(mf2.format(obj2));
            }
            if (current.getAttribute("original") != null) {
                this.xliff.getFile().setOriginal(current.getAttribute("original"));
            } else {
                this.xliff.getFile().setOriginal("");
                mf2 = new MessageFormat(res.getString("ymsg_AttributeNoValue"));
                obj2 = new Object[]{"original"};
                this.errorMessagesLoadRSX.add(mf2.format(obj2));
            }
            if (current.getAttribute("product-name") != null) {
                this.xliff.getFile().setProductname(current.getAttribute("product-name"));
            } else {
                this.xliff.getFile().setOriginal("");
                mf2 = new MessageFormat(res.getString("ymsg_AttributeNoValue"));
                obj2 = new Object[]{"product-name"};
                this.errorMessagesLoadRSX.add(mf2.format(obj2));
            }
            if (current.getAttribute("source-language") != null) {
                LangType langType = this.s2xTypes.getLangtype(current.getAttribute("source-language"), "XLIFF");
                if (langType != null) {
                    this.xliff.getFile().setSourceLanguage(langType);
                } else {
                    this.xliff.getFile().getSourceLanguage().setXLIFFValue(current.getAttribute("source-language"));
                    mf2 = new MessageFormat(res.getString("ymsg_wrongSourceLangu"));
                    obj2 = new Object[]{current.getAttribute("source-language")};
                    this.errorMessagesLoadRSX.add(mf2.format(obj2));
                }
            } else {
                this.xliff.getFile().getSourceLanguage().setXLIFFValue("");
                mf2 = new MessageFormat(res.getString("ymsg_AttributeNoValue3"));
                obj2 = new Object[]{"source-language"};
                this.errorMessagesLoadRSX.add(mf2.format(obj2));
            }
            if (current.getAttribute("tool") != null) {
                this.xliff.getFile().setTool(current.getAttribute("tool"));
            } else {
                this.xliff.getFile().setOriginal("");
                mf2 = new MessageFormat(res.getString("ymsg_ToolNoValue"));
                obj2 = new Object[]{"tool"};
                this.errorMessagesLoadRSX.add(mf2.format(obj2));
            }
        } else {
            MessageFormat mf2 = new MessageFormat(res.getString("ymsg_FatalError"));
            Object[] obj2 = new Object[]{"file"};
            throw new ValidationException(mf2.format(obj2));
        }
        current = (Element)header.getElementsByTagName("external-file").item(0);
        if (current != null) {
            crc = new String("");
            String href = new String("");
            String uid = new String("");
            if (current.getAttribute("crc") != null) {
                crc = current.getAttribute("crc");
            }
            if (current.getAttribute("href") != null) {
                href = current.getAttribute("href");
            }
            if (current.getAttribute("uid") != null) {
                uid = current.getAttribute("uid");
            }
            this.xliff.getFile().getHeader().getSkl().getExternalFile().setCrc(crc);
            this.xliff.getFile().getHeader().getSkl().getExternalFile().setHref(href);
            this.xliff.getFile().getHeader().getSkl().getExternalFile().setUid(uid);
        }
        if ((current = (Element)header.getElementsByTagName("internal-file").item(0)) != null) {
            crc = new String("");
            String content = new String("");
            String form = new String("");
            if (current.getAttribute("crc") != null) {
                crc = current.getAttribute("crc");
            }
            if (current.getFirstChild() != null && current.getFirstChild().getNodeValue() != null) {
                content = current.getFirstChild().getNodeValue();
            }
            if (current.getAttribute("form") != null) {
                form = current.getAttribute("form");
            }
            this.setInternalFile(crc, form, content);
        }
        if ((current = (Element)header.getElementsByTagName("phase-group").item(0)) != null) {
            NodeList phases = current.getElementsByTagName("phase");
            i = 0;
            while (i < phases.getLength()) {
                String phaseName = new String("");
                String processName = new String("");
                String tool = new String("");
                String[] notesContent = new String[]{};
                current = (Element)phases.item(i);
                if (current.getAttribute("phase-name") != null) {
                    phaseName = current.getAttribute("phase-name");
                }
                if (current.getAttribute("process-name") != null) {
                    processName = current.getAttribute("process-name");
                }
                if (current.getAttribute("tool") != null) {
                    tool = current.getAttribute("tool");
                }
                if (current.hasChildNodes()) {
                    PhaseTypeItem phaseTypeItem = new PhaseTypeItem();
                    NodeList notes = current.getElementsByTagName("note");
                    notesContent = new String[notes.getLength()];
                    j = 0;
                    while (j < notes.getLength()) {
                        if (notes.item(j).getFirstChild() != null && notes.item(j).getFirstChild().getNodeValue() != null) {
                            notesContent[j] = notes.item(j).getFirstChild().getNodeValue();
                        }
                        ++j;
                    }
                }
                if (phaseName != null && !phaseName.equals("")) {
                    Phase phase = new Phase();
                    phase.setPhaseName(phaseName);
                    phase.setProcessName(processName);
                    phase.setTool(tool);
                    if (notesContent.length > 0) {
                        phase.getPhaseTypeItem(0).setNote(notesContent);
                    }
                    this.xliff.getFile().getHeader().getPhaseGroup().addPhase(phase);
                }
                ++i;
            }
        }
        if ((current = (Element)header.getElementsByTagName("s2x").item(0)) == null) {
            mf2 = new MessageFormat(res.getString("ymsg_ElementAutoCorrect"));
            obj2 = new Object[]{"s2x"};
            this.errorMessagesLoadRSX.add(mf2.format(obj2));
        }
        if ((current = (Element)header.getElementsByTagName("giltDirectives").item(0)) == null) {
            mf2 = new MessageFormat(res.getString("ymsg_ElementAutoCorrect"));
            obj2 = new Object[]{"giltDirectives"};
            this.errorMessagesLoadRSX.add(mf2.format(obj2));
        }
        if ((current = (Element)header.getElementsByTagName("develContact").item(0)) != null && current.getFirstChild() != null) {
            if (current.getFirstChild().getNodeValue() != null) {
                this.xliff.getFile().getHeader().getS2x().getGiltDirectives().setDevelContact(current.getFirstChild().getNodeValue());
            } else {
                this.xliff.getFile().getHeader().getS2x().getGiltDirectives().setDevelContact("");
                mf2 = new MessageFormat(res.getString("ymsg_ElementNoValue"));
                obj2 = new Object[]{"develContact"};
                this.errorMessagesLoadRSX.add(mf2.format(obj2));
            }
        } else {
            mf2 = new MessageFormat(res.getString("ymsg_ElementNotExists"));
            obj2 = new Object[]{"develContact"};
            this.errorMessagesLoadRSX.add(mf2.format(obj2));
        }
        current = (Element)header.getElementsByTagName("domain").item(0);
        if (current != null && current.getFirstChild() != null && current.getFirstChild().getNodeValue() != null && !current.getFirstChild().getNodeValue().equals("")) {
            this.xliff.getFile().getHeader().getS2x().getGiltDirectives().getDomain().setXLIFFValue(current.getFirstChild().getNodeValue());
        }
        if ((current = (Element)header.getElementsByTagName("originalLocale").item(0)) != null) {
            if (current.getAttribute("xml:lang") != null) {
                LangType lang = this.s2xTypes.getLangtype(current.getAttribute("xml:lang"), "XLIFF");
                if (lang != null) {
                    this.xliff.getFile().getHeader().getS2x().getGiltDirectives().getOriginalLocale().setLang(lang);
                } else {
                    this.xliff.getFile().getHeader().getS2x().getGiltDirectives().getOriginalLocale().getLang().setXLIFFValue(current.getAttribute("xml:lang"));
                }
            } else {
                this.xliff.getFile().getHeader().getS2x().getGiltDirectives().getOriginalLocale().getLang().setXLIFFValue("");
                mf2 = new MessageFormat(res.getString("ymsg_AttributeNoValue1"));
                obj2 = new Object[]{"xml:lang"};
                obj2[1] = "originalLocale";
                this.errorMessagesLoadRSX.add(mf2.format(obj2));
            }
        } else {
            mf2 = new MessageFormat(res.getString("ymsg_AttributeNotExits"));
            obj2 = new Object[]{"xml:lang", "originalLocale"};
            this.errorMessagesLoadRSX.add(mf2.format(obj2));
        }
        current = (Element)header.getElementsByTagName("maxLength").item(0);
        if (current != null && current.getFirstChild() != null && current.getFirstChild().getNodeValue() != null) {
            this.xliff.getFile().getHeader().getS2x().getGiltDirectives().setMaxLength(current.getFirstChild().getNodeValue());
        } else {
            mf2 = new MessageFormat(res.getString("ymsg_SetMLToDefault"));
            obj2 = new Object[]{"maxLength", new Integer(255)};
            this.errorMessagesLoadRSX.add(mf2.format(obj2));
        }
        Element body = (Element)root.getElementsByTagName("body").item(0);
        if (body == null) {
            mf2 = new MessageFormat(res.getString("ymsg_ElementNotExists"));
            obj2 = new Object[]{"body"};
            this.errorMessagesLoadRSX.add(mf2.format(obj2));
        } else {
            NodeList groups = body.getElementsByTagName("group");
            if (body.getChildNodes().getLength() > groups.getLength() * 2 + 1) {
                this.errorMessagesLoadRSX.add(res.getString("ymsg_missingGroup"));
            }
            i = 0;
            while (i < groups.getLength()) {
                current = (Element)groups.item(i);
                if (current.getAttribute("restype") != null && !current.getAttribute("restype").equals("")) {
                    String restype = current.getAttribute("restype");
                    RestypeValue restypeValue = this.s2xTypes.getRestype(restype, "XLIFF");
                    if (restypeValue != null) {
                        Group group = null;
                        group = this.getGroup(restypeValue.getXLIFFValue());
                        if (group == null) {
                            group = new Group();
                            group.setRestype(restypeValue);
                            this.xliff.getFile().getBody().addGroup(group);
                        }
                        NodeList transunits = current.getElementsByTagName("trans-unit");
                        int len = transunits.getLength();
                        j = 0;
                        while (j < len) {
                            current = (Element)transunits.item(j);
                            if (current != null) {
                                TransUnit tu = new TransUnit();
                                String id = current.getAttribute("id") != null ? current.getAttribute("id") : "";
                                tu.setId(id);
                                String maxwidth = current.getAttribute("maxwidth") != null && !current.getAttribute("maxwidth").equals("") ? current.getAttribute("maxwidth") : "0";
                                tu.setMaxwidth(new Integer(maxwidth));
                                String resname = current.getAttribute("resname") != null ? current.getAttribute("resname") : id;
                                tu.setResname(resname);
                                String translate = current.getAttribute("translate") != null && !current.getAttribute("maxwidth").equals("") ? current.getAttribute("translate") : "yes";
                                tu.setTranslate(translate);
                                current = (Element)current.getElementsByTagName("source").item(0);
                                String source = current != null && current.getFirstChild() != null && current.getFirstChild().getNodeValue() != null ? esc.unescape(current.getFirstChild().getNodeValue()) : "";
                                tu.setSource(source);
                                TranslationUnit tunit = null;
                                try {
                                    tunit = this.getText(id);
                                }
                                catch (TextNotFoundException tnfe) {
                                    // empty catch block
                                }
                                if (tunit == null) {
                                    group.addTransUnit(tu);
                                } else {
                                    if (resname.equals(id)) {
                                        mf2 = new MessageFormat(res.getString("ymsg_DuplicateID1"));
                                        obj2 = new Object[]{id, source};
                                    } else {
                                        mf2 = new MessageFormat(res.getString("ymsg_DuplicateID2"));
                                        obj2 = new Object[]{id, source, resname};
                                    }
                                    this.errorMessagesLoadRSX.add(mf2.format(obj2));
                                }
                            }
                            ++j;
                        }
                    } else {
                        mf2 = new MessageFormat(res.getString("ymsg_wrongRestype"));
                        obj2 = new Object[]{restype};
                        this.errorMessagesLoadRSX.add(mf2.format(obj2));
                    }
                } else {
                    this.errorMessagesLoadRSX.add(res.getString("ymsg_noRestype"));
                }
                ++i;
            }
        }
    }

    public void setCodepageValidation(boolean codepageValidation) {
        this.codepageValidation = codepageValidation;
    }

    public void setDatatype(String xliffDatatype) throws ValidationException {
        StringBuffer errorMsg = new StringBuffer();
        errorMsg.append(this.validator.checkAgainstSchema("datatype", xliffDatatype));
        if (errorMsg.length() != 0) {
            errorMsg.insert(0, res.getString("ymsg_SetDatatype") + "\n");
            throw new ValidationException(errorMsg.toString());
        }
        DatatypeValue datatype = this.s2xTypes.getDatatype(xliffDatatype, "XLIFF");
        this.xliff.getFile().setDatatype(datatype);
    }

    public void setOriginal(String original) throws ValidationException {
        StringBuffer errorMsg = new StringBuffer();
        errorMsg.append(this.validator.checkAgainstSchema("original", original));
        if (errorMsg.length() != 0) {
            errorMsg.insert(0, res.getString("ymsg_SetOriginal") + "\n");
            throw new ValidationException(errorMsg.toString());
        }
        this.xliff.getFile().setOriginal(original);
    }

    public void setSourceLanguage(String sourceLanguage) throws ValidationException {
        Vector texts;
        int len;
        StringBuffer errorMsg = new StringBuffer();
        errorMsg.append(this.validator.checkAgainstSchema("source-language", sourceLanguage));
        if (errorMsg.length() == 0 && (len = (texts = this.getTexts()).size()) > 0 && this.isCodepageValidationON()) {
            int i = 0;
            while (i < len) {
                TranslationUnit tu = (TranslationUnit)texts.get(i);
                if (!this.validator.checkAgainstCodepage(tu.getSource(), S2XTypes.getInstance().getLangtype(this.getSourceLanguage(), "XLIFF")).equals("")) {
                    if (errorMsg.length() > 0) {
                        errorMsg.append("\n");
                    }
                    errorMsg.append(res.getString("ymsg_CannotSetOrigLang"));
                    break;
                }
                ++i;
            }
        }
        if (errorMsg.length() != 0) {
            errorMsg.insert(0, res.getString("ymsg_SetLanguage") + "\n");
            throw new ValidationException(errorMsg.toString());
        }
        LangType l = this.s2xTypes.getLangtype(sourceLanguage, "XLIFF");
        this.xliff.getFile().setSourceLanguage(l);
    }

    public void setProductname(String productname) throws ValidationException {
        StringBuffer errorMsg = new StringBuffer();
        errorMsg.append(this.validator.checkAgainstSchema("product-name", productname));
        if (errorMsg.length() != 0) {
            errorMsg.insert(0, res.getString("ymsg_SetProductname") + "\n");
            throw new ValidationException(errorMsg.toString());
        }
        this.xliff.getFile().setProductname(productname);
    }

    public void setTool(String tool) {
        this.xliff.getFile().setTool(tool);
    }

    public void setDevelContact(String develContact) throws ValidationException {
        StringBuffer errorMsg = new StringBuffer();
        errorMsg.append(this.validator.checkAgainstSchema("develContact", develContact));
        if (errorMsg.length() != 0) {
            errorMsg.insert(0, res.getString("ymsg_SetEmail") + "\n");
            throw new ValidationException(errorMsg.toString());
        }
        this.xliff.getFile().getHeader().getS2x().getGiltDirectives().setDevelContact(develContact);
    }

    public void setDomain(String domain) throws ValidationException {
        StringBuffer errorMsg = new StringBuffer();
        errorMsg.append(this.validator.checkAgainstSchema("domain", domain));
        if (errorMsg.length() != 0) {
            errorMsg.insert(0, res.getString("ymsg_SetDomain") + "\n");
            throw new ValidationException(errorMsg.toString());
        }
        DomainType d = this.s2xTypes.getDomaintype(domain, "XLIFF");
        this.xliff.getFile().getHeader().getS2x().getGiltDirectives().setDomain(d);
    }

    public void setCollection(String collection) throws ValidationException {
        StringBuffer errorMsg = new StringBuffer();
        errorMsg.append(this.validator.checkAgainstSchema("collection", collection));
        if (errorMsg.length() != 0) {
            errorMsg.insert(0, res.getString("ymsg_SetCollection") + "\n");
            throw new ValidationException(errorMsg.toString());
        }
        this.xliff.getFile().getHeader().getS2x().getGiltDirectives().setCollection(collection);
    }

    public void setExternalFile(String crc, String href, String uid) throws ValidationException {
        StringBuffer errorMsg = new StringBuffer();
        Object[] obj = new Object[2];
        MessageFormat mf = new MessageFormat(res.getString("ymsg_EmptyAttribute"));
        obj[0] = "\"external-file\"";
        if (href == null || href.equals("")) {
            obj[1] = "\"href\"";
            errorMsg.append(mf.format(obj));
            throw new ValidationException(errorMsg.toString());
        }
        this.xliff.getFile().getHeader().getSkl().getExternalFile().setCrc(crc);
        this.xliff.getFile().getHeader().getSkl().getExternalFile().setHref(href);
        this.xliff.getFile().getHeader().getSkl().getExternalFile().setUid(uid);
    }

    public void setInternalFile(String crc, String form, String content) {
        this.xliff.getFile().getHeader().getSkl().getInternalFile().setCrc(crc);
        this.xliff.getFile().getHeader().getSkl().getInternalFile().setForm(form);
        this.xliff.getFile().getHeader().getSkl().getInternalFile().setContent(content);
    }

    public void setMaxLength(String maxLength) throws ValidationException {
        StringBuffer errorMsg = new StringBuffer();
        errorMsg.append(this.validator.checkAgainstSchema("maxLength", maxLength));
        if (errorMsg.length() > 0) {
            errorMsg.insert(0, res.getString("ymsg_SetMaxlength1") + "\n");
            throw new ValidationException(errorMsg.toString());
        }
        int maxLen = new Integer(maxLength);
        int len = this.s2xTypes.getRestypes().size();
        int i = 0;
        while (i < len) {
            Group group;
            S2XTypeInterface type = (S2XTypeInterface)this.s2xTypes.getRestypes().get(i);
            if (type.getSAPInternalValue().startsWith("X") && (group = this.getGroup(type.getXLIFFValue())) != null) {
                int j = 0;
                while (j < group.getTransUnitCount()) {
                    TransUnit transUnit = group.getTransUnit(j);
                    if (transUnit.getMaxwidth() == 0 && transUnit.getSource().length() > maxLen) {
                        if (errorMsg.length() == 0) {
                            MessageFormat mf = new MessageFormat(res.getString("ymsg_TextTooLong"));
                            Object[] obj = new Object[]{"maxLength"};
                            errorMsg.append(mf.format(obj));
                            errorMsg.append("\n");
                            errorMsg.append(transUnit.getId() + " " + transUnit.getSource());
                        } else {
                            errorMsg.append("\n");
                            errorMsg.append(transUnit.getId() + " " + transUnit.getSource());
                        }
                    }
                    ++j;
                }
            }
            ++i;
        }
        if (errorMsg.length() > 0) {
            errorMsg.insert(0, res.getString("ymsg_SetMaxlength2") + "\n");
            throw new ValidationException(errorMsg.toString());
        }
        this.xliff.getFile().getHeader().getS2x().getGiltDirectives().setMaxLength(maxLength);
    }

    public void setOriginalLocale(String originalLocale) throws ValidationException {
        Vector texts;
        int len;
        StringBuffer errorMsg = new StringBuffer();
        errorMsg.append(this.validator.checkAgainstSchema("xml:lang", originalLocale));
        if (errorMsg.length() == 0 && (len = (texts = this.getTexts()).size()) > 0 && this.isCodepageValidationON()) {
            int i = 0;
            while (i < len) {
                TranslationUnit tu = (TranslationUnit)texts.get(i);
                if (!this.validator.checkAgainstCodepage(tu.getSource(), S2XTypes.getInstance().getLangtype(originalLocale, "XLIFF")).equals("")) {
                    if (errorMsg.length() > 0) {
                        errorMsg.append("\n");
                    }
                    errorMsg.append(res.getString("ymsg_CannotSetOrigLang"));
                    break;
                }
                ++i;
            }
        }
        if (errorMsg.length() != 0) {
            errorMsg.insert(0, res.getString("ymsg_SetOrigLang") + "\n");
            throw new ValidationException(errorMsg.toString());
        }
        LangType l = this.s2xTypes.getLangtype(originalLocale, "XLIFF");
        OriginalLocaleType o = new OriginalLocaleType();
        o.setLang(l);
        this.xliff.getFile().getHeader().getS2x().getGiltDirectives().setOriginalLocale(o);
    }

    public void setDc(String dc) throws ValidationException {
        StringBuffer errorMsg = new StringBuffer();
        errorMsg.append(this.validator.checkAgainstSchema("dc", dc));
        if (errorMsg.length() != 0) {
            errorMsg.insert(0, res.getString("ymsg_SetDC") + "\n");
            throw new ValidationException(errorMsg.toString());
        }
        this.xliff.getFile().getHeader().getS2x().getDtr().setDc(dc);
    }

    public void setRel(String rel) throws ValidationException {
        StringBuffer errorMsg = new StringBuffer();
        errorMsg.append(this.validator.checkAgainstSchema("rel", rel));
        if (errorMsg.length() != 0) {
            errorMsg.insert(0, res.getString("ymsg_SetRel") + "\n");
            throw new ValidationException(errorMsg.toString());
        }
        this.xliff.getFile().getHeader().getS2x().getDtr().setRel(rel);
    }

    public void setResname(String id, String restype, String resname) {
        TransUnit transUnit = this.getTransUnit(restype, id);
        transUnit.setResname(resname);
    }

    public void setSc(String sc) {
        this.xliff.getFile().getHeader().getS2x().getDtr().setSc(sc);
    }

    public void store(File file) throws IOException, FileNotFoundException, MarshalException {
        if (file == null) {
            MessageFormat mf = new MessageFormat(res.getString("ymsg_FileNull"));
            Object[] obj = new Object[]{"java.io.File", "null"};
            throw new IllegalArgumentException(mf.format(obj));
        }
        this.store(new FileOutputStream(file));
    }

    public void store(OutputStream out) throws IOException, MarshalException {
        if (out == null) {
            MessageFormat mf = new MessageFormat(res.getString("ymsg_OutputStreamNull"));
            Object[] obj = new Object[]{"java.io.OutputStream", "null"};
            throw new IllegalArgumentException(mf.format(obj));
        }
        this.xliff.marshal(out);
        out.flush();
        out.close();
    }

    public void storeMSX(File file) throws IOException, FileNotFoundException, MarshalException {
        if (file == null) {
            MessageFormat mf = new MessageFormat(res.getString("ymsg_FileNull"));
            Object[] obj = new Object[]{"java.io.File", "null"};
            throw new IllegalArgumentException(mf.format(obj));
        }
        if (this.containTranslationUnits()) {
            this.storeMSX(new FileOutputStream(file));
        }
    }

    public void storeMSX(OutputStream out) throws IOException, MarshalException {
        if (out == null) {
            MessageFormat mf = new MessageFormat(res.getString("ymsg_OutputStreamNull"));
            Object[] obj = new Object[]{"java.io.OutputStream", "null"};
            throw new IllegalArgumentException(mf.format(obj));
        }
        this.xliff.marshalMSX(out);
        out.flush();
        out.close();
    }

    public void storeRSX() throws IOException, FileNotFoundException, MarshalException, ValidationException {
        if (this.fileName == null || this.fileName.equals("")) {
            throw new IllegalArgumentException(res.getString("ymsg_FileNameNull"));
        }
        this.storeRSX(new FileOutputStream(this.fileName));
    }

    public void storeRSX(File file) throws IOException, FileNotFoundException, MarshalException, ValidationException {
        if (file == null) {
            MessageFormat mf = new MessageFormat(res.getString("ymsg_FileNull"));
            Object[] obj = new Object[]{"java.io.File", "null"};
            throw new IllegalArgumentException(mf.format(obj));
        }
        this.storeRSX(new FileOutputStream(file));
    }

    public void storeRSX(OutputStream out) throws IOException, MarshalException, ValidationException {
        if (out == null) {
            MessageFormat mf = new MessageFormat(res.getString("ymsg_OutputStreamNull"));
            Object[] obj = new Object[]{"java.io.OutputStream", "null"};
            throw new IllegalArgumentException(mf.format(obj));
        }
        try {
            if (!this.isValidRSX()) {
                throw new ValidationException(res.getString("ymsg_NoCompleteRSX"));
            }
            this.xliff.marshalRSX(out);
            out.flush();
            out.close();
        }
        catch (Exception ex) {
            throw new ValidationException(ex.getMessage());
        }
    }

    public void storeISX() throws IOException, FileNotFoundException, MarshalException, ValidationException {
        if (this.fileName == null || this.fileName.equals("")) {
            throw new IllegalArgumentException(res.getString("ymsg_FileNameNull"));
        }
        this.storeISX(new FileOutputStream(this.fileName));
    }

    public void storeISX(File file) throws IOException, FileNotFoundException, MarshalException, ValidationException {
        if (file == null) {
            MessageFormat mf = new MessageFormat(res.getString("ymsg_FileNull"));
            Object[] obj = new Object[]{"java.io.File", "null"};
            throw new IllegalArgumentException(mf.format(obj));
        }
        this.storeISX(new FileOutputStream(file));
    }

    public void storeISX(OutputStream out) throws IOException, MarshalException, ValidationException {
        if (out == null) {
            MessageFormat mf = new MessageFormat(res.getString("ymsg_OutputStreamNull"));
            Object[] obj = new Object[]{"java.io.OutputStream", "null"};
            throw new IllegalArgumentException(mf.format(obj));
        }
        try {
            if (!this.isValidISX()) {
                throw new ValidationException(res.getString("ymsg_NoCompleteISX"));
            }
            this.xliff.marshalISX(out);
            out.flush();
            out.close();
        }
        catch (Exception ex) {
            throw new ValidationException(ex.getMessage());
        }
    }

    public boolean containTranslationUnits() {
        boolean containsTranslationUnit = false;
        int i = 0;
        while (i < this.xliff.getFile().getBody().getGroupCount()) {
            Group group = this.xliff.getFile().getBody().getGroup(i);
            int j = 0;
            while (j < group.getTransUnitCount()) {
                if (group.getTransUnit(j).getTranslate().toLowerCase().equals("yes")) {
                    containsTranslationUnit = true;
                    return containsTranslationUnit;
                }
                ++j;
            }
            ++i;
        }
        return containsTranslationUnit;
    }
}

