/*
 * Decompiled with CFR 0.152.
 */
package com.sap.dictionary.tools.tsmodel.dictionary.utils;

import com.sap.dictionary.tools.tsmodel.dictionary.plugin.TsmodelDictionaryPlugin;
import com.sap.ide.metamodel.core.services.ServicesEclipse;
import com.sap.ide.metamodel.core.services.ServicesUI;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;

public abstract class DictionaryUtil {
    public static boolean stringIsEmpty(String string) {
        return string == null || string.trim().equals("");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static String searchPackage(WizardPage wizardPage, String projectName) {
        IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(projectName);
        IPackageFragmentRoot[] packageFragments = ServicesEclipse.getSourceRoots((IProject)project);
        if (packageFragments.length > 0 && packageFragments[0] != null) {
            IPackageFragmentRoot packageRoot = null;
            int i = 0;
            while (i < packageFragments.length) {
                if (packageFragments[i].getElementName().equals("packages")) {
                    packageRoot = packageFragments[i];
                    break;
                }
                ++i;
            }
            IJavaElement[] packages = null;
            try {
                packages = packageRoot.getChildren();
            }
            catch (JavaModelException jme) {
                MessageDialog.openError((Shell)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (String)"Browse Packages", (String)"No packages found");
                TsmodelDictionaryPlugin.tracer.error("get packages", (Throwable)jme);
                return null;
            }
            if (packages.length > 1) {
                IPackageFragment packageFragment = ServicesUI.browsePackages((IPackageFragmentRoot)packageRoot, (Shell)wizardPage.getShell());
                if (packageFragment == null) return null;
                return packageFragment.getElementName();
            }
            MessageDialog.openError((Shell)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (String)"Browse Packages", (String)"No packages found");
            return null;
        }
        MessageDialog.openError((Shell)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (String)"Internal Error", (String)"No package root found");
        return null;
    }
}

