/*
 * Decompiled with CFR 0.152.
 */
package com.sap.dictionary.tools.tsmodel.dictionary.utils;

import com.sap.dictionary.designtime.DtDbTableChecker;
import com.sap.dictionary.designtime.DtIndexChecker;
import com.sap.dictionary.tools.tsmodel.dictionary.plugin.TsmodelDictionaryPlugin;
import com.sap.dictionary.tools.tsmodel.dictionary.provider.DataSourceManager;
import com.sap.dictionary.tools.tsmodel.dictionary.utils.DictionaryUtil;
import com.sap.dictionary.tools.ui.messages.MessagePool;
import com.sap.ide.metamodel.Metamodel;
import com.sap.ide.metamodel.dictionary.datatype.DtDbTable;
import com.sap.ide.metamodel.general.exception.IllegalNamingException;
import com.sap.ide.metamodel.general.exception.LoadException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jdt.core.JavaConventions;
import org.eclipse.jface.wizard.WizardPage;

public abstract class DictionaryObjectChecker {
    private char mAction;
    public static final char ACTION_CREATE = 'A';
    public static final char ACTION_COPY = 'C';
    private static final String PACKAGE_DDIC = "com.sap.dictionary";
    private static final String PACKAGE_WEB_DYNPRO = "com.sap.ide.webdynpro.uielementdefinitions";

    public static String checkTableName(String newTableName, String oldTableName, char action, DataSourceManager dataSourceManager) {
        HashMap hMessages;
        String message = null;
        DtDbTableChecker dtDbTableChecker = new DtDbTableChecker();
        if (DictionaryUtil.stringIsEmpty(newTableName)) {
            message = action == 'A' ? "Specify the table name" : "Specify the name of the new table";
            return message;
        }
        if (action == 'C' && newTableName.equalsIgnoreCase(oldTableName)) {
            return "The name of the new table has to be different from that of the old one";
        }
        if (dataSourceManager.getDictionaryRoot().hasTable("", newTableName)) {
            return MessagePool.getMessage((String)"Table & already exists", (String)newTableName);
        }
        if (!dtDbTableChecker.nameIsOk(newTableName) && (hMessages = dtDbTableChecker.getMessages()).containsValue("Error")) {
            message = hMessages.toString();
            int index = message.indexOf("Error");
            if (index >= 0) {
                message = message.substring(1, index - 1);
                message = "Table name: ".concat(message);
            } else {
                message = MessagePool.getMessage((String)"Table name & is invalid", (String)newTableName);
            }
            return message;
        }
        return null;
    }

    public static String checkViewName(String newTableName, String oldTableName, char action, DataSourceManager dataSourceManager) {
        HashMap hMessages;
        String message = null;
        DtDbTableChecker dtDbTableChecker = new DtDbTableChecker();
        if (DictionaryUtil.stringIsEmpty(newTableName)) {
            message = action == 'A' ? "Specify the database view name" : "Specify the name of the new database view";
            return message;
        }
        if (action == 'C' && newTableName.equalsIgnoreCase(oldTableName)) {
            return "The name of the new database view has to be different from that of the old one";
        }
        if (dataSourceManager.getDictionaryRoot().hasView("", newTableName)) {
            return MessagePool.getMessage((String)"Database view & already exists", (String)newTableName);
        }
        if (!dtDbTableChecker.nameIsOk(newTableName) && (hMessages = dtDbTableChecker.getMessages()).containsValue("Error")) {
            message = hMessages.toString();
            int index = message.indexOf("Error");
            if (index >= 0) {
                message = message.substring(1, index - 1);
                message = "Database view name: ".concat(message);
            } else {
                message = MessagePool.getMessage((String)"Database view name & is invalid", (String)newTableName);
            }
            return message;
        }
        return null;
    }

    public static String checkIndexName(String newIndexName, String oldIndexName, char action) {
        HashMap hMessages;
        String message = null;
        DtIndexChecker dtIndexChecker = new DtIndexChecker();
        if (DictionaryUtil.stringIsEmpty(newIndexName)) {
            message = action == 'A' ? "Specify the name of the index" : MessagePool.getMessage((String)"Copy index &: &", (String)oldIndexName, (String)"Specify the name of the new index");
            return message;
        }
        if (action == 'C' && newIndexName.equalsIgnoreCase(oldIndexName)) {
            return MessagePool.getMessage((String)"Copy index &: &", (String)oldIndexName, (String)"The name of the new index has to be different from that of the old one");
        }
        if (!dtIndexChecker.nameIsOk(newIndexName) && (hMessages = dtIndexChecker.getMessages()).containsValue("Error")) {
            message = hMessages.toString();
            int index = message.indexOf("Error");
            if (index >= 0) {
                message = message.substring(1, index - 1);
                message = MessagePool.getMessage((String)"Index &: &", (String)newIndexName, (String)message);
            } else {
                message = MessagePool.getMessage((String)"Index name & is invalid", (String)newIndexName);
            }
            return message;
        }
        return null;
    }

    public static String checkPackageName(String packageName) {
        String s = null;
        if (DictionaryUtil.stringIsEmpty(packageName)) {
            s = "Specify a package name";
            return s;
        }
        if (packageName.indexOf(" ") != -1) {
            s = "Package names must not contain any spaces";
            return s;
        }
        try {
            Metamodel.getNamingService().checkMainDevelopmentObjectPackage(packageName);
        }
        catch (IllegalNamingException e) {
            s = e.getMessage();
            return s;
        }
        IStatus validatedStatus = JavaConventions.validatePackageName((String)packageName);
        if (validatedStatus.getSeverity() != 0) {
            s = validatedStatus.getMessage();
            return s;
        }
        if (packageName.equals(PACKAGE_DDIC)) {
            s = MessagePool.getMessage((String)"The package & is reserved for built-in types. Use a different package", (String)PACKAGE_DDIC);
            return s;
        }
        if (packageName.equals(PACKAGE_WEB_DYNPRO)) {
            s = MessagePool.getMessage((String)"The package & is reserved for predefined types. Use a different package", (String)PACKAGE_WEB_DYNPRO);
            return s;
        }
        return s;
    }

    public static String checkSimpleTypeName(String simpleType) {
        IStatus status = null;
        if (!DictionaryUtil.stringIsEmpty(simpleType)) {
            if (!Character.isDigit(simpleType.charAt(0)) && simpleType.charAt(0) != '_') {
                int i = 0;
                while (i < simpleType.length()) {
                    char c = simpleType.charAt(i);
                    if (!(c >= 'A' && c <= 'Z' || c >= 'a' && c <= 'z' || c == '_' || Character.isDigit(c))) {
                        return "The simple type name may only consist of the characters a..z, A..Z, 0..9 and _";
                    }
                    ++i;
                }
                status = ResourcesPlugin.getWorkspace().validateName(simpleType, 1);
                if (status.getSeverity() == 0) {
                    return null;
                }
                return status.getMessage();
            }
            return "The first character of the simple type name may only be one of the characters a..z, A..Z";
        }
        return "Specify the name of the simple type";
    }

    public static String checkStructureName(String structure) {
        IStatus status = null;
        if (!DictionaryUtil.stringIsEmpty(structure)) {
            if (!Character.isDigit(structure.charAt(0)) && structure.charAt(0) != '_') {
                int i = 0;
                while (i < structure.length()) {
                    char c = structure.charAt(i);
                    if (!(c >= 'A' && c <= 'Z' || c >= 'a' && c <= 'z' || c == '_' || Character.isDigit(c))) {
                        return "The structure name may only consist of the characters a..z, A..Z, 0..9 and _";
                    }
                    ++i;
                }
                status = ResourcesPlugin.getWorkspace().validateName(structure, 1);
                if (status.getSeverity() == 0) {
                    return null;
                }
                return status.getMessage();
            }
            return "The first character of the structure name may only be one of the characters a..z, A..Z";
        }
        return "Specify the name of the structure";
    }

    public static String checkProjectHasIndex(String projectName, HashSet indexes) {
        DtDbTable[] dtDbTables;
        try {
            dtDbTables = DataSourceManager.getDataSourceManager(projectName).getDictionaryRoot().getTables();
            if (dtDbTables == null || dtDbTables != null && dtDbTables.length == 0) {
                return null;
            }
        }
        catch (LoadException e) {
            TsmodelDictionaryPlugin.tracer.error("get ddic tables", (Throwable)e);
            return null;
        }
        Iterator iter = indexes.iterator();
        while (iter.hasNext()) {
            String indexName = (String)iter.next();
            if (DictionaryUtil.stringIsEmpty(indexName)) continue;
            int j = 0;
            while (j < dtDbTables.length) {
                if (dtDbTables[j].hasDbIndex(indexName)) {
                    return MessagePool.getMessage((String)"Index & already exists for table &", (String)indexName, (String)dtDbTables[j].getName());
                }
                ++j;
            }
        }
        return null;
    }

    private static void updateStatus(String message, WizardPage wizardPage, boolean setPageStatus) {
        wizardPage.setErrorMessage(message);
        if (setPageStatus) {
            wizardPage.setPageComplete(message == null);
        }
    }
}

