/*
 * Decompiled with CFR 0.152.
 */
package com.sap.dictionary.tools.tsmodel.dictionary.utils;

import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.custom.VerifyKeyListener;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;

public class AdvancedTextInput
extends StyledText {
    public AdvancedTextInput(Composite parent, int style) {
        super(parent, style);
        this.addVerifyKeyListener(new VerifyKeyListener(){

            public void verifyKey(VerifyEvent event) {
                if (!AdvancedTextInput.this.getEditable()) {
                    event.doit = false;
                    return;
                }
                if (event.character == '\t') {
                    event.doit = false;
                }
                if (event.character == ' ') {
                    event.doit = false;
                    int curpos = AdvancedTextInput.this.getCaretOffset();
                    AdvancedTextInput.this.replaceTextRange(curpos, 0, ".");
                    AdvancedTextInput.this.setCaretOffset(curpos + 1);
                    StyleRange styleRange = new StyleRange();
                    styleRange.start = curpos;
                    styleRange.length = 1;
                    styleRange.fontStyle = 1;
                    styleRange.foreground = Display.getDefault().getSystemColor(15);
                    AdvancedTextInput.this.setStyleRange(styleRange);
                }
            }
        });
    }

    public String getText() {
        String text = super.getText();
        char[] textArray = text.toCharArray();
        int i = 0;
        while (i < text.length()) {
            StyleRange range = this.getStyleRangeAtOffset(i);
            if (range != null && range.fontStyle == 1) {
                textArray[i] = 32;
            }
            ++i;
        }
        return new String(textArray);
    }

    public void setEditable(boolean editable) {
        super.setEditable(editable);
        if (!editable) {
            this.setBackground(Display.getDefault().getSystemColor(33));
        } else {
            this.setBackground(Display.getDefault().getSystemColor(25));
            this.setForeground(Display.getDefault().getSystemColor(24));
        }
    }

    public boolean setFocus() {
        if (this.getEditable()) {
            this.setBackground(Display.getDefault().getSystemColor(25));
            this.setForeground(Display.getDefault().getSystemColor(24));
        }
        return super.setFocus();
    }

    public void setText(String text) {
        super.setText(text);
        char[] chars = text.toCharArray();
        int i = 0;
        while (i < chars.length) {
            if (chars[i] == ' ') {
                this.replaceTextRange(i, 1, ".");
                StyleRange styleRange = new StyleRange();
                styleRange.start = i;
                styleRange.length = 1;
                styleRange.fontStyle = 1;
                styleRange.foreground = Display.getDefault().getSystemColor(15);
                this.setStyleRange(styleRange);
            }
            ++i;
        }
    }
}

