/*
 * Decompiled with CFR 0.152.
 */
package com.sap.dictionary.tools.tsmodel.dictionary.provider;

import com.sap.dictionary.tools.tsmodel.dictionary.actions.CreateStructureWizard;
import com.sap.dictionary.tools.tsmodel.dictionary.actions.EditStructureInput;
import com.sap.dictionary.tools.tsmodel.dictionary.plugin.TsmodelDictionaryPlugin;
import com.sap.dictionary.tools.tsmodel.dictionary.provider.DataSourceManager;
import com.sap.dictionary.tools.tsmodel.dictionary.provider.GenericModelAware;
import com.sap.ide.metamodel.Metamodel;
import com.sap.ide.metamodel.core.plugin.MetamodelManager;
import com.sap.ide.metamodel.core.project.ProjectService;
import com.sap.ide.metamodel.core.repository.MMRepositoryObject;
import com.sap.ide.metamodel.core.repository.MMRepositoryObjectList;
import com.sap.ide.metamodel.core.repository.RepositoryServices;
import com.sap.ide.metamodel.dictionary.datatype.DtGeneralStructure;
import com.sap.ide.metamodel.dictionary.datatype.DtLogicalDictionary;
import com.sap.ide.metamodel.dictionary.datatype.DtStructure;
import com.sap.ide.metamodel.dictionary.repository.StructureRepositoryManager;
import com.sap.ide.metamodel.general.DevelopmentObject;
import com.sap.ide.metamodel.general.MDOAccessProblem;
import com.sap.ide.metamodel.general.exception.CreateException;
import com.sap.ide.metamodel.general.exception.DeleteException;
import com.sap.ide.metamodel.general.exception.LoadException;
import com.tssap.selena.model.elements.Element;
import com.tssap.selena.model.elements.Entity;
import com.tssap.selena.model.elements.Model;
import com.tssap.selena.model.elements.UniqueName;
import com.tssap.selena.model.enum.UniqueNameEnumeration;
import com.tssap.selena.model.extension.ChildrenProvider;
import com.tssap.selena.model.extension.EntityExistenceProvider;
import com.tssap.selena.model.extension.ParentProvider;
import com.tssap.selena.model.util.EnumerationConverter;
import java.util.ArrayList;
import java.util.Collections;
import org.eclipse.core.resources.IWorkspaceDescription;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.internal.WorkbenchPlugin;

public class StructureNodeProvider
extends GenericModelAware
implements EntityExistenceProvider,
ChildrenProvider,
ParentProvider {
    public boolean canCreateUniqueName(Entity parent, String shapeType, Entity template) {
        UniqueName uniqueName = parent.getUniqueName();
        return uniqueName.getDomain().equals("Dictionaries") && uniqueName.getSubDomain().equals("Structures") && shapeType.equals("DDStructure");
    }

    public UniqueName createUniqueName(Entity parent, String shapeType, Entity template) {
        Model model = parent.getModel();
        if (model == null) {
            return null;
        }
        if (!ProjectService.checkMetamodelLanguage((Metamodel)this.mDataSourceManager.getDictionaryRoot().getMetamodel())) {
            Shell shell = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
            MessageDialog.openError((Shell)shell, (String)"Error", (String)"The operation has to be aborted due to language problems. \nPlease try one of the following: \n   Close and reopen the project \n   Shutdown and restart the IDE \nFor more Details please refer to eclipse log file at ECLIPSE_HOME/eclipse/.metadata/.log");
            return null;
        }
        DtGeneralStructure lStructure = null;
        CreateStructureWizard wizard = new CreateStructureWizard(this.mDataSourceManager);
        WizardDialog dialog = new WizardDialog(WorkbenchPlugin.getDefault().getWorkbench().getActiveWorkbenchWindow().getShell(), (IWizard)wizard);
        int ret = dialog.open();
        if (ret == 0 && wizard.mName != null) {
            IWorkspaceDescription descr;
            try {
                lStructure = this.mDataSourceManager.getDictionaryRoot().createStructure(wizard.mCont, wizard.mName);
            }
            catch (CreateException e) {
                MessageDialog.openError((Shell)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (String)"Create Error", (String)"Structure could not be created");
                TsmodelDictionaryPlugin.tracer.error("create structure", (Throwable)e);
                return null;
            }
            try {
                IWorkbenchWindow dwindow = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
                IWorkbenchPage page = dwindow.getActivePage();
                if (page != null) {
                    page.openEditor((IEditorInput)new EditStructureInput(this.mDataSourceManager.getDictionaryRoot().getMetamodel(), this.mDataSourceManager.getDictionaryRoot(), (DtStructure)lStructure), "com.sap.dictionary.tools.structureeditor.StructureEditor", true);
                }
            }
            catch (PartInitException e) {
                TsmodelDictionaryPlugin.tracer.error("open editor", (Throwable)e);
            }
            boolean isAutoBuilding = ResourcesPlugin.getWorkspace().isAutoBuilding();
            if (isAutoBuilding) {
                try {
                    descr = ResourcesPlugin.getWorkspace().getDescription();
                    descr.setAutoBuilding(false);
                    ResourcesPlugin.getWorkspace().setDescription(descr);
                }
                catch (CoreException e) {
                    TsmodelDictionaryPlugin.tracer.error("set workspace description", (Throwable)e);
                }
            }
            MetamodelManager.saveAllMetaData((Metamodel)this.mDataSourceManager.getDictionaryRoot().getMetamodel());
            try {
                descr = ResourcesPlugin.getWorkspace().getDescription();
                descr.setAutoBuilding(isAutoBuilding);
                ResourcesPlugin.getWorkspace().setDescription(descr);
            }
            catch (CoreException e) {
                TsmodelDictionaryPlugin.tracer.error("set workspace description", (Throwable)e);
            }
        }
        return null;
    }

    public boolean exists(UniqueName uniqueName) {
        return uniqueName.getDomain().equals("Dictionaries") && uniqueName.getSubDomain().equals("Structure") && this.mDataSourceManager.developmentObjectExists(uniqueName);
    }

    public boolean isChildrenProviderApplicable(Entity parent) {
        UniqueName uniqueName = parent.getUniqueName();
        return uniqueName.getDomain().equals("Dictionaries") && uniqueName.getSubDomain().equals("Structures");
    }

    public UniqueNameEnumeration children(Entity parent) {
        ArrayList<UniqueName> list = new ArrayList<UniqueName>();
        String projectName = parent.getUniqueName().getName();
        DtGeneralStructure[] structures = null;
        try {
            structures = this.mDataSourceManager.getDictionaryRoot().getStructures();
        }
        catch (LoadException e) {
            System.out.println("error on getStructures");
            TsmodelDictionaryPlugin.tracer.error("get ddic structures for project " + projectName, (Throwable)e);
            return null;
        }
        String logicalDdicName = "";
        logicalDdicName = parent.getUniqueName().getLocation();
        int i = 0;
        while (i < structures.length) {
            DtLogicalDictionary logDic = structures[i].getLogicalDictionary();
            if (!(logDic != null && !logDic.getName().equals(logicalDdicName) || logDic == null && !logicalDdicName.equals("Local Dictionary") || structures[i].originatesInArchive())) {
                UniqueName uniqueName = DataSourceManager.createUniqueName((DevelopmentObject)structures[i], "Structure", logicalDdicName);
                list.add(uniqueName);
            }
            ++i;
        }
        return EnumerationConverter.toUniqueNameEnumeration(Collections.enumeration(list));
    }

    public boolean isDeleteProviderApplicable(Element element) {
        if (element instanceof Entity) {
            return this.exists(element.getUniqueName());
        }
        return false;
    }

    public boolean canDelete(Element element) {
        return true;
    }

    public void delete(Element element) {
        DtStructure structure = (DtStructure)this.mDataSourceManager.getDevelopmentObject(element.getUniqueName());
        if (structure != null) {
            MMRepositoryObject[] repositoryObjects = StructureNodeProvider.getRepositoryObjectsAffectedByStructureDeletion((DtGeneralStructure)structure);
            if (!RepositoryServices.checkWriteability((MMRepositoryObject[])repositoryObjects)) {
                return;
            }
            if (structure.isReadOnly()) {
                MessageDialog.openInformation((Shell)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (String)"Information", (String)"Structure is read-only, cannot be deleted");
            } else {
                MDOAccessProblem[] accessProblems = structure.checkForDelete();
                int i = 0;
                while (i < accessProblems.length) {
                    MDOAccessProblem mdoAccessProblem = accessProblems[i];
                    if (mdoAccessProblem.getReason() == 3) {
                        MessageDialog.openError((Shell)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (String)"Access Problem", (String)"Structure cannot be deleted");
                        return;
                    }
                    if (mdoAccessProblem.getReason() == 7) {
                        MessageDialog.openError((Shell)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (String)"Text File Access Problem", (String)"Structure cannot be deleted");
                        return;
                    }
                    ++i;
                }
                try {
                    structure.delete();
                    this.mDataSourceManager.commitChanges();
                }
                catch (DeleteException e) {
                    MessageDialog.openError((Shell)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (String)"Delete Error", (String)"Simple Type cannot be deleted");
                    TsmodelDictionaryPlugin.tracer.error("commit changes", (Throwable)e);
                }
                this.closeEditor(structure);
            }
        }
    }

    public static MMRepositoryObject[] getRepositoryObjectsAffectedByStructureDeletion(DtGeneralStructure structure) {
        MMRepositoryObjectList list = new MMRepositoryObjectList();
        list.addRepositoryObject(StructureRepositoryManager.getRepositoryObject((DtGeneralStructure)structure, (boolean)true));
        return list.getRepositoryObjects();
    }

    public boolean isDeleted(Element element) {
        return false;
    }

    private void closeEditor(DtStructure structure) {
        IWorkbenchWindow dwindow = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        IWorkbenchPage[] pages = dwindow.getPages();
        IWorkbenchPage page = null;
        IEditorReference[] editorReferences = null;
        IEditorPart editor = null;
        int j = 0;
        while (j < pages.length) {
            page = pages[j];
            editorReferences = page.getEditorReferences();
            int i = 0;
            while (i < editorReferences.length) {
                editor = editorReferences[i].getEditor(false);
                if (editor.getEditorInput() instanceof EditStructureInput && ((EditStructureInput)editor.getEditorInput()).structure == structure) {
                    page.closeEditor(editor, false);
                }
                ++i;
            }
            ++j;
        }
    }

    public UniqueName getParentUniqueName(Element child) {
        return DataSourceManager.createUniqueNameForStructureNode("Structures", child.getUniqueName().getLocation());
    }
}

