/*
 * Decompiled with CFR 0.152.
 */
package com.sap.dictionary.tools.tsmodel.dictionary.provider;

import com.sap.dictionary.tools.tsmodel.dictionary.actions.CreateSimpletypeWizard;
import com.sap.dictionary.tools.tsmodel.dictionary.actions.EditSimpleTypeInput;
import com.sap.dictionary.tools.tsmodel.dictionary.plugin.TsmodelDictionaryPlugin;
import com.sap.dictionary.tools.tsmodel.dictionary.provider.DataSourceManager;
import com.sap.dictionary.tools.tsmodel.dictionary.provider.GenericModelAware;
import com.sap.ide.metamodel.Metamodel;
import com.sap.ide.metamodel.core.plugin.MetamodelManager;
import com.sap.ide.metamodel.core.project.ProjectService;
import com.sap.ide.metamodel.core.repository.MMRepositoryObject;
import com.sap.ide.metamodel.core.repository.MMRepositoryObjectList;
import com.sap.ide.metamodel.core.repository.RepositoryServices;
import com.sap.ide.metamodel.dictionary.datatype.DtLogicalDictionary;
import com.sap.ide.metamodel.dictionary.datatype.DtSimpleType;
import com.sap.ide.metamodel.dictionary.repository.SimpleTypeRepositoryManager;
import com.sap.ide.metamodel.general.DevelopmentObject;
import com.sap.ide.metamodel.general.MDOAccessProblem;
import com.sap.ide.metamodel.general.exception.CreateException;
import com.sap.ide.metamodel.general.exception.DeleteException;
import com.sap.ide.metamodel.general.exception.LoadException;
import com.tssap.selena.model.elements.Element;
import com.tssap.selena.model.elements.Entity;
import com.tssap.selena.model.elements.Model;
import com.tssap.selena.model.elements.UniqueName;
import com.tssap.selena.model.enum.UniqueNameEnumeration;
import com.tssap.selena.model.extension.ChildrenProvider;
import com.tssap.selena.model.extension.EntityExistenceProvider;
import com.tssap.selena.model.extension.ParentProvider;
import com.tssap.selena.model.util.EnumerationConverter;
import java.util.ArrayList;
import java.util.Collections;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.internal.WorkbenchPlugin;

public class SimpleTypeNodeProvider
extends GenericModelAware
implements EntityExistenceProvider,
ChildrenProvider,
ParentProvider {
    public boolean canCreateUniqueName(Entity parent, String shapeType, Entity template) {
        UniqueName uniqueName = parent.getUniqueName();
        return uniqueName.getDomain().equals("Dictionaries") && uniqueName.getSubDomain().equals("SimpleTypes") && shapeType.equals("DDSimpleType");
    }

    public UniqueName createUniqueName(Entity parent, String shapeType, Entity template) {
        Model model = parent.getModel();
        if (model == null) {
            return null;
        }
        if (!ProjectService.checkMetamodelLanguage((Metamodel)this.mDataSourceManager.getDictionaryRoot().getMetamodel())) {
            Shell shell = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
            MessageDialog.openError((Shell)shell, (String)"Error", (String)"The operation has to be aborted due to language problems. \nPlease try one of the following: \n   Close and reopen the project \n   Shutdown and restart the IDE \nFor more Details please refer to eclipse log file at ECLIPSE_HOME/eclipse/.metadata/.log");
            return null;
        }
        DtSimpleType lSimpleType = null;
        CreateSimpletypeWizard wizard = new CreateSimpletypeWizard(this.mDataSourceManager);
        WizardDialog dialog = new WizardDialog(WorkbenchPlugin.getDefault().getWorkbench().getActiveWorkbenchWindow().getShell(), (IWizard)wizard);
        dialog.open();
        if (wizard.mCont != null & wizard.mName != null) {
            try {
                lSimpleType = this.mDataSourceManager.getDictionaryRoot().createSimpleType(wizard.mCont, wizard.mName);
                lSimpleType.setBuiltInType("string");
                lSimpleType.createDbProperty();
                lSimpleType.createExternalRepresentation();
                lSimpleType.createTexts();
                lSimpleType.createSchemaType();
                lSimpleType.createTechnicalInfo();
                lSimpleType.setTypeName(wizard.mName);
            }
            catch (CreateException e) {
                MessageDialog.openError((Shell)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (String)"Create Error", (String)"Simple Type could not be created");
                TsmodelDictionaryPlugin.tracer.error("create simple type", (Throwable)e);
                return null;
            }
            try {
                IWorkbenchWindow dwindow = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
                IWorkbenchPage page = dwindow.getActivePage();
                if (page != null) {
                    page.openEditor((IEditorInput)new EditSimpleTypeInput(this.mDataSourceManager.getDictionaryRoot().getMetamodel(), this.mDataSourceManager.getDictionaryRoot(), lSimpleType, true), "com.sap.dictionary.tools.simpletype.SimpletypeEditor", true);
                }
            }
            catch (PartInitException e) {
                TsmodelDictionaryPlugin.tracer.error("open simple type editor", (Throwable)e);
            }
            MetamodelManager.saveAllMetaData((Metamodel)this.mDataSourceManager.getDictionaryRoot().getMetamodel());
        }
        return null;
    }

    public boolean exists(UniqueName uniqueName) {
        return uniqueName.getDomain().equals("Dictionaries") && uniqueName.getSubDomain().equals("SimpleType") && this.mDataSourceManager.developmentObjectExists(uniqueName);
    }

    public boolean isChildrenProviderApplicable(Entity parent) {
        UniqueName uniqueName = parent.getUniqueName();
        return uniqueName.getDomain().equals("Dictionaries") && uniqueName.getSubDomain().equals("SimpleTypes");
    }

    public UniqueNameEnumeration children(Entity parent) {
        ArrayList<UniqueName> list = new ArrayList<UniqueName>();
        DtSimpleType[] simpleTypes = null;
        try {
            simpleTypes = this.mDataSourceManager.getDictionaryRoot().getSimpleTypes();
        }
        catch (LoadException e) {
            System.out.println("error on getSimpleTypes");
            TsmodelDictionaryPlugin.tracer.error("get simple types", (Throwable)e);
            return null;
        }
        String logicalDdicName = "";
        logicalDdicName = parent.getUniqueName().getLocation();
        int i = 0;
        while (i < simpleTypes.length) {
            String typeName;
            DtLogicalDictionary logDic = simpleTypes[i].getLogicalDictionary();
            if ((logDic == null || logDic.getName().equals(logicalDdicName)) && (logDic != null || logicalDdicName.equals("Local Dictionary")) && !simpleTypes[i].originatesInArchive() && simpleTypes[i].getTypeName() != null && (!(typeName = simpleTypes[i].getName()).equals("") && (typeName.charAt(0) >= 'A' && typeName.charAt(0) <= 'Z' || typeName.charAt(0) >= 'a' && typeName.charAt(0) <= 'z') || simpleTypes[i].getBackendName() != null && simpleTypes[i].getBackendName().length() > 0)) {
                UniqueName uniqueName = DataSourceManager.createUniqueName((DevelopmentObject)simpleTypes[i], "SimpleType", logicalDdicName);
                list.add(uniqueName);
            }
            ++i;
        }
        return EnumerationConverter.toUniqueNameEnumeration(Collections.enumeration(list));
    }

    public boolean isDeleteProviderApplicable(Element element) {
        if (element instanceof Entity) {
            return this.exists(element.getUniqueName());
        }
        return false;
    }

    public boolean canDelete(Element element) {
        return true;
    }

    public void delete(Element element) {
        DtSimpleType simpleType = (DtSimpleType)this.mDataSourceManager.getDevelopmentObject(element.getUniqueName());
        if (simpleType != null) {
            MMRepositoryObject[] repositoryObjects = SimpleTypeNodeProvider.getRepositoryObjectsAffectedBySimpleTypeDeletion(simpleType);
            if (!RepositoryServices.checkWriteability((MMRepositoryObject[])repositoryObjects)) {
                return;
            }
            if (simpleType.isReadOnly()) {
                MessageDialog.openInformation((Shell)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (String)"Information", (String)"Simple Type is read-only, cannot be deleted");
            } else {
                MDOAccessProblem[] accessProblems = simpleType.checkForDelete();
                int i = 0;
                while (i < accessProblems.length) {
                    MDOAccessProblem mdoAccessProblem = accessProblems[i];
                    if (mdoAccessProblem.getReason() == 3) {
                        MessageDialog.openError((Shell)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (String)"Access Problem", (String)"Simple Type cannot be deleted");
                        return;
                    }
                    if (mdoAccessProblem.getReason() == 7) {
                        MessageDialog.openError((Shell)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (String)"Text File Access Problem", (String)"Simple Type cannot be deleted");
                        return;
                    }
                    ++i;
                }
                try {
                    simpleType.delete();
                    this.mDataSourceManager.commitChanges();
                }
                catch (DeleteException e) {
                    MessageDialog.openError((Shell)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (String)"Delete Error", (String)"Simple Type cannot be deleted");
                    TsmodelDictionaryPlugin.tracer.error("commit changes", (Throwable)e);
                }
                this.closeEditor(simpleType);
            }
        }
    }

    public static MMRepositoryObject[] getRepositoryObjectsAffectedBySimpleTypeDeletion(DtSimpleType simpleType) {
        MMRepositoryObjectList list = new MMRepositoryObjectList();
        list.addRepositoryObject(SimpleTypeRepositoryManager.getRepositoryObject((DtSimpleType)simpleType, (boolean)true));
        return list.getRepositoryObjects();
    }

    public boolean isDeleted(Element element) {
        return false;
    }

    private void closeEditor(DtSimpleType simpleType) {
        IWorkbenchWindow dwindow = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        IWorkbenchPage[] pages = dwindow.getPages();
        IWorkbenchPage page = null;
        IEditorReference[] editorReferences = null;
        IEditorPart editor = null;
        int j = 0;
        while (j < pages.length) {
            page = pages[j];
            editorReferences = page.getEditorReferences();
            int i = 0;
            while (i < editorReferences.length) {
                editor = editorReferences[i].getEditor(false);
                if (editor.getEditorInput() instanceof EditSimpleTypeInput && ((EditSimpleTypeInput)editor.getEditorInput()).dictSimpleType == simpleType) {
                    page.closeEditor(editor, false);
                }
                ++i;
            }
            ++j;
        }
    }

    public UniqueName getParentUniqueName(Element child) {
        return DataSourceManager.createUniqueNameForStructureNode("SimpleTypes", child.getUniqueName().getLocation());
    }
}

