/*
 * Decompiled with CFR 0.152.
 */
package com.sap.dictionary.tools.tsmodel.dictionary.provider;

import com.sap.dictionary.tools.tsmodel.dictionary.plugin.TsmodelDictionaryPlugin;
import com.sap.dictionary.tools.tsmodel.dictionary.provider.DataSourceManager;
import com.sap.dictionary.tools.tsmodel.dictionary.provider.StructureNodeProviderBase;
import com.sap.ide.metamodel.dictionary.datatype.DtLogicalDictionary;
import com.sap.ide.metamodel.dictionary.services.ServicesEclipse;
import com.sap.ide.metamodel.general.exception.LoadException;
import com.tssap.selena.model.elements.Element;
import com.tssap.selena.model.elements.Entity;
import com.tssap.selena.model.elements.Model;
import com.tssap.selena.model.elements.ModelAccess;
import com.tssap.selena.model.elements.UniqueName;
import com.tssap.selena.model.enum.UniqueNameEnumeration;
import com.tssap.selena.model.extension.ParentProvider;
import com.tssap.selena.model.util.EnumerationConverter;
import java.util.ArrayList;
import java.util.Collections;

public class DictionaryNodeProvider
extends StructureNodeProviderBase
implements ParentProvider {
    public DictionaryNodeProvider() {
        super("Dictionary", "Dictionaries", "Dictionaries", "DDDictionary");
    }

    public boolean isChildrenProviderApplicable(Entity parent) {
        boolean isApplicable = super.isChildrenProviderApplicable(parent);
        if (!isApplicable) {
            return false;
        }
        Model model = parent.getModel();
        String projectName = model.getUniqueName().getName();
        boolean hasDictionaryNature = ServicesEclipse.projectHasDictionaryNature((String)projectName);
        return hasDictionaryNature;
    }

    public static UniqueName createUniqueName() {
        return null;
    }

    public UniqueNameEnumeration children(Entity parent) {
        ArrayList<UniqueName> list = new ArrayList<UniqueName>();
        UniqueName uniqueName = ModelAccess.createUniqueName((String)"Dictionaries", (String)"Dictionary", (String)"Local Dictionary", (String)"Local Dictionary", null);
        list.add(uniqueName);
        try {
            String projectName = parent.getModel().getUniqueName().getName();
            DataSourceManager dsm = DataSourceManager.getDataSourceManager(projectName);
            DtLogicalDictionary[] logDic = dsm.getDictionaryRoot().getLogicalDictionaries();
            int i = 0;
            while (i < logDic.length) {
                if (!logDic[i].originatesInArchive()) {
                    String name = logDic[i].getName();
                    String keyName = logDic[i].getKey().toString();
                    keyName = keyName.replace(':', '#');
                    uniqueName = ModelAccess.createUniqueName((String)"Dictionaries", (String)"Dictionary", (String)name, (String)keyName, null);
                    list.add(uniqueName);
                }
                ++i;
            }
        }
        catch (LoadException e) {
            TsmodelDictionaryPlugin.tracer.error("get log dics", (Throwable)e);
        }
        return EnumerationConverter.toUniqueNameEnumeration(Collections.enumeration(list));
    }

    public UniqueName getParentUniqueName(Element child) {
        return DataSourceManager.createUniqueNameForStructureNode("Dictionaries");
    }
}

