/*
 * Decompiled with CFR 0.152.
 */
package com.sap.dictionary.tools.tsmodel.dictionary.provider;

import com.sap.dictionary.tools.tsmodel.dictionary.actions.CreateDbTableWizard;
import com.sap.dictionary.tools.tsmodel.dictionary.actions.EditDbViewInput;
import com.sap.dictionary.tools.tsmodel.dictionary.plugin.TsmodelDictionaryPlugin;
import com.sap.dictionary.tools.tsmodel.dictionary.provider.DataSourceManager;
import com.sap.dictionary.tools.tsmodel.dictionary.provider.GenericModelAware;
import com.sap.ide.metamodel.Metamodel;
import com.sap.ide.metamodel.core.plugin.MetamodelManager;
import com.sap.ide.metamodel.core.project.ProjectService;
import com.sap.ide.metamodel.dictionary.datatype.DtDbView;
import com.sap.ide.metamodel.general.DevelopmentObject;
import com.sap.ide.metamodel.general.exception.CreateException;
import com.sap.ide.metamodel.general.exception.DeleteException;
import com.sap.ide.metamodel.general.exception.LoadException;
import com.tssap.selena.model.elements.Element;
import com.tssap.selena.model.elements.Entity;
import com.tssap.selena.model.elements.Model;
import com.tssap.selena.model.elements.UniqueName;
import com.tssap.selena.model.enum.UniqueNameEnumeration;
import com.tssap.selena.model.extension.ChildrenProvider;
import com.tssap.selena.model.extension.EntityExistenceProvider;
import com.tssap.selena.model.extension.ParentProvider;
import com.tssap.selena.model.util.EnumerationConverter;
import java.util.ArrayList;
import java.util.Collections;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.internal.WorkbenchPlugin;

public class DbViewNodeProvider
extends GenericModelAware
implements EntityExistenceProvider,
ChildrenProvider,
ParentProvider {
    public boolean canCreateUniqueName(Entity parent, String shapeType, Entity template) {
        UniqueName uniqueName = parent.getUniqueName();
        return uniqueName.getDomain().equals("Dictionaries") && uniqueName.getSubDomain().equals("DbViews") && shapeType.equals("DDDbView");
    }

    public UniqueName createUniqueName(Entity parent, String shapeType, Entity template) {
        Model model = parent.getModel();
        if (model == null) {
            return null;
        }
        if (!ProjectService.checkMetamodelLanguage((Metamodel)this.mDataSourceManager.getDictionaryRoot().getMetamodel())) {
            Shell shell = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
            MessageDialog.openError((Shell)shell, (String)"Error", (String)"The operation has to be aborted due to language problems. \nPlease try one of the following: \n   Close and reopen the project \n   Shutdown and restart the IDE \nFor more Details please refer to eclipse log file at ECLIPSE_HOME/eclipse/.metadata/.log");
            return null;
        }
        DtDbView lDbView = null;
        CreateDbTableWizard wizard = new CreateDbTableWizard(this.mDataSourceManager, false);
        WizardDialog dialog = new WizardDialog(WorkbenchPlugin.getDefault().getWorkbench().getActiveWorkbenchWindow().getShell(), (IWizard)wizard);
        int ret = dialog.open();
        if (ret == 0 && wizard.mName != null) {
            try {
                lDbView = this.mDataSourceManager.getDictionaryRoot().createView("", wizard.mName);
                lDbView.setDescription(wizard.mName);
                MetamodelManager.saveAllMetaData((Metamodel)this.mDataSourceManager.getDictionaryRoot().getMetamodel());
            }
            catch (CreateException e) {
                MessageDialog.openError((Shell)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (String)"Create Error", (String)"Database View could not be created");
                TsmodelDictionaryPlugin.tracer.error("create view", (Throwable)e);
                return null;
            }
            try {
                IWorkbenchWindow dwindow = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
                IWorkbenchPage page = dwindow.getActivePage();
                if (page != null) {
                    page.openEditor((IEditorInput)new EditDbViewInput(this.mDataSourceManager.getDictionaryRoot().getMetamodel(), this.mDataSourceManager.getDictionaryRoot(), lDbView), "com.sap.dictionary.tools.dbvieweditor.MultiPageEditor", true);
                }
            }
            catch (PartInitException e) {
                TsmodelDictionaryPlugin.tracer.error("open view editor", (Throwable)e);
            }
        }
        return null;
    }

    public boolean exists(UniqueName uniqueName) {
        return uniqueName.getDomain().equals("Dictionaries") && uniqueName.getSubDomain().equals("DbView") && this.mDataSourceManager.developmentObjectExists(uniqueName);
    }

    public boolean isChildrenProviderApplicable(Entity parent) {
        UniqueName uniqueName = parent.getUniqueName();
        return uniqueName.getDomain().equals("Dictionaries") && uniqueName.getSubDomain().equals("DbViews");
    }

    public UniqueNameEnumeration children(Entity parent) {
        ArrayList<UniqueName> list = new ArrayList<UniqueName>();
        String projectName = parent.getUniqueName().getName();
        DtDbView[] dbViews = null;
        try {
            dbViews = this.mDataSourceManager.getDictionaryRoot().getViews();
        }
        catch (LoadException e) {
            TsmodelDictionaryPlugin.tracer.error("get db views", (Throwable)e);
            return null;
        }
        int i = 0;
        while (i < dbViews.length) {
            if (!dbViews[i].originatesInArchive()) {
                UniqueName uniqueName = DataSourceManager.createUniqueName((DevelopmentObject)dbViews[i], "DbView", parent.getUniqueName().getLocation());
                list.add(uniqueName);
            }
            ++i;
        }
        return EnumerationConverter.toUniqueNameEnumeration(Collections.enumeration(list));
    }

    public boolean isDeleteProviderApplicable(Element element) {
        if (element instanceof Entity) {
            return this.exists(element.getUniqueName());
        }
        return false;
    }

    public boolean canDelete(Element element) {
        return true;
    }

    public void delete(Element element) {
        DtDbView dbView = (DtDbView)this.mDataSourceManager.getDevelopmentObject(element.getUniqueName());
        if (dbView != null) {
            if (dbView.isReadOnly()) {
                MessageDialog.openInformation((Shell)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (String)"Information", (String)"View is Read Only, cannot be deleted");
            } else {
                try {
                    dbView.delete();
                }
                catch (DeleteException e) {
                    TsmodelDictionaryPlugin.tracer.error("delete view", (Throwable)e);
                }
                this.closeEditor(dbView);
            }
        }
    }

    public boolean isDeleted(Element element) {
        return false;
    }

    private void closeEditor(DtDbView dbView) {
        IWorkbenchWindow dwindow = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        IWorkbenchPage[] pages = dwindow.getPages();
        IWorkbenchPage page = null;
        IEditorReference[] editorReferences = null;
        IEditorPart editor = null;
        int j = 0;
        while (j < pages.length) {
            page = pages[j];
            editorReferences = page.getEditorReferences();
            int i = 0;
            while (i < editorReferences.length) {
                editor = editorReferences[i].getEditor(false);
                if (editor.getEditorInput() instanceof EditDbViewInput && ((EditDbViewInput)editor.getEditorInput()).dictDbView == dbView) {
                    page.closeEditor(editor, false);
                }
                ++i;
            }
            ++j;
        }
    }

    public UniqueName getParentUniqueName(Element child) {
        return DataSourceManager.createUniqueNameForStructureNode("DbViews", child.getUniqueName().getLocation());
    }
}

