/*
 * Decompiled with CFR 0.152.
 */
package com.sap.dictionary.tools.tsmodel.dictionary.provider;

import com.sap.dictionary.tools.tsmodel.dictionary.actions.CreateDbTableWizard;
import com.sap.dictionary.tools.tsmodel.dictionary.actions.EditDbTableInput;
import com.sap.dictionary.tools.tsmodel.dictionary.plugin.TsmodelDictionaryPlugin;
import com.sap.dictionary.tools.tsmodel.dictionary.provider.DataSourceManager;
import com.sap.dictionary.tools.tsmodel.dictionary.provider.GenericModelAware;
import com.sap.ide.metamodel.Metamodel;
import com.sap.ide.metamodel.core.plugin.MetamodelManager;
import com.sap.ide.metamodel.core.project.ProjectService;
import com.sap.ide.metamodel.dictionary.datatype.DtDbTable;
import com.sap.ide.metamodel.general.DevelopmentObject;
import com.sap.ide.metamodel.general.exception.CreateException;
import com.sap.ide.metamodel.general.exception.DeleteException;
import com.sap.ide.metamodel.general.exception.LoadException;
import com.tssap.selena.model.elements.Element;
import com.tssap.selena.model.elements.Entity;
import com.tssap.selena.model.elements.Model;
import com.tssap.selena.model.elements.UniqueName;
import com.tssap.selena.model.enum.UniqueNameEnumeration;
import com.tssap.selena.model.extension.ChildrenProvider;
import com.tssap.selena.model.extension.EntityExistenceProvider;
import com.tssap.selena.model.extension.ParentProvider;
import com.tssap.selena.model.util.EnumerationConverter;
import java.util.ArrayList;
import java.util.Collections;
import org.eclipse.core.resources.IWorkspaceDescription;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.internal.WorkbenchPlugin;

public class DbTableNodeProvider
extends GenericModelAware
implements EntityExistenceProvider,
ChildrenProvider,
ParentProvider {
    public boolean canCreateUniqueName(Entity parent, String shapeType, Entity template) {
        UniqueName uniqueName = parent.getUniqueName();
        return uniqueName.getDomain().equals("Dictionaries") && uniqueName.getSubDomain().equals("DbTables") && shapeType.equals("DDDbTable");
    }

    public UniqueName createUniqueName(Entity parent, String shapeType, Entity template) {
        Model model = parent.getModel();
        if (model == null) {
            return null;
        }
        if (!ProjectService.checkMetamodelLanguage((Metamodel)this.mDataSourceManager.getDictionaryRoot().getMetamodel())) {
            Shell shell = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
            MessageDialog.openError((Shell)shell, (String)"Error", (String)"The operation has to be aborted due to language problems. \nPlease try one of the following: \n   Close and reopen the project \n   Shutdown and restart the IDE \nFor more Details please refer to eclipse log file at ECLIPSE_HOME/eclipse/.metadata/.log");
            return null;
        }
        DtDbTable lDbTable = null;
        CreateDbTableWizard wizard = new CreateDbTableWizard(this.mDataSourceManager, true);
        WizardDialog dialog = new WizardDialog(WorkbenchPlugin.getDefault().getWorkbench().getActiveWorkbenchWindow().getShell(), (IWizard)wizard);
        int ret = dialog.open();
        if (ret == 0 && wizard.mName != null) {
            try {
                lDbTable = this.mDataSourceManager.getDictionaryRoot().createTable("", wizard.mName);
                lDbTable.setDescription(wizard.mName);
            }
            catch (CreateException e) {
                MessageDialog.openError((Shell)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (String)"Create Error", (String)"Database Table could not be created");
                TsmodelDictionaryPlugin.tracer.error("create table", (Throwable)e);
                return null;
            }
            try {
                IWorkbenchWindow dwindow = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
                IWorkbenchPage page = dwindow.getActivePage();
                if (page != null) {
                    page.openEditor((IEditorInput)new EditDbTableInput(this.mDataSourceManager.getDictionaryRoot().getMetamodel(), this.mDataSourceManager.getDictionaryRoot(), lDbTable), "com.sap.dictionary.tools.tableeditor.TableEditor", true);
                }
            }
            catch (PartInitException e) {
                TsmodelDictionaryPlugin.tracer.error("open editor", (Throwable)e);
            }
            boolean isAutoBuilding = ResourcesPlugin.getWorkspace().isAutoBuilding();
            if (isAutoBuilding) {
                try {
                    IWorkspaceDescription descr = ResourcesPlugin.getWorkspace().getDescription();
                    descr.setAutoBuilding(false);
                    ResourcesPlugin.getWorkspace().setDescription(descr);
                }
                catch (CoreException e) {
                    TsmodelDictionaryPlugin.tracer.error("set workspace description", (Throwable)e);
                }
            }
            MetamodelManager.saveAllMetaData((Metamodel)this.mDataSourceManager.getDictionaryRoot().getMetamodel());
            long time = System.currentTimeMillis();
            while (System.currentTimeMillis() - time < 1000L) {
                if (Display.getDefault().readAndDispatch()) continue;
                Display.getDefault().sleep();
            }
            try {
                IWorkspaceDescription descr = ResourcesPlugin.getWorkspace().getDescription();
                descr.setAutoBuilding(isAutoBuilding);
                ResourcesPlugin.getWorkspace().setDescription(descr);
            }
            catch (CoreException e) {
                TsmodelDictionaryPlugin.tracer.error("set workspace description", (Throwable)e);
            }
        }
        return null;
    }

    public boolean exists(UniqueName uniqueName) {
        return uniqueName.getDomain().equals("Dictionaries") && uniqueName.getSubDomain().equals("DbTable") && this.mDataSourceManager.developmentObjectExists(uniqueName);
    }

    public boolean isChildrenProviderApplicable(Entity parent) {
        UniqueName uniqueName = parent.getUniqueName();
        return uniqueName.getDomain().equals("Dictionaries") && uniqueName.getSubDomain().equals("DbTables");
    }

    public UniqueNameEnumeration children(Entity parent) {
        ArrayList<UniqueName> list = new ArrayList<UniqueName>();
        String projectName = parent.getUniqueName().getName();
        DtDbTable[] dbTables = null;
        try {
            dbTables = this.mDataSourceManager.getDictionaryRoot().getTables();
        }
        catch (LoadException e) {
            TsmodelDictionaryPlugin.tracer.error("get ddic tables", (Throwable)e);
            return null;
        }
        int i = 0;
        while (i < dbTables.length) {
            if (!dbTables[i].originatesInArchive()) {
                UniqueName uniqueName = DataSourceManager.createUniqueName((DevelopmentObject)dbTables[i], "DbTable", parent.getUniqueName().getLocation());
                list.add(uniqueName);
            }
            ++i;
        }
        return EnumerationConverter.toUniqueNameEnumeration(Collections.enumeration(list));
    }

    public boolean isDeleteProviderApplicable(Element element) {
        if (element instanceof Entity) {
            return this.exists(element.getUniqueName());
        }
        return false;
    }

    public boolean canDelete(Element element) {
        return true;
    }

    public void delete(Element element) {
        DtDbTable dbTable = (DtDbTable)this.mDataSourceManager.getDevelopmentObject(element.getUniqueName());
        if (dbTable != null) {
            if (dbTable.isReadOnly()) {
                MessageDialog.openInformation((Shell)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (String)"Information", (String)"Table is Read Only, cannot be deleted");
            } else {
                try {
                    dbTable.delete();
                }
                catch (DeleteException e) {
                    TsmodelDictionaryPlugin.tracer.error("delete db table", (Throwable)e);
                }
                this.closeEditor(dbTable);
            }
        }
    }

    public boolean isDeleted(Element element) {
        return false;
    }

    private void closeEditor(DtDbTable dbTable) {
        IWorkbenchWindow dwindow = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        IWorkbenchPage[] pages = dwindow.getPages();
        IWorkbenchPage page = null;
        IEditorReference[] editorReferences = null;
        IEditorPart editor = null;
        int j = 0;
        while (j < pages.length) {
            page = pages[j];
            editorReferences = page.getEditorReferences();
            int i = 0;
            while (i < editorReferences.length) {
                editor = editorReferences[i].getEditor(false);
                if (editor.getEditorInput() instanceof EditDbTableInput && ((EditDbTableInput)editor.getEditorInput()).dictDbTable == dbTable) {
                    page.closeEditor(editor, false);
                }
                ++i;
            }
            ++j;
        }
    }

    public UniqueName getParentUniqueName(Element child) {
        return DataSourceManager.createUniqueNameForStructureNode("DbTables", child.getUniqueName().getLocation());
    }
}

