/*
 * Decompiled with CFR 0.152.
 */
package com.sap.dictionary.tools.tsmodel.dictionary.provider;

import com.sap.dictionary.tools.tsmodel.dictionary.plugin.TsmodelDictionaryPlugin;
import com.sap.dictionary.tools.tsmodel.dictionary.provider.DataSourceManager;
import com.sap.dictionary.tools.tsmodel.dictionary.provider.GenericModelAware;
import com.sap.ide.metamodel.dictionary.datatype.DtDbIndex;
import com.sap.ide.metamodel.dictionary.datatype.DtDbTable;
import com.sap.ide.metamodel.general.DevelopmentObject;
import com.sap.ide.metamodel.general.exception.DeleteException;
import com.tssap.selena.model.elements.Element;
import com.tssap.selena.model.elements.Entity;
import com.tssap.selena.model.elements.UniqueName;
import com.tssap.selena.model.enum.UniqueNameEnumeration;
import com.tssap.selena.model.extension.ChildrenProvider;
import com.tssap.selena.model.extension.EntityExistenceProvider;
import com.tssap.selena.model.extension.ParentProvider;
import com.tssap.selena.model.util.EnumerationConverter;
import java.util.ArrayList;
import java.util.Collections;

public class DbIndexNodeProvider
extends GenericModelAware
implements EntityExistenceProvider,
ChildrenProvider,
ParentProvider {
    public boolean canCreateUniqueName(Entity parent, String shapeType, Entity template) {
        UniqueName uniqueName = parent.getUniqueName();
        return uniqueName.getDomain().equals("Dictionaries") && uniqueName.getSubDomain().equals("DbTable") && shapeType.equals("DDDbIndex");
    }

    public UniqueName createUniqueName(Entity parent, String shapeType, Entity template) {
        return null;
    }

    public boolean exists(UniqueName uniqueName) {
        return uniqueName.getDomain().equals("Dictionaries") && uniqueName.getSubDomain().equals("DbIndex") && this.mDataSourceManager.developmentObjectExists(uniqueName);
    }

    public boolean isChildrenProviderApplicable(Entity parent) {
        UniqueName uniqueName = parent.getUniqueName();
        return uniqueName.getDomain().equals("Dictionaries") && uniqueName.getSubDomain().equals("DbTable");
    }

    public UniqueNameEnumeration children(Entity parent) {
        ArrayList<UniqueName> list = new ArrayList<UniqueName>();
        DtDbTable dbTable = null;
        dbTable = (DtDbTable)this.mDataSourceManager.getDevelopmentObject(parent.getUniqueName());
        if (dbTable == null) {
            return null;
        }
        DtDbIndex[] indexes = dbTable.getDbIndexes();
        int i = 0;
        while (i < indexes.length) {
            if (!indexes[i].originatesInArchive()) {
                UniqueName uniqueName = DataSourceManager.createUniqueName((DevelopmentObject)indexes[i], "DbIndex", parent.getUniqueName().getLocation());
                list.add(uniqueName);
            }
            ++i;
        }
        return EnumerationConverter.toUniqueNameEnumeration(Collections.enumeration(list));
    }

    public boolean isDeleteProviderApplicable(Element element) {
        if (element instanceof Entity) {
            return this.exists(element.getUniqueName());
        }
        return false;
    }

    public boolean canDelete(Element element) {
        return true;
    }

    public void delete(Element element) {
        DtDbTable dbTable = (DtDbTable)this.mDataSourceManager.getDevelopmentObject(element.getUniqueName());
        if (dbTable != null) {
            try {
                dbTable.delete();
            }
            catch (DeleteException e) {
                TsmodelDictionaryPlugin.tracer.error("delete table");
            }
            this.mDataSourceManager.commitChanges();
        }
    }

    public boolean isDeleted(Element element) {
        return false;
    }

    public UniqueName getParentUniqueName(Element child) {
        if (this.exists(child.getUniqueName())) {
            DtDbIndex index = (DtDbIndex)this.mDataSourceManager.getDevelopmentObject(child.getUniqueName());
            if (index == null) {
                return null;
            }
            DtDbTable table = (DtDbTable)index.getParent();
            if (table != null) {
                return DataSourceManager.createUniqueName((DevelopmentObject)table, "DbTable", child.getUniqueName().getLocation());
            }
        }
        return null;
    }
}

