/*
 * Decompiled with CFR 0.152.
 */
package com.sap.dictionary.tools.tsmodel.dictionary.provider;

import com.sap.dictionary.tools.tsmodel.dictionary.plugin.TsmodelDictionaryPlugin;
import com.sap.dictionary.tools.tsmodel.dictionary.provider.HierarchyDeltaProvider;
import com.sap.dictionary.tools.tsmodel.dictionary.provider.UpdateDescription;
import com.sap.ide.metamodel.Metamodel;
import com.sap.ide.metamodel.core.plugin.MetamodelManager;
import com.sap.ide.metamodel.dictionary.DtDictionaryRoot;
import com.sap.ide.metamodel.dictionary.datatype.DtDbIndex;
import com.sap.ide.metamodel.dictionary.datatype.DtDbTable;
import com.sap.ide.metamodel.dictionary.datatype.DtDbView;
import com.sap.ide.metamodel.dictionary.datatype.DtGeneralStructure;
import com.sap.ide.metamodel.dictionary.datatype.DtSimpleType;
import com.sap.ide.metamodel.dictionary.plugin.DictionaryRootManager;
import com.sap.ide.metamodel.general.DevelopmentObject;
import com.sap.ide.metamodel.general.DevelopmentObjectKey;
import com.sap.ide.metamodel.general.DevelopmentObjectObserver;
import com.sap.ide.metamodel.general.event.MetamodelEvent;
import com.sap.ide.metamodel.general.exception.InvalidKeyException;
import com.tssap.selena.model.elements.Element;
import com.tssap.selena.model.elements.Entity;
import com.tssap.selena.model.elements.Model;
import com.tssap.selena.model.elements.ModelAccess;
import com.tssap.selena.model.elements.UniqueName;
import com.tssap.selena.model.util.delta.ModelDeltaNodeKind;
import java.util.ArrayList;
import java.util.HashMap;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;

public class DataSourceManager
implements DevelopmentObjectObserver {
    private static DataSourceManager mDataSourceManager;
    private String mProjectName;
    private HierarchyDeltaProvider mChangeListener;
    private static HashMap mInstanceMap;
    private String tempName = "";

    public static DataSourceManager getDataSourceManager(String projectName) {
        DataSourceManager dataSourceManager = (DataSourceManager)mInstanceMap.get(projectName);
        if (dataSourceManager == null) {
            dataSourceManager = new DataSourceManager(projectName);
            mInstanceMap.put(projectName, dataSourceManager);
        }
        return dataSourceManager;
    }

    public static void removeDataSourceManager(String projectName) {
        DataSourceManager dataSourceManager = (DataSourceManager)mInstanceMap.get(projectName);
        if (dataSourceManager == null) {
            return;
        }
        mInstanceMap.remove(projectName);
        dataSourceManager.destructor();
    }

    DataSourceManager(String projectName) {
        this.mProjectName = projectName;
        this.getDictionaryRoot().attachGlobalObserver((DevelopmentObjectObserver)this);
    }

    void destructor() {
        DtDictionaryRoot dictionaryRoot = this.getDictionaryRoot();
        if (dictionaryRoot != null) {
            dictionaryRoot.detachGlobalObserver((DevelopmentObjectObserver)this);
        }
        this.mProjectName = null;
        this.mChangeListener = null;
    }

    private Metamodel getMetamodel() {
        Metamodel metamodel = MetamodelManager.getMetamodel((String)this.mProjectName);
        return metamodel;
    }

    public DtDictionaryRoot getDictionaryRoot() {
        Metamodel metamodel = this.getMetamodel();
        DtDictionaryRoot dictionaryRoot = metamodel != null ? DictionaryRootManager.getDictionaryRoot((Metamodel)metamodel) : null;
        return dictionaryRoot;
    }

    boolean developmentObjectExists(UniqueName uniqueName) {
        boolean exists = this.getDevelopmentObject(uniqueName) != null;
        return exists;
    }

    public DevelopmentObject getDevelopmentObject(UniqueName uniqueName) {
        String name = uniqueName.getName();
        if (name.length() == 0) {
            return null;
        }
        name = name.replace('#', ':');
        DevelopmentObjectKey keyObject = null;
        try {
            keyObject = this.getMetamodel().createDevelopmentObjectKeyFromString(name);
        }
        catch (InvalidKeyException e) {
            TsmodelDictionaryPlugin.tracer.error("getMAPIObject: invalid key exception", (Throwable)e);
            return null;
        }
        return this.getMetamodel().getObjectFromKey(keyObject);
    }

    static String adaptKey(String key) {
        return key.replace(':', '#');
    }

    public static UniqueName createUniqueName(DevelopmentObject object, String subDomain, String location) {
        String name = object.getKey().toString();
        UniqueName uniqueName = ModelAccess.createUniqueName((String)"Dictionaries", (String)subDomain, (String)location, (String)DataSourceManager.adaptKey(name), null);
        return uniqueName;
    }

    public void setListener(HierarchyDeltaProvider provider) {
        this.mChangeListener = provider;
    }

    public void removeListener(HierarchyDeltaProvider provider) {
    }

    UpdateDescription[] getObjectsToUpdate(MetamodelEvent event) {
        ArrayList<UpdateDescription> list = new ArrayList<UpdateDescription>();
        UniqueName uniqueName = null;
        DevelopmentObject object = event.getModifiedObject();
        if (object == null) {
            return null;
        }
        if (event.getEventId() == 1 || event.getEventId() == 2) {
            DevelopmentObject changedObject = event.getModifiedObject();
            if (changedObject instanceof DtSimpleType) {
                uniqueName = DataSourceManager.createUniqueNameForStructureNode("SimpleTypes");
            }
            if (changedObject instanceof DtDbTable) {
                uniqueName = DataSourceManager.createUniqueNameForStructureNode("DbTables");
            }
            if (changedObject instanceof DtDbIndex) {
                uniqueName = DataSourceManager.createUniqueNameForStructureNode("DbTables");
            }
            if (changedObject instanceof DtGeneralStructure) {
                uniqueName = DataSourceManager.createUniqueNameForStructureNode("Structures");
            }
            if (changedObject instanceof DtDbView) {
                uniqueName = DataSourceManager.createUniqueNameForStructureNode("DbViews");
            }
            if (uniqueName != null) {
                list.add(new UpdateDescription(uniqueName, ModelDeltaNodeKind.CHANGED));
            } else {
                return null;
            }
        }
        if (list.size() > 0) {
            UpdateDescription[] helperArray = new UpdateDescription[]{};
            return list.toArray(helperArray);
        }
        return null;
    }

    private void updateInternal(MetamodelEvent event) {
        DevelopmentObject object = event.getModifiedObject();
        UpdateDescription[] descriptions = this.getObjectsToUpdate(event);
        if (descriptions == null) {
            return;
        }
        if (this.mProjectName != null && this.mChangeListener != null) {
            int i = 0;
            while (i < descriptions.length) {
                this.mChangeListener.update(descriptions[i].getUniqueName(), descriptions[i].getModelDeltaNodeKind());
                ++i;
            }
            return;
        }
    }

    public void update(MetamodelEvent event) {
        this.updateInternal(event);
        if (this.mChangeListener != null && (event.getEventId() == 1 || event.getEventId() == 2 || event.getEventId() == 64)) {
            this.updateModel(this.mChangeListener.getModel());
        }
    }

    public void update(MetamodelEvent[] events) {
        int i = 0;
        while (i < events.length) {
            this.updateInternal(events[i]);
            this.updateModel(this.mChangeListener.getModel());
            ++i;
        }
    }

    public void refresh() {
        this.mChangeListener.totalUpdate();
        this.updateModel(this.mChangeListener.getModel());
    }

    public void commitChanges() {
    }

    public static UniqueName createUniqueNameForStructureNode(String subDomain) {
        UniqueName uniqueName = ModelAccess.createUniqueName((String)"Dictionaries", (String)subDomain, null, null, null);
        return uniqueName;
    }

    public static UniqueName createUniqueNameForStructureNode(String subDomain, String location) {
        UniqueName uniqueName = ModelAccess.createUniqueName((String)"Dictionaries", (String)subDomain, (String)location, null, null);
        return uniqueName;
    }

    public static void refreshProject(String projectName) {
        IProject eclipseProject = ResourcesPlugin.getWorkspace().getRoot().getProject(projectName);
        if (eclipseProject != null) {
            try {
                eclipseProject.refreshLocal(2, null);
            }
            catch (CoreException e) {
                TsmodelDictionaryPlugin.tracer.error("refresh resource", (Throwable)e);
            }
        } else {
            System.out.println("DataSourceManager: eclipseProject is null");
        }
    }

    public String getProjectName() {
        return this.mProjectName;
    }

    private void updateModel(Model model) {
        model.getExtensionManager().modelContentsChanged();
    }

    public Model getModelEntity() {
        UniqueName uname = ModelAccess.createModelUniqueName((String)this.mProjectName);
        Model lModel = ModelAccess.getModel((UniqueName)uname);
        return lModel;
    }

    public Entity getDictionaryNode(Model model, String subdomain) {
        UniqueName uname = DataSourceManager.createUniqueNameForStructureNode(subdomain);
        Entity entity = model.findEntity(uname);
        return entity;
    }

    public Element getSimpleTypesEntity() {
        Model lModel = this.getModelEntity();
        if (lModel == null) {
            return null;
        }
        Entity simpleTypesNode = this.getDictionaryNode(lModel, "SimpleTypes");
        if (simpleTypesNode == null) {
            return null;
        }
        return simpleTypesNode;
    }

    public void setSimpleTypeName(String name) {
        this.tempName = name;
    }

    public String getSimpleTypeName() {
        String newName = new String(this.tempName);
        this.tempName = "";
        return newName;
    }

    static {
        mInstanceMap = new HashMap();
    }
}

