/*
 * Decompiled with CFR 0.152.
 */
package com.sap.dictionary.tools.tsmodel.dictionary.factories;

import com.sap.dictionary.tools.tsmodel.dictionary.actions.EditStructureInput;
import com.sap.dictionary.tools.tsmodel.dictionary.plugin.TsmodelDictionaryPlugin;
import com.sap.ide.metamodel.Metamodel;
import com.sap.ide.metamodel.core.plugin.MetamodelManager;
import com.sap.ide.metamodel.dictionary.DtDictionaryRoot;
import com.sap.ide.metamodel.dictionary.datatype.DtGeneralStructure;
import com.sap.ide.metamodel.dictionary.datatype.DtStructure;
import com.sap.ide.metamodel.dictionary.plugin.DictionaryRootManager;
import com.sap.ide.metamodel.general.exception.LoadException;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.ui.IElementFactory;
import org.eclipse.ui.IMemento;

public class StructureEditorElementFactory
implements IElementFactory {
    public IAdaptable createElement(IMemento memento) {
        String project = memento.getString("project");
        if (project == null) {
            return null;
        }
        String packageName = memento.getString("package");
        if (packageName == null) {
            return null;
        }
        String objectName = memento.getString("developmentObject");
        if (objectName == null) {
            return null;
        }
        IProject eclipseProject = ResourcesPlugin.getWorkspace().getRoot().getProject(project);
        if (eclipseProject == null || !eclipseProject.exists()) {
            return null;
        }
        Metamodel metamodel = MetamodelManager.getMetamodel((String)project);
        if (metamodel == null) {
            return null;
        }
        DtDictionaryRoot root = DictionaryRootManager.getDictionaryRoot((Metamodel)metamodel);
        if (root == null) {
            return null;
        }
        DtGeneralStructure structure = null;
        try {
            structure = root.getStructure(packageName, objectName);
        }
        catch (LoadException e) {
            TsmodelDictionaryPlugin.tracer.error("get structure " + objectName, (Throwable)e);
            return null;
        }
        if (structure == null) {
            return null;
        }
        return new EditStructureInput(metamodel, root, (DtStructure)structure);
    }
}

