/*
 * Decompiled with CFR 0.152.
 */
package com.sap.dictionary.tools.tsmodel.dictionary.factories;

import com.sap.dictionary.tools.tsmodel.dictionary.actions.EditSimpleTypeInput;
import com.sap.dictionary.tools.tsmodel.dictionary.plugin.TsmodelDictionaryPlugin;
import com.sap.ide.metamodel.Metamodel;
import com.sap.ide.metamodel.core.plugin.MetamodelManager;
import com.sap.ide.metamodel.dictionary.DtDictionaryRoot;
import com.sap.ide.metamodel.dictionary.datatype.DtSimpleType;
import com.sap.ide.metamodel.dictionary.plugin.DictionaryRootManager;
import com.sap.ide.metamodel.general.exception.LoadException;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.ui.IElementFactory;
import org.eclipse.ui.IMemento;

public class SimpletypeEditorElementFactory
implements IElementFactory {
    public IAdaptable createElement(IMemento memento) {
        String project = memento.getString("project");
        if (project == null) {
            return null;
        }
        String packageName = memento.getString("package");
        if (packageName == null) {
            return null;
        }
        String objectName = memento.getString("developmentObject");
        if (objectName == null) {
            return null;
        }
        IProject eclipseProject = ResourcesPlugin.getWorkspace().getRoot().getProject(project);
        if (eclipseProject == null || !eclipseProject.exists()) {
            return null;
        }
        Metamodel metamodel = MetamodelManager.getMetamodel((String)project);
        if (metamodel == null) {
            return null;
        }
        DtDictionaryRoot root = DictionaryRootManager.getDictionaryRoot((Metamodel)metamodel);
        if (root == null) {
            return null;
        }
        DtSimpleType simpleType = null;
        try {
            simpleType = root.getSimpleType(packageName, objectName);
        }
        catch (LoadException e) {
            TsmodelDictionaryPlugin.tracer.error("get simple type " + objectName, (Throwable)e);
            return null;
        }
        if (simpleType == null) {
            return null;
        }
        return new EditSimpleTypeInput(metamodel, root, simpleType);
    }
}

