/*
 * Decompiled with CFR 0.152.
 */
package com.sap.dictionary.tools.tsmodel.dictionary.actions;

import com.sap.dictionary.tools.tsmodel.dictionary.actions.EditStructureInput;
import com.sap.dictionary.tools.tsmodel.dictionary.plugin.TsmodelDictionaryPlugin;
import com.sap.dictionary.tools.tsmodel.dictionary.provider.DataSourceManager;
import com.sap.dictionary.tools.tsmodel.dictionary.utils.MetamodelServices;
import com.sap.ide.metamodel.dictionary.datatype.DtStructure;
import com.sap.ide.metamodel.general.DevelopmentObject;
import com.tssap.selena.model.elements.Element;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IObjectActionDelegate;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;

public class EditStructureAction
implements IObjectActionDelegate {
    private Shell myShell;
    private Element myElement;
    static /* synthetic */ Class class$com$tssap$selena$model$elements$Element;

    public void setActivePart(IAction action, IWorkbenchPart targetPart) {
        this.myShell = targetPart.getSite().getShell();
    }

    public void run(IAction action) {
        if (this.myElement == null) {
            return;
        }
        String projectName = this.myElement.getModel().getUniqueName().getName();
        DevelopmentObject object = DataSourceManager.getDataSourceManager(projectName).getDevelopmentObject(this.myElement.getUniqueName());
        if (object == null) {
            System.out.println("EditStructureAction: object is NULL");
            return;
        }
        if (object instanceof DtStructure) {
            DtStructure structure = (DtStructure)object;
            if (structure == null) {
                MessageDialog.openError((Shell)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (String)"Inconsistent Data", (String)"Structure does not exist");
            } else if (structure.getName() == null) {
                MessageDialog.openError((Shell)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (String)"Inconsistent Data", (String)"Structure editor cannot be opened because structure name is missing");
            } else {
                try {
                    IWorkbenchWindow dwindow = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
                    IWorkbenchPage page = dwindow.getActivePage();
                    if (page != null) {
                        IEditorReference[] ref = page.getEditorReferences();
                        int i = 0;
                        while (i < ref.length) {
                            IEditorInput input = ref[i].getEditor(false).getEditorInput();
                            if (input instanceof EditStructureInput && ((EditStructureInput)input).structure == structure) {
                                page.openEditor(input, "com.sap.dictionary.tools.structureeditor.StructureEditor");
                                return;
                            }
                            ++i;
                        }
                        page.openEditor((IEditorInput)new EditStructureInput(MetamodelServices.getMetamodel(projectName), MetamodelServices.getDictionaryRoot(projectName), structure), "com.sap.dictionary.tools.structureeditor.StructureEditor", true);
                    }
                }
                catch (PartInitException e) {
                    TsmodelDictionaryPlugin.tracer.error("open editor", (Throwable)e);
                }
            }
        } else {
            System.out.println("EditStructureAction: object is no Structure");
        }
    }

    public void selectionChanged(IAction action, ISelection selection) {
        Object selectedObject = ((IStructuredSelection)selection).getFirstElement();
        if (selectedObject instanceof Element) {
            this.myElement = (Element)selectedObject;
        } else if (selectedObject instanceof IAdaptable) {
            this.myElement = (Element)((IAdaptable)selectedObject).getAdapter(class$com$tssap$selena$model$elements$Element == null ? (class$com$tssap$selena$model$elements$Element = EditStructureAction.class$("com.tssap.selena.model.elements.Element")) : class$com$tssap$selena$model$elements$Element);
        }
        action.setEnabled(this.myElement != null);
    }

    public void setSelectedElement(Element element) {
        this.myElement = element;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

