/*
 * Decompiled with CFR 0.152.
 */
package com.sap.dictionary.tools.tsmodel.dictionary.actions;

import com.sap.dictionary.tools.tsmodel.dictionary.actions.CreateStructureWizardPage;
import com.sap.dictionary.tools.tsmodel.dictionary.provider.DataSourceManager;
import com.sap.ide.metamodel.core.repository.PackageNameService;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;

public class CreateStructureWizard
extends Wizard
implements INewWizard {
    public static final String DEFAULT_PACKAGE = "";
    public static final String PAGE = "c_structure";
    public String mName = null;
    public String mCont = null;
    public DataSourceManager mDataSourceManager = null;
    public WizardPage mPage;

    public CreateStructureWizard(DataSourceManager dataSourceManager) {
        String projectName = dataSourceManager.getDictionaryRoot().getMetamodel().getName();
        this.addPage((IWizardPage)new CreateStructureWizardPage(PAGE, projectName, DEFAULT_PACKAGE));
        this.mPage = (WizardPage)this.getPage(PAGE);
        this.mDataSourceManager = dataSourceManager;
    }

    public boolean performFinish() {
        this.mName = ((CreateStructureWizardPage)this.getPage((String)PAGE)).propName.getText();
        this.mCont = ((CreateStructureWizardPage)this.getPage((String)PAGE)).propPackage.getText();
        String packageName = this.mCont;
        IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(this.mDataSourceManager.getProjectName());
        int ret = PackageNameService.canReservePackageName((String)packageName, (IProject)project);
        if (ret == PackageNameService.ICouldNotReservePackageName) {
            this.mPage.setErrorMessage("Package name is already reserved. Choose a different package name.");
            this.mName = null;
            this.mCont = null;
            return false;
        }
        if (ret != PackageNameService.IOk) {
            String message = null;
            if (ret == PackageNameService.ICommunicationException) {
                message = "Communication error";
            } else if (ret == PackageNameService.ICoreException) {
                message = "Core Exception";
            } else if (ret == PackageNameService.ICouldNotLogon) {
                message = "Could not logon";
            } else if (ret == PackageNameService.IProjectNotUnderSourceControl) {
                message = "Project is not under source control";
            } else if (ret == PackageNameService.IVfsException) {
                message = "Vfs error";
            }
            if (!MessageDialog.openQuestion((Shell)Display.getDefault().getActiveShell(), (String)message, (String)"Could not check package name. Do you want to continue?")) {
                this.mName = null;
                this.mCont = null;
                return false;
            }
        }
        if (this.mDataSourceManager.getDictionaryRoot().hasStructure(this.mCont, this.mName)) {
            this.mPage.setErrorMessage("Structure already exists");
            return false;
        }
        return true;
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
        this.setWindowTitle("New Structure");
    }
}

