/*
 * Decompiled with CFR 0.152.
 */
package com.sap.dictionary.tools.tsmodel.dictionary.actions;

import com.sap.dictionary.tools.tsmodel.dictionary.utils.DictionaryObjectChecker;
import com.sap.dictionary.tools.tsmodel.dictionary.utils.DictionaryUtil;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class CreateSimpletypeWizardPage
extends WizardPage {
    private static final String PAGE_TITLE = "New Simple Type";
    private static final String PAGE_DESCRIPTION = "Enter the name and package for the new simple type";
    public Text propName;
    public Text propPackage;
    private Button browsePackageButton;
    private String mProjectName;
    private String newStName = "";
    private String newStPackage = "";

    protected CreateSimpletypeWizardPage(String pageName, String projectName, String newName) {
        super(pageName);
        this.setTitle(PAGE_TITLE);
        this.setDescription(PAGE_DESCRIPTION);
        this.mProjectName = projectName;
        if (newName.indexOf(".") >= 0) {
            this.newStPackage = newName.substring(0, newName.lastIndexOf("."));
            this.newStName = newName.substring(newName.lastIndexOf(".") + 1, newName.length());
        } else {
            this.newStName = newName;
            this.newStPackage = "";
        }
    }

    protected CreateSimpletypeWizardPage(String pageName, String title, ImageDescriptor titleImage) {
        super(pageName, title, titleImage);
    }

    public void createControl(Composite parent) {
        Composite root = new Composite(parent, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 3;
        root.setLayout((Layout)gridLayout);
        GridData gd = new GridData(256);
        root.setLayoutData((Object)gd);
        this.setControl((Control)root);
        new Label(root, 0).setText("Simple Type name:");
        this.propName = new Text(root, 2052);
        this.propName.setText(this.newStName);
        GridData gd2 = new GridData(256);
        gd2.grabExcessHorizontalSpace = true;
        this.propName.setLayoutData((Object)gd2);
        new Label(root, 0).setText("");
        new Label(root, 0).setText("Simple Type package:");
        this.propPackage = new Text(root, 2052);
        GridData gd3 = new GridData(256);
        gd3.grabExcessHorizontalSpace = true;
        this.propPackage.setLayoutData((Object)gd3);
        this.propPackage.setText("");
        if (this.newStPackage.length() > 0) {
            this.propPackage.setText(this.newStPackage);
        }
        this.browsePackageButton = new Button(root, 8);
        this.browsePackageButton.setText("Browse...");
        this.setPageComplete(false);
        this.checkInput();
        this.propName.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                CreateSimpletypeWizardPage.this.checkInput();
            }
        });
        this.propPackage.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                CreateSimpletypeWizardPage.this.checkInput();
            }
        });
        this.browsePackageButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                CreateSimpletypeWizardPage.this.searchPackage();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
    }

    private void checkInput() {
        String errMess = null;
        if (this.isValidIdentifier(this.propName.getText())) {
            errMess = DictionaryObjectChecker.checkPackageName(this.propPackage.getText());
            if (errMess == null) {
                this.setPageComplete(true);
                this.setErrorMessage(null);
            } else {
                this.setPageComplete(false);
                this.setErrorMessage(errMess);
            }
        } else {
            this.setPageComplete(false);
        }
    }

    public final boolean isValidIdentifier(String s) {
        if (s != null && s.length() > 0) {
            String message = DictionaryObjectChecker.checkSimpleTypeName(s);
            if (message == null) {
                return true;
            }
            this.setErrorMessage(message);
            return false;
        }
        return false;
    }

    private void searchPackage() {
        String packageName = DictionaryUtil.searchPackage(this, this.mProjectName);
        if (!DictionaryUtil.stringIsEmpty(packageName)) {
            this.propPackage.setText(packageName);
        }
    }
}

