/*
 * Decompiled with CFR 0.152.
 */
package com.sap.dictionary.tools.tsmodel.dictionary.actions;

import com.sap.dictionary.tools.tsmodel.dictionary.plugin.TsmodelDictionaryPlugin;
import com.sap.dictionary.tools.tsmodel.dictionary.provider.DataSourceManager;
import com.sap.dictionary.tools.tsmodel.dictionary.utils.DictionaryObjectChecker;
import com.sap.dictionary.tools.tsmodel.dictionary.utils.DictionaryUtil;
import com.sap.dictionary.tools.tsmodel.preference.NSPreferencePage;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class CreateDbTableWizardPage
extends WizardPage {
    public Text propName;
    private Button browsePackageButton;
    private String mProjectName;
    private DataSourceManager mDataSourceManager;
    private boolean mIsTable = true;

    protected CreateDbTableWizardPage(String pageName, String projectName, DataSourceManager dataSourceManager, boolean isTable) {
        super(pageName);
        this.mIsTable = isTable;
        if (isTable) {
            this.setTitle("New Database Table");
            this.setDescription("Enter the name of the new database table");
        } else {
            this.setTitle("New Database View");
            this.setDescription("Enter the name of the new database view");
        }
        this.mProjectName = projectName;
        this.mDataSourceManager = dataSourceManager;
    }

    protected CreateDbTableWizardPage(String pageName, String title, ImageDescriptor titleImage) {
        super(pageName, title, titleImage);
    }

    public void createControl(Composite parent) {
        Composite root = new Composite(parent, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 2;
        root.setLayout((Layout)gridLayout);
        GridData gd = new GridData(256);
        root.setLayoutData((Object)gd);
        this.setControl((Control)root);
        if (this.mIsTable) {
            new Label(root, 0).setText("Table name:");
        } else {
            new Label(root, 0).setText("Database view name:");
        }
        this.propName = new Text(root, 2052);
        GridData gd2 = new GridData(256);
        gd2.grabExcessHorizontalSpace = true;
        this.propName.setLayoutData((Object)gd2);
        IPreferenceStore store = TsmodelDictionaryPlugin.getDefault().getPreferenceStore();
        this.propName.setText(store.getString(NSPreferencePage.nskey));
        this.propName.selectAll();
        this.setPageComplete(false);
        this.propName.addFocusListener((FocusListener)new FocusAdapter(){

            public void focusLost(FocusEvent e) {
                super.focusLost(e);
                String temp = CreateDbTableWizardPage.this.propName.getText();
                temp = temp.toUpperCase();
                CreateDbTableWizardPage.this.propName.setText(temp);
                CreateDbTableWizardPage.this.checkInput();
            }
        });
        this.propName.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                CreateDbTableWizardPage.this.checkEmpty();
                CreateDbTableWizardPage.this.checkInput();
            }
        });
    }

    private void checkInput() {
        Object errMess = null;
        if (this.isValidIdentifier(this.propName.getText())) {
            this.setPageComplete(true);
            this.setErrorMessage(null);
        } else {
            this.setPageComplete(false);
        }
    }

    private void checkEmpty() {
        String tableName = this.propName.getText();
        if (DictionaryUtil.stringIsEmpty(tableName)) {
            if (this.mIsTable) {
                this.setErrorMessage("Specify the table name");
            } else {
                this.setErrorMessage("Specify the database view name");
            }
            this.setPageComplete(false);
        } else {
            this.setErrorMessage(null);
            this.setPageComplete(true);
        }
    }

    public final boolean isValidIdentifier(String s) {
        if (this.mIsTable) {
            String message = DictionaryObjectChecker.checkTableName(s, null, 'A', this.mDataSourceManager);
            if (DictionaryUtil.stringIsEmpty(message)) {
                return true;
            }
            this.setErrorMessage(message);
            return false;
        }
        String message = DictionaryObjectChecker.checkViewName(s, null, 'A', this.mDataSourceManager);
        if (DictionaryUtil.stringIsEmpty(message)) {
            return true;
        }
        this.setErrorMessage(message);
        return false;
    }
}

