/*
 * Decompiled with CFR 0.152.
 */
package com.sap.dictionary.tools.tsmodel.dictionary.actions;

import com.sap.dictionary.tools.nameserver.NameServerUtil;
import com.sap.dictionary.tools.tsmodel.dictionary.actions.CreateDbTableWizardPage;
import com.sap.dictionary.tools.tsmodel.dictionary.provider.DataSourceManager;
import com.sap.dictionary.tools.ui.messages.MessagePool;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;

public class CreateDbTableWizard
extends Wizard
implements INewWizard {
    public static final String DEFAULT_PACKAGE = "";
    public static final String PAGE = "c_dbtable";
    public String mName = null;
    public DataSourceManager mDataSourceManager = null;
    public WizardPage mPage;
    private String mProjectName = null;
    private boolean mIsTable = true;

    public CreateDbTableWizard(DataSourceManager dataSourceManager, boolean isTable) {
        this.mIsTable = isTable;
        this.mProjectName = dataSourceManager.getDictionaryRoot().getMetamodel().getName();
        this.addPage((IWizardPage)new CreateDbTableWizardPage(PAGE, this.mProjectName, dataSourceManager, this.mIsTable));
        this.mPage = (WizardPage)this.getPage(PAGE);
        this.mDataSourceManager = dataSourceManager;
    }

    public boolean performFinish() {
        ((CreateDbTableWizardPage)this.getPage(PAGE)).setPageComplete(false);
        this.mName = ((CreateDbTableWizardPage)this.getPage((String)PAGE)).propName.getText();
        if (this.mDataSourceManager.getDictionaryRoot().hasTable(DEFAULT_PACKAGE, this.mName)) {
            if (this.mIsTable) {
                this.mPage.setErrorMessage(MessagePool.getMessage((String)"Table & already exists", (String)this.mName));
            } else {
                this.mPage.setErrorMessage(MessagePool.getMessage((String)"Database view & already exists", (String)this.mName));
            }
            return false;
        }
        if (NameServerUtil.isNameReservedOnWizard((String)"SAP_DBObjectName", (String)this.mProjectName, (String)this.mName, (boolean)false)) {
            return false;
        }
        return NameServerUtil.isPrefixValidOnWizard((String)"SAP_DBObjectName", (String)this.mProjectName, (String)this.mName, (WizardPage)((WizardPage)this.getPage(PAGE)), (boolean)true);
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
        if (this.mIsTable) {
            this.setWindowTitle("New Database Table");
        } else {
            this.setWindowTitle("New Database View");
        }
    }
}

