/*
 * Decompiled with CFR 0.152.
 */
package com.sap.dictionary.tools.tsmodel.dictionary.actions;

import com.sap.dictionary.tools.tsmodel.dictionary.utils.DictionaryObjectChecker;
import com.sap.dictionary.tools.tsmodel.dictionary.utils.DictionaryUtil;
import com.sap.ide.metamodel.general.clipboard.ClipboardObject;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class CopyStructureWizardPage
extends WizardPage {
    private ClipboardObject mClipboardObject;
    private String mProjectName;
    private String[] mMessages;
    private Text mOldStructure;
    private Text mOldPackage;
    private Text mNewStructure;
    private Text mNewPackage;
    private Button mBrowse;
    protected static final int CHECK_STRUCTURE = 0;
    protected static final int CHECK_PACKAGE = 1;

    public CopyStructureWizardPage(String pageName, String projectName, ClipboardObject clipboardObject) {
        super(pageName);
        this.setTitle(pageName);
        this.setDescription("Enter the name of the new structure");
        this.mProjectName = projectName;
        this.mClipboardObject = clipboardObject;
        this.mMessages = new String[2];
    }

    public void createControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 3;
        composite.setLayout((Layout)gridLayout);
        GridData gridData = new GridData(256);
        composite.setLayoutData((Object)gridData);
        Label label = new Label(composite, 0);
        label.setText("From structure:");
        this.mOldStructure = new Text(composite, 2052);
        gridData = new GridData(768);
        this.mOldStructure.setLayoutData((Object)gridData);
        this.mOldStructure.setEditable(false);
        label = new Label(composite, 0);
        label.setText("");
        label = new Label(composite, 0);
        label.setText("From package:");
        this.mOldPackage = new Text(composite, 2052);
        gridData = new GridData(768);
        this.mOldPackage.setLayoutData((Object)gridData);
        this.mOldPackage.setEditable(false);
        label = new Label(composite, 0);
        label.setText("");
        label = new Label(composite, 0);
        label.setText("To structure:");
        this.mNewStructure = new Text(composite, 2052);
        gridData = new GridData(768);
        this.mNewStructure.setLayoutData((Object)gridData);
        label = new Label(composite, 0);
        label.setText("");
        label = new Label(composite, 0);
        label.setText("To package:");
        this.mNewPackage = new Text(composite, 2052);
        gridData = new GridData(768);
        this.mNewPackage.setLayoutData((Object)gridData);
        this.mNewStructure.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                CopyStructureWizardPage.this.checkPackageName();
                CopyStructureWizardPage.this.checkStructureName();
            }
        });
        this.mNewPackage.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                CopyStructureWizardPage.this.checkStructureName();
                CopyStructureWizardPage.this.checkPackageName();
            }
        });
        this.mBrowse = new Button(composite, 8);
        this.mBrowse.setText("Browse...");
        this.mBrowse.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                CopyStructureWizardPage.this.searchPackage();
            }
        });
        this.initialize();
        this.setControl((Control)composite);
        this.mNewStructure.setFocus();
        this.setPageComplete(false);
    }

    private void initialize() {
        if (this.mClipboardObject != null) {
            this.mOldStructure.setText(this.mClipboardObject.getNewName());
            this.mOldPackage.setText(this.mClipboardObject.getNewPackage());
            this.setPageComplete(true);
        } else {
            this.setPageComplete(false);
        }
    }

    private void searchPackage() {
        String packageName = DictionaryUtil.searchPackage(this, this.mProjectName);
        if (!DictionaryUtil.stringIsEmpty(packageName)) {
            this.mNewPackage.setText(packageName);
        }
    }

    private void checkStructureName() {
        this.updateStatus(DictionaryObjectChecker.checkStructureName(this.mNewStructure.getText()), 0);
    }

    private void checkPackageName() {
        this.updateStatus(DictionaryObjectChecker.checkPackageName(this.mNewPackage.getText()), 1);
    }

    protected String getStructureName() {
        return this.mNewStructure.getText();
    }

    protected String getPackageName() {
        return this.mNewPackage.getText();
    }

    protected void updateStatus(String message, int index) {
        this.mMessages[index] = message;
        if (DictionaryUtil.stringIsEmpty(message)) {
            int i = 0;
            while (i < this.mMessages.length) {
                if (i != index && !DictionaryUtil.stringIsEmpty(this.mMessages[i])) {
                    message = this.mMessages[i];
                    break;
                }
                ++i;
            }
        }
        if (DictionaryUtil.stringIsEmpty(message)) {
            this.setErrorMessage(null);
            this.setPageComplete(true);
        } else {
            this.setErrorMessage(message);
            this.setPageComplete(false);
        }
    }
}

