/*
 * Decompiled with CFR 0.152.
 */
package com.sap.dictionary.tools.tsmodel.dictionary.actions;

import com.sap.dictionary.tools.tsmodel.dictionary.actions.CopyStructureWizardPage;
import com.sap.dictionary.tools.tsmodel.dictionary.provider.DataSourceManager;
import com.sap.dictionary.tools.ui.messages.MessagePool;
import com.sap.ide.metamodel.general.clipboard.ClipboardObject;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;

public class CopyStructureWizard
extends Wizard
implements INewWizard {
    private CopyStructureWizardPage mCopyStructureWizardPage;
    private DataSourceManager mDataSourceManager = null;
    private String mProjectName = null;
    private ClipboardObject mClipboardObject = null;

    public CopyStructureWizard(DataSourceManager dataSourceManager, ClipboardObject clipboardObject) {
        this.mDataSourceManager = dataSourceManager;
        this.mClipboardObject = clipboardObject;
        this.mProjectName = dataSourceManager.getDictionaryRoot().getMetamodel().getName();
    }

    public void addPages() {
        this.mCopyStructureWizardPage = new CopyStructureWizardPage("Copy Structure", this.mProjectName, this.mClipboardObject);
        this.addPage((IWizardPage)this.mCopyStructureWizardPage);
    }

    public boolean performFinish() {
        String structureName = this.mCopyStructureWizardPage.getStructureName();
        String packageName = this.mCopyStructureWizardPage.getPackageName();
        if (this.mDataSourceManager.getDictionaryRoot().hasStructure(packageName, structureName)) {
            this.mCopyStructureWizardPage.updateStatus(MessagePool.getMessage((String)"Structure & already exists in package &", (String)structureName, (String)packageName), 0);
            return false;
        }
        if (this.mClipboardObject != null) {
            this.mClipboardObject.setNewName(structureName);
            this.mClipboardObject.setNewPackage(packageName);
            return true;
        }
        return false;
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
    }
}

