/*
 * Decompiled with CFR 0.152.
 */
package com.sap.dictionary.tools.tsmodel.dictionary.actions;

import com.sap.dictionary.tools.tsmodel.dictionary.actions.CopySimpleTypeWizardPage;
import com.sap.dictionary.tools.tsmodel.dictionary.provider.DataSourceManager;
import com.sap.dictionary.tools.ui.messages.MessagePool;
import com.sap.ide.metamodel.general.clipboard.ClipboardObject;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;

public class CopySimpleTypeWizard
extends Wizard
implements INewWizard {
    private CopySimpleTypeWizardPage mCopySimpleTypeWizardPage;
    private DataSourceManager mDataSourceManager = null;
    private String mProjectName = null;
    private ClipboardObject mClipboardObject = null;

    public CopySimpleTypeWizard(DataSourceManager dataSourceManager, ClipboardObject clipboardObject) {
        this.mDataSourceManager = dataSourceManager;
        this.mClipboardObject = clipboardObject;
        this.mProjectName = dataSourceManager.getDictionaryRoot().getMetamodel().getName();
    }

    public void addPages() {
        this.mCopySimpleTypeWizardPage = new CopySimpleTypeWizardPage("Copy Simple Type", this.mProjectName, this.mClipboardObject);
        this.addPage((IWizardPage)this.mCopySimpleTypeWizardPage);
    }

    public boolean performFinish() {
        String simpleTypeName = this.mCopySimpleTypeWizardPage.getSimpleTypeName();
        String packageName = this.mCopySimpleTypeWizardPage.getPackageName();
        if (this.mDataSourceManager.getDictionaryRoot().hasSimpleType(packageName, simpleTypeName)) {
            this.mCopySimpleTypeWizardPage.updateStatus(MessagePool.getMessage((String)"Simple type & already exists in package &", (String)simpleTypeName, (String)packageName), 0);
            return false;
        }
        if (this.mClipboardObject != null) {
            this.mClipboardObject.setNewName(simpleTypeName);
            this.mClipboardObject.setNewPackage(packageName);
            return true;
        }
        return false;
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
    }
}

