/*
 * Decompiled with CFR 0.152.
 */
package com.sap.dictionary.tools.tsmodel.dictionary.actions;

import com.sap.dictionary.tools.nameserver.NameServerUtil;
import com.sap.dictionary.tools.tsmodel.dictionary.plugin.TsmodelDictionaryPlugin;
import com.sap.dictionary.tools.tsmodel.dictionary.provider.DataSourceManager;
import com.sap.dictionary.tools.tsmodel.dictionary.utils.DictionaryObjectChecker;
import com.sap.dictionary.tools.tsmodel.dictionary.utils.DictionaryUtil;
import com.sap.ide.metamodel.dictionary.datatype.DtDbTable;
import com.sap.ide.metamodel.general.clipboard.ClipboardObject;
import com.sap.ide.metamodel.general.exception.LoadException;
import com.tssap.util.ui.lfsupport.IWidgetFactory;
import com.tssap.util.ui.lfsupport.LiteWidgetFactory;
import com.tssap.util.ui.pane.IGridLayoutPane;
import com.tssap.util.ui.pane.PaneFactory;
import com.tssap.util.ui.viewer.table.ISapTableViewer;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableModel;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;

public class CopyDbTableWizardPage3
extends WizardPage {
    private TableCopyTableModel mTableCopyTableModel = null;
    private ISapTableViewer mSapTableViewer;
    private ClipboardObject mClipboardObject;
    private String mProjectName;
    private DataSourceManager mDataSourceManager;
    private boolean nameServerChecked = false;
    private String[] mMessages;
    private static final String PAGE_DESCR = "Enter the names of the new tables";
    private static final int COLUMN_POSITION_OLD_NAME = 0;
    private static final int COLUMN_POSITION_NEW_NAME = 1;
    private static final String ERROR = "Error";
    private static final String MESSAGE_DUMMY = "Dummy";

    public CopyDbTableWizardPage3(String pageName, String projectName, DataSourceManager dataSourceManager, ClipboardObject clipboardObject) {
        super(pageName);
        this.setTitle(pageName);
        this.setDescription(PAGE_DESCR);
        this.mProjectName = projectName;
        this.mDataSourceManager = dataSourceManager;
        this.mClipboardObject = clipboardObject;
        int i = this.mClipboardObject.getChildren().length + 1;
        this.mMessages = new String[i];
    }

    public void createControl(Composite parent) {
        Composite root = new Composite(parent, 0);
        FillLayout fillLayout = new FillLayout();
        root.setLayout((Layout)fillLayout);
        this.setControl((Control)root);
        IGridLayoutPane gridLayoutPane = PaneFactory.createGridLayoutPane((Composite)root, (int)1, (IWidgetFactory)new LiteWidgetFactory());
        this.mTableCopyTableModel = new TableCopyTableModel();
        this.mTableCopyTableModel.addColumn(new String("From Table"));
        this.mTableCopyTableModel.addColumn(new String("To Table"));
        this.initialize();
        this.mSapTableViewer = gridLayoutPane.addSapTableViewer((TableModel)this.mTableCopyTableModel, gridLayoutPane.createGridLayoutData(4, 4, true, true, 1, 1));
        this.mTableCopyTableModel.addTableModelListener(new TableCopyTableModelListener());
    }

    private void initialize() {
        this.setPageComplete(true);
    }

    private String checkTableName(String tableName, int index) {
        String message = DictionaryObjectChecker.checkTableName(tableName, (String)this.mTableCopyTableModel.getValueAt(index, 0), 'C', this.mDataSourceManager);
        if (!DictionaryUtil.stringIsEmpty(message)) {
            return message;
        }
        return this.checkNameServerReservation(tableName);
    }

    private String checkIndexName(String indexName, String tableName, int index) {
        DtDbTable dtDbTable = null;
        try {
            dtDbTable = this.mDataSourceManager.getDictionaryRoot().getTable("", tableName);
        }
        catch (LoadException e) {
            TsmodelDictionaryPlugin.tracer.error("get table " + tableName, (Throwable)e);
        }
        if (dtDbTable == null) {
            MessageDialog.openError((Shell)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (String)"Copy Index", (String)("The database table could not be determined for index " + indexName));
            return null;
        }
        String message = DictionaryObjectChecker.checkIndexName(indexName, (String)this.mTableCopyTableModel.getValueAt(index, 0), 'C');
        if (!DictionaryUtil.stringIsEmpty(message)) {
            return message;
        }
        return this.checkNameServerReservation(indexName);
    }

    private String checkNameServerReservation(String objectName) {
        if (NameServerUtil.isNameServerAvailable((String)this.mProjectName)) {
            if (NameServerUtil.isNameReservedOnWizard((String)"SAP_DBObjectName", (String)this.mProjectName, (String)objectName, (boolean)true)) {
                return MESSAGE_DUMMY;
            }
            if (!NameServerUtil.isPrefixValidOnWizard((String)"SAP_DBObjectName", (String)this.mProjectName, (String)objectName, (WizardPage)this, (boolean)true)) {
                return MESSAGE_DUMMY;
            }
        } else if (!this.nameServerChecked) {
            this.nameServerChecked = true;
            MessageDialog.openWarning((Shell)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (String)"Name Reservation", (String)"Could not connect to name serverThe name reservation of the dictionary objects can't be checked");
        }
        return null;
    }

    private void updateStatus(String message, int index) {
        this.mMessages[index] = message;
        if (DictionaryUtil.stringIsEmpty(message)) {
            int i = 0;
            while (i < this.mMessages.length) {
                if (i != index && !DictionaryUtil.stringIsEmpty(this.mMessages[i])) {
                    message = this.mMessages[i];
                    break;
                }
                ++i;
            }
        }
        if (DictionaryUtil.stringIsEmpty(message)) {
            this.setErrorMessage(null);
            this.setPageComplete(true);
        } else {
            if (!message.equals(MESSAGE_DUMMY)) {
                this.setErrorMessage(message);
            }
            this.setPageComplete(false);
        }
    }

    public class TableCopyTableModelListener
    implements TableModelListener {
        public void tableChanged(TableModelEvent e) {
            if (e.getType() != 0) {
                return;
            }
            if (e.getColumn() != 1) {
                return;
            }
            if (e.getType() != 0) {
                return;
            }
            int index = CopyDbTableWizardPage3.this.mSapTableViewer.getTable().getSelectionIndex();
            if (index < 0) {
                return;
            }
            String tableName = (String)CopyDbTableWizardPage3.this.mTableCopyTableModel.getValueAt(index, 1);
            CopyDbTableWizardPage3.this.updateStatus(CopyDbTableWizardPage3.this.checkTableName(tableName, index), index);
        }
    }

    private class TableCopyTableModel
    extends DefaultTableModel {
        public boolean isCellEditable(int row, int column) {
            return column != 0;
        }
    }
}

