/*
 * Decompiled with CFR 0.152.
 */
package com.sap.dictionary.tools.tsmodel.dictionary.actions;

import com.sap.dictionary.tools.nameserver.NameServerUtil;
import com.sap.dictionary.tools.tsmodel.dictionary.plugin.TsmodelDictionaryPlugin;
import com.sap.dictionary.tools.tsmodel.dictionary.provider.DataSourceManager;
import com.sap.dictionary.tools.tsmodel.dictionary.utils.DictionaryObjectChecker;
import com.sap.dictionary.tools.tsmodel.dictionary.utils.DictionaryUtil;
import com.sap.dictionary.tools.tsmodel.preference.NSPreferencePage;
import com.sap.ide.metamodel.dictionary.DtDictionaryDevelopmentObjectEnum;
import com.sap.ide.metamodel.general.clipboard.ClipboardObject;
import java.util.Iterator;
import java.util.Set;
import java.util.TreeMap;
import java.util.Vector;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.ICellEditorListener;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.custom.TableEditor;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;

public class CopyDbTableWizardPage
extends WizardPage {
    private ClipboardObject mClipboardObject;
    private String mProjectName;
    private DataSourceManager mDataSourceManager;
    private Text mOldTableName;
    private Text mNewTableName;
    protected Button mCopyIndexes;
    private Table mIndexes;
    private Group mIndexesGroup;
    private TableEditor mTableEditor;
    private TextCellEditor mTextCellEditor;
    private boolean nameServerChecked = false;
    private String[] mMessages;
    private static final int CHECK_TABLE = 0;
    private ClipboardObject[] mClipboardIndexes;
    protected static final int COLUMN_OLD_INDEX = 0;
    protected static final int COLUMN_NEW_INDEX = 1;
    private boolean mIsTable = true;

    public CopyDbTableWizardPage(String pageName, String projectName, DataSourceManager dataSourceManager, ClipboardObject clipboardObject, boolean isTable) {
        super(pageName);
        this.setTitle(pageName);
        if (isTable) {
            this.setDescription("Enter the name of the new table");
        } else {
            this.setDescription("Enter the name of the new view");
        }
        this.mProjectName = projectName;
        this.mDataSourceManager = dataSourceManager;
        this.mClipboardObject = clipboardObject;
        ClipboardObject[] children = clipboardObject.getChildren();
        Vector<ClipboardObject> indexes = new Vector<ClipboardObject>();
        int i = 0;
        while (i < children.length) {
            if (children[i].getType() == DtDictionaryDevelopmentObjectEnum.DTDBINDEX) {
                indexes.addElement(children[i]);
            }
            ++i;
        }
        this.mClipboardIndexes = new ClipboardObject[indexes.size()];
        indexes.toArray(this.mClipboardIndexes);
        this.mMessages = new String[this.mClipboardIndexes.length + 1];
        this.mIsTable = isTable;
    }

    public void createControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 2;
        composite.setLayout((Layout)gridLayout);
        GridData gridData = new GridData(256);
        composite.setLayoutData((Object)gridData);
        this.createTableSection(composite);
        this.createIndexesSection(composite);
        this.initialize();
        this.setControl((Control)composite);
        this.mNewTableName.setFocus();
    }

    private void initialize() {
        this.mOldTableName.setText(this.mClipboardObject.getNewName());
        if (this.mIsTable && this.mClipboardIndexes.length == 0) {
            this.mCopyIndexes.setEnabled(false);
        }
        this.setIndexesVisible(false);
        this.setPageComplete(true);
    }

    private void setIndexesVisible(boolean isVisible) {
        this.mIndexes.setVisible(isVisible);
        this.mIndexesGroup.setVisible(isVisible);
    }

    private String getOldTableName() {
        return this.mOldTableName.getText();
    }

    protected String getNewTableName() {
        return this.mNewTableName.getText();
    }

    private String checkTableName(String tableName) {
        String message = DictionaryObjectChecker.checkTableName(tableName, this.getOldTableName(), 'C', this.mDataSourceManager);
        if (!DictionaryUtil.stringIsEmpty(message)) {
            return message;
        }
        return this.checkNameServerReservation(tableName);
    }

    private String checkIndexName(String newIndexName, String oldIndexName) {
        if (DictionaryUtil.stringIsEmpty(newIndexName)) {
            return null;
        }
        String message = DictionaryObjectChecker.checkIndexName(newIndexName, oldIndexName, 'C');
        if (!DictionaryUtil.stringIsEmpty(message)) {
            return message;
        }
        return this.checkNameServerReservation(newIndexName);
    }

    private String checkNameServerReservation(String objectName) {
        if (NameServerUtil.isNameServerAvailable((String)this.mProjectName)) {
            if (NameServerUtil.isNameReservedOnWizard((String)"SAP_DBObjectName", (String)this.mProjectName, (String)objectName, (boolean)true)) {
                return "Dummy";
            }
            if (!NameServerUtil.isPrefixValidOnWizard((String)"SAP_DBObjectName", (String)this.mProjectName, (String)objectName, (WizardPage)this, (boolean)true)) {
                return "Dummy";
            }
        } else if (!this.nameServerChecked) {
            this.nameServerChecked = true;
            MessageDialog.openWarning((Shell)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (String)"Name Reservation", (String)"Could not connect to name server\nThe name reservation of the dictionary objects can't be checked");
        }
        return null;
    }

    private void createTableSection(Composite composite) {
        Label label = new Label(composite, 0);
        if (this.mIsTable) {
            label.setText("From table:");
        } else {
            label.setText("From view:");
        }
        this.mOldTableName = new Text(composite, 2052);
        GridData gridData = new GridData(768);
        this.mOldTableName.setLayoutData((Object)gridData);
        this.mOldTableName.setEditable(false);
        label = new Label(composite, 0);
        if (this.mIsTable) {
            label.setText("To table:");
        } else {
            label.setText("To view:");
        }
        this.mNewTableName = new Text(composite, 2052);
        gridData = new GridData(768);
        this.mNewTableName.setLayoutData((Object)gridData);
        IPreferenceStore store = TsmodelDictionaryPlugin.getDefault().getPreferenceStore();
        this.mNewTableName.setText(store.getString(NSPreferencePage.nskey));
        String prefix = this.mNewTableName.getText();
        int index = DictionaryUtil.stringIsEmpty(prefix) ? 0 : prefix.length();
        this.mNewTableName.setSelection(index);
        this.mNewTableName.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                CopyDbTableWizardPage.this.updateStatus(null, 0);
            }
        });
        this.mNewTableName.addFocusListener((FocusListener)new FocusAdapter(){

            public void focusLost(FocusEvent e) {
                super.focusLost(e);
                String tableName = CopyDbTableWizardPage.this.mNewTableName.getText();
                tableName = tableName.toUpperCase();
                CopyDbTableWizardPage.this.mNewTableName.setText(tableName);
                CopyDbTableWizardPage.this.updateStatus(CopyDbTableWizardPage.this.checkTableName(tableName), 0);
            }
        });
        if (this.mIsTable) {
            this.mCopyIndexes = new Button(composite, 32);
            this.mCopyIndexes.setText("Copy indexes");
            this.mCopyIndexes.setSelection(false);
            this.mCopyIndexes.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    super.widgetSelected(e);
                    CopyDbTableWizardPage.this.setIndexesVisible(true);
                    CopyDbTableWizardPage.this.mCopyIndexes.setEnabled(false);
                }
            });
            label = new Label(composite, 0);
            label.setText("");
        }
    }

    private void createIndexesSection(Composite composite) {
        this.mIndexesGroup = new Group(composite, 0);
        this.mIndexesGroup.setText("Indexes to be copied");
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 1;
        this.mIndexesGroup.setLayout((Layout)gridLayout);
        GridData gridData = new GridData(256);
        gridData.horizontalSpan = 3;
        this.mIndexesGroup.setLayoutData((Object)gridData);
        this.mIndexes = new Table((Composite)this.mIndexesGroup, 67588);
        gridData = new GridData(1808);
        gridData.heightHint = 150;
        gridData.widthHint = 50;
        this.mIndexes.setLayoutData((Object)gridData);
        this.mIndexes.setHeaderVisible(true);
        this.mIndexes.setLinesVisible(true);
        TableColumn column0 = new TableColumn(this.mIndexes, 0);
        column0.setText("Old Index Name");
        column0.setWidth(180);
        TableColumn column1 = new TableColumn(this.mIndexes, 0);
        column1.setText("New Index Name");
        column1.setWidth(180);
        this.mTableEditor = new TableEditor(this.mIndexes);
        this.mIndexes.addListener(3, new Listener(){

            public void handleEvent(Event event) {
                Point point = new Point(event.x, event.y);
                TableItem tableItem = CopyDbTableWizardPage.this.mIndexes.getItem(point);
                if (tableItem == null) {
                    return;
                }
                int columns = CopyDbTableWizardPage.this.mIndexes.getColumnCount();
                int i = 0;
                while (i < columns) {
                    Rectangle rectangle = tableItem.getBounds(i);
                    if (rectangle.contains(point) && i == 1) {
                        CopyDbTableWizardPage.this.handleSelect(event);
                    }
                    ++i;
                }
            }
        });
        this.mIndexes.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                super.widgetSelected(e);
            }
        });
        this.fillTable();
    }

    private void fillTable() {
        TableItem tableItem = null;
        TreeMap tIndexes = new TreeMap();
        int i = 0;
        while (i < this.mClipboardIndexes.length) {
            tIndexes.put(this.mClipboardIndexes[i].getNewName(), null);
            ++i;
        }
        Set sIndexes = tIndexes.keySet();
        Iterator iter = sIndexes.iterator();
        while (iter.hasNext()) {
            tableItem = new TableItem(this.mIndexes, 0);
            tableItem.setText(0, (String)iter.next());
            tableItem.setChecked(true);
        }
    }

    protected Table getIndexes() {
        return this.mIndexes;
    }

    private void updateStatus(String message, int index) {
        this.mMessages[index] = message;
        if (DictionaryUtil.stringIsEmpty(message)) {
            int i = 0;
            while (i < this.mMessages.length) {
                if (i != index && !DictionaryUtil.stringIsEmpty(this.mMessages[i])) {
                    message = this.mMessages[i];
                    break;
                }
                ++i;
            }
        }
        if (DictionaryUtil.stringIsEmpty(message)) {
            this.setErrorMessage(null);
            this.setPageComplete(true);
        } else {
            if (!message.equals("Dummy")) {
                this.setErrorMessage(message);
            }
            this.setPageComplete(false);
        }
    }

    private void handleSelect(Event e) {
        TableItem[] tableItems;
        if (this.mTextCellEditor != null) {
            this.deactivateCellEditor();
        }
        if ((tableItems = this.mIndexes.getSelection()).length == 0) {
            return;
        }
        this.activateCellEditor(tableItems[0]);
    }

    private void deactivateCellEditor() {
        String indexName = (String)this.mTextCellEditor.getValue();
        if (indexName == null) {
            indexName = "";
        }
        indexName = indexName.toUpperCase();
        TableItem selectedItem = this.mTableEditor.getItem();
        String oldIndexName = selectedItem.getText(0);
        this.updateStatus(this.checkIndexName(indexName, oldIndexName), this.mIndexes.indexOf(selectedItem) + 1);
        if (this.mTextCellEditor != null) {
            this.mTextCellEditor = null;
        }
        selectedItem.setText(1, indexName);
        this.mTextCellEditor = null;
    }

    private void activateCellEditor(TableItem tableItem) {
        this.mIndexes.showSelection();
        String indexName = tableItem.getText(1);
        if (indexName == null) {
            indexName = "";
        }
        this.mTextCellEditor = new TextCellEditor((Composite)this.mIndexes){

            protected void keyReleaseOccured(KeyEvent keyEvent) {
                if (keyEvent.character == '\u001b') {
                    this.fireCancelEditor();
                } else if (keyEvent.character == '\r') {
                    this.deactivate();
                    CopyDbTableWizardPage.this.deactivateCellEditor();
                }
            }
        };
        if (this.mTextCellEditor == null) {
            return;
        }
        this.mTextCellEditor.setValue((Object)indexName);
        String value = (String)this.mTextCellEditor.getValue();
        if (value == null) {
            value = "";
        }
        this.mTextCellEditor.activate();
        Control control = this.mTextCellEditor.getControl();
        if (control == null) {
            this.mTextCellEditor.deactivate();
            this.mTextCellEditor = null;
            return;
        }
        CellEditor.LayoutData layout = this.mTextCellEditor.getLayoutData();
        this.mTableEditor.horizontalAlignment = layout.horizontalAlignment;
        this.mTableEditor.grabHorizontal = layout.grabHorizontal;
        this.mTableEditor.minimumWidth = layout.minimumWidth;
        this.mTableEditor.setEditor(control, tableItem, 1);
        this.mTextCellEditor.setFocus();
        this.setPageComplete(false);
        this.mTextCellEditor.addListener(new ICellEditorListener(){

            public void applyEditorValue() {
                CopyDbTableWizardPage.this.deactivateCellEditor();
            }

            public void cancelEditor() {
                CopyDbTableWizardPage.this.mTextCellEditor.deactivate();
            }

            public void editorValueChanged(boolean oldValidState, boolean newValidState) {
            }
        });
    }
}

